/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.NumericData;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.init.CacheManager;
import org.hawkular.alerts.bus.messages.MetricDataMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularMetricData")})
public class MetricDataListener
extends BasicMessageListener<MetricDataMessage> {
    private final Logger log = Logger.getLogger(MetricDataListener.class);
    @EJB
    AlertsService alerts;
    @EJB
    DefinitionsService definitions;
    @EJB
    CacheManager cacheManager;

    private boolean isNeeded(Set<String> activeMetricIds, String metricId) {
        if (null == activeMetricIds) {
            return true;
        }
        return activeMetricIds.contains(metricId);
    }

    protected void onBasicMessage(MetricDataMessage msg) {
        this.log.debugf("Message received: [%s]", (Object)msg);
        MetricDataMessage.MetricData metricData = msg.getMetricData();
        List<MetricDataMessage.SingleMetric> data = metricData.getData();
        ArrayList<NumericData> alertData = new ArrayList<NumericData>(data.size());
        Set<String> activeMetricIds = this.cacheManager.getActiveDataIds();
        for (MetricDataMessage.SingleMetric m : data) {
            if (this.isNeeded(activeMetricIds, m.getSource())) {
                alertData.add(new NumericData(m.getSource(), m.getTimestamp(), Double.valueOf(m.getValue())));
                continue;
            }
            this.log.debugf("Filtering data not used in Triggers. MetricId=%s", (Object)m.getSource());
        }
        this.log.debugf("Sending: [%s]", alertData);
        this.alerts.sendData(alertData);
    }
}

