/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.sender;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.hawkular.actions.api.model.ActionMessage;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

public class ActionSender
implements ActionListener {
    private final MsgLogger msgLogger = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(ActionSender.class);
    private static final String CONNECTION_FACTORY = "java:/HawkularBusConnectionFactory";
    private static final String ACTIONS_TOPIC = "HawkularAlertsActionsTopic";
    private static final String DEFINITIONS_SERVICE = "java:app/hawkular-alerts-engine/CassDefinitionsServiceImpl";
    private TopicConnectionFactory conFactory;
    private ConnectionContextFactory ccf;
    private ProducerConnectionContext pcc;
    InitialContext ctx;
    DefinitionsService definitions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Action action) {
        try {
            this.init();
            if (this.pcc == null) {
                this.msgLogger.warnCannotConnectToBus();
                return;
            }
            ActionMessage nMsg = new ActionMessage();
            nMsg.setActionId(action.getActionId());
            nMsg.setMessage(action.getMessage());
            if (this.definitions != null) {
                Map properties = this.definitions.getAction(action.getTenantId(), action.getActionPlugin(), action.getActionId());
                nMsg.setProperties(properties);
                MessageId mid = new MessageProcessor().send(this.pcc, (BasicMessage)nMsg, ActionSender.actionPluginFilter(action.getActionPlugin()));
                this.msgLogger.infoSentActionMessage(mid.getId());
            } else {
                this.msgLogger.warnCannotAccessToDefinitionsService();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLogger.errorProcessingAction(e.getMessage());
        }
        finally {
            if (this.pcc != null) {
                try {
                    this.pcc.close();
                    this.pcc = null;
                }
                catch (IOException iOException) {}
            }
            if (this.ccf != null) {
                try {
                    this.ccf.close();
                    this.ccf = null;
                }
                catch (JMSException jMSException) {}
            }
        }
    }

    private void init() throws Exception {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        if (this.conFactory == null) {
            this.conFactory = (TopicConnectionFactory)this.ctx.lookup(CONNECTION_FACTORY);
        }
        if (this.ccf == null) {
            this.ccf = new ConnectionContextFactory((ConnectionFactory)this.conFactory);
        }
        if (this.pcc == null) {
            this.pcc = this.ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.TOPIC, ACTIONS_TOPIC));
        }
        if (this.definitions == null) {
            this.definitions = (DefinitionsService)this.ctx.lookup(DEFINITIONS_SERVICE);
        }
    }

    private static Map<String, String> actionPluginFilter(String actionPlugin) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("actionPlugin", actionPlugin);
        return map;
    }
}

