/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.Map;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.hawkular.actions.api.model.ActionPluginMessage;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsPluginsQueue")})
public class ActionPluginListener
extends BasicMessageListener<ActionPluginMessage> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(ActionPluginListener.class);
    @EJB
    DefinitionsService definitions;

    protected void onBasicMessage(ActionPluginMessage msg) {
        block9: {
            this.log.debugf("Message received: [%s]", (Object)msg);
            String op = msg.getOp();
            String actionPlugin = msg.getActionPlugin();
            if (op == null || op.isEmpty()) {
                this.msgLog.warnActionPluginRegistrationWithoutOp();
            } else if (op.equals("init")) {
                try {
                    if (this.definitions.getActionPlugin(actionPlugin) == null) {
                        Set properties = msg.getProperties();
                        Map defaultProperties = msg.getDefaultProperties();
                        if (defaultProperties != null && !defaultProperties.isEmpty()) {
                            this.definitions.addActionPlugin(actionPlugin, defaultProperties);
                        } else {
                            this.definitions.addActionPlugin(actionPlugin, properties);
                        }
                        this.msgLog.infoActionPluginRegistration(actionPlugin);
                        break block9;
                    }
                    this.msgLog.warnActionPluginAlreadyRegistered(actionPlugin);
                }
                catch (Exception e) {
                    this.log.debugf(e.getMessage(), (Object)e);
                    this.msgLog.errorDefinitionsService(e.getMessage());
                }
            } else {
                this.msgLog.warnActionPluginRegistrationWithUnknownOp(actionPlugin, op);
            }
        }
    }
}

