/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.Availability;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.init.CacheManager;
import org.hawkular.alerts.bus.messages.AvailDataMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAvailData")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AvailDataListener
extends BasicMessageListener<AvailDataMessage> {
    private final Logger log = Logger.getLogger(AvailDataListener.class);
    @EJB
    AlertsService alerts;
    @EJB
    DefinitionsService definitions;
    @EJB
    CacheManager cacheManager;

    private boolean isNeeded(Set<String> activeAvailabilityIds, String id) {
        if (null == activeAvailabilityIds) {
            return true;
        }
        return activeAvailabilityIds.contains(id);
    }

    protected void onBasicMessage(AvailDataMessage msg) {
        AvailDataMessage.AvailData availData = msg.getAvailData();
        this.log.debugf("Message received with [%s] availability.", availData.getData().size());
        List<AvailDataMessage.SingleAvail> data = availData.getData();
        ArrayList<Availability> alertData = new ArrayList<Availability>(data.size());
        Set<String> activeAvailabilityIds = this.cacheManager.getActiveAvailabilityIds();
        for (AvailDataMessage.SingleAvail a : data) {
            if (!this.isNeeded(activeAvailabilityIds, a.getId())) continue;
            alertData.add(new Availability(a.getId(), a.getTimestamp(), a.getAvail()));
        }
        this.log.debugf("Sending [%s] availability to Alerting", alertData.size());
        try {
            this.alerts.sendData(alertData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

