/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.bus.init.CacheManager;
import org.hawkular.alerts.bus.messages.MetricDataMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularMetricData")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class MetricDataListener
extends BasicMessageListener<MetricDataMessage> {
    private final Logger log = Logger.getLogger(MetricDataListener.class);
    @EJB
    AlertsService alerts;
    @EJB
    CacheManager cacheManager;

    private boolean isNeeded(Set<String> activeMetricIds, String metricId) {
        if (null == activeMetricIds) {
            return true;
        }
        return activeMetricIds.contains(metricId);
    }

    protected void onBasicMessage(MetricDataMessage msg) {
        MetricDataMessage.MetricData metricData = msg.getMetricData();
        this.log.tracef("Message received with [%s] metrics.", metricData.getData().size());
        List<MetricDataMessage.SingleMetric> data = metricData.getData();
        ArrayList<Data> alertData = null;
        Set<String> activeMetricIds = this.cacheManager.getActiveDataIds();
        for (MetricDataMessage.SingleMetric m : data) {
            if (!this.isNeeded(activeMetricIds, m.getSource())) continue;
            if (null == alertData) {
                alertData = new ArrayList<Data>(data.size());
            }
            alertData.add(new Data(m.getSource(), m.getTimestamp(), String.valueOf(m.getValue())));
        }
        if (null == alertData) {
            this.log.tracef("Forwarding 0 of [%s] metrics to Alerts Engine...", data.size());
        } else {
            this.log.debugf("Forwarding [%s] of [%s] metrics to Alerts Engine (filtered [%s])...", alertData.size(), data.size(), data.size() - alertData.size());
            try {
                this.alerts.sendData(alertData);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

