/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.bus.api.BusActionResponseMessage;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsActionsResponseQueue")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ActionPluginOperationListener
extends BasicMessageListener<BusActionResponseMessage> {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(ActionPluginOperationListener.class);
    @EJB
    ActionsService actions;

    protected void onBasicMessage(BusActionResponseMessage msg) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Message received: " + msg));
        }
        if (msg != null && msg.getPayload().containsKey("action")) {
            String jsonAction = (String)msg.getPayload().get("action");
            Action updatedAction = (Action)JsonUtil.fromJson((String)jsonAction, Action.class);
            this.actions.updateResult(updatedAction);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Operation message received from plugin [" + updatedAction.getActionPlugin() + "] with " + "payload [" + updatedAction.getResult() + "]"));
            }
        } else {
            this.msgLog.warnActionResponseMessageWithoutPayload();
        }
    }
}

