/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.bus.init.CacheManager;
import org.hawkular.alerts.bus.messages.MetricDataMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularMetricData")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class MetricDataListener
extends BasicMessageListener<MetricDataMessage> {
    private final Logger log = Logger.getLogger(MetricDataListener.class);
    @EJB
    AlertsService alerts;
    @EJB
    CacheManager cacheManager;

    private boolean isNeeded(Set<String> activeMetricIds, String metricId) {
        if (null == activeMetricIds) {
            return true;
        }
        return activeMetricIds.contains(metricId);
    }

    protected void onBasicMessage(MetricDataMessage msg) {
        MetricDataMessage.MetricData metricData = msg.getMetricData();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Message received with [" + metricData.getData().size() + "] metrics."));
        }
        List<MetricDataMessage.SingleMetric> data = metricData.getData();
        ArrayList<Data> alertData = null;
        Set<String> activeMetricIds = this.cacheManager.getActiveDataIds();
        for (MetricDataMessage.SingleMetric m : data) {
            if (!this.isNeeded(activeMetricIds, m.getSource())) continue;
            if (null == alertData) {
                alertData = new ArrayList<Data>(data.size());
            }
            alertData.add(new Data(m.getSource(), m.getTimestamp(), String.valueOf(m.getValue())));
        }
        if (null == alertData) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Forwarding 0 of [" + data.size() + "] metrics to Alerts Engine..."));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Forwarding [" + alertData.size() + "] of [" + data.size() + "] metrics to Alerts Engine " + "(filtered [" + (data.size() - alertData.size()) + "])..."));
            }
            try {
                this.alerts.sendData(alertData);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String convertReceivedMessageClassNameToDesiredMessageClassName(String className) {
        if (className.equals("org.hawkular.metrics.component.publish.MetricDataMessage")) {
            return "org.hawkular.alerts.bus.messages.MetricDataMessage";
        }
        return null;
    }
}

