/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.api.BusActionMessage;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

public class BusActionListener
implements ActionListener {
    private final MsgLogger msgLogger = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BusActionListener.class);
    private static final String CONNECTION_FACTORY = "java:/HawkularBusConnectionFactory";
    private static final String ACTIONS_TOPIC = "HawkularAlertsActionsTopic";
    private static final String DEFINITIONS_SERVICE = "java:app/hawkular-alerts-rest/CassDefinitionsServiceImpl";
    private TopicConnectionFactory conFactory;
    private ConnectionContextFactory ccf;
    private ProducerConnectionContext pcc;
    InitialContext ctx;
    DefinitionsService definitions;

    public void process(Action action) {
        try {
            this.init();
            if (this.pcc == null) {
                this.msgLogger.warnCannotConnectToBus();
                return;
            }
            if (this.definitions != null) {
                Map properties = this.definitions.getAction(action.getTenantId(), action.getActionPlugin(), action.getActionId());
                Map defaultProperties = this.definitions.getDefaultActionPlugin(action.getActionPlugin());
                Map<String, String> mixedProps = this.mixProperties(properties, defaultProperties);
                action.setProperties(mixedProps);
                BusActionMessage pluginMessage = new BusActionMessage(action);
                MessageId mid = new MessageProcessor().send(this.pcc, (BasicMessage)pluginMessage);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Sent action message [" + mid.getId() + "] to the bus"));
                }
            } else {
                this.msgLogger.warnCannotAccessToDefinitionsService();
            }
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLogger.errorProcessingAction(e.getMessage());
        }
    }

    private void init() throws Exception {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        if (this.conFactory == null) {
            this.conFactory = (TopicConnectionFactory)this.ctx.lookup(CONNECTION_FACTORY);
        }
        if (this.ccf == null) {
            this.ccf = new ConnectionContextFactory((ConnectionFactory)this.conFactory);
        }
        if (this.pcc == null) {
            this.pcc = this.ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.TOPIC, ACTIONS_TOPIC));
        }
        if (this.definitions == null) {
            this.definitions = (DefinitionsService)this.ctx.lookup(DEFINITIONS_SERVICE);
        }
    }

    public void close() throws Exception {
        if (this.pcc != null) {
            try {
                this.pcc.close();
                this.pcc = null;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (this.ccf != null) {
            try {
                this.ccf.close();
                this.ccf = null;
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    private Map<String, String> mixProperties(Map<String, String> props, Map<String, String> defProps) {
        HashMap<String, String> mixed = new HashMap<String, String>();
        if (props != null) {
            mixed.putAll(props);
        }
        if (defProps != null) {
            for (String defKey : defProps.keySet()) {
                mixed.putIfAbsent(defKey, defProps.get(defKey));
            }
        }
        return mixed;
    }
}

