/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.api.AvailDataMessage;
import org.hawkular.alerts.bus.init.CacheManager;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAvailData")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AvailDataListener
extends BasicMessageListener<AvailDataMessage> {
    private final Logger log = Logger.getLogger(AvailDataListener.class);
    @EJB
    AlertsService alerts;
    @EJB
    DefinitionsService definitions;
    @EJB
    CacheManager cacheManager;

    private boolean isNeeded(Set<String> activeAvailabilityIds, String id) {
        if (null == activeAvailabilityIds) {
            return true;
        }
        return activeAvailabilityIds.contains(id);
    }

    protected void onBasicMessage(AvailDataMessage msg) {
        AvailDataMessage.AvailData availData = msg.getAvailData();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Message received with [" + availData.getData().size() + "] avails."));
        }
        List data = availData.getData();
        ArrayList<Data> alertData = null;
        Set<String> activeAvailabilityIds = this.cacheManager.getActiveAvailabilityIds();
        for (AvailDataMessage.SingleAvail a : data) {
            if (!this.isNeeded(activeAvailabilityIds, a.getId())) continue;
            if (null == alertData) {
                alertData = new ArrayList<Data>(data.size());
            }
            alertData.add(new Data(a.getTenantId(), a.getId(), a.getTimestamp(), a.getAvail()));
        }
        if (null == alertData) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Forwarding 0 of [" + data.size() + "] avails to Alerts Engine..."));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Forwarding [" + alertData.size() + "] of [" + data.size() + "] avails to Alerts Engine " + "(filtered [" + (data.size() - alertData.size()) + "])..."));
            }
            try {
                this.alerts.sendData(alertData);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String convertReceivedMessageClassNameToDesiredMessageClassName(String className) {
        if (className.equals("org.hawkular.metrics.component.publish.AvailDataMessage")) {
            return "org.hawkular.alerts.bus.messages.AvailDataMessage";
        }
        return null;
    }
}

