/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.init;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.PropertiesService;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.infinispan.Cache;
import org.jboss.logging.Logger;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CacheManager {
    private final Logger log = Logger.getLogger(CacheManager.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final String DISABLE_PUBLISH_FILTERING = "hawkular-alerts.disable-publish-filtering";
    private final String DISABLE_PUBLISH_FILTERING_ENV = "DISABLE_PUBLISH_FILTERING";
    private final String RESET_PUBLISH_CACHE = "hawkular-alerts.reset-publish-cache";
    private final String RESET_PUBLISH_CACHE_ENV = "RESET_PUBLISH_CACHE";
    private final String AVAILABILITY = "hm_a_";
    private final String GAUGE = "hm_g_";
    private final String COUNTER = "hm_c_";
    private final String COUNTER_RATE = "hm_cr_";
    private final String STRING = "hm_s_";
    private final String GAUGE_RATE = "hm_gr_";
    Set<DataIdKey> activeDataIds;
    Set<DataIdKey> activeAvailabityIds;
    @EJB
    PropertiesService properties;
    @EJB
    DefinitionsService definitions;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-metrics/publish")
    private Cache publishCache;

    @PostConstruct
    public void init() {
        if (!Boolean.parseBoolean(this.properties.getProperty("hawkular-alerts.disable-publish-filtering", "DISABLE_PUBLISH_FILTERING", "false"))) {
            if (Boolean.parseBoolean(this.properties.getProperty("hawkular-alerts.reset-publish-cache", "RESET_PUBLISH_CACHE", "true"))) {
                this.msgLog.warnClearPublishCache();
                this.publishCache.clear();
            }
            this.msgLog.infoInitPublishCache();
            this.updateActiveIds();
            this.definitions.registerListener(e -> this.updateActiveIds(), DefinitionsEvent.Type.CONDITION_CHANGE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
        } else {
            this.msgLog.warnDisabledPublishCache();
        }
    }

    public Set<DataIdKey> getActiveDataIds() {
        return this.activeDataIds;
    }

    public Set<DataIdKey> getActiveAvailabilityIds() {
        return this.activeAvailabityIds;
    }

    private synchronized void updateActiveIds() {
        try {
            Collection conditions = this.definitions.getAllConditions();
            HashSet<DataIdKey> dataIds = new HashSet<DataIdKey>(conditions.size());
            HashSet<DataIdKey> availIds = new HashSet<DataIdKey>(conditions.size());
            for (Condition c : conditions) {
                String tenantId = c.getTenantId();
                String dataId = c.getDataId();
                DataIdKey key = new DataIdKey(tenantId, dataId);
                if (c instanceof AvailabilityCondition) {
                    availIds.add(key);
                    if (!this.isNewAvailId(key)) continue;
                    this.publish(key);
                    continue;
                }
                dataIds.add(key);
                if (this.isNewDataId(key)) {
                    this.publish(key);
                }
                if (!(c instanceof CompareCondition)) continue;
                String data2Id = ((CompareCondition)c).getData2Id();
                DataIdKey key2 = new DataIdKey(tenantId, data2Id);
                dataIds.add(key2);
                if (!this.isNewDataId(key2)) continue;
                this.publish(key2);
            }
            if (this.activeDataIds != null && !this.activeDataIds.isEmpty()) {
                this.activeDataIds.stream().filter(old -> !dataIds.contains(old)).forEach(old -> this.unpublish((DataIdKey)old));
            }
            if (this.activeAvailabityIds != null && this.activeAvailabityIds.isEmpty()) {
                this.activeAvailabityIds.stream().filter(old -> !availIds.contains(old)).forEach(old -> this.unpublish((DataIdKey)old));
            }
            this.activeDataIds = Collections.unmodifiableSet(dataIds);
            this.activeAvailabityIds = Collections.unmodifiableSet(availIds);
        }
        catch (Exception e) {
            this.log.error((Object)"FAILED to load conditions to create Id filters. All data being forwarded to alerting!", (Throwable)e);
            this.activeDataIds = null;
            this.activeAvailabityIds = null;
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Updated activeDataIds! " + this.activeDataIds));
            this.log.debug((Object)("Updated activeAvailIds! " + this.activeAvailabityIds));
        }
    }

    private boolean isNewAvailId(DataIdKey availIdKey) {
        if (this.activeAvailabityIds == null || this.activeAvailabityIds.isEmpty()) {
            return true;
        }
        return !this.activeAvailabityIds.contains(availIdKey);
    }

    private boolean isNewDataId(DataIdKey dataIdKey) {
        if (this.activeDataIds == null || this.activeDataIds.isEmpty()) {
            return true;
        }
        return !this.activeDataIds.contains(dataIdKey);
    }

    private void publish(DataIdKey dataIdKey) {
        MetricId metricId = this.getMetricId(dataIdKey);
        if (metricId != null && this.publishCache != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Publishing metricId: " + metricId));
            }
            this.publishCache.put((Object)metricId, (Object)metricId);
        }
    }

    private void unpublish(DataIdKey dataIdKey) {
        MetricId metricId = this.getMetricId(dataIdKey);
        if (metricId != null && this.publishCache != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unpublishing metricId: " + metricId));
            }
            this.publishCache.remove((Object)metricId);
        }
    }

    private MetricId getMetricId(DataIdKey dataIdKey) {
        String metricId;
        MetricType type;
        String tenantId = dataIdKey.getTenantId();
        String dataId = dataIdKey.getDataId();
        if (dataId.startsWith("hm_a_")) {
            type = MetricType.AVAILABILITY;
            metricId = dataId.substring("hm_a_".length());
        } else if (dataId.startsWith("hm_g_")) {
            type = MetricType.GAUGE;
            metricId = dataId.substring("hm_g_".length());
        } else if (dataId.startsWith("hm_c_")) {
            type = MetricType.COUNTER;
            metricId = dataId.substring("hm_c_".length());
        } else if (dataId.startsWith("hm_cr_")) {
            type = MetricType.COUNTER_RATE;
            metricId = dataId.substring("hm_cr_".length());
        } else if (dataId.startsWith("hm_s_")) {
            type = MetricType.STRING;
            metricId = dataId.substring("hm_s_".length());
        } else if (dataId.startsWith("hm_gr_")) {
            type = MetricType.GAUGE_RATE;
            metricId = dataId.substring("hm_gr_".length());
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("DataId " + dataId + " doesn't have a valid metrics type."));
            }
            return null;
        }
        return new MetricId(tenantId, type, metricId);
    }

    public static class DataIdKey {
        private String tenantId;
        private String dataId;

        public DataIdKey(String tenantId, String dataId) {
            this.tenantId = tenantId;
            this.dataId = dataId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getDataId() {
            return this.dataId;
        }

        public void setDataId(String dataId) {
            this.dataId = dataId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataIdKey dataIdKey = (DataIdKey)o;
            if (this.tenantId != null ? !this.tenantId.equals(dataIdKey.tenantId) : dataIdKey.tenantId != null) {
                return false;
            }
            return this.dataId != null ? this.dataId.equals(dataIdKey.dataId) : dataIdKey.dataId == null;
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
            return result;
        }
    }
}

