/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.io.IOException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.bus.api.BusActionMessage;
import org.hawkular.alerts.bus.log.MsgLogger;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.jboss.logging.Logger;

public class BusActionListener
implements ActionListener {
    private final MsgLogger msgLogger = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(BusActionListener.class);
    private static final String CONNECTION_FACTORY = "java:/HawkularBusConnectionFactory";
    private static final String ACTIONS_TOPIC = "HawkularAlertsActionsTopic";
    private TopicConnectionFactory conFactory;
    private ThreadLocal<ConnectionContextFactory> ccf = new ThreadLocal();
    private ThreadLocal<ProducerConnectionContext> pcc = new ThreadLocal();
    InitialContext ctx;

    public void process(Action action) {
        try {
            this.init();
            if (this.pcc == null) {
                this.msgLogger.warnCannotConnectToBus();
                return;
            }
            BusActionMessage pluginMessage = new BusActionMessage(action);
            MessageId mid = new MessageProcessor().send(this.pcc.get(), (BasicMessage)pluginMessage);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sent action message [" + mid.getId() + "] to the bus"));
            }
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            this.msgLogger.errorProcessingAction(e.getMessage());
        }
    }

    private void init() throws Exception {
        if (this.ctx == null) {
            this.ctx = new InitialContext();
        }
        if (this.conFactory == null) {
            this.conFactory = (TopicConnectionFactory)this.ctx.lookup(CONNECTION_FACTORY);
        }
        if (this.ccf.get() == null) {
            this.ccf.set(new ConnectionContextFactory((ConnectionFactory)this.conFactory));
        }
        if (this.pcc.get() == null) {
            this.pcc.set(this.ccf.get().createProducerConnectionContext(new Endpoint(Endpoint.Type.TOPIC, ACTIONS_TOPIC)));
        }
    }

    public void close() throws Exception {
        if (this.pcc.get() != null) {
            try {
                this.pcc.get().close();
                this.pcc.remove();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.ccf.get() != null) {
            try {
                this.ccf.get().close();
                this.ccf.remove();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }
}

