/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.bus.api.MetricDataMessage;
import org.hawkular.alerts.bus.init.CacheManager;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularMetricData")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class MetricDataListener
extends BasicMessageListener<MetricDataMessage> {
    private final Logger log = Logger.getLogger(MetricDataListener.class);
    @EJB
    AlertsService alerts;
    @EJB
    CacheManager cacheManager;

    private boolean isNeeded(Set<CacheManager.DataIdKey> activeMetricIds, CacheManager.DataIdKey metricId) {
        if (null == activeMetricIds) {
            return true;
        }
        return activeMetricIds.contains(metricId);
    }

    protected void onBasicMessage(MetricDataMessage msg) {
        MetricDataMessage.MetricData metricData = msg.getMetricData();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Message received with [" + metricData.getData().size() + "] metrics."));
        }
        List data = metricData.getData();
        ArrayList<Data> alertData = null;
        Set<CacheManager.DataIdKey> activeMetricIds = this.cacheManager.getActiveDataIds();
        for (MetricDataMessage.SingleMetric m : data) {
            String fullMetricId = m.getType() + "-" + m.getSource();
            if (this.isNeeded(activeMetricIds, new CacheManager.DataIdKey(metricData.getTenantId(), fullMetricId))) {
                if (this.log.isTraceEnabled()) {
                    this.log.tracef("KEEPING METRIC [%s:%s]", (Object)fullMetricId, (Object)String.valueOf(m.getValue()));
                }
                if (null == alertData) {
                    alertData = new ArrayList<Data>(data.size());
                }
                alertData.add(Data.forNumeric((String)metricData.getTenantId(), (String)fullMetricId, (long)m.getTimestamp(), (Double)m.getValue()));
                continue;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.tracef("TOSSING METRIC [%s]", (Object)fullMetricId);
        }
        if (null == alertData) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Forwarding 0 of [" + data.size() + "] metrics to Alerts Engine..."));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Forwarding [" + alertData.size() + "] of [" + data.size() + "] metrics to Alerts Engine " + "(filtered [" + (data.size() - alertData.size()) + "])..."));
            }
            try {
                this.alerts.sendData(alertData);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected String convertReceivedMessageClassNameToDesiredMessageClassName(String className) {
        if (className.equals("org.hawkular.metrics.component.publish.MetricDataMessage")) {
            return "org.hawkular.alerts.bus.api.MetricDataMessage";
        }
        return null;
    }
}

