/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.AvailabilityType;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.bus.api.AvailDataMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAvailData")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class AvailDataListener
extends BasicMessageListener<AvailDataMessage> {
    private final Logger log = Logger.getLogger(AvailDataListener.class);
    @EJB
    AlertsService alerts;
    @EJB
    DefinitionsService definitions;

    protected void onBasicMessage(AvailDataMessage msg) {
        AvailDataMessage.AvailData availData = msg.getAvailData();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Message received with [" + availData.getData().size() + "] avails."));
        }
        List data = availData.getData();
        ArrayList<Data> alertData = new ArrayList<Data>(data.size());
        for (AvailDataMessage.SingleAvail a : data) {
            String dataId = "hm_a_" + a.getId();
            alertData.add(Data.forAvailability((String)a.getTenantId(), (String)dataId, (long)a.getTimestamp(), (AvailabilityType)AvailabilityType.valueOf((String)a.getAvail())));
        }
        this.log.debugf("Forwarding [%s] avails to Alerts Engine", alertData.size());
        try {
            this.alerts.sendData(alertData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String convertReceivedMessageClassNameToDesiredMessageClassName(String className) {
        if (className.equals("org.hawkular.metrics.component.publish.AvailDataMessage")) {
            return "org.hawkular.alerts.bus.api.AvailDataMessage";
        }
        return null;
    }
}

