/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.bus.listener;

import java.util.ArrayList;
import java.util.List;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJB;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.jms.MessageListener;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.bus.api.DataIdPrefix;
import org.hawkular.alerts.bus.api.MetricDataMessage;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import org.jboss.logging.Logger;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularMetricData")})
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class MetricDataListener
extends BasicMessageListener<MetricDataMessage> {
    private final Logger log = Logger.getLogger(MetricDataListener.class);
    @EJB
    AlertsService alerts;

    protected void onBasicMessage(MetricDataMessage msg) {
        MetricDataMessage.MetricData metricData = msg.getMetricData();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Message received with [" + metricData.getData().size() + "] metrics."));
        }
        List data = metricData.getData();
        ArrayList<Data> alertData = new ArrayList<Data>(data.size());
        for (MetricDataMessage.SingleMetric m : data) {
            String dataId = (String)DataIdPrefix.METRIC_TYPE_PREFIX.get(m.getType()) + m.getSource();
            alertData.add(Data.forNumeric((String)metricData.getTenantId(), (String)dataId, (long)m.getTimestamp(), (Double)m.getValue()));
        }
        this.log.debugf("Forwarding [%s] metrics to Alerts Engine", alertData.size());
        try {
            this.alerts.sendData(alertData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String convertReceivedMessageClassNameToDesiredMessageClassName(String className) {
        if (className.equals("org.hawkular.metrics.component.publish.MetricDataMessage")) {
            return "org.hawkular.alerts.bus.api.MetricDataMessage";
        }
        return null;
    }
}

