/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.impl.GsonAdapter;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.rules.RulesEngine;
import org.jboss.logging.Logger;

@Singleton
public class CassAlertsServiceImpl
implements AlertsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassAlertsServiceImpl.class);
    private static final String ENGINE_DELAY = "hawkular-alerts.engine-delay";
    private static final String ENGINE_PERIOD = "hawkular-alerts.engine-period";
    private static final String CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private int delay;
    private int period;
    private Session session;
    private String keyspace;
    private Gson gson;
    private PreparedStatement insertAlert;
    private PreparedStatement insertAlertTrigger;
    private PreparedStatement insertAlertCtime;
    private PreparedStatement insertAlertStatus;
    private PreparedStatement updateAlert;
    private PreparedStatement selectAlertStatus;
    private PreparedStatement deleteAlertStatus;
    private final List<Data> pendingData = new CopyOnWriteArrayList<Data>();
    private final List<Alert> alerts = new CopyOnWriteArrayList<Alert>();
    private final Set<Dampening> pendingTimeouts = new CopyOnWriteArraySet<Dampening>();
    private final Map<Trigger, List<Set<ConditionEval>>> autoResolvedTriggers = new HashMap<Trigger, List<Set<ConditionEval>>>();
    private final Set<Trigger> disabledTriggers = new CopyOnWriteArraySet<Trigger>();
    private final Timer wakeUpTimer = new Timer("CassAlertsServiceImpl-Timer");
    private TimerTask rulesTask;
    @EJB
    RulesEngine rules;
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;

    public CassAlertsServiceImpl() {
        this.delay = new Integer(AlertProperties.getProperty(ENGINE_DELAY, "1000"));
        this.period = new Integer(AlertProperties.getProperty(ENGINE_PERIOD, "2000"));
    }

    @PostConstruct
    public void initServices() {
        try {
            if (this.keyspace == null) {
                this.keyspace = AlertProperties.getProperty(CASSANDRA_KEYSPACE, "hawkular_alerts");
            }
            if (this.session == null) {
                this.session = CassCluster.getSession();
            }
            this.initPreparedStatements();
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeHierarchyAdapter(ConditionEval.class, new GsonAdapter());
            this.gson = gsonBuilder.create();
            this.reload();
        }
        catch (Throwable t) {
            this.msgLog.errorCannotInitializeAlertsService(t.getMessage());
        }
    }

    private void initPreparedStatements() throws Exception {
        if (this.insertAlert == null) {
            this.insertAlert = this.session.prepare("INSERT INTO " + this.keyspace + ".alerts " + "(alertId, payload) VALUES (?, ?) ");
        }
        if (this.insertAlertTrigger == null) {
            this.insertAlertTrigger = this.session.prepare("INSERT INTO " + this.keyspace + ".alerts_triggers " + "(alertId, triggerId) VALUES (?, ?) ");
        }
        if (this.insertAlertCtime == null) {
            this.insertAlertCtime = this.session.prepare("INSERT INTO " + this.keyspace + ".alerts_ctimes " + "(alertId, ctime) VALUES (?, ?) ");
        }
        if (this.insertAlertStatus == null) {
            this.insertAlertStatus = this.session.prepare("INSERT INTO " + this.keyspace + ".alerts_statuses " + "(alertId, status) VALUES (?, ?) ");
        }
        if (this.updateAlert == null) {
            this.updateAlert = this.session.prepare("UPDATE " + this.keyspace + ".alerts " + "SET payload = ? WHERE alertId = ? ");
        }
        if (this.selectAlertStatus == null) {
            this.selectAlertStatus = this.session.prepare("SELECT alertId, status FROM " + this.keyspace + ".alerts_statuses " + "WHERE alertId = ? ALLOW FILTERING ");
        }
        if (this.deleteAlertStatus == null) {
            this.deleteAlertStatus = this.session.prepare("DELETE FROM " + this.keyspace + ".alerts_statuses " + "WHERE alertId = ? AND status = ?");
        }
    }

    public void addAlerts(Collection<Alert> alerts) throws Exception {
        if (alerts == null) {
            throw new IllegalArgumentException("Alerts must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertAlert == null) {
            throw new RuntimeException("insertAlert PreparedStatement is null");
        }
        try {
            for (Alert a : alerts) {
                this.session.execute((Statement)this.insertAlert.bind(new Object[]{a.getAlertId(), this.toJson(a)}));
                this.session.execute((Statement)this.insertAlertTrigger.bind(new Object[]{a.getAlertId(), a.getTriggerId()}));
                this.session.execute((Statement)this.insertAlertCtime.bind(new Object[]{a.getAlertId(), a.getCtime()}));
                this.session.execute((Statement)this.insertAlertStatus.bind(new Object[]{a.getAlertId(), a.getStatus().name()}));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public List<Alert> getAlerts(AlertsCriteria criteria) throws Exception {
        boolean filter;
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        boolean bl = filter = null != criteria && criteria.hasCriteria();
        if (filter) {
            this.log.debugf("getAlerts criteria: %s", (Object)criteria.toString());
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        HashSet alertIds = new HashSet();
        StringBuilder sAlerts = new StringBuilder("SELECT payload FROM ").append(this.keyspace).append(".alerts ");
        if (filter) {
            HashSet<String> triggerIds = new HashSet<String>();
            if (this.isEmpty(criteria.getTriggerIds())) {
                if (!this.isEmpty(criteria.getTriggerId())) {
                    triggerIds.add(criteria.getTriggerId());
                }
            } else {
                for (String triggerId : criteria.getTriggerIds()) {
                    if (this.isEmpty(triggerId)) continue;
                    triggerIds.add(triggerId);
                }
            }
            if (!this.isEmpty(criteria.getTags()) || criteria.getTag() != null) {
                Tag tag;
                HashSet<Tag> tags = new HashSet<Tag>();
                if (criteria.getTags() != null) {
                    tags.addAll(criteria.getTags());
                }
                if ((tag = criteria.getTag()) != null) {
                    tags.add(tag);
                }
                triggerIds.addAll(this.getTriggersIdByTags(tags));
            }
            HashSet<String> alertIdsFilteredByTriggers = new HashSet<String>();
            boolean filterByTriggers = false;
            if (triggerIds.size() > 0) {
                filterByTriggers = true;
                StringBuilder sAlertsTriggers = new StringBuilder("SELECT alertId FROM ").append(this.keyspace).append(".alerts_triggers WHERE ");
                if (triggerIds.size() == 1) {
                    sAlertsTriggers.append("( triggerId = '");
                    sAlertsTriggers.append((String)triggerIds.iterator().next());
                    sAlertsTriggers.append("' )");
                } else {
                    sAlertsTriggers.append("( triggerId IN (");
                    int entries = 0;
                    for (String triggerId : triggerIds) {
                        if (this.isEmpty(triggerId)) continue;
                        sAlertsTriggers.append(entries++ > 0 ? "," : "");
                        sAlertsTriggers.append("'");
                        sAlertsTriggers.append(triggerId);
                        sAlertsTriggers.append("'");
                    }
                    sAlertsTriggers.append(") )");
                }
                try {
                    ResultSet rsAlertIdsByTriggerIds = this.session.execute(sAlertsTriggers.toString());
                    if (rsAlertIdsByTriggerIds.isExhausted()) {
                        alertIdsFilteredByTriggers.add("empty-alert");
                    } else {
                        for (Row row : rsAlertIdsByTriggerIds) {
                            String alertId = row.getString("alertId");
                            alertIdsFilteredByTriggers.add(alertId);
                        }
                    }
                }
                catch (Exception e) {
                    this.msgLog.errorDatabaseException(e.getMessage());
                    throw e;
                }
            }
            HashSet<Object> alertIdsFilteredByCtime = new HashSet<Object>();
            boolean filterByCtime = false;
            if (criteria.getStartTime() != null || criteria.getEndTime() != null) {
                filterByCtime = true;
                StringBuilder sAlertsCtimes = new StringBuilder("SELECT alertId FROM ").append(this.keyspace).append(".alerts_ctimes WHERE ");
                boolean andNeeded = false;
                if (criteria.getStartTime() != null) {
                    sAlertsCtimes.append("( ctime >= ");
                    sAlertsCtimes.append(criteria.getStartTime());
                    sAlertsCtimes.append(" )");
                    andNeeded = true;
                }
                if (criteria.getEndTime() != null) {
                    if (andNeeded) {
                        sAlertsCtimes.append(" AND ");
                    }
                    sAlertsCtimes.append("( ctime <= ");
                    sAlertsCtimes.append(criteria.getEndTime());
                    sAlertsCtimes.append(" )");
                }
                sAlertsCtimes.append(" ALLOW FILTERING ");
                try {
                    ResultSet rsAlertsCtimes = this.session.execute(sAlertsCtimes.toString());
                    if (rsAlertsCtimes.isExhausted()) {
                        alertIdsFilteredByCtime.add("empty-alert");
                    } else {
                        for (Row row : rsAlertsCtimes) {
                            String alertId = row.getString("alertId");
                            alertIdsFilteredByCtime.add(alertId);
                        }
                    }
                }
                catch (Exception e) {
                    this.msgLog.errorDatabaseException(e.getMessage());
                    throw e;
                }
            }
            HashSet<String> alertIdsFilteredByStatus = new HashSet<String>();
            boolean filterByStatus = false;
            HashSet<Alert.Status> statuses = new HashSet<Alert.Status>();
            if (this.isEmpty(criteria.getStatusSet())) {
                if (criteria.getStatus() != null) {
                    statuses.add(criteria.getStatus());
                }
            } else {
                statuses.addAll(criteria.getStatusSet());
            }
            if (statuses.size() > 0) {
                filterByStatus = true;
                StringBuilder sAlertsStatuses = new StringBuilder("SELECT alertId FROM ").append(this.keyspace).append(".alerts_statuses WHERE ");
                if (statuses.size() == 1) {
                    sAlertsStatuses.append("( status = '");
                    sAlertsStatuses.append(((Alert.Status)statuses.iterator().next()).name());
                    sAlertsStatuses.append("' ) ");
                } else {
                    sAlertsStatuses.append("( status IN (");
                    int entries = 0;
                    for (Alert.Status status : statuses) {
                        sAlertsStatuses.append(entries++ > 0 ? "," : "");
                        sAlertsStatuses.append("'");
                        sAlertsStatuses.append(status.name());
                        sAlertsStatuses.append("'");
                    }
                    sAlertsStatuses.append(") ) ");
                }
                try {
                    ResultSet rsAlertsStatuses = this.session.execute(sAlertsStatuses.toString());
                    if (rsAlertsStatuses.isExhausted()) {
                        alertIdsFilteredByStatus.add("empty-alert");
                    } else {
                        for (Row row : rsAlertsStatuses) {
                            String alertId = row.getString("alertId");
                            alertIdsFilteredByStatus.add(alertId);
                        }
                    }
                }
                catch (Exception e) {
                    this.msgLog.errorDatabaseException(e.getMessage());
                    throw e;
                }
            }
            HashSet<String> alertIdsFilteredByAlerts = new HashSet<String>();
            boolean filterByAlerts = false;
            if (this.isEmpty(criteria.getAlertIds())) {
                if (!this.isEmpty(criteria.getAlertId())) {
                    filterByAlerts = true;
                    alertIdsFilteredByAlerts.add(criteria.getAlertId());
                }
            } else {
                filterByAlerts = true;
                alertIdsFilteredByAlerts.addAll(criteria.getAlertIds());
            }
            boolean firstJoin = true;
            if (filterByTriggers) {
                alertIds.addAll(alertIdsFilteredByTriggers);
                firstJoin = false;
            }
            if (filterByCtime) {
                if (firstJoin) {
                    alertIds.addAll(alertIdsFilteredByCtime);
                } else {
                    alertIds.retainAll(alertIdsFilteredByCtime);
                }
                firstJoin = false;
            }
            if (filterByStatus) {
                if (firstJoin) {
                    alertIds.addAll(alertIdsFilteredByStatus);
                } else {
                    alertIds.retainAll(alertIdsFilteredByStatus);
                }
                firstJoin = false;
            }
            if (filterByAlerts) {
                if (firstJoin) {
                    alertIds.addAll(alertIdsFilteredByAlerts);
                } else {
                    alertIds.retainAll(alertIdsFilteredByAlerts);
                }
            }
            if (alertIds.size() > 0) {
                sAlerts.append("WHERE ");
                if (alertIds.size() == 1) {
                    sAlerts.append("( alertId = '");
                    sAlerts.append((String)alertIds.iterator().next());
                    sAlerts.append("' ) ");
                } else {
                    sAlerts.append("( alertId IN (");
                    int entries = 0;
                    for (String alertId : alertIds) {
                        if (this.isEmpty(alertId)) continue;
                        sAlerts.append(entries++ > 0 ? "," : "");
                        sAlerts.append("'");
                        sAlerts.append(alertId);
                        sAlerts.append("'");
                    }
                    sAlerts.append(") ) ");
                }
            }
            sAlerts.append("ALLOW FILTERING ");
        }
        this.log.debugf("getAlerts() - CQL: " + sAlerts.toString(), new Object[0]);
        if (!filter || filter && alertIds.size() > 0) {
            try {
                ResultSet rsAlerts = this.session.execute(sAlerts.toString());
                for (Row row : rsAlerts) {
                    String payload = row.getString("payload");
                    Alert alert = this.fromJson(payload, Alert.class);
                    alerts.add(alert);
                }
            }
            catch (Exception e) {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
        }
        this.log.debug(alerts);
        return alerts;
    }

    private Collection<String> getTriggersIdByTags(Collection<Tag> tags) {
        HashSet<String> triggerIds = new HashSet<String>();
        for (Tag tag : tags) {
            StringBuilder sTag = new StringBuilder("SELECT triggers FROM ").append(this.keyspace).append(".tags_triggers ");
            if (tag.getCategory() == null && tag.getName() == null) continue;
            sTag.append("WHERE ");
            if (!this.isEmpty(tag.getCategory())) {
                sTag.append(" category = '").append(tag.getCategory()).append("' ");
            }
            if (!this.isEmpty(tag.getName())) {
                if (!this.isEmpty(tag.getCategory())) {
                    sTag.append("AND ");
                }
                sTag.append(" name = '").append(tag.getName()).append("' ");
                if (this.isEmpty(tag.getCategory())) {
                    sTag.append("ALLOW FILTERING ");
                }
            }
            ResultSet rsTriggers = this.session.execute(sTag.toString());
            for (Row row : rsTriggers) {
                Set triggers = row.getSet("triggers", String.class);
                triggerIds.addAll(triggers);
            }
        }
        return triggerIds;
    }

    public void clear() {
        this.rulesTask.cancel();
        this.rules.clear();
        this.pendingData.clear();
        this.alerts.clear();
        this.pendingTimeouts.clear();
        this.autoResolvedTriggers.clear();
        this.disabledTriggers.clear();
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, this.delay, (long)this.period);
    }

    public void reload() {
        this.rules.reset();
        if (this.rulesTask != null) {
            this.rulesTask.cancel();
        }
        Collection triggers = null;
        try {
            triggers = this.definitions.getAllTriggers();
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService("Triggers", e.getMessage());
        }
        if (triggers != null && !triggers.isEmpty()) {
            for (Trigger trigger : triggers) {
                if (!trigger.isEnabled()) continue;
                this.reloadTrigger(trigger);
            }
        }
        this.rules.addGlobal("log", this.log);
        this.rules.addGlobal("actions", this.actions);
        this.rules.addGlobal("alerts", this.alerts);
        this.rules.addGlobal("pendingTimeouts", this.pendingTimeouts);
        this.rules.addGlobal("autoResolvedTriggers", this.autoResolvedTriggers);
        this.rules.addGlobal("disabledTriggers", this.disabledTriggers);
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, this.delay, (long)this.period);
    }

    public void reloadTrigger(String triggerId) {
        if (null == triggerId) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger trigger = null;
        try {
            trigger = this.definitions.getTrigger(triggerId);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService("Trigger", e.getMessage());
        }
        if (null == trigger) {
            this.log.debugf("Trigger not found for triggerId [" + triggerId + "], removing from rulebase if it exists", new Object[0]);
            Trigger doomedTrigger = new Trigger(triggerId, "doomed");
            this.removeTrigger(trigger);
            return;
        }
        this.reloadTrigger(trigger);
    }

    private void reloadTrigger(Trigger trigger) {
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        this.removeTrigger(trigger);
        if (trigger.isEnabled()) {
            try {
                Collection conditionSet = this.definitions.getTriggerConditions(trigger.getId(), null);
                Collection dampenings = this.definitions.getTriggerDampenings(trigger.getId(), null);
                this.rules.addFact(trigger);
                this.rules.addFacts(conditionSet);
                if (!dampenings.isEmpty()) {
                    this.rules.addFacts(dampenings);
                }
            }
            catch (Exception e) {
                this.log.debugf(e.getMessage(), (Object)e);
                this.msgLog.errorDefinitionsService("Conditions/Dampening", e.getMessage());
            }
        }
    }

    private void removeTrigger(Trigger trigger) {
        if (null != this.rules.getFact(trigger)) {
            this.rules.removeFact(trigger);
            final String triggerId = trigger.getId();
            this.rules.removeFacts(new Predicate<Object>(){

                @Override
                public boolean test(Object t) {
                    if (t instanceof Dampening) {
                        return ((Dampening)t).getTriggerId().equals(triggerId);
                    }
                    if (t instanceof Condition) {
                        return ((Condition)t).getTriggerId().equals(triggerId);
                    }
                    return false;
                }
            });
        } else {
            this.log.debugf("Trigger not found. Not removed from rulebase %s", (Object)trigger);
        }
    }

    public void sendData(Collection<Data> data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.pendingData.addAll(data);
    }

    public void sendData(Data data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.pendingData.add(data);
    }

    public void ackAlerts(Collection<String> alertIds, String ackBy, String ackNotes) throws Exception {
        if (this.isEmpty(alertIds)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        List<Alert> alertsToAck = this.getAlerts(criteria);
        for (Alert a : alertsToAck) {
            a.setStatus(Alert.Status.ACKNOWLEDGED);
            a.setAckBy(ackBy);
            a.setAckNotes(ackNotes);
            this.updateAlertStatus(a);
        }
    }

    public void resolveAlerts(Collection<String> alertIds, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(alertIds)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        List<Alert> alertsToResolve = this.getAlerts(criteria);
        for (Alert a : alertsToResolve) {
            a.setStatus(Alert.Status.RESOLVED);
            a.setResolvedBy(resolvedBy);
            a.setResolvedNotes(resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a);
        }
    }

    public void resolveAlertsForTrigger(String triggerId, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(triggerId)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setTriggerId(triggerId);
        criteria.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
        List<Alert> alertsToResolve = this.getAlerts(criteria);
        for (Alert a : alertsToResolve) {
            a.setStatus(Alert.Status.RESOLVED);
            a.setResolvedBy(resolvedBy);
            a.setResolvedNotes(resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a);
        }
    }

    private Alert updateAlertStatus(Alert alert) throws Exception {
        if (alert == null || alert.getAlertId() == null || alert.getAlertId().isEmpty()) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            ResultSet rsAlertsStatusToDelete = this.session.execute((Statement)this.selectAlertStatus.bind(new Object[]{alert.getAlertId()}));
            for (Row row : rsAlertsStatusToDelete) {
                String alertIdToDelete = row.getString("alertId");
                String statusToDelete = row.getString("status");
                this.session.execute((Statement)this.deleteAlertStatus.bind(new Object[]{alertIdToDelete, statusToDelete}));
            }
            this.session.execute((Statement)this.insertAlertStatus.bind(new Object[]{alert.getAlertId(), alert.getStatus().name()}));
            this.session.execute((Statement)this.updateAlert.bind(new Object[]{this.toJson(alert), alert.getAlertId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alert;
    }

    private String toJson(Object resource) {
        this.log.debugf(this.gson.toJson(resource), new Object[0]);
        return this.gson.toJson(resource);
    }

    private <T> T fromJson(String json, Class<T> clazz) {
        return (T)this.gson.fromJson(json, clazz);
    }

    private boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisabledTriggers() {
        try {
            for (Trigger t : this.disabledTriggers) {
                try {
                    t.setEnabled(false);
                    this.definitions.updateTrigger(t);
                }
                catch (Exception e) {
                    this.log.errorf("Failed to persist updated trigger. Could not autoDisable %s", (Object)t);
                }
            }
        }
        finally {
            this.disabledTriggers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAutoResolvedTriggers() {
        try {
            for (Map.Entry<Trigger, List<Set<ConditionEval>>> entry : this.autoResolvedTriggers.entrySet()) {
                Trigger t = entry.getKey();
                try {
                    if (!t.isAutoResolveAlerts()) continue;
                    this.resolveAlertsForTrigger(t.getId(), "AUTO", null, entry.getValue());
                }
                catch (Exception e) {
                    this.log.errorf("Failed to resolve Alerts. Could not AutoResolve alerts for trigger %s", (Object)t);
                }
            }
        }
        finally {
            this.autoResolvedTriggers.clear();
        }
    }

    private class RulesInvoker
    extends TimerTask {
        private RulesInvoker() {
        }

        @Override
        public void run() {
            int numTimeouts = this.checkPendingTimeouts();
            if (!CassAlertsServiceImpl.this.pendingData.isEmpty() || numTimeouts > 0) {
                CassAlertsServiceImpl.this.log.debugf("Executing rules engine on [%1d] datums and [%2d] dampening timeouts.", (Object)CassAlertsServiceImpl.this.pendingData.size(), (Object)numTimeouts);
                try {
                    if (CassAlertsServiceImpl.this.pendingData.isEmpty()) {
                        CassAlertsServiceImpl.this.rules.fireNoData();
                    } else {
                        CassAlertsServiceImpl.this.rules.addData(CassAlertsServiceImpl.this.pendingData);
                        CassAlertsServiceImpl.this.pendingData.clear();
                    }
                    CassAlertsServiceImpl.this.rules.fire();
                    CassAlertsServiceImpl.this.addAlerts(CassAlertsServiceImpl.this.alerts);
                    CassAlertsServiceImpl.this.alerts.clear();
                    CassAlertsServiceImpl.this.handleDisabledTriggers();
                    CassAlertsServiceImpl.this.handleAutoResolvedTriggers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CassAlertsServiceImpl.this.log.debugf("Error on rules processing: " + e, new Object[0]);
                    CassAlertsServiceImpl.this.msgLog.errorProcessingRules(e.getMessage());
                }
                finally {
                    CassAlertsServiceImpl.this.alerts.clear();
                }
            }
        }

        private int checkPendingTimeouts() {
            if (CassAlertsServiceImpl.this.pendingTimeouts.isEmpty()) {
                return 0;
            }
            long now = System.currentTimeMillis();
            HashSet<Dampening> timeouts = null;
            for (Dampening d : CassAlertsServiceImpl.this.pendingTimeouts) {
                if (now < d.getTrueEvalsStartTime() + d.getEvalTimeSetting()) continue;
                d.setSatisfied(true);
                try {
                    CassAlertsServiceImpl.this.log.debugf("Dampening Timeout Hit! %s", (Object)d.toString());
                    CassAlertsServiceImpl.this.rules.updateFact(d);
                    if (null == timeouts) {
                        timeouts = new HashSet<Dampening>();
                    }
                    timeouts.add(d);
                }
                catch (Exception e) {
                    CassAlertsServiceImpl.this.log.error((Object)("Unable to update Dampening Fact on Timeout! " + d.toString()), (Throwable)e);
                }
            }
            if (null == timeouts) {
                return 0;
            }
            CassAlertsServiceImpl.this.pendingTimeouts.removeAll(timeouts);
            return timeouts.size();
        }
    }
}

