/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.model.trigger.TriggerTemplate;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.jboss.logging.Logger;

@Singleton
public class CassDefinitionsServiceImpl
implements DefinitionsService {
    private static final String JBOSS_DATA_DIR = "jboss.server.data.dir";
    private static final String INIT_FOLDER = "hawkular-alerts";
    private static final String CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassDefinitionsServiceImpl.class);
    private AlertsService alertsService;
    private Session session;
    private String keyspace;
    private boolean initialized = false;
    private List<DefinitionsListener> listeners = new ArrayList<DefinitionsListener>();
    private PreparedStatement insertTrigger;
    private PreparedStatement selectTriggerConditions;
    private PreparedStatement selectTriggerConditionsTriggerMode;
    private PreparedStatement deleteConditionsMode;
    private PreparedStatement insertAvailabilityCondition;
    private PreparedStatement insertCompareCondition;
    private PreparedStatement insertStringCondition;
    private PreparedStatement insertThresholdCondition;
    private PreparedStatement insertThresholdRangeCondition;
    private PreparedStatement insertTag;
    private PreparedStatement insertDampening;
    private PreparedStatement insertAction;
    private PreparedStatement selectAllTriggers;
    private PreparedStatement selectAllConditions;
    private PreparedStatement selectAllDampenings;
    private PreparedStatement selectAllActions;
    private PreparedStatement selectTrigger;
    private PreparedStatement selectTriggerDampenings;
    private PreparedStatement selectTriggerDampeningsMode;
    private PreparedStatement deleteDampenings;
    private PreparedStatement deleteConditions;
    private PreparedStatement deleteTriggers;
    private PreparedStatement updateTrigger;
    private PreparedStatement deleteDampeningId;
    private PreparedStatement selectDampeningId;
    private PreparedStatement updateDampeningId;
    private PreparedStatement selectConditionId;
    private PreparedStatement insertActionPlugin;
    private PreparedStatement deleteActionPlugin;
    private PreparedStatement updateActionPlugin;
    private PreparedStatement selectActionPlugins;
    private PreparedStatement selectActionPlugin;
    private PreparedStatement deleteAction;
    private PreparedStatement updateAction;
    private PreparedStatement selectActionsPlugin;
    private PreparedStatement selectAction;
    private PreparedStatement selectTagsTriggers;
    private PreparedStatement insertTagsTriggers;
    private PreparedStatement updateTagsTriggers;
    private PreparedStatement selectTag;
    private PreparedStatement deleteTagsTriggers;

    public CassDefinitionsServiceImpl() {
    }

    public CassDefinitionsServiceImpl(AlertsService alertsService, Session session, String keyspace) {
        this();
        this.alertsService = alertsService;
        this.session = session;
        this.keyspace = keyspace;
    }

    @PostConstruct
    public void init() {
        try {
            if (this.keyspace == null) {
                this.keyspace = AlertProperties.getProperty(CASSANDRA_KEYSPACE, "hawkular_alerts");
            }
            if (this.session == null) {
                this.session = CassCluster.getSession();
            }
            this.initPreparedStatements();
            this.initialData();
            if (this.alertsService == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    this.alertsService = (AlertsService)ctx.lookup("java:app/hawkular-alerts-engine/CassAlertsServiceImpl");
                }
                catch (NamingException e) {
                    this.log.debugf(e.getMessage(), (Object)e);
                    this.msgLog.errorCannotWithAlertsService(e.getMessage());
                }
            }
        }
        catch (Throwable t) {
            this.msgLog.errorCannotInitializeDefinitionsService(t.getMessage());
            t.printStackTrace();
        }
    }

    private void initialData() throws IOException {
        String data = System.getProperty(JBOSS_DATA_DIR);
        if (data == null || data.isEmpty()) {
            this.msgLog.errorFolderNotFound(data);
            return;
        }
        String folder = data + "/" + INIT_FOLDER;
        this.initFiles(folder);
        this.initialized = true;
    }

    private void initPreparedStatements() {
        if (this.insertTrigger == null) {
            this.insertTrigger = this.session.prepare("INSERT INTO " + this.keyspace + ".triggers " + "(name, description, autoDisable, autoResolve, autoResolveAlerts, actions, firingMatch, " + "autoResolveMatch, id, enabled) " + "values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.selectTriggerConditions == null) {
            this.selectTriggerConditions = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange FROM " + this.keyspace + ".conditions " + "WHERE triggerId = ? ORDER BY triggerMode, type, conditionId ");
        }
        if (this.selectTriggerConditionsTriggerMode == null) {
            this.selectTriggerConditionsTriggerMode = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange FROM " + this.keyspace + ".conditions " + "WHERE triggerId = ? AND triggerMode = ? ORDER BY triggerMode, type, conditionId ");
        }
        if (this.deleteConditionsMode == null) {
            this.deleteConditionsMode = this.session.prepare("DELETE FROM " + this.keyspace + ".conditions " + "WHERE triggerId = ? AND triggerMode = ? ");
        }
        if (this.insertAvailabilityCondition == null) {
            this.insertAvailabilityCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, " + "operator) VALUES (?, ?, 'AVAILABILITY', ?, ?, ?, ?, ?) ");
        }
        if (this.insertCompareCondition == null) {
            this.insertCompareCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, " + "operator, data2Id, data2Multiplier) VALUES (?, ?, 'COMPARE', ?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertStringCondition == null) {
            this.insertStringCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, " + "operator, pattern, ignoreCase) VALUES (?, ?, 'STRING', ?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertThresholdCondition == null) {
            this.insertThresholdCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, " + "operator, threshold) VALUES (?, ?, 'THRESHOLD', ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertThresholdRangeCondition == null) {
            this.insertThresholdRangeCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, " + "operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange) VALUES (?, ?, 'RANGE', ?, ?, " + "?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertTag == null) {
            this.insertTag = this.session.prepare("INSERT INTO " + this.keyspace + ".tags " + "(triggerId, category, name, visible) VALUES (?, ?, ?, ?) ");
        }
        if (this.insertDampening == null) {
            this.insertDampening = this.session.prepare("INSERT INTO " + this.keyspace + ".dampenings " + "(triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, " + "dampeningId) VALUES (?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertAction == null) {
            this.insertAction = this.session.prepare("INSERT INTO " + this.keyspace + ".actions " + "(actionId, actionPlugin, properties) VALUES (?, ?, ?) ");
        }
        if (this.selectAllTriggers == null) {
            this.selectAllTriggers = this.session.prepare("SELECT name, description, autoDisable, autoResolve, autoResolveAlerts, actions, firingMatch, autoResolveMatch, id, enabled FROM " + this.keyspace + ".triggers ");
        }
        if (this.selectAllConditions == null) {
            this.selectAllConditions = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange FROM " + this.keyspace + ".conditions ");
        }
        if (this.selectAllDampenings == null) {
            this.selectAllDampenings = this.session.prepare("SELECT triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId FROM " + this.keyspace + ".dampenings ");
        }
        if (this.selectAllActions == null) {
            this.selectAllActions = this.session.prepare("SELECT actionId FROM " + this.keyspace + ".actions ");
        }
        if (this.selectTrigger == null) {
            this.selectTrigger = this.session.prepare("SELECT name, description, autoDisable, autoResolve, autoResolveAlerts, actions, firingMatch, autoResolveMatch, id, enabled FROM " + this.keyspace + ".triggers WHERE id = ? ");
        }
        if (this.selectTriggerDampenings == null) {
            this.selectTriggerDampenings = this.session.prepare("SELECT triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId FROM " + this.keyspace + ".dampenings " + "WHERE triggerId = ? ");
        }
        if (this.selectTriggerDampeningsMode == null) {
            this.selectTriggerDampeningsMode = this.session.prepare("SELECT triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId FROM " + this.keyspace + ".dampenings " + "WHERE triggerId = ? and triggerMode = ? ");
        }
        if (this.deleteDampenings == null) {
            this.deleteDampenings = this.session.prepare("DELETE FROM " + this.keyspace + ".dampenings WHERE triggerId = ? ");
        }
        if (this.deleteConditions == null) {
            this.deleteConditions = this.session.prepare("DELETE FROM " + this.keyspace + ".conditions WHERE triggerId = ? ");
        }
        if (this.deleteTriggers == null) {
            this.deleteTriggers = this.session.prepare("DELETE FROM " + this.keyspace + ".triggers WHERE id = ? ");
        }
        if (this.updateTrigger == null) {
            this.updateTrigger = this.session.prepare("UPDATE " + this.keyspace + ".triggers " + "SET name = ?, description = ?, autoDisable = ?, autoResolve = ?, autoResolveAlerts = ?, " + "actions = ?, firingMatch = ?, autoResolveMatch = ?, enabled = ? " + "WHERE id = ? ");
        }
        if (this.deleteDampeningId == null) {
            this.deleteDampeningId = this.session.prepare("DELETE FROM " + this.keyspace + ".dampenings " + "WHERE triggerId = ? AND triggerMode = ? AND dampeningId = ? ");
        }
        if (this.selectDampeningId == null) {
            this.selectDampeningId = this.session.prepare("SELECT triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId FROM " + this.keyspace + ".dampenings " + "WHERE dampeningId = ? ");
        }
        if (this.updateDampeningId == null) {
            this.updateDampeningId = this.session.prepare("UPDATE " + this.keyspace + ".dampenings " + "SET type = ?, evalTrueSetting = ?, evalTotalSetting = ?, evalTimeSetting = ? " + "WHERE triggerId = ? AND triggerMode = ? AND dampeningId = ? ");
        }
        if (this.selectConditionId == null) {
            this.selectConditionId = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange FROM " + this.keyspace + ".conditions WHERE conditionId = ? ");
        }
        if (this.insertActionPlugin == null) {
            this.insertActionPlugin = this.session.prepare("INSERT INTO " + this.keyspace + ".action_plugins (actionPlugin, " + "properties) VALUES (?, ?) ");
        }
        if (this.deleteActionPlugin == null) {
            this.deleteActionPlugin = this.session.prepare("DELETE FROM " + this.keyspace + ".action_plugins WHERE actionPlugin = ? ");
        }
        if (this.updateActionPlugin == null) {
            this.updateActionPlugin = this.session.prepare("UPDATE " + this.keyspace + ".action_plugins " + "SET properties = ? WHERE actionPlugin = ? ");
        }
        if (this.selectActionPlugins == null) {
            this.selectActionPlugins = this.session.prepare("SELECT actionPlugin FROM " + this.keyspace + ".action_plugins ");
        }
        if (this.selectActionPlugin == null) {
            this.selectActionPlugin = this.session.prepare("SELECT properties FROM " + this.keyspace + ".action_plugins " + "WHERE actionPlugin = ? ");
        }
        if (this.deleteAction == null) {
            this.deleteAction = this.session.prepare("DELETE FROM " + this.keyspace + ".actions WHERE actionId = ? ");
        }
        if (this.updateAction == null) {
            this.updateAction = this.session.prepare("UPDATE " + this.keyspace + ".actions " + "SET properties = ? " + "WHERE actionId = ?");
        }
        if (this.selectActionsPlugin == null) {
            this.selectActionsPlugin = this.session.prepare("SELECT actionId FROM " + this.keyspace + ".actions " + "WHERE actionPlugin = ? ");
        }
        if (this.selectAction == null) {
            this.selectAction = this.session.prepare("SELECT properties FROM " + this.keyspace + ".actions WHERE actionId = ? ");
        }
        if (this.selectTagsTriggers == null) {
            this.selectTagsTriggers = this.session.prepare("SELECT triggers FROM " + this.keyspace + ".tags_triggers " + "WHERE category = ? AND name = ? ");
        }
        if (this.insertTagsTriggers == null) {
            this.insertTagsTriggers = this.session.prepare("INSERT INTO " + this.keyspace + ".tags_triggers " + "(category, name, triggers) VALUES (?, ?, ?) ");
        }
        if (this.updateTagsTriggers == null) {
            this.updateTagsTriggers = this.session.prepare("UPDATE " + this.keyspace + ".tags_triggers " + "SET triggers = ? " + "WHERE category = ? AND name = ? ");
        }
        if (this.selectTag == null) {
            this.selectTag = this.session.prepare("SELECT category, name FROM " + this.keyspace + ".tags " + "WHERE triggerId = ? ");
        }
        if (this.deleteTagsTriggers == null) {
            this.deleteTagsTriggers = this.session.prepare("DELETE FROM " + this.keyspace + ".tags_triggers " + "WHERE category = ? AND name = ? ");
        }
    }

    private void initFiles(String folder) {
        if (folder == null) {
            this.msgLog.errorFolderMustBeNotNull();
            return;
        }
        if (this.session == null) {
            this.msgLog.errorDatabaseException("Cassandra session is null. Initialization can not work.");
            return;
        }
        File fFolder = new File(folder);
        if (!fFolder.exists()) {
            this.log.debugf("Data folder doesn't exits. Skipping initialization.", new Object[0]);
            return;
        }
        try {
            this.initTriggers(fFolder);
            this.initConditions(fFolder);
            this.initDampenings(fFolder);
            this.initActions(fFolder);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.msgLog.errorDatabaseException("Error initializing files. Msg: " + e);
        }
    }

    private void initTriggers(File fFolder) throws Exception {
        File triggers = new File(fFolder, "triggers.data");
        if (triggers.exists() && triggers.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(triggers.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.log.debugf(e.toString(), (Object)e);
                this.msgLog.warningReadingFile("triggers.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length != 10) continue;
                    String triggerId = fields[0];
                    boolean enabled = new Boolean(fields[1]);
                    String name = fields[2];
                    String description = fields[3];
                    boolean autoDisable = new Boolean(fields[4]);
                    boolean autoResolve = new Boolean(fields[5]);
                    boolean autoResolveAlerts = new Boolean(fields[6]);
                    TriggerTemplate.Match firingMatch = TriggerTemplate.Match.valueOf((String)fields[7]);
                    TriggerTemplate.Match autoResolveMatch = TriggerTemplate.Match.valueOf((String)fields[8]);
                    String[] notifiers = fields[9].split("\\|");
                    Trigger trigger = new Trigger(triggerId, name);
                    trigger.setEnabled(enabled);
                    trigger.setAutoDisable(autoDisable);
                    trigger.setAutoResolve(autoResolve);
                    trigger.setAutoResolveAlerts(autoResolveAlerts);
                    trigger.setDescription(description);
                    trigger.setFiringMatch(firingMatch);
                    trigger.setAutoResolveMatch(autoResolveMatch);
                    for (String notifier : notifiers) {
                        trigger.addAction(notifier);
                    }
                    this.addTrigger(trigger);
                    this.log.debugf("Init file - Inserting [%s]", (Object)trigger);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("triggers.data");
        }
    }

    private void initConditions(File initFolder) throws Exception {
        File conditions = new File(initFolder, "conditions.data");
        if (conditions.exists() && conditions.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(conditions.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.msgLog.warningReadingFile("conditions.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    CompareCondition newCondition;
                    String operator;
                    String dataId;
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length <= 4) continue;
                    String triggerId = fields[0];
                    Trigger.Mode triggerMode = Trigger.Mode.valueOf((String)fields[1]);
                    int conditionSetSize = new Integer(fields[2]);
                    int conditionSetIndex = new Integer(fields[3]);
                    String type = fields[4];
                    if (type != null && !type.isEmpty() && type.equals("threshold") && fields.length == 8) {
                        dataId = fields[5];
                        operator = fields[6];
                        Double threshold = (double)new Double(fields[7]);
                        ThresholdCondition newCondition2 = new ThresholdCondition();
                        newCondition2.setTriggerId(triggerId);
                        newCondition2.setTriggerMode(triggerMode);
                        newCondition2.setConditionSetSize(conditionSetSize);
                        newCondition2.setConditionSetIndex(conditionSetIndex);
                        newCondition2.setDataId(dataId);
                        newCondition2.setOperator(ThresholdCondition.Operator.valueOf((String)operator));
                        newCondition2.setThreshold(threshold);
                        this.initCondition((Condition)newCondition2);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition2);
                    }
                    if (type != null && !type.isEmpty() && type.equals("range") && fields.length == 11) {
                        dataId = fields[5];
                        String operatorLow = fields[6];
                        String operatorHigh = fields[7];
                        Double thresholdLow = (double)new Double(fields[8]);
                        Double thresholdHigh = (double)new Double(fields[9]);
                        boolean inRange = new Boolean(fields[10]);
                        ThresholdRangeCondition newCondition3 = new ThresholdRangeCondition();
                        newCondition3.setTriggerId(triggerId);
                        newCondition3.setTriggerMode(triggerMode);
                        newCondition3.setConditionSetSize(conditionSetSize);
                        newCondition3.setConditionSetIndex(conditionSetIndex);
                        newCondition3.setDataId(dataId);
                        newCondition3.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)operatorLow));
                        newCondition3.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)operatorHigh));
                        newCondition3.setThresholdLow(thresholdLow);
                        newCondition3.setThresholdHigh(thresholdHigh);
                        newCondition3.setInRange(inRange);
                        this.initCondition((Condition)newCondition3);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition3);
                    }
                    if (type != null && !type.isEmpty() && type.equals("compare") && fields.length == 9) {
                        dataId = fields[5];
                        operator = fields[6];
                        Double data2Multiplier = (double)new Double(fields[7]);
                        String data2Id = fields[8];
                        newCondition = new CompareCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(CompareCondition.Operator.valueOf((String)operator));
                        newCondition.setData2Multiplier(data2Multiplier);
                        newCondition.setData2Id(data2Id);
                        this.initCondition((Condition)newCondition);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition);
                    }
                    if (type != null && !type.isEmpty() && type.equals("string") && fields.length == 9) {
                        dataId = fields[5];
                        operator = fields[6];
                        String pattern = fields[7];
                        boolean ignoreCase = new Boolean(fields[8]);
                        newCondition = new StringCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(StringCondition.Operator.valueOf((String)operator));
                        newCondition.setPattern(pattern);
                        newCondition.setIgnoreCase(ignoreCase);
                        this.initCondition((Condition)newCondition);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition);
                    }
                    if (type == null || type.isEmpty() || !type.equals("availability") || fields.length != 7) continue;
                    dataId = fields[5];
                    operator = fields[6];
                    AvailabilityCondition newCondition4 = new AvailabilityCondition();
                    newCondition4.setTriggerId(triggerId);
                    newCondition4.setTriggerMode(triggerMode);
                    newCondition4.setConditionSetSize(conditionSetSize);
                    newCondition4.setConditionSetIndex(conditionSetIndex);
                    newCondition4.setDataId(dataId);
                    newCondition4.setOperator(AvailabilityCondition.Operator.valueOf((String)operator));
                    this.initCondition((Condition)newCondition4);
                    this.log.debugf("Init file - Inserting [%s]", (Object)newCondition4);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("conditions.data");
        }
    }

    private void initCondition(Condition condition) throws Exception {
        Collection<Condition> conditions = this.getTriggerConditions(condition.getTriggerId(), condition.getTriggerMode());
        conditions.add(condition);
        this.setConditions(condition.getTriggerId(), condition.getTriggerMode(), conditions);
    }

    private void initDampenings(File initFolder) throws Exception {
        File dampening = new File(initFolder, "dampening.data");
        if (dampening.exists() && dampening.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(dampening.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.msgLog.warningReadingFile("dampening.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length != 6) continue;
                    String triggerId = fields[0];
                    Trigger.Mode triggerMode = Trigger.Mode.valueOf((String)fields[1]);
                    String type = fields[2];
                    int evalTrueSetting = new Integer(fields[3]);
                    int evalTotalSetting = new Integer(fields[4]);
                    int evalTimeSetting = new Integer(fields[5]);
                    Dampening newDampening = new Dampening(triggerId, triggerMode, Dampening.Type.valueOf((String)type), evalTrueSetting, evalTotalSetting, (long)evalTimeSetting);
                    this.addDampening(newDampening);
                    this.log.debugf("Init file - Inserting [%s]", (Object)newDampening);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("dampening.data");
        }
    }

    private void initActions(File initFolder) throws Exception {
        File actions = new File(initFolder, "actions.data");
        if (actions.exists() && actions.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(actions.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length <= 2) continue;
                    String actionId = fields[0];
                    String actionPlugin = fields[1];
                    HashMap<String, String> newAction = new HashMap<String, String>();
                    newAction.put("actionId", actionId);
                    newAction.put("actionPlugin", actionPlugin);
                    for (int i = 2; i < fields.length; ++i) {
                        String property = fields[i];
                        String[] properties = property.split("=");
                        if (properties.length != 2) continue;
                        newAction.put(properties[0], properties[1]);
                    }
                    this.addAction(actionId, newAction);
                    this.log.debugf("Init file - Inserting [%s]", newAction);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("actions.data");
        }
    }

    public void addAction(String actionId, Map<String, String> properties) throws Exception {
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("actionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        String actionPlugin = properties.get("actionPlugin");
        if (actionPlugin == null) {
            throw new IllegalArgumentException("Action has not actionPlugin property");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertAction == null) {
            throw new RuntimeException("insertAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.insertAction.bind(new Object[]{actionId, actionPlugin, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addTrigger(Trigger trigger) throws Exception {
        if (trigger == null || trigger.getId() == null || trigger.getId().isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertTrigger == null) {
            throw new RuntimeException("insertTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.insertTrigger.bind(new Object[]{trigger.getName(), trigger.getDescription(), trigger.isAutoDisable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getActions(), trigger.getFiringMatch().name(), trigger.getAutoResolveMatch().name(), trigger.getId(), trigger.isEnabled()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeTrigger(String triggerId) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteDampenings == null || this.deleteConditions == null || this.deleteTriggers == null) {
            throw new RuntimeException("delete*Triggers PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.deleteDampenings.bind(new Object[]{triggerId}));
            this.session.execute((Statement)this.deleteConditions.bind(new Object[]{triggerId}));
            this.deleteTags(triggerId, null, null);
            this.session.execute((Statement)this.deleteTriggers.bind(new Object[]{triggerId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Trigger updateTrigger(Trigger trigger) throws Exception {
        if (trigger == null || trigger.getId() == null || trigger.getId().isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.updateTrigger == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.updateTrigger.bind(new Object[]{trigger.getName(), trigger.getDescription(), trigger.isAutoDisable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getActions(), trigger.getFiringMatch().name(), trigger.getAutoResolveMatch().name(), trigger.isEnabled(), trigger.getId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(trigger.getId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.TRIGGER_CHANGE);
        return trigger;
    }

    public Trigger getTrigger(String triggerId) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectTrigger == null) {
            throw new RuntimeException("selectTrigger PreparedStatement is null");
        }
        Trigger trigger = null;
        try {
            ResultSet rsTrigger = this.session.execute((Statement)this.selectTrigger.bind(new Object[]{triggerId}));
            Iterator itTrigger = rsTrigger.iterator();
            if (itTrigger.hasNext()) {
                Row row = (Row)itTrigger.next();
                trigger = new Trigger();
                trigger.setName(row.getString("name"));
                trigger.setDescription(row.getString("description"));
                trigger.setAutoDisable(row.getBool("autoDisable"));
                trigger.setAutoResolve(row.getBool("autoResolve"));
                trigger.setAutoResolveAlerts(row.getBool("autoResolveAlerts"));
                trigger.setActions(row.getSet("actions", String.class));
                trigger.setFiringMatch(TriggerTemplate.Match.valueOf((String)row.getString("firingMatch")));
                trigger.setAutoResolveMatch(TriggerTemplate.Match.valueOf((String)row.getString("autoResolveMatch")));
                trigger.setId(row.getString("id"));
                trigger.setEnabled(row.getBool("enabled"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return trigger;
    }

    public Collection<Trigger> getAllTriggers() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllTriggers == null) {
            throw new RuntimeException("selectAllTriggers PreparedStatement is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            ResultSet rsTriggers = this.session.execute((Statement)this.selectAllTriggers.bind());
            for (Row row : rsTriggers) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("name"));
                trigger.setDescription(row.getString("description"));
                trigger.setAutoDisable(row.getBool("autoDisable"));
                trigger.setAutoResolve(row.getBool("autoResolve"));
                trigger.setAutoResolveAlerts(row.getBool("autoResolveAlerts"));
                trigger.setActions(row.getSet("actions", String.class));
                trigger.setFiringMatch(TriggerTemplate.Match.valueOf((String)row.getString("firingMatch")));
                trigger.setAutoResolveMatch(TriggerTemplate.Match.valueOf((String)row.getString("autoResolveMatch")));
                trigger.setId(row.getString("id"));
                trigger.setEnabled(row.getBool("enabled"));
                triggers.add(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return triggers;
    }

    public Trigger copyTrigger(String triggerId, Map<String, String> dataIdMap) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (dataIdMap == null || dataIdMap.isEmpty()) {
            throw new IllegalArgumentException("DataIdMap must be not null");
        }
        Trigger trigger = this.getTrigger(triggerId);
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger not found for triggerId [" + triggerId + "]");
        }
        HashSet<String> dataIdTokens = new HashSet<String>();
        Collection<Condition> conditions = this.getTriggerConditions(triggerId, null);
        for (Condition c : conditions) {
            if (c instanceof CompareCondition) {
                dataIdTokens.add(((CompareCondition)c).getDataId());
                dataIdTokens.add(((CompareCondition)c).getData2Id());
                continue;
            }
            dataIdTokens.add(c.getDataId());
        }
        if (!dataIdTokens.equals(dataIdMap.keySet())) {
            throw new IllegalArgumentException("DataIdMap must contain the exact dataIds (keyset) expected by the condition set. Expected: " + dataIdMap.keySet() + ", dataIdMap: " + dataIdMap.keySet());
        }
        Collection<Dampening> dampenings = this.getTriggerDampenings(triggerId, null);
        Trigger newTrigger = new Trigger(trigger.getName());
        newTrigger.setName(trigger.getName());
        newTrigger.setDescription(trigger.getDescription());
        newTrigger.setFiringMatch(trigger.getFiringMatch());
        newTrigger.setAutoResolveMatch(trigger.getAutoResolveMatch());
        newTrigger.setActions(trigger.getActions());
        this.addTrigger(newTrigger);
        for (Condition c : conditions) {
            ThresholdCondition newCondition = null;
            if (c instanceof ThresholdCondition) {
                newCondition = new ThresholdCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((ThresholdCondition)c).getOperator(), ((ThresholdCondition)c).getThreshold());
            } else if (c instanceof ThresholdRangeCondition) {
                newCondition = new ThresholdRangeCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((ThresholdRangeCondition)c).getOperatorLow(), ((ThresholdRangeCondition)c).getOperatorHigh(), ((ThresholdRangeCondition)c).getThresholdLow(), ((ThresholdRangeCondition)c).getThresholdHigh(), ((ThresholdRangeCondition)c).isInRange());
            } else if (c instanceof AvailabilityCondition) {
                newCondition = new AvailabilityCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((AvailabilityCondition)c).getOperator());
            } else if (c instanceof CompareCondition) {
                newCondition = new CompareCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(((CompareCondition)c).getDataId()), ((CompareCondition)c).getOperator(), ((CompareCondition)c).getData2Multiplier(), dataIdMap.get(((CompareCondition)c).getData2Id()));
            } else if (c instanceof StringCondition) {
                newCondition = new StringCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((StringCondition)c).getOperator(), ((StringCondition)c).getPattern(), ((StringCondition)c).isIgnoreCase());
            }
            this.addCondition(newTrigger.getId(), newCondition.getTriggerMode(), (Condition)newCondition);
        }
        for (Dampening d : dampenings) {
            Dampening newDampening = new Dampening(newTrigger.getId(), d.getTriggerMode(), d.getType(), d.getEvalTrueSetting(), d.getEvalTotalSetting(), d.getEvalTimeSetting());
            this.addDampening(newDampening);
        }
        return newTrigger;
    }

    public Dampening addDampening(Dampening dampening) throws Exception {
        if (dampening == null || dampening.getTriggerId() == null || dampening.getTriggerId().isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertDampening == null) {
            throw new RuntimeException("insertDampening PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.insertDampening.bind(new Object[]{dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
        return dampening;
    }

    public void removeDampening(String dampeningId) throws Exception {
        if (dampeningId == null || dampeningId.isEmpty()) {
            throw new IllegalArgumentException("dampeningId must not be null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteDampeningId == null) {
            throw new RuntimeException("deleteDampeningId PreparedStatement is null");
        }
        Dampening dampening = this.getDampening(dampeningId);
        if (dampening == null) {
            this.log.debugf("Ignoring removeDampening(" + dampeningId + "), the Dampening does not exist.", new Object[0]);
            return;
        }
        try {
            this.session.execute((Statement)this.deleteDampeningId.bind(new Object[]{dampening.getTriggerId(), dampening.getTriggerMode().name(), dampeningId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
    }

    public Dampening updateDampening(Dampening dampening) throws Exception {
        if (dampening == null || dampening.getDampeningId() == null || dampening.getDampeningId().isEmpty()) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.updateDampeningId == null) {
            throw new RuntimeException("updateDampeningId PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.updateDampeningId.bind(new Object[]{dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
        return dampening;
    }

    public Dampening getDampening(String dampeningId) throws Exception {
        if (dampeningId == null || dampeningId.isEmpty()) {
            throw new IllegalArgumentException("dampeningId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectDampeningId == null) {
            throw new RuntimeException("selectDampeningId PreparedStatement is null");
        }
        Dampening dampening = null;
        try {
            ResultSet rsDampening = this.session.execute((Statement)this.selectDampeningId.bind(new Object[]{dampeningId}));
            Iterator itDampening = rsDampening.iterator();
            if (itDampening.hasNext()) {
                Row row = (Row)itDampening.next();
                dampening = new Dampening();
                dampening.setTriggerId(row.getString("triggerId"));
                dampening.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                dampening.setType(Dampening.Type.valueOf((String)row.getString("type")));
                dampening.setEvalTrueSetting(row.getInt("evalTrueSetting"));
                dampening.setEvalTotalSetting(row.getInt("evalTotalSetting"));
                dampening.setEvalTimeSetting(row.getLong("evalTimeSetting"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampening;
    }

    public Collection<Dampening> getTriggerDampenings(String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectTriggerDampenings == null || this.selectTriggerDampeningsMode == null) {
            throw new RuntimeException("selectTriggerDampenings* PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = triggerMode == null ? this.session.execute((Statement)this.selectTriggerDampenings.bind(new Object[]{triggerId})) : this.session.execute((Statement)this.selectTriggerDampeningsMode.bind(new Object[]{triggerId, triggerMode.name()}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getAllDampenings() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllDampenings == null) {
            throw new RuntimeException("selectAllDampenings PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)this.selectAllDampenings.bind());
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    private void mapDampenings(ResultSet rsDampenings, List<Dampening> dampenings) throws Exception {
        for (Row row : rsDampenings) {
            Dampening dampening = new Dampening();
            dampening.setTriggerId(row.getString("triggerId"));
            dampening.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
            dampening.setType(Dampening.Type.valueOf((String)row.getString("type")));
            dampening.setEvalTrueSetting(row.getInt("evalTrueSetting"));
            dampening.setEvalTotalSetting(row.getInt("evalTotalSetting"));
            dampening.setEvalTimeSetting(row.getLong("evalTimeSetting"));
            dampenings.add(dampening);
        }
    }

    public Collection<Condition> addCondition(String triggerId, Trigger.Mode triggerMode, Condition condition) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        Collection<Condition> conditions = this.getTriggerConditions(triggerId, triggerMode);
        conditions.add(condition);
        int i = 0;
        for (Condition c : conditions) {
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
        }
        return this.setConditions(triggerId, triggerMode, conditions);
    }

    public Collection<Condition> removeCondition(String conditionId) throws Exception {
        if (conditionId == null || conditionId.isEmpty()) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition condition = this.getCondition(conditionId);
        if (null == condition) {
            this.log.debugf("Ignoring removeCondition [%s], the condition does not exist.", (Object)conditionId);
        }
        String triggerId = condition.getTriggerId();
        Trigger.Mode triggerMode = condition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(triggerId, triggerMode);
        int i = 0;
        int size = conditions.size() - 1;
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) continue;
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
            newConditions.add(c);
        }
        return this.setConditions(triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> updateCondition(Condition condition) throws Exception {
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        String conditionId = condition.getConditionId();
        if (conditionId == null || conditionId.isEmpty()) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition existingCondition = this.getCondition(conditionId);
        if (null == condition) {
            throw new IllegalArgumentException("ConditionId [" + conditionId + "] does not exist.");
        }
        String triggerId = existingCondition.getTriggerId();
        Trigger.Mode triggerMode = existingCondition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(triggerId, triggerMode);
        int size = conditions.size();
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) {
                newConditions.add(condition);
                continue;
            }
            newConditions.add(c);
        }
        return this.setConditions(triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> setConditions(String triggerId, Trigger.Mode triggerMode, Collection<Condition> conditions) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("Conditions must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertAvailabilityCondition == null || this.insertCompareCondition == null || this.insertStringCondition == null || this.insertThresholdCondition == null || this.insertThresholdRangeCondition == null) {
            throw new RuntimeException("insert*Condition PreparedStatement is null");
        }
        this.removeConditions(triggerId, triggerMode);
        try {
            ArrayList<String> dataIds = new ArrayList<String>(2);
            int i = 0;
            for (Condition cond : conditions) {
                cond.setTriggerId(triggerId);
                cond.setTriggerMode(triggerMode);
                cond.setConditionSetSize(conditions.size());
                cond.setConditionSetIndex(++i);
                dataIds.add(cond.getDataId());
                if (cond instanceof AvailabilityCondition) {
                    AvailabilityCondition aCond = (AvailabilityCondition)cond;
                    this.session.execute((Statement)this.insertAvailabilityCondition.bind(new Object[]{aCond.getTriggerId(), aCond.getTriggerMode().name(), aCond.getConditionSetSize(), aCond.getConditionSetIndex(), aCond.getConditionId(), aCond.getDataId(), aCond.getOperator().name()}));
                } else if (cond instanceof CompareCondition) {
                    CompareCondition cCond = (CompareCondition)cond;
                    dataIds.add(cCond.getData2Id());
                    this.session.execute((Statement)this.insertCompareCondition.bind(new Object[]{cCond.getTriggerId(), cCond.getTriggerMode().name(), cCond.getConditionSetSize(), cCond.getConditionSetIndex(), cCond.getConditionId(), cCond.getDataId(), cCond.getOperator().name(), cCond.getData2Id(), cCond.getData2Multiplier()}));
                } else if (cond instanceof StringCondition) {
                    StringCondition sCond = (StringCondition)cond;
                    this.session.execute((Statement)this.insertStringCondition.bind(new Object[]{sCond.getTriggerId(), sCond.getTriggerMode().name(), sCond.getConditionSetSize(), sCond.getConditionSetIndex(), sCond.getConditionId(), sCond.getDataId(), sCond.getOperator().name(), sCond.getPattern(), sCond.isIgnoreCase()}));
                } else if (cond instanceof ThresholdCondition) {
                    ThresholdCondition tCond = (ThresholdCondition)cond;
                    this.session.execute((Statement)this.insertThresholdCondition.bind(new Object[]{tCond.getTriggerId(), tCond.getTriggerMode().name(), tCond.getConditionSetSize(), tCond.getConditionSetIndex(), tCond.getConditionId(), tCond.getDataId(), tCond.getOperator().name(), tCond.getThreshold()}));
                } else if (cond instanceof ThresholdRangeCondition) {
                    ThresholdRangeCondition rCond = (ThresholdRangeCondition)cond;
                    this.session.execute((Statement)this.insertThresholdRangeCondition.bind(new Object[]{rCond.getTriggerId(), rCond.getTriggerMode().name(), rCond.getConditionSetSize(), rCond.getConditionSetIndex(), rCond.getConditionId(), rCond.getDataId(), rCond.getOperatorLow().name(), rCond.getOperatorHigh().name(), rCond.getThresholdLow(), rCond.getThresholdHigh(), rCond.isInRange()}));
                }
                for (String dataId : dataIds) {
                    this.insertTag(cond.getTriggerId(), "dataId", dataId, false);
                }
                dataIds.clear();
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && this.alertsService != null) {
            this.alertsService.reloadTrigger(triggerId);
        }
        this.notifyListeners(DefinitionsEvent.EventType.CONDITION_CHANGE);
        return conditions;
    }

    private void insertTag(String triggerId, String category, String name, boolean visible) throws Exception {
        if (!this.getTags(triggerId, category, name).isEmpty()) {
            return;
        }
        this.session.execute((Statement)this.insertTag.bind(new Object[]{triggerId, category, name, visible}));
        this.insertTriggerByTagIndex(category, name, triggerId);
    }

    private void insertTriggerByTagIndex(String category, String name, String triggerId) {
        Set<String> triggers = this.getTriggersByTags(category, name);
        if ((triggers = new HashSet<String>(triggers)).isEmpty()) {
            triggers.add(triggerId);
            this.session.execute((Statement)this.insertTagsTriggers.bind(new Object[]{category, name, triggers}));
        } else if (!triggers.contains(triggerId)) {
            triggers.add(triggerId);
            this.session.execute((Statement)this.updateTagsTriggers.bind(new Object[]{triggers, category, name}));
        }
    }

    private Set<String> getTriggersByTags(String category, String name) {
        Set<String> triggerTags = new HashSet<String>();
        ResultSet rsTriggersTags = this.session.execute((Statement)this.selectTagsTriggers.bind(new Object[]{category, name}));
        Iterator itTriggersTags = rsTriggersTags.iterator();
        if (itTriggersTags.hasNext()) {
            Row row = (Row)itTriggersTags.next();
            triggerTags = row.getSet("triggers", String.class);
        }
        return triggerTags;
    }

    private List<Tag> getTags(String triggerId, String category, String name) throws Exception {
        StringBuilder sTags = new StringBuilder("SELECT triggerId, category, name, visible ").append("FROM ").append(this.keyspace).append(".tags ").append("WHERE triggerId = '").append(triggerId).append("' ");
        if (category != null && !category.trim().isEmpty()) {
            sTags.append("AND category = '").append(category).append("' ");
        }
        if (name != null && !name.trim().isEmpty()) {
            sTags.append("AND name = '").append(name).append("' ");
        }
        sTags.append("ORDER BY category, name");
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ResultSet rsTags = this.session.execute(sTags.toString());
        for (Row row : rsTags) {
            Tag tag = new Tag();
            tag.setTriggerId(row.getString("triggerId"));
            tag.setCategory(row.getString("category"));
            tag.setName(row.getString("name"));
            tag.setVisible(row.getBool("visible"));
            tags.add(tag);
        }
        return tags;
    }

    private void notifyListeners(DefinitionsEvent.EventType eventType) {
        DefinitionsEvent de = new DefinitionsEvent(eventType);
        for (DefinitionsListener dl : this.listeners) {
            this.log.debugf("Notified Listener %s", (Object)eventType.name());
            dl.onChange(de);
        }
    }

    private void removeConditions(String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must not be null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must not be null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteConditionsMode == null) {
            throw new RuntimeException("deleteConditionsMode PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.deleteConditionsMode.bind(new Object[]{triggerId, triggerMode.name()}));
            this.deleteTags(triggerId, "dataId", null);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void deleteTags(String triggerId, String category, String name) throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        StringBuilder sTags = new StringBuilder("DELETE FROM ").append(this.keyspace).append(".tags ").append("WHERE triggerId = '").append(triggerId).append("' ");
        if (category != null && !category.trim().isEmpty()) {
            sTags.append(" AND category = '").append(category).append("' ");
        }
        if (name != null && !name.trim().isEmpty()) {
            sTags.append(" AND name = '").append(name).append("' ");
        }
        try {
            this.deleteTriggerByTagIndex(triggerId, category, name);
            this.session.execute(sTags.toString());
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void deleteTriggerByTagIndex(String triggerId, String category, String name) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            return;
        }
        List<Tag> tags = null;
        if (category == null || name == null) {
            tags = this.getTriggerTags(triggerId, category);
        } else {
            tags = new ArrayList<Tag>();
            Tag singleTag = new Tag();
            singleTag.setCategory(category);
            singleTag.setName(name);
            tags.add(singleTag);
        }
        for (Tag tag : tags) {
            Set<String> triggers = this.getTriggersByTags(tag.getCategory(), tag.getName());
            if (triggers.size() > 1) {
                HashSet<String> updateTriggers = new HashSet<String>(triggers);
                updateTriggers.remove(triggerId);
                this.session.execute((Statement)this.updateTagsTriggers.bind(new Object[]{triggers, tag.getCategory(), tag.getName()}));
                continue;
            }
            this.session.execute((Statement)this.deleteTagsTriggers.bind(new Object[]{tag.getCategory(), tag.getName()}));
        }
    }

    public Condition getCondition(String conditionId) throws Exception {
        if (conditionId == null || conditionId.isEmpty()) {
            throw new IllegalArgumentException("conditionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectConditionId == null) {
            throw new RuntimeException("selectConditionId PreparedStatement is null");
        }
        Condition condition = null;
        try {
            ResultSet rsCondition = this.session.execute((Statement)this.selectConditionId.bind(new Object[]{conditionId}));
            Iterator itCondition = rsCondition.iterator();
            if (itCondition.hasNext()) {
                Row row = (Row)itCondition.next();
                condition = this.mapCondition(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return condition;
    }

    public Collection<Condition> getTriggerConditions(String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("triggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectTriggerConditions == null || this.selectTriggerConditionsTriggerMode == null) {
            throw new RuntimeException("selectTriggerConditions* PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = triggerMode == null ? this.session.execute((Statement)this.selectTriggerConditions.bind(new Object[]{triggerId})) : this.session.execute((Statement)this.selectTriggerConditionsTriggerMode.bind(new Object[]{triggerId, triggerMode.name()}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getAllConditions() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllConditions == null) {
            throw new RuntimeException("selectAllConditions PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)this.selectAllConditions.bind());
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    private void mapConditions(ResultSet rsConditions, List<Condition> conditions) throws Exception {
        for (Row row : rsConditions) {
            Condition condition = this.mapCondition(row);
            if (condition == null) continue;
            conditions.add(condition);
        }
    }

    private Condition mapCondition(Row row) throws Exception {
        AvailabilityCondition condition = null;
        String type = row.getString("type");
        if (type != null && !type.isEmpty()) {
            if (type.equals(Condition.Type.AVAILABILITY.name())) {
                AvailabilityCondition aCondition = new AvailabilityCondition();
                aCondition.setTriggerId(row.getString("triggerId"));
                aCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                aCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                aCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                aCondition.setDataId(row.getString("dataId"));
                aCondition.setOperator(AvailabilityCondition.Operator.valueOf((String)row.getString("operator")));
                condition = aCondition;
            } else if (type.equals(Condition.Type.COMPARE.name())) {
                CompareCondition cCondition = new CompareCondition();
                cCondition.setTriggerId(row.getString("triggerId"));
                cCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                cCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                cCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                cCondition.setDataId(row.getString("dataId"));
                cCondition.setOperator(CompareCondition.Operator.valueOf((String)row.getString("operator")));
                cCondition.setData2Id(row.getString("data2Id"));
                cCondition.setData2Multiplier(Double.valueOf(row.getDouble("data2Multiplier")));
                condition = cCondition;
            } else if (type.equals(Condition.Type.STRING.name())) {
                StringCondition sCondition = new StringCondition();
                sCondition.setTriggerId(row.getString("triggerId"));
                sCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                sCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                sCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                sCondition.setDataId(row.getString("dataId"));
                sCondition.setOperator(StringCondition.Operator.valueOf((String)row.getString("operator")));
                sCondition.setPattern(row.getString("pattern"));
                sCondition.setIgnoreCase(row.getBool("ignoreCase"));
                condition = sCondition;
            } else if (type.equals(Condition.Type.THRESHOLD.name())) {
                ThresholdCondition tCondition = new ThresholdCondition();
                tCondition.setTriggerId(row.getString("triggerId"));
                tCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                tCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                tCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                tCondition.setDataId(row.getString("dataId"));
                tCondition.setOperator(ThresholdCondition.Operator.valueOf((String)row.getString("operator")));
                tCondition.setThreshold(Double.valueOf(row.getDouble("threshold")));
                condition = tCondition;
            } else if (type.equals(Condition.Type.RANGE.name())) {
                ThresholdRangeCondition rCondition = new ThresholdRangeCondition();
                rCondition.setTriggerId(row.getString("triggerId"));
                rCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                rCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                rCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                rCondition.setDataId(row.getString("dataId"));
                rCondition.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorLow")));
                rCondition.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorHigh")));
                rCondition.setThresholdLow(Double.valueOf(row.getDouble("thresholdLow")));
                rCondition.setThresholdHigh(Double.valueOf(row.getDouble("thresholdHigh")));
                rCondition.setInRange(row.getBool("inRange"));
                condition = rCondition;
            } else {
                this.log.debugf("Wrong condition type found: " + type, new Object[0]);
            }
        } else {
            this.log.debugf("Wrong condition type: null or empty", new Object[0]);
        }
        return condition;
    }

    public void addActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertActionPlugin == null) {
            throw new RuntimeException("insertActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.insertActionPlugin.bind(new Object[]{actionPlugin, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeActionPlugin(String actionPlugin) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteActionPlugin == null) {
            throw new RuntimeException("deleteActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.deleteActionPlugin.bind(new Object[]{actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.updateActionPlugin == null) {
            throw new RuntimeException("updateActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.updateActionPlugin.bind(new Object[]{properties, actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<String> getActionPlugins() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectActionPlugins == null) {
            throw new RuntimeException("selectActionPlugins PreparedStatement is null");
        }
        ArrayList<String> actionPlugins = new ArrayList<String>();
        try {
            ResultSet rsActionPlugins = this.session.execute((Statement)this.selectActionPlugins.bind());
            for (Row row : rsActionPlugins) {
                actionPlugins.add(row.getString("actionPlugin"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actionPlugins;
    }

    public Set<String> getActionPlugin(String actionPlugin) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectActionPlugin == null) {
            throw new RuntimeException("selectActionPlugin PreparedStatement is null");
        }
        Set properties = null;
        try {
            ResultSet rsActionPlugin = this.session.execute((Statement)this.selectActionPlugin.bind(new Object[]{actionPlugin}));
            Iterator itActionPlugin = rsActionPlugin.iterator();
            if (itActionPlugin.hasNext()) {
                Row row = (Row)itActionPlugin.next();
                properties = row.getSet("properties", String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public void removeAction(String actionId) throws Exception {
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("actionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteAction == null) {
            throw new RuntimeException("deleteAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.deleteAction.bind(new Object[]{actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateAction(String actionId, Map<String, String> properties) throws Exception {
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.updateAction == null) {
            throw new RuntimeException("updateAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.updateAction.bind(new Object[]{properties, actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<String> getAllActions() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllActions == null) {
            throw new RuntimeException("selectAllActions PreparedStatement is null");
        }
        ArrayList<String> actions = new ArrayList<String>();
        try {
            ResultSet rsActions = this.session.execute((Statement)this.selectAllActions.bind());
            for (Row row : rsActions) {
                actions.add(row.getString("actionId"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Collection<String> getActions(String actionPlugin) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectActionsPlugin == null) {
            throw new RuntimeException("selectActionsPlugin PreparedStatement is null");
        }
        ArrayList<String> actions = new ArrayList<String>();
        try {
            ResultSet rsActions = this.session.execute((Statement)this.selectActionsPlugin.bind(new Object[]{actionPlugin}));
            for (Row row : rsActions) {
                actions.add(row.getString("actionId"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Map<String, String> getAction(String actionId) throws Exception {
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("actionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAction == null) {
            throw new RuntimeException("selectAction PreparedStatement is null");
        }
        Map properties = null;
        try {
            ResultSet rsAction = this.session.execute((Statement)this.selectAction.bind(new Object[]{actionId}));
            Iterator itAction = rsAction.iterator();
            if (itAction.hasNext()) {
                Row row = (Row)itAction.next();
                properties = row.getMap("properties", String.class, String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public void addTag(Tag tag) throws Exception {
        if (tag == null) {
            throw new IllegalArgumentException("Tag must be not null");
        }
        if (tag.getTriggerId() == null || tag.getTriggerId().isEmpty()) {
            throw new IllegalArgumentException("Tag TriggerId must be not null or empty");
        }
        if (tag.getName() == null || tag.getName().isEmpty()) {
            throw new IllegalArgumentException("Tag Name must be not null or empty");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            this.insertTag(tag.getTriggerId(), tag.getCategory(), tag.getName(), tag.isVisible());
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeTags(String triggerId, String category, String name) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("Tag TriggerId must be not null or empty");
        }
        try {
            this.deleteTags(triggerId, category, name);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public List<Tag> getTriggerTags(String triggerId, String category) throws Exception {
        List<Tag> tags;
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("Tag TriggerId must be not null or empty");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            tags = this.getTags(triggerId, category, null);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return tags;
    }

    public void registerListener(DefinitionsListener listener) {
        this.listeners.add(listener);
    }
}

