/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.model.trigger.TriggerTemplate;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.jboss.logging.Logger;

public class DbDefinitionsServiceImpl
implements DefinitionsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(DbDefinitionsServiceImpl.class);
    private static final String JBOSS_DATA_DIR = "jboss.server.data.dir";
    private static final String INIT_FOLDER = "hawkular-alerts";
    private Gson gson;
    private final String DS_NAME;
    private DataSource ds;
    private AlertsService alertsService;
    private boolean initialized = false;
    private List<DefinitionsListener> listeners = new ArrayList<DefinitionsListener>();

    public DbDefinitionsServiceImpl() {
        this.DS_NAME = System.getProperty("org.hawkular.alerts.engine.datasource", "java:jboss/datasources/HawkularDS");
    }

    public DbDefinitionsServiceImpl(AlertsService alertsService, DataSource ds) {
        this();
        this.ds = ds;
        this.alertsService = alertsService;
    }

    @PostConstruct
    public void init() {
        try {
            InitialContext ctx;
            this.gson = new GsonBuilder().create();
            if (this.ds == null) {
                try {
                    ctx = new InitialContext();
                    this.ds = (DataSource)ctx.lookup(this.DS_NAME);
                }
                catch (NamingException e) {
                    this.log.debugf(e.getMessage(), (Object)e);
                    this.msgLog.errorCannotConnectWithDatasource(e.getMessage());
                }
            }
            if (this.alertsService == null) {
                try {
                    ctx = new InitialContext();
                    this.alertsService = (AlertsService)ctx.lookup("java:app/hawkular-alerts-engine/BasicAlertsServiceImpl");
                }
                catch (NamingException e) {
                    this.log.debugf(e.getMessage(), (Object)e);
                    this.msgLog.errorCannotWithAlertsService(e.getMessage());
                }
            }
            this.initDatabase();
            String data = System.getProperty(JBOSS_DATA_DIR);
            if (data == null) {
                this.msgLog.errorFolderNotFound(data);
                return;
            }
            String folder = data + "/" + INIT_FOLDER;
            this.initFiles(folder);
            this.initialized = true;
        }
        catch (Throwable t) {
            this.msgLog.errorCannotInitializeDefinitionsService(t.getMessage());
            t.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDatabase() {
        if (this.ds == null) {
            this.log.debugf("DataSource null. Cannot init database", new Object[0]);
            return;
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            s.execute("CREATE TABLE IF NOT EXISTS HWK_ALERTS_TRIGGERS ( triggerId VARCHAR2(250) PRIMARY KEY,   payload VARCHAR2(1024) )");
            s.execute("CREATE TABLE IF NOT EXISTS HWK_ALERTS_CONDITIONS ( conditionId VARCHAR2(250) PRIMARY KEY,  triggerId VARCHAR2(250) NOT NULL,  triggerMode VARCHAR2(20) NOT NULL,  className VARCHAR2(250) NOT NULL,  payload VARCHAR2(1024) )");
            s.execute("CREATE TABLE IF NOT EXISTS HWK_ALERTS_DAMPENINGS ( dampeningId VARCHAR2(250) PRIMARY KEY,  triggerId VARCHAR2(250) NOT NULL,  triggerMode VARCHAR2(20) NOT NULL,  payload VARCHAR2(1024) )");
            s.execute("CREATE TABLE IF NOT EXISTS HWK_ALERTS_ACTION_PLUGINS ( actionPlugin VARCHAR(250) PRIMARY KEY,  payload VARCHAR(1024) )");
            s.execute("CREATE TABLE IF NOT EXISTS HWK_ALERTS_ACTIONS ( actionId VARCHAR(250) NOT NULL,  actionPlugin VARCHAR(250),  payload VARCHAR(1024),  PRIMARY KEY(actionId, actionPlugin))");
            s.execute("CREATE TABLE IF NOT EXISTS HWK_ALERTS_TAGS ( triggerId VARCHAR2(250) NOT NULL,   category VARCHAR2(250),  name VARCHAR2(1024) NOT NULL,   visible BOOLEAN NOT NULL,   PRIMARY KEY(triggerId, category, name) )");
            s.execute("CREATE TABLE IF NOT EXISTS HWK_ALERTS_ALERTS ( alertId VARCHAR2(300) PRIMARY KEY,   triggerId VARCHAR2(250) NOT NULL,   ctime long NOT NULL,  status VARCHAR2(20) NOT NULL,  payload CLOB )");
            s.close();
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.log.debugf(e.getMessage(), (Object)e);
                this.msgLog.errorDatabaseException(e.getMessage());
                this.close(c, s);
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    private void initFiles(String folder) {
        if (folder == null) {
            this.msgLog.errorFolderMustBeNotNull();
            return;
        }
        if (this.ds == null) {
            this.msgLog.errorDatabaseException("DataSource is null. Initialization can not work.");
            return;
        }
        File initFolder = new File(folder);
        try {
            int nActions;
            int nDampenings;
            int nConditions;
            int nTriggers = this.getNumTable("HWK_ALERTS_TRIGGERS");
            if (nTriggers == 0) {
                this.initTriggers(initFolder);
            }
            if ((nConditions = this.getNumTable("HWK_ALERTS_CONDITIONS")) == 0) {
                this.initConditions(initFolder);
            }
            if ((nDampenings = this.getNumTable("HWK_ALERTS_DAMPENINGS")) == 0) {
                this.initDampening(initFolder);
            }
            if ((nActions = this.getNumTable("HWK_ALERTS_ACTIONS")) == 0) {
                this.initActions(initFolder);
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.msgLog.errorDatabaseException("Error initializing files. Msg: " + e);
        }
    }

    private void initTriggers(File initFolder) throws Exception {
        File triggers = new File(initFolder, "triggers.data");
        if (triggers.exists() && triggers.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(triggers.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.log.debugf(e.toString(), (Object)e);
                this.msgLog.warningReadingFile("triggers.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length != 10) continue;
                    String triggerId = fields[0];
                    boolean enabled = new Boolean(fields[1]);
                    String name = fields[2];
                    String description = fields[3];
                    boolean autoDisable = new Boolean(fields[4]);
                    boolean autoResolve = new Boolean(fields[5]);
                    boolean autoResolveAlerts = new Boolean(fields[6]);
                    TriggerTemplate.Match firingMatch = TriggerTemplate.Match.valueOf((String)fields[7]);
                    TriggerTemplate.Match autoResolveMatch = TriggerTemplate.Match.valueOf((String)fields[8]);
                    String[] notifiers = fields[9].split("\\|");
                    Trigger trigger = new Trigger(triggerId, name);
                    trigger.setEnabled(enabled);
                    trigger.setAutoDisable(autoDisable);
                    trigger.setAutoResolve(autoResolve);
                    trigger.setAutoResolveAlerts(autoResolveAlerts);
                    trigger.setDescription(description);
                    trigger.setFiringMatch(firingMatch);
                    trigger.setAutoResolveMatch(autoResolveMatch);
                    for (String notifier : notifiers) {
                        trigger.addAction(notifier);
                    }
                    this.addTrigger(trigger);
                    this.log.debugf("Init file - Inserting [%s]", (Object)trigger);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("triggers.data");
        }
    }

    private void initConditions(File initFolder) throws Exception {
        File conditions = new File(initFolder, "conditions.data");
        if (conditions.exists() && conditions.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(conditions.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.msgLog.warningReadingFile("conditions.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    CompareCondition newCondition;
                    String operator;
                    String dataId;
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length <= 4) continue;
                    String triggerId = fields[0];
                    Trigger.Mode triggerMode = Trigger.Mode.valueOf((String)fields[1]);
                    int conditionSetSize = new Integer(fields[2]);
                    int conditionSetIndex = new Integer(fields[3]);
                    String type = fields[4];
                    if (type != null && !type.isEmpty() && type.equals("threshold") && fields.length == 8) {
                        dataId = fields[5];
                        operator = fields[6];
                        Double threshold = (double)new Double(fields[7]);
                        ThresholdCondition newCondition2 = new ThresholdCondition();
                        newCondition2.setTriggerId(triggerId);
                        newCondition2.setTriggerMode(triggerMode);
                        newCondition2.setConditionSetSize(conditionSetSize);
                        newCondition2.setConditionSetIndex(conditionSetIndex);
                        newCondition2.setDataId(dataId);
                        newCondition2.setOperator(ThresholdCondition.Operator.valueOf((String)operator));
                        newCondition2.setThreshold(threshold);
                        this.initCondition((Condition)newCondition2);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition2);
                    }
                    if (type != null && !type.isEmpty() && type.equals("range") && fields.length == 11) {
                        dataId = fields[5];
                        String operatorLow = fields[6];
                        String operatorHigh = fields[7];
                        Double thresholdLow = (double)new Double(fields[8]);
                        Double thresholdHigh = (double)new Double(fields[9]);
                        boolean inRange = new Boolean(fields[10]);
                        ThresholdRangeCondition newCondition3 = new ThresholdRangeCondition();
                        newCondition3.setTriggerId(triggerId);
                        newCondition3.setTriggerMode(triggerMode);
                        newCondition3.setConditionSetSize(conditionSetSize);
                        newCondition3.setConditionSetIndex(conditionSetIndex);
                        newCondition3.setDataId(dataId);
                        newCondition3.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)operatorLow));
                        newCondition3.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)operatorHigh));
                        newCondition3.setThresholdLow(thresholdLow);
                        newCondition3.setThresholdHigh(thresholdHigh);
                        newCondition3.setInRange(inRange);
                        this.initCondition((Condition)newCondition3);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition3);
                    }
                    if (type != null && !type.isEmpty() && type.equals("compare") && fields.length == 9) {
                        dataId = fields[5];
                        operator = fields[6];
                        Double data2Multiplier = (double)new Double(fields[7]);
                        String data2Id = fields[8];
                        newCondition = new CompareCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(CompareCondition.Operator.valueOf((String)operator));
                        newCondition.setData2Multiplier(data2Multiplier);
                        newCondition.setData2Id(data2Id);
                        this.initCondition((Condition)newCondition);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition);
                    }
                    if (type != null && !type.isEmpty() && type.equals("string") && fields.length == 9) {
                        dataId = fields[5];
                        operator = fields[6];
                        String pattern = fields[7];
                        boolean ignoreCase = new Boolean(fields[8]);
                        newCondition = new StringCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(StringCondition.Operator.valueOf((String)operator));
                        newCondition.setPattern(pattern);
                        newCondition.setIgnoreCase(ignoreCase);
                        this.initCondition((Condition)newCondition);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition);
                    }
                    if (type == null || type.isEmpty() || !type.equals("availability") || fields.length != 7) continue;
                    dataId = fields[5];
                    operator = fields[6];
                    AvailabilityCondition newCondition4 = new AvailabilityCondition();
                    newCondition4.setTriggerId(triggerId);
                    newCondition4.setTriggerMode(triggerMode);
                    newCondition4.setConditionSetSize(conditionSetSize);
                    newCondition4.setConditionSetIndex(conditionSetIndex);
                    newCondition4.setDataId(dataId);
                    newCondition4.setOperator(AvailabilityCondition.Operator.valueOf((String)operator));
                    this.initCondition((Condition)newCondition4);
                    this.log.debugf("Init file - Inserting [%s]", (Object)newCondition4);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("conditions.data");
        }
    }

    private void initCondition(Condition condition) throws Exception {
        Collection<Condition> conditions = this.getTriggerConditions(condition.getTriggerId(), condition.getTriggerMode());
        conditions.add(condition);
        this.setConditions(condition.getTriggerId(), condition.getTriggerMode(), conditions);
    }

    private void initDampening(File initFolder) throws Exception {
        File dampening = new File(initFolder, "dampening.data");
        if (dampening.exists() && dampening.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(dampening.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.msgLog.warningReadingFile("dampening.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length != 6) continue;
                    String triggerId = fields[0];
                    Trigger.Mode triggerMode = Trigger.Mode.valueOf((String)fields[1]);
                    String type = fields[2];
                    int evalTrueSetting = new Integer(fields[3]);
                    int evalTotalSetting = new Integer(fields[4]);
                    int evalTimeSetting = new Integer(fields[5]);
                    Dampening newDampening = new Dampening(triggerId, triggerMode, Dampening.Type.valueOf((String)type), evalTrueSetting, evalTotalSetting, (long)evalTimeSetting);
                    this.addDampening(newDampening);
                    this.log.debugf("Init file - Inserting [%s]", (Object)newDampening);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("dampening.data");
        }
    }

    private void initActions(File initFolder) throws Exception {
        File actions = new File(initFolder, "actions.data");
        if (actions.exists() && actions.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(actions.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length <= 2) continue;
                    String actionId = fields[0];
                    String actionPlugin = fields[1];
                    HashMap<String, String> newAction = new HashMap<String, String>();
                    newAction.put("actionId", actionId);
                    newAction.put("actionPlugin", actionPlugin);
                    for (int i = 2; i < fields.length; ++i) {
                        String property = fields[i];
                        String[] properties = property.split("=");
                        if (properties.length != 2) continue;
                        newAction.put(properties[0], properties[1]);
                    }
                    this.addAction(actionId, newAction);
                    this.log.debugf("Init file - Inserting [%s]", newAction);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("actions.data");
        }
    }

    public Collection<Condition> getAllConditions() throws Exception {
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT conditionId, className, payload FROM HWK_ALERTS_CONDITIONS ").append("ORDER BY conditionId");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                Condition condition;
                String className = rs.getString(2);
                if (className.equals("AvailabilityCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), AvailabilityCondition.class);
                } else if (className.equals("CompareCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), CompareCondition.class);
                } else if (className.equals("StringCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), StringCondition.class);
                } else if (className.equals("ThresholdCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), ThresholdCondition.class);
                } else if (className.equals("ThresholdRangeCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), ThresholdRangeCondition.class);
                } else {
                    this.log.debugf("Condition type: " + className + " not found", new Object[0]);
                    condition = null;
                }
                if (condition == null) continue;
                conditions.add(condition);
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return conditions;
    }

    public Condition getCondition(String conditionId) throws Exception {
        if (conditionId == null || conditionId.isEmpty()) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Condition condition = null;
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT conditionId, className, payload FROM HWK_ALERTS_CONDITIONS WHERE ").append("conditionId = '").append(conditionId).append("' ").append("ORDER BY triggerId");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            if (rs.next()) {
                String className = rs.getString(2);
                if (className.equals("AvailabilityCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), AvailabilityCondition.class);
                } else if (className.equals("CompareCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), CompareCondition.class);
                } else if (className.equals("StringCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), StringCondition.class);
                } else if (className.equals("ThresholdCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), ThresholdCondition.class);
                } else if (className.equals("ThresholdRangeCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), ThresholdRangeCondition.class);
                } else {
                    this.log.debugf("Condition type: " + className + " not found", new Object[0]);
                    condition = null;
                }
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return condition;
    }

    public Collection<Condition> getTriggerConditions(String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT triggerId, className, payload FROM HWK_ALERTS_CONDITIONS WHERE ").append("triggerId = '").append(triggerId).append("' ");
            if (null != triggerMode) {
                sql.append("AND triggerMode = '").append(triggerMode.name()).append("' ");
            }
            sql.append("ORDER BY triggerId");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                Condition condition;
                String className = rs.getString(2);
                if (className.equals("AvailabilityCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), AvailabilityCondition.class);
                } else if (className.equals("CompareCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), CompareCondition.class);
                } else if (className.equals("StringCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), StringCondition.class);
                } else if (className.equals("ThresholdCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), ThresholdCondition.class);
                } else if (className.equals("ThresholdRangeCondition")) {
                    condition = (Condition)this.fromJson(rs.getString(3), ThresholdRangeCondition.class);
                } else {
                    this.log.debugf("Condition type: " + className + " not found", new Object[0]);
                    condition = null;
                }
                if (condition == null) continue;
                conditions.add(condition);
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return conditions;
    }

    public Dampening getDampening(String dampeningId) throws Exception {
        if (dampeningId == null || dampeningId.isEmpty()) {
            throw new IllegalArgumentException("dampeningId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Dampening dampening = null;
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT dampeningId, payload FROM HWK_ALERTS_DAMPENINGS WHERE ").append("dampeningId = '").append(dampeningId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            if (rs.next()) {
                dampening = this.fromJson(rs.getString(2), Dampening.class);
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return dampening;
    }

    public Collection<Dampening> getTriggerDampenings(String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT triggerId, payload FROM HWK_ALERTS_DAMPENINGS WHERE ").append("triggerId = '").append(triggerId).append("' ");
            if (null != triggerMode) {
                sql.append("AND triggerMode = '").append(triggerMode.name()).append("' ");
            }
            sql.append("ORDER BY triggerId");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                Dampening dampening = this.fromJson(rs.getString(2), Dampening.class);
                dampenings.add(dampening);
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return dampenings;
    }

    public Collection<Dampening> getAllDampenings() throws Exception {
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT triggerId, payload FROM HWK_ALERTS_DAMPENINGS ").append("ORDER BY triggerId");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                Dampening dampening = this.fromJson(rs.getString(2), Dampening.class);
                dampenings.add(dampening);
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return dampenings;
    }

    public Collection<Condition> addCondition(String triggerId, Trigger.Mode triggerMode, Condition condition) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        Collection<Condition> conditions = this.getTriggerConditions(triggerId, triggerMode);
        conditions.add(condition);
        int i = 0;
        for (Condition c : conditions) {
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
        }
        return this.setConditions(triggerId, triggerMode, conditions);
    }

    public Collection<Condition> removeCondition(String conditionId) throws Exception {
        if (conditionId == null || conditionId.isEmpty()) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition condition = this.getCondition(conditionId);
        if (null == condition) {
            this.log.debugf("Ignoring removeCondition [%s], the condition does not exist.", (Object)conditionId);
        }
        String triggerId = condition.getTriggerId();
        Trigger.Mode triggerMode = condition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(triggerId, triggerMode);
        int i = 0;
        int size = conditions.size() - 1;
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) continue;
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
            newConditions.add(c);
        }
        return this.setConditions(triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> updateCondition(Condition condition) throws Exception {
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        String conditionId = condition.getConditionId();
        if (conditionId == null || conditionId.isEmpty()) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition existingCondition = this.getCondition(conditionId);
        if (null == condition) {
            throw new IllegalArgumentException("ConditionId [" + conditionId + "] does not exist.");
        }
        String triggerId = existingCondition.getTriggerId();
        Trigger.Mode triggerMode = existingCondition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(triggerId, triggerMode);
        int size = conditions.size();
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) {
                newConditions.add(condition);
                continue;
            }
            newConditions.add(c);
        }
        return this.setConditions(triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> setConditions(String triggerId, Trigger.Mode triggerMode, Collection<Condition> conditions) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("Conditions must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        this.removeConditions(triggerId, triggerMode);
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            ArrayList<String> dataIds = new ArrayList<String>(2);
            int i = 0;
            for (Condition cond : conditions) {
                cond.setTriggerId(triggerId);
                cond.setTriggerMode(triggerMode);
                cond.setConditionSetSize(conditions.size());
                cond.setConditionSetIndex(++i);
                StringBuilder sql = new StringBuilder("INSERT INTO HWK_ALERTS_CONDITIONS VALUES (").append("'").append(cond.getConditionId()).append("', ").append("'").append(cond.getTriggerId()).append("', ").append("'").append(cond.getTriggerMode().name()).append("', ").append("'").append(cond.getClass().getSimpleName()).append("', ").append("'").append(this.toJson(cond)).append("'").append(")");
                this.log.debugf("SQL: " + sql, new Object[0]);
                s.execute(sql.toString());
                dataIds.add(cond.getDataId());
                if (cond instanceof CompareCondition) {
                    dataIds.add(((CompareCondition)cond).getData2Id());
                }
                for (String dataId : dataIds) {
                    this.insertTag(c, s, cond.getTriggerId(), "dataId", dataId, false);
                }
                dataIds.clear();
            }
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(triggerId);
        }
        this.notifyListeners(DefinitionsEvent.EventType.CONDITION_CHANGE);
        return conditions;
    }

    public Dampening addDampening(Dampening dampening) throws Exception {
        if (dampening == null || dampening.getTriggerId() == null || dampening.getTriggerId().isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("INSERT INTO HWK_ALERTS_DAMPENINGS VALUES (").append("'").append(dampening.getDampeningId()).append("', ").append("'").append(dampening.getTriggerId()).append("', ").append("'").append(dampening.getTriggerMode().name()).append("', ").append("'").append(this.toJson(dampening)).append("'").append(")");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
        return dampening;
    }

    public void addAction(String actionId, Map<String, String> properties) throws Exception {
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("actionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        String actionPlugin = properties.get("actionPlugin");
        if (actionPlugin == null) {
            throw new IllegalArgumentException("Action has not actionPlugin property");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("INSERT INTO HWK_ALERTS_ACTIONS VALUES (").append("'").append(actionId).append("', ").append("'").append(actionPlugin).append("', ").append("'").append(this.toJson(properties)).append("'").append(")");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    public void addActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("INSERT INTO HWK_ALERTS_ACTION_PLUGINS VALUES (").append("'").append(actionPlugin).append("', ").append("'").append(this.toJson(properties)).append("'").append(")");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            s.close();
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    public void addTrigger(Trigger trigger) throws Exception {
        if (trigger == null || trigger.getId() == null || trigger.getId().isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("INSERT INTO HWK_ALERTS_TRIGGERS VALUES (").append("'").append(trigger.getId()).append("', ").append("'").append(this.toJson(trigger)).append("'").append(")");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        this.notifyListeners(DefinitionsEvent.EventType.TRIGGER_CHANGE);
    }

    public Trigger copyTrigger(String triggerId, Map<String, String> dataIdMap) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (dataIdMap == null || dataIdMap.isEmpty()) {
            throw new IllegalArgumentException("DataIdMap must be not null");
        }
        Trigger trigger = this.getTrigger(triggerId);
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger not found for triggerId [" + triggerId + "]");
        }
        HashSet<String> dataIdTokens = new HashSet<String>();
        Collection<Condition> conditions = this.getTriggerConditions(triggerId, null);
        for (Condition c : conditions) {
            if (c instanceof CompareCondition) {
                dataIdTokens.add(((CompareCondition)c).getDataId());
                dataIdTokens.add(((CompareCondition)c).getData2Id());
                continue;
            }
            dataIdTokens.add(c.getDataId());
        }
        if (!dataIdTokens.equals(dataIdMap.keySet())) {
            throw new IllegalArgumentException("DataIdMap must contain the exact dataIds (keyset) expected by the condition set. Expected: " + dataIdMap.keySet() + ", dataIdMap: " + dataIdMap.keySet());
        }
        Collection<Dampening> dampenings = this.getTriggerDampenings(triggerId, null);
        Trigger newTrigger = new Trigger(trigger.getName());
        newTrigger.setName(trigger.getName());
        newTrigger.setDescription(trigger.getDescription());
        newTrigger.setFiringMatch(trigger.getFiringMatch());
        newTrigger.setAutoResolveMatch(trigger.getAutoResolveMatch());
        newTrigger.setActions(trigger.getActions());
        this.addTrigger(newTrigger);
        for (Condition c : conditions) {
            ThresholdCondition newCondition = null;
            if (c instanceof ThresholdCondition) {
                newCondition = new ThresholdCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((ThresholdCondition)c).getOperator(), ((ThresholdCondition)c).getThreshold());
            } else if (c instanceof ThresholdRangeCondition) {
                newCondition = new ThresholdRangeCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((ThresholdRangeCondition)c).getOperatorLow(), ((ThresholdRangeCondition)c).getOperatorHigh(), ((ThresholdRangeCondition)c).getThresholdLow(), ((ThresholdRangeCondition)c).getThresholdHigh(), ((ThresholdRangeCondition)c).isInRange());
            } else if (c instanceof AvailabilityCondition) {
                newCondition = new AvailabilityCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((AvailabilityCondition)c).getOperator());
            } else if (c instanceof CompareCondition) {
                newCondition = new CompareCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(((CompareCondition)c).getDataId()), ((CompareCondition)c).getOperator(), ((CompareCondition)c).getData2Multiplier(), dataIdMap.get(((CompareCondition)c).getData2Id()));
            } else if (c instanceof StringCondition) {
                newCondition = new StringCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((StringCondition)c).getOperator(), ((StringCondition)c).getPattern(), ((StringCondition)c).isIgnoreCase());
            }
            this.addCondition(newTrigger.getId(), newCondition.getTriggerMode(), (Condition)newCondition);
        }
        for (Dampening d : dampenings) {
            Dampening newDampening = new Dampening(newTrigger.getId(), d.getTriggerMode(), d.getType(), d.getEvalTrueSetting(), d.getEvalTotalSetting(), d.getEvalTimeSetting());
            this.addDampening(newDampening);
        }
        return newTrigger;
    }

    public Map<String, String> getAction(String actionId) throws Exception {
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Map payload = null;
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT actionId, payload FROM HWK_ALERTS_ACTIONS WHERE ").append("actionId = '").append(actionId).append("'");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            if (rs.next()) {
                payload = this.fromJson(rs.getString(2), Map.class);
            }
            s.close();
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return payload;
    }

    public Collection<String> getAllActions() throws Exception {
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        ArrayList<String> actions = new ArrayList<String>();
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT actionId FROM HWK_ALERTS_ACTIONS ORDER BY actionId ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                actions.add(rs.getString(1));
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return actions;
    }

    public Collection<String> getActions(String actionPlugin) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        ArrayList<String> actions = null;
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT actionId FROM HWK_ALERTS_ACTIONS WHERE ").append("actionPlugin = '").append(actionPlugin).append("' ").append("ORDER BY actionId");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            actions = new ArrayList<String>();
            while (rs.next()) {
                actions.add(rs.getString(1));
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return actions;
    }

    public Set<String> getActionPlugin(String actionPlugin) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Set payload = null;
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT actionPlugin, payload FROM HWK_ALERTS_ACTION_PLUGINS WHERE ").append("actionPlugin = '").append(actionPlugin).append("'");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            if (rs.next()) {
                payload = this.fromJson(rs.getString(2), Set.class);
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return payload != null && !payload.isEmpty() ? new HashSet(payload) : null;
    }

    public Collection<String> getActionPlugins() throws Exception {
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        ArrayList<String> actionPlugins = new ArrayList<String>();
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT actionPlugin FROM HWK_ALERTS_ACTION_PLUGINS ").append("ORDER BY actionPlugin");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                actionPlugins.add(rs.getString(1));
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return actionPlugins;
    }

    public Trigger getTrigger(String triggerId) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Trigger trigger = null;
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT triggerId, payload FROM HWK_ALERTS_TRIGGERS WHERE ").append("triggerId = '").append(triggerId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            if (rs.next()) {
                trigger = this.fromJson(rs.getString(2), Trigger.class);
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return trigger;
    }

    public Collection<Trigger> getAllTriggers() throws Exception {
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT triggerId, payload FROM HWK_ALERTS_TRIGGERS ").append("ORDER BY triggerId");
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                Trigger trigger = this.fromJson(rs.getString(2), Trigger.class);
                triggers.add(trigger);
            }
            this.close(c, s, rs);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s, rs);
                throw throwable;
            }
        }
        return triggers;
    }

    private void removeConditions(String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must not be null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must not be null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("DELETE FROM HWK_ALERTS_CONDITIONS WHERE ").append("triggerId = '").append(triggerId).append("' ").append(" AND triggerMode = '").append(triggerMode.name()).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.deleteTags(c, s, triggerId, "dataId", null);
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    public void removeDampening(String dampeningId) throws Exception {
        if (dampeningId == null || dampeningId.isEmpty()) {
            throw new IllegalArgumentException("dampeningId must not be null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Dampening dampening = this.getDampening(dampeningId);
        if (null == dampening) {
            this.log.debugf("Ignoring removeDampening(" + dampeningId + "), the Dampening does not exist.", new Object[0]);
            return;
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("DELETE FROM HWK_ALERTS_DAMPENINGS WHERE ").append("dampeningId = '").append(dampeningId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
    }

    public void removeAction(String actionId) throws Exception {
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("ActionId must not be null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("DELETE FROM HWK_ALERTS_ACTIONS WHERE ").append("actionId = '").append(actionId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    public void removeActionPlugin(String actionPlugin) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must not be null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("DELETE FROM HWK_ALERTS_ACTION_PLUGINS WHERE ").append("actionPlugin = '").append(actionPlugin).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    public void removeTrigger(String triggerId) throws Exception {
        if (triggerId == null || triggerId.isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("DELETE FROM HWK_ALERTS_DAMPENINGS WHERE ").append("triggerId = '").append(triggerId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            sql = new StringBuilder("DELETE FROM HWK_ALERTS_CONDITIONS WHERE ").append("triggerId = '").append(triggerId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            sql = new StringBuilder("DELETE FROM HWK_ALERTS_TAGS WHERE ").append("triggerId = '").append(triggerId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            sql = new StringBuilder("DELETE FROM HWK_ALERTS_TRIGGERS WHERE ").append("triggerId = '").append(triggerId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(triggerId);
        }
        this.notifyListeners(DefinitionsEvent.EventType.TRIGGER_CHANGE);
    }

    public Dampening updateDampening(Dampening dampening) throws Exception {
        if (dampening == null) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("UPDATE HWK_ALERTS_DAMPENINGS SET ").append("payload = '").append(this.toJson(dampening)).append("' ").append("WHERE dampeningId = '").append(dampening.getDampeningId()).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
        return dampening;
    }

    public void updateAction(String actionId, Map<String, String> properties) throws Exception {
        if (actionId == null || actionId.isEmpty()) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("UPDATE HWK_ALERTS_ACTIONS SET ").append("payload = '").append(this.toJson(properties)).append("' ").append("WHERE actionId = '").append(actionId).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    public void updateActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("UPDATE HWK_ALERTS_ACTION_PLUGINS SET ").append("payload = '").append(this.toJson(properties)).append("' ").append("WHERE actionPlugin = '").append(actionPlugin).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    public Trigger updateTrigger(Trigger trigger) throws Exception {
        if (trigger == null || trigger.getId() == null || trigger.getId().isEmpty()) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("UPDATE HWK_ALERTS_TRIGGERS SET ").append("payload = '").append(this.toJson(trigger)).append("' ").append("WHERE triggerId = '").append(trigger.getId()).append("' ");
            this.log.debugf("SQL: " + sql, new Object[0]);
            s.execute(sql.toString());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(trigger.getId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.TRIGGER_CHANGE);
        return trigger;
    }

    public int getNumTable(String table) throws Exception {
        if (table == null || table.isEmpty()) {
            throw new IllegalArgumentException("Table must be not null");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        int numRows = -1;
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            StringBuilder sql = new StringBuilder("SELECT COUNT(*) FROM ").append(table);
            this.log.debugf("SQL: " + sql, new Object[0]);
            rs = s.executeQuery(sql.toString());
            if (rs.next()) {
                numRows = rs.getInt(1);
            }
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        return numRows;
    }

    private String toJson(Object resource) {
        return this.gson.toJson(resource);
    }

    private <T> T fromJson(String json, Class<T> clazz) {
        return (T)this.gson.fromJson(json, clazz);
    }

    private void close(Connection c, Statement s) {
        this.close(c, s, null);
    }

    private void close(Connection c, Statement s, ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (s != null) {
                s.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addTag(Tag tag) throws Exception {
        if (tag == null) {
            throw new IllegalArgumentException("Tag must be not null");
        }
        if (this.isEmpty(tag.getTriggerId())) {
            throw new IllegalArgumentException("Tag TriggerId must be not null or empty");
        }
        if (this.isEmpty(tag.getName())) {
            throw new IllegalArgumentException("Tag Name must be not null or empty");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            this.insertTag(c, s, tag.getTriggerId(), tag.getCategory(), tag.getName(), tag.isVisible());
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    private void insertTag(Connection c, Statement s, String triggerId, String category, String name, boolean visible) throws Exception {
        if (!this.getTags(c, s, triggerId, category, name).isEmpty()) {
            return;
        }
        StringBuilder sql = new StringBuilder("INSERT INTO HWK_ALERTS_TAGS VALUES (");
        sql.append("'").append(triggerId).append("', ");
        if (this.isEmpty(category)) {
            sql.append("NULL, ");
        } else {
            sql.append("'").append(category).append("', ");
        }
        sql.append("'").append(name).append("', ");
        sql.append("'").append(String.valueOf(visible)).append("' ");
        sql.append(")");
        this.log.debugf("SQL: " + sql, new Object[0]);
        s = c.createStatement();
        s.execute(sql.toString());
    }

    public void removeTags(String triggerId, String category, String name) throws Exception {
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("Tag TriggerId must be not null or empty");
        }
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            this.deleteTags(c, s, triggerId, category, name);
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
    }

    private void deleteTags(Connection c, Statement s, String triggerId, String category, String name) throws Exception {
        StringBuilder sql = new StringBuilder("DELETE FROM HWK_ALERTS_TAGS WHERE ");
        sql.append("triggerId = '").append(triggerId).append("' ");
        if (!this.isEmpty(category)) {
            sql.append("AND category = '").append(category).append("' ");
        }
        if (!this.isEmpty(name)) {
            sql.append("AND name = '").append(name).append("' ");
        }
        this.log.debugf("SQL: " + sql, new Object[0]);
        s = c.createStatement();
        s.executeUpdate(sql.toString());
    }

    public List<Tag> getTriggerTags(String triggerId, String category) throws Exception {
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("Tag TriggerId must be not null or empty");
        }
        if (this.ds == null) {
            throw new Exception("DataSource is null");
        }
        List<Tag> tags = null;
        Connection c = null;
        Statement s = null;
        try {
            c = this.ds.getConnection();
            s = c.createStatement();
            tags = this.getTags(c, s, triggerId, category, null);
            this.close(c, s);
        }
        catch (SQLException e) {
            try {
                this.msgLog.errorDatabaseException(e.getMessage());
                throw e;
            }
            catch (Throwable throwable) {
                this.close(c, s);
                throw throwable;
            }
        }
        return tags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Tag> getTags(Connection c, Statement s, String triggerId, String category, String name) throws Exception {
        StringBuilder sql = new StringBuilder("SELECT triggerId, category, name, visible FROM HWK_ALERTS_TAGS WHERE ");
        sql.append("triggerId = '").append(triggerId).append("' ");
        if (!this.isEmpty(category)) {
            sql.append("AND category = '").append(category).append("' ");
        }
        if (!this.isEmpty(name)) {
            sql.append("AND name = '").append(name).append("' ");
        }
        sql.append("ORDER BY category, name");
        this.log.debugf("SQL: " + sql, new Object[0]);
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ResultSet rs = null;
        try {
            rs = s.executeQuery(sql.toString());
            while (rs.next()) {
                Tag tag = new Tag(rs.getString(1), rs.getString(2), rs.getString(3), rs.getBoolean(4));
                tags.add(tag);
            }
        }
        finally {
            if (null != rs) {
                rs.close();
            }
        }
        return tags;
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private void notifyListeners(DefinitionsEvent.EventType eventType) {
        DefinitionsEvent de = new DefinitionsEvent(eventType);
        for (DefinitionsListener dl : this.listeners) {
            this.log.debugf("Notified Listener %s", (Object)eventType.name());
            dl.onChange(de);
        }
    }

    public void registerListener(DefinitionsListener listener) {
        this.listeners.add(listener);
    }
}

