/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Futures;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.impl.GsonAdapter;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.rules.RulesEngine;
import org.jboss.logging.Logger;

@Singleton
public class CassAlertsServiceImpl
implements AlertsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassAlertsServiceImpl.class);
    private static final String ENGINE_DELAY = "hawkular-alerts.engine-delay";
    private static final String ENGINE_PERIOD = "hawkular-alerts.engine-period";
    private static final String CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private int delay;
    private int period;
    private Session session;
    private String keyspace;
    private Gson gson;
    private PreparedStatement insertAlert;
    private PreparedStatement insertAlertTrigger;
    private PreparedStatement insertAlertCtime;
    private PreparedStatement insertAlertStatus;
    private PreparedStatement updateAlert;
    private PreparedStatement selectAlertStatus;
    private PreparedStatement deleteAlertStatus;
    private PreparedStatement selectAlertsByTenant;
    private PreparedStatement selectAlertsByTenantAndAlert;
    private PreparedStatement selectAlertsTriggers;
    private PreparedStatement selectAlertCTimeStartEnd;
    private PreparedStatement selectAlertCTimeStart;
    private PreparedStatement selectAlertCTimeEnd;
    private PreparedStatement selectAlertStatusByTenantAndStatus;
    private PreparedStatement selectTagsTriggersByCategoryAndName;
    private PreparedStatement selectTagsTriggersByCategory;
    private PreparedStatement selectTagsTriggersByName;
    private final List<Data> pendingData = new CopyOnWriteArrayList<Data>();
    private final List<Alert> alerts = new CopyOnWriteArrayList<Alert>();
    private final Set<Dampening> pendingTimeouts = new CopyOnWriteArraySet<Dampening>();
    private final Map<Trigger, List<Set<ConditionEval>>> autoResolvedTriggers = new HashMap<Trigger, List<Set<ConditionEval>>>();
    private final Set<Trigger> disabledTriggers = new CopyOnWriteArraySet<Trigger>();
    private final Timer wakeUpTimer = new Timer("CassAlertsServiceImpl-Timer");
    private TimerTask rulesTask;
    @EJB
    RulesEngine rules;
    @EJB
    DefinitionsService definitions;
    @EJB
    ActionsService actions;

    public CassAlertsServiceImpl() {
        this.delay = new Integer(AlertProperties.getProperty(ENGINE_DELAY, "1000"));
        this.period = new Integer(AlertProperties.getProperty(ENGINE_PERIOD, "2000"));
    }

    public ActionsService getActions() {
        return this.actions;
    }

    public void setActions(ActionsService actions) {
        this.actions = actions;
    }

    public DefinitionsService getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(DefinitionsService definitions) {
        this.definitions = definitions;
    }

    public RulesEngine getRules() {
        return this.rules;
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    @PostConstruct
    public void initServices() {
        try {
            if (this.keyspace == null) {
                this.keyspace = AlertProperties.getProperty(CASSANDRA_KEYSPACE, "hawkular_alerts");
            }
            if (this.session == null) {
                this.session = CassCluster.getSession();
            }
            this.initPreparedStatements();
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeHierarchyAdapter(ConditionEval.class, new GsonAdapter());
            this.gson = gsonBuilder.create();
            this.reload();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                t.printStackTrace();
            }
            this.msgLog.errorCannotInitializeAlertsService(t.getMessage());
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.session != null) {
            this.session.close();
        }
    }

    private void initPreparedStatements() throws Exception {
        if (this.insertAlert == null) {
            this.insertAlert = this.session.prepare("INSERT INTO " + this.keyspace + ".alerts " + "(tenantId, alertId, payload) VALUES (?, ?, ?) ");
        }
        if (this.insertAlertTrigger == null) {
            this.insertAlertTrigger = this.session.prepare("INSERT INTO " + this.keyspace + ".alerts_triggers " + "(tenantId, alertId, triggerId) VALUES (?, ?, ?) ");
        }
        if (this.insertAlertCtime == null) {
            this.insertAlertCtime = this.session.prepare("INSERT INTO " + this.keyspace + ".alerts_ctimes " + "(tenantId, alertId, ctime) VALUES (?, ?, ?) ");
        }
        if (this.insertAlertStatus == null) {
            this.insertAlertStatus = this.session.prepare("INSERT INTO " + this.keyspace + ".alerts_statuses " + "(tenantId, alertId, status) VALUES (?, ?, ?) ");
        }
        if (this.updateAlert == null) {
            this.updateAlert = this.session.prepare("UPDATE " + this.keyspace + ".alerts " + "SET payload = ? WHERE tenantId = ? AND alertId = ? ");
        }
        if (this.selectAlertStatus == null) {
            this.selectAlertStatus = this.session.prepare("SELECT alertId, status FROM " + this.keyspace + ".alerts_statuses " + "WHERE tenantId = ? AND status = ? AND alertId = ? ");
        }
        if (this.deleteAlertStatus == null) {
            this.deleteAlertStatus = this.session.prepare("DELETE FROM " + this.keyspace + ".alerts_statuses " + "WHERE tenantId = ? AND status = ? AND alertId = ? ");
        }
        if (this.selectAlertsByTenant == null) {
            this.selectAlertsByTenant = this.session.prepare("SELECT payload FROM " + this.keyspace + ".alerts " + "WHERE tenantId = ? ");
        }
        if (this.selectAlertsByTenantAndAlert == null) {
            this.selectAlertsByTenantAndAlert = this.session.prepare("SELECT payload FROM " + this.keyspace + ".alerts " + "WHERE tenantId = ? AND alertId = ? ");
        }
        if (this.selectAlertsTriggers == null) {
            this.selectAlertsTriggers = this.session.prepare("SELECT alertId FROM " + this.keyspace + ".alerts_triggers " + "WHERE tenantId = ? AND " + "triggerId = ? ");
        }
        if (this.selectAlertCTimeStartEnd == null) {
            this.selectAlertCTimeStartEnd = this.session.prepare("SELECT alertId FROM " + this.keyspace + ".alerts_ctimes " + "WHERE tenantId = ? AND ctime >= ? AND ctime <= ?");
        }
        if (this.selectAlertCTimeStart == null) {
            this.selectAlertCTimeStart = this.session.prepare("SELECT alertId FROM " + this.keyspace + ".alerts_ctimes " + "WHERE tenantId = ? AND ctime >= ?");
        }
        if (this.selectAlertCTimeEnd == null) {
            this.selectAlertCTimeEnd = this.session.prepare("SELECT alertId FROM " + this.keyspace + ".alerts_ctimes " + "WHERE tenantId = ? AND ctime <= ?");
        }
        if (this.selectAlertStatusByTenantAndStatus == null) {
            this.selectAlertStatusByTenantAndStatus = this.session.prepare("SELECT alertId FROM " + this.keyspace + "" + ".alerts_statuses WHERE tenantId = ? AND status = ?");
        }
        if (this.selectTagsTriggersByCategoryAndName == null) {
            this.selectTagsTriggersByCategoryAndName = this.session.prepare("SELECT triggers FROM " + this.keyspace + "" + ".tags_triggers WHERE tenantId = ? AND category = ? AND name = ?");
        }
        if (this.selectTagsTriggersByCategory == null) {
            this.selectTagsTriggersByCategory = this.session.prepare("SELECT triggers FROM " + this.keyspace + "" + ".tags_triggers WHERE tenantId = ? AND category = ?");
        }
        if (this.selectTagsTriggersByName == null) {
            this.selectTagsTriggersByName = this.session.prepare("SELECT triggers FROM " + this.keyspace + "" + ".tags_triggers WHERE tenantId = ? AND name = ?");
        }
    }

    public void addAlerts(Collection<Alert> alerts) throws Exception {
        if (alerts == null) {
            throw new IllegalArgumentException("Alerts must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertAlert == null) {
            throw new RuntimeException("insertAlert PreparedStatement is null");
        }
        try {
            ArrayList futures = new ArrayList();
            alerts.stream().forEach(a -> {
                futures.add(this.session.executeAsync((Statement)this.insertAlert.bind(new Object[]{a.getTenantId(), a.getAlertId(), this.toJson(a)})));
                futures.add(this.session.executeAsync((Statement)this.insertAlertTrigger.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getTriggerId()})));
                futures.add(this.session.executeAsync((Statement)this.insertAlertCtime.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getCtime()})));
                futures.add(this.session.executeAsync((Statement)this.insertAlertStatus.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getStatus().name()})));
            });
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public List<Alert> getAlerts(String tenantId, AlertsCriteria criteria) throws Exception {
        boolean filter;
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        boolean bl = filter = null != criteria && criteria.hasCriteria();
        if (filter) {
            this.log.debugf("getAlerts criteria: %s", (Object)criteria.toString());
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        HashSet<String> alertIds = new HashSet<String>();
        try {
            if (filter) {
                HashSet<String> alertIdsFilteredByTriggers = new HashSet<String>();
                boolean filterByTriggers = this.filterByTriggers(tenantId, alertIdsFilteredByTriggers, criteria);
                HashSet<String> alertIdsFilteredByCtime = new HashSet<String>();
                boolean filterByCtime = this.filterByCtime(tenantId, alertIdsFilteredByCtime, criteria);
                HashSet<String> alertIdsFilteredByStatus = new HashSet<String>();
                boolean filterByStatus = this.filterByStatuses(tenantId, alertIdsFilteredByStatus, criteria);
                HashSet<String> alertIdsFilteredByAlerts = new HashSet<String>();
                boolean filterByAlerts = this.filterByAlerts(alertIdsFilteredByAlerts, criteria);
                boolean firstJoin = true;
                if (filterByTriggers) {
                    alertIds.addAll(alertIdsFilteredByTriggers);
                    firstJoin = false;
                }
                if (filterByCtime) {
                    if (firstJoin) {
                        alertIds.addAll(alertIdsFilteredByCtime);
                    } else {
                        alertIds.retainAll(alertIdsFilteredByCtime);
                    }
                    firstJoin = false;
                }
                if (filterByStatus) {
                    if (firstJoin) {
                        alertIds.addAll(alertIdsFilteredByStatus);
                    } else {
                        alertIds.retainAll(alertIdsFilteredByStatus);
                    }
                    firstJoin = false;
                }
                if (filterByAlerts) {
                    if (firstJoin) {
                        alertIds.addAll(alertIdsFilteredByAlerts);
                    } else {
                        alertIds.retainAll(alertIdsFilteredByAlerts);
                    }
                }
            }
            if (!filter) {
                ResultSet rsAlerts = this.session.execute((Statement)this.selectAlertsByTenant.bind(new Object[]{tenantId}));
                for (Row row : rsAlerts) {
                    String payload = row.getString("payload");
                    Alert alert = this.fromJson(payload, Alert.class);
                    alerts.add(alert);
                }
            } else {
                List futures = alertIds.stream().map(alertId -> this.session.executeAsync((Statement)this.selectAlertsByTenantAndAlert.bind(new Object[]{tenantId, alertId}))).collect(Collectors.toList());
                List rsAlerts = (List)Futures.allAsList(futures).get();
                rsAlerts.stream().forEach(r -> {
                    for (Row row : r) {
                        String payload = row.getString("payload");
                        Alert alert = this.fromJson(payload, Alert.class);
                        alerts.add(alert);
                    }
                });
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alerts;
    }

    private void extractTriggersId(Set<String> triggerIds, AlertsCriteria criteria) throws Exception {
        if (this.isEmpty(criteria.getTriggerIds())) {
            if (!this.isEmpty(criteria.getTriggerId())) {
                triggerIds.add(criteria.getTriggerId());
            }
        } else {
            for (String triggerId : criteria.getTriggerIds()) {
                if (this.isEmpty(triggerId)) continue;
                triggerIds.add(triggerId);
            }
        }
        if (!this.isEmpty(criteria.getTags()) || criteria.getTag() != null) {
            Tag tag;
            HashSet<Tag> tags = new HashSet<Tag>();
            if (criteria.getTags() != null) {
                tags.addAll(criteria.getTags());
            }
            if ((tag = criteria.getTag()) != null) {
                tags.add(tag);
            }
            triggerIds.addAll(this.getTriggersIdByTags(tags));
        }
    }

    private boolean filterByTriggers(String tenantId, Set<String> alertsId, AlertsCriteria criteria) throws Exception {
        HashSet<String> triggerIds = new HashSet<String>();
        this.extractTriggersId(triggerIds, criteria);
        boolean filterByTriggers = false;
        if (triggerIds.size() > 0) {
            filterByTriggers = true;
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            for (String triggerId : triggerIds) {
                if (this.isEmpty(triggerId)) continue;
                futures.add(this.session.executeAsync((Statement)this.selectAlertsTriggers.bind(new Object[]{tenantId, triggerId})));
            }
            List rsAlertIdsByTriggerIds = (List)Futures.allAsList(futures).get();
            rsAlertIdsByTriggerIds.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertsId.add(alertId);
                }
            });
            if (alertsId.isEmpty()) {
                alertsId.add("no-result-fake-alert-id");
            }
        }
        return filterByTriggers;
    }

    private boolean filterByCtime(String tenantId, Set<String> alertsId, AlertsCriteria criteria) throws Exception {
        boolean filterByCtime = false;
        if (criteria.getStartTime() != null || criteria.getEndTime() != null) {
            filterByCtime = true;
            BoundStatement boundCtime = criteria.getStartTime() != null && criteria.getEndTime() != null ? this.selectAlertCTimeStartEnd.bind(new Object[]{tenantId, criteria.getStartTime(), criteria.getEndTime()}) : (criteria.getStartTime() != null ? this.selectAlertCTimeStart.bind(new Object[]{tenantId, criteria.getStartTime()}) : this.selectAlertCTimeEnd.bind(new Object[]{tenantId, criteria.getEndTime()}));
            ResultSet rsAlertsCtimes = this.session.execute((Statement)boundCtime);
            if (rsAlertsCtimes.isExhausted()) {
                alertsId.add("no-result-fake-alert-id");
            } else {
                for (Row row : rsAlertsCtimes) {
                    String alertId = row.getString("alertId");
                    alertsId.add(alertId);
                }
            }
        }
        return filterByCtime;
    }

    private boolean filterByStatuses(String tenantId, Set<String> alertsId, AlertsCriteria criteria) throws Exception {
        boolean filterByStatus = false;
        HashSet<Alert.Status> statuses = new HashSet<Alert.Status>();
        if (this.isEmpty(criteria.getStatusSet())) {
            if (criteria.getStatus() != null) {
                statuses.add(criteria.getStatus());
            }
        } else {
            statuses.addAll(criteria.getStatusSet());
        }
        if (statuses.size() > 0) {
            filterByStatus = true;
            List futures = statuses.stream().map(status -> this.session.executeAsync((Statement)this.selectAlertStatusByTenantAndStatus.bind(new Object[]{tenantId, status.name()}))).collect(Collectors.toList());
            List rsAlertStatuses = (List)Futures.allAsList(futures).get();
            rsAlertStatuses.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertsId.add(alertId);
                }
            });
            if (alertsId.isEmpty()) {
                alertsId.add("no-result-fake-alert-id");
            }
        }
        return filterByStatus;
    }

    private boolean filterByAlerts(Set<String> alertsId, AlertsCriteria criteria) {
        boolean filterByAlerts = false;
        if (this.isEmpty(criteria.getAlertIds())) {
            if (!this.isEmpty(criteria.getAlertId())) {
                filterByAlerts = true;
                alertsId.add(criteria.getAlertId());
            }
        } else {
            filterByAlerts = true;
            alertsId.addAll(criteria.getAlertIds());
        }
        return filterByAlerts;
    }

    private Collection<String> getTriggersIdByTags(Collection<Tag> tags) throws Exception {
        HashSet<String> triggerIds = new HashSet<String>();
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        for (Tag tag : tags) {
            if (tag.getCategory() == null && tag.getName() == null) continue;
            BoundStatement boundTag = !this.isEmpty(tag.getCategory()) && !this.isEmpty(tag.getName()) ? this.selectTagsTriggersByCategoryAndName.bind(new Object[]{tag.getTenantId(), tag.getCategory(), tag.getName()}) : (!this.isEmpty(tag.getCategory()) ? this.selectTagsTriggersByCategory.bind(new Object[]{tag.getTenantId(), tag.getCategory()}) : this.selectTagsTriggersByName.bind(new Object[]{tag.getTenantId(), tag.getName()}));
            futures.add(this.session.executeAsync((Statement)boundTag));
        }
        List rsTriggers = (List)Futures.allAsList(futures).get();
        rsTriggers.stream().forEach(r -> {
            for (Row row : r) {
                Set triggers = row.getSet("triggers", String.class);
                triggerIds.addAll(triggers);
            }
        });
        return triggerIds;
    }

    public void clear() {
        this.rulesTask.cancel();
        this.rules.clear();
        this.pendingData.clear();
        this.alerts.clear();
        this.pendingTimeouts.clear();
        this.autoResolvedTriggers.clear();
        this.disabledTriggers.clear();
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, this.delay, (long)this.period);
    }

    public void reload() {
        this.rules.reset();
        if (this.rulesTask != null) {
            this.rulesTask.cancel();
        }
        Collection triggers = null;
        try {
            triggers = this.definitions.getAllTriggers();
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService("Triggers", e.getMessage());
        }
        if (triggers != null && !triggers.isEmpty()) {
            triggers.stream().filter(Trigger::isEnabled).forEach(this::reloadTrigger);
        }
        this.rules.addGlobal("log", this.log);
        this.rules.addGlobal("actions", this.actions);
        this.rules.addGlobal("alerts", this.alerts);
        this.rules.addGlobal("pendingTimeouts", this.pendingTimeouts);
        this.rules.addGlobal("autoResolvedTriggers", this.autoResolvedTriggers);
        this.rules.addGlobal("disabledTriggers", this.disabledTriggers);
        this.rulesTask = new RulesInvoker();
        this.wakeUpTimer.schedule(this.rulesTask, this.delay, (long)this.period);
    }

    public void reloadTrigger(String tenantId, String triggerId) {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger trigger = null;
        try {
            trigger = this.definitions.getTrigger(tenantId, triggerId);
        }
        catch (Exception e) {
            this.log.debugf(e.getMessage(), (Object)e);
            this.msgLog.errorDefinitionsService("Trigger", e.getMessage());
        }
        if (null == trigger) {
            this.log.debugf("Trigger not found for triggerId [" + triggerId + "], removing from rulebase if it exists", new Object[0]);
            Trigger doomedTrigger = new Trigger(triggerId, "doomed");
            this.removeTrigger(doomedTrigger);
            return;
        }
        this.reloadTrigger(trigger);
    }

    private void reloadTrigger(Trigger trigger) {
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        this.removeTrigger(trigger);
        if (trigger.isEnabled()) {
            try {
                Collection conditionSet = this.definitions.getTriggerConditions(trigger.getTenantId(), trigger.getId(), null);
                Collection dampenings = this.definitions.getTriggerDampenings(trigger.getTenantId(), trigger.getId(), null);
                this.rules.addFact(trigger);
                this.rules.addFacts(conditionSet);
                if (!dampenings.isEmpty()) {
                    this.rules.addFacts(dampenings);
                }
            }
            catch (Exception e) {
                this.log.debugf(e.getMessage(), (Object)e);
                this.msgLog.errorDefinitionsService("Conditions/Dampening", e.getMessage());
            }
        }
    }

    private void removeTrigger(Trigger trigger) {
        if (null != this.rules.getFact(trigger)) {
            this.rules.removeFact(trigger);
            String triggerId = trigger.getId();
            this.rules.removeFacts(t -> {
                if (t instanceof Dampening) {
                    return ((Dampening)t).getTriggerId().equals(triggerId);
                }
                if (t instanceof Condition) {
                    return ((Condition)t).getTriggerId().equals(triggerId);
                }
                return false;
            });
        } else {
            this.log.debugf("Trigger not found. Not removed from rulebase %s", (Object)trigger);
        }
    }

    public void sendData(Collection<Data> data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.pendingData.addAll(data);
    }

    public void sendData(Data data) {
        if (data == null) {
            throw new IllegalArgumentException("Data must be not null");
        }
        this.pendingData.add(data);
    }

    public void ackAlerts(String tenantId, Collection<String> alertIds, String ackBy, String ackNotes) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        List<Alert> alertsToAck = this.getAlerts(tenantId, criteria);
        for (Alert a : alertsToAck) {
            a.setStatus(Alert.Status.ACKNOWLEDGED);
            a.setAckBy(ackBy);
            a.setAckNotes(ackNotes);
            this.updateAlertStatus(a);
        }
    }

    public void resolveAlerts(String tenantId, Collection<String> alertIds, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        List<Alert> alertsToResolve = this.getAlerts(tenantId, criteria);
        for (Alert a : alertsToResolve) {
            a.setStatus(Alert.Status.RESOLVED);
            a.setResolvedBy(resolvedBy);
            a.setResolvedNotes(resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a);
        }
    }

    public void resolveAlertsForTrigger(String tenantId, String triggerId, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(triggerId)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setTriggerId(triggerId);
        criteria.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
        List<Alert> alertsToResolve = this.getAlerts(tenantId, criteria);
        for (Alert a : alertsToResolve) {
            a.setStatus(Alert.Status.RESOLVED);
            a.setResolvedBy(resolvedBy);
            a.setResolvedNotes(resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a);
        }
    }

    private Alert updateAlertStatus(Alert alert) throws Exception {
        if (alert == null || alert.getAlertId() == null || alert.getAlertId().isEmpty()) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            ResultSet rsAlertsStatusToDelete = this.session.execute((Statement)this.selectAlertStatus.bind(new Object[]{alert.getTenantId(), alert.getStatus().name(), alert.getAlertId()}));
            for (Row row : rsAlertsStatusToDelete) {
                String alertIdToDelete = row.getString("alertId");
                String statusToDelete = row.getString("status");
                this.session.execute((Statement)this.deleteAlertStatus.bind(new Object[]{alert.getTenantId(), statusToDelete, alertIdToDelete}));
            }
            this.session.execute((Statement)this.insertAlertStatus.bind(new Object[]{alert.getTenantId(), alert.getAlertId(), alert.getStatus().name()}));
            this.session.execute((Statement)this.updateAlert.bind(new Object[]{this.toJson(alert), alert.getTenantId(), alert.getAlertId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alert;
    }

    private String toJson(Object resource) {
        this.log.debugf(this.gson.toJson(resource), new Object[0]);
        return this.gson.toJson(resource);
    }

    private <T> T fromJson(String json, Class<T> clazz) {
        return (T)this.gson.fromJson(json, clazz);
    }

    private boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisabledTriggers() {
        try {
            for (Trigger t : this.disabledTriggers) {
                try {
                    t.setEnabled(false);
                    this.definitions.updateTrigger(t.getTenantId(), t);
                }
                catch (Exception e) {
                    this.log.errorf("Failed to persist updated trigger. Could not autoDisable %s", (Object)t);
                }
            }
        }
        finally {
            this.disabledTriggers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAutoResolvedTriggers() {
        try {
            for (Map.Entry<Trigger, List<Set<ConditionEval>>> entry : this.autoResolvedTriggers.entrySet()) {
                Trigger t = entry.getKey();
                try {
                    if (!t.isAutoResolveAlerts()) continue;
                    this.resolveAlertsForTrigger(t.getTenantId(), t.getId(), "AUTO", null, entry.getValue());
                }
                catch (Exception e) {
                    this.log.errorf("Failed to resolve Alerts. Could not AutoResolve alerts for trigger %s", (Object)t);
                }
            }
        }
        finally {
            this.autoResolvedTriggers.clear();
        }
    }

    private class RulesInvoker
    extends TimerTask {
        private RulesInvoker() {
        }

        @Override
        public void run() {
            int numTimeouts = this.checkPendingTimeouts();
            if (!CassAlertsServiceImpl.this.pendingData.isEmpty() || numTimeouts > 0) {
                CassAlertsServiceImpl.this.log.debugf("Executing rules engine on [%1d] datums and [%2d] dampening timeouts.", (Object)CassAlertsServiceImpl.this.pendingData.size(), (Object)numTimeouts);
                try {
                    if (CassAlertsServiceImpl.this.pendingData.isEmpty()) {
                        CassAlertsServiceImpl.this.rules.fireNoData();
                    } else {
                        CassAlertsServiceImpl.this.rules.addData(CassAlertsServiceImpl.this.pendingData);
                        CassAlertsServiceImpl.this.pendingData.clear();
                    }
                    CassAlertsServiceImpl.this.rules.fire();
                    CassAlertsServiceImpl.this.addAlerts(CassAlertsServiceImpl.this.alerts);
                    CassAlertsServiceImpl.this.alerts.clear();
                    CassAlertsServiceImpl.this.handleDisabledTriggers();
                    CassAlertsServiceImpl.this.handleAutoResolvedTriggers();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CassAlertsServiceImpl.this.log.debugf("Error on rules processing: " + e, new Object[0]);
                    CassAlertsServiceImpl.this.msgLog.errorProcessingRules(e.getMessage());
                }
                finally {
                    CassAlertsServiceImpl.this.alerts.clear();
                }
            }
        }

        private int checkPendingTimeouts() {
            if (CassAlertsServiceImpl.this.pendingTimeouts.isEmpty()) {
                return 0;
            }
            long now = System.currentTimeMillis();
            HashSet<Dampening> timeouts = null;
            for (Dampening d : CassAlertsServiceImpl.this.pendingTimeouts) {
                if (now < d.getTrueEvalsStartTime() + d.getEvalTimeSetting()) continue;
                d.setSatisfied(true);
                try {
                    CassAlertsServiceImpl.this.log.debugf("Dampening Timeout Hit! %s", (Object)d.toString());
                    CassAlertsServiceImpl.this.rules.updateFact(d);
                    if (null == timeouts) {
                        timeouts = new HashSet<Dampening>();
                    }
                    timeouts.add(d);
                }
                catch (Exception e) {
                    CassAlertsServiceImpl.this.log.error((Object)("Unable to update Dampening Fact on Timeout! " + d.toString()), (Throwable)e);
                }
            }
            if (null == timeouts) {
                return 0;
            }
            CassAlertsServiceImpl.this.pendingTimeouts.removeAll(timeouts);
            return timeouts.size();
        }
    }
}

