/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Singleton;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.model.trigger.TriggerTemplate;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.jboss.logging.Logger;

@Singleton
public class CassDefinitionsServiceImpl
implements DefinitionsService {
    private static final String JBOSS_DATA_DIR = "jboss.server.data.dir";
    private static final String INIT_FOLDER = "hawkular-alerts";
    private static final String CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private static final String ALERTS_SERVICE = "hawkular-alerts.alerts-service-jndi";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassDefinitionsServiceImpl.class);
    private AlertsService alertsService;
    private Session session;
    private String keyspace;
    private boolean initialized = false;
    private List<DefinitionsListener> listeners = new ArrayList<DefinitionsListener>();
    private PreparedStatement insertTrigger;
    private PreparedStatement insertTriggerActions;
    private PreparedStatement selectTriggerConditions;
    private PreparedStatement selectTriggerConditionsTriggerMode;
    private PreparedStatement deleteConditionsMode;
    private PreparedStatement insertAvailabilityCondition;
    private PreparedStatement insertCompareCondition;
    private PreparedStatement insertStringCondition;
    private PreparedStatement insertThresholdCondition;
    private PreparedStatement insertThresholdRangeCondition;
    private PreparedStatement insertTag;
    private PreparedStatement insertDampening;
    private PreparedStatement insertAction;
    private PreparedStatement selectAllTriggers;
    private PreparedStatement selectTriggerActions;
    private PreparedStatement selectTenantTriggers;
    private PreparedStatement selectAllConditions;
    private PreparedStatement selectAllConditionsByTenant;
    private PreparedStatement selectAllDampenings;
    private PreparedStatement selectAllDampeningsByTenant;
    private PreparedStatement selectAllActions;
    private PreparedStatement selectAllActionsByTenant;
    private PreparedStatement selectTrigger;
    private PreparedStatement selectTriggerDampenings;
    private PreparedStatement selectTriggerDampeningsMode;
    private PreparedStatement deleteDampenings;
    private PreparedStatement deleteConditions;
    private PreparedStatement deleteTriggers;
    private PreparedStatement updateTrigger;
    private PreparedStatement deleteTriggerActions;
    private PreparedStatement deleteDampeningId;
    private PreparedStatement selectDampeningId;
    private PreparedStatement updateDampeningId;
    private PreparedStatement selectConditionId;
    private PreparedStatement insertActionPlugin;
    private PreparedStatement deleteActionPlugin;
    private PreparedStatement updateActionPlugin;
    private PreparedStatement selectActionPlugins;
    private PreparedStatement selectActionPlugin;
    private PreparedStatement deleteAction;
    private PreparedStatement updateAction;
    private PreparedStatement selectActionsPlugin;
    private PreparedStatement selectAction;
    private PreparedStatement selectTagsTriggers;
    private PreparedStatement insertTagsTriggers;
    private PreparedStatement updateTagsTriggers;
    private PreparedStatement deleteTagsTriggers;
    private PreparedStatement selectTags;
    private PreparedStatement selectTagsByCategoryAndName;
    private PreparedStatement selectTagsByCategory;
    private PreparedStatement selectTagsByName;
    private PreparedStatement deleteTags;
    private PreparedStatement deleteTagsByName;

    public AlertsService getAlertsService() {
        return this.alertsService;
    }

    public void setAlertsService(AlertsService alertsService) {
        this.alertsService = alertsService;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    @PostConstruct
    public void init() {
        try {
            if (this.keyspace == null) {
                this.keyspace = AlertProperties.getProperty(CASSANDRA_KEYSPACE, "hawkular_alerts");
            }
            if (this.session == null) {
                this.session = CassCluster.getSession();
            }
            this.initPreparedStatements();
            this.initialData();
            if (this.alertsService == null) {
                try {
                    InitialContext ctx = new InitialContext();
                    this.alertsService = (AlertsService)ctx.lookup(AlertProperties.getProperty(ALERTS_SERVICE, "java:app/hawkular-alerts-engine/CassAlertsServiceImpl"));
                }
                catch (NamingException e) {
                    this.log.debugf(e.getMessage(), (Object)e);
                    this.msgLog.errorCannotWithAlertsService(e.getMessage());
                }
            }
        }
        catch (Throwable t) {
            this.msgLog.errorCannotInitializeDefinitionsService(t.getMessage());
            t.printStackTrace();
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.session != null) {
            this.session.close();
        }
    }

    private void initialData() throws IOException {
        String data = System.getProperty(JBOSS_DATA_DIR);
        if (data == null || data.isEmpty()) {
            this.msgLog.errorFolderNotFound(data);
            return;
        }
        String folder = data + "/" + INIT_FOLDER;
        this.initFiles(folder);
        this.initialized = true;
    }

    private void initPreparedStatements() {
        if (this.insertTrigger == null) {
            this.insertTrigger = this.session.prepare("INSERT INTO " + this.keyspace + ".triggers " + "(name, description, autoDisable, autoResolve, autoResolveAlerts, firingMatch, " + "autoResolveMatch, id, enabled, tenantId) " + "values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertTriggerActions == null) {
            this.insertTriggerActions = this.session.prepare("INSERT INTO " + this.keyspace + ".triggers_actions " + "(tenantId, triggerId, actionPlugin, actions) VALUES (?, ?, ?, ?) ");
        }
        if (this.selectTriggerConditions == null) {
            this.selectTriggerConditions = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange, tenantId FROM " + this.keyspace + ".conditions " + "WHERE tenantId = ? AND triggerId = ? ORDER BY triggerId, triggerMode, type");
        }
        if (this.selectTriggerConditionsTriggerMode == null) {
            this.selectTriggerConditionsTriggerMode = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange, tenantId FROM " + this.keyspace + ".conditions " + "WHERE tenantId = ? AND triggerId = ? AND triggerMode = ? " + "ORDER BY triggerId, triggerMode, type");
        }
        if (this.deleteConditionsMode == null) {
            this.deleteConditionsMode = this.session.prepare("DELETE FROM " + this.keyspace + ".conditions " + "WHERE tenantId = ? AND triggerId = ? AND triggerMode = ? ");
        }
        if (this.insertAvailabilityCondition == null) {
            this.insertAvailabilityCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(tenantId, triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, " + "dataId, operator) VALUES (?, ?, ?, 'AVAILABILITY', ?, ?, ?, ?, ?) ");
        }
        if (this.insertCompareCondition == null) {
            this.insertCompareCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(tenantId, triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, " + "dataId, operator, data2Id, data2Multiplier) VALUES (?, ?, ?, 'COMPARE', ?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertStringCondition == null) {
            this.insertStringCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(tenantId, triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, " + "dataId, operator, pattern, ignoreCase) VALUES (?, ?, ?, 'STRING', ?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertThresholdCondition == null) {
            this.insertThresholdCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(tenantId, triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, " + "dataId, operator, threshold) VALUES (?, ?, ?, 'THRESHOLD', ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertThresholdRangeCondition == null) {
            this.insertThresholdRangeCondition = this.session.prepare("INSERT INTO " + this.keyspace + ".conditions " + "(tenantId, triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, " + "dataId, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange) " + "VALUES (?, ?, ?, 'RANGE', ?, ?, ?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertTag == null) {
            this.insertTag = this.session.prepare("INSERT INTO " + this.keyspace + ".tags " + "(tenantId, triggerId, category, name, visible) VALUES (?, ?, ?, ?, ?) ");
        }
        if (this.insertDampening == null) {
            this.insertDampening = this.session.prepare("INSERT INTO " + this.keyspace + ".dampenings " + "(triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, " + "dampeningId, tenantId) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ");
        }
        if (this.insertAction == null) {
            this.insertAction = this.session.prepare("INSERT INTO " + this.keyspace + ".actions " + "(tenantId, actionPlugin, actionId, properties) VALUES (?, ?, ?, ?) ");
        }
        if (this.selectAllTriggers == null) {
            this.selectAllTriggers = this.session.prepare("SELECT name, description, autoDisable, autoResolve, autoResolveAlerts, firingMatch, autoResolveMatch, id, enabled, tenantId FROM " + this.keyspace + ".triggers ");
        }
        if (this.selectTriggerActions == null) {
            this.selectTriggerActions = this.session.prepare("SELECT tenantId, triggerId, actionPlugin, actions FROM " + this.keyspace + ".triggers_actions " + "WHERE tenantId = ? AND triggerId = ? ");
        }
        if (this.selectTenantTriggers == null) {
            this.selectTenantTriggers = this.session.prepare("SELECT name, description, autoDisable, autoResolve, autoResolveAlerts, firingMatch, autoResolveMatch, id, enabled, tenantId FROM " + this.keyspace + ".triggers WHERE tenantId = ? ");
        }
        if (this.selectAllConditions == null) {
            this.selectAllConditions = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange,tenantId FROM " + this.keyspace + ".conditions ");
        }
        if (this.selectAllConditionsByTenant == null) {
            this.selectAllConditionsByTenant = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange,tenantId FROM " + this.keyspace + ".conditions WHERE tenantId = ? ");
        }
        if (this.selectAllDampenings == null) {
            this.selectAllDampenings = this.session.prepare("SELECT tenantId, triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId FROM " + this.keyspace + ".dampenings ");
        }
        if (this.selectAllDampeningsByTenant == null) {
            this.selectAllDampeningsByTenant = this.session.prepare("SELECT tenantId, triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId FROM " + this.keyspace + ".dampenings " + "WHERE tenantId = ? ");
        }
        if (this.selectAllActions == null) {
            this.selectAllActions = this.session.prepare("SELECT tenantId, actionPlugin, actionId FROM " + this.keyspace + ".actions ");
        }
        if (this.selectAllActionsByTenant == null) {
            this.selectAllActionsByTenant = this.session.prepare("SELECT actionPlugin, actionId FROM " + this.keyspace + ".actions WHERE tenantId = ? ");
        }
        if (this.selectTrigger == null) {
            this.selectTrigger = this.session.prepare("SELECT name, description, autoDisable, autoResolve, autoResolveAlerts, firingMatch, autoResolveMatch, id, enabled, tenantId FROM " + this.keyspace + ".triggers WHERE tenantId = ? AND id = ? ");
        }
        if (this.selectTriggerDampenings == null) {
            this.selectTriggerDampenings = this.session.prepare("SELECT tenantId, triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId FROM " + this.keyspace + ".dampenings " + "WHERE tenantId = ? AND triggerId = ? ");
        }
        if (this.selectTriggerDampeningsMode == null) {
            this.selectTriggerDampeningsMode = this.session.prepare("SELECT tenantId, triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId FROM " + this.keyspace + ".dampenings " + "WHERE tenantId = ? AND triggerId = ? and triggerMode = ? ");
        }
        if (this.deleteDampenings == null) {
            this.deleteDampenings = this.session.prepare("DELETE FROM " + this.keyspace + ".dampenings " + "WHERE tenantId = ? AND triggerId = ? ");
        }
        if (this.deleteConditions == null) {
            this.deleteConditions = this.session.prepare("DELETE FROM " + this.keyspace + ".conditions " + "WHERE tenantId = ? AND triggerId = ? ");
        }
        if (this.deleteTriggers == null) {
            this.deleteTriggers = this.session.prepare("DELETE FROM " + this.keyspace + ".triggers " + "WHERE tenantId = ? AND id = ? ");
        }
        if (this.updateTrigger == null) {
            this.updateTrigger = this.session.prepare("UPDATE " + this.keyspace + ".triggers " + "SET name = ?, description = ?, autoDisable = ?, autoResolve = ?, autoResolveAlerts = ?, " + "firingMatch = ?, autoResolveMatch = ?, enabled = ? " + "WHERE tenantId = ? AND id = ? ");
        }
        if (this.deleteTriggerActions == null) {
            this.deleteTriggerActions = this.session.prepare("DELETE FROM " + this.keyspace + ".triggers_actions " + "WHERE tenantId = ? AND triggerId = ? ");
        }
        if (this.deleteDampeningId == null) {
            this.deleteDampeningId = this.session.prepare("DELETE FROM " + this.keyspace + ".dampenings " + "WHERE tenantId = ? AND triggerId = ? AND triggerMode = ? AND dampeningId = ? ");
        }
        if (this.selectDampeningId == null) {
            this.selectDampeningId = this.session.prepare("SELECT triggerId, triggerMode, type, evalTrueSetting, evalTotalSetting, evalTimeSetting, dampeningId, tenantId FROM " + this.keyspace + ".dampenings " + "WHERE tenantId = ? AND dampeningId = ? ");
        }
        if (this.updateDampeningId == null) {
            this.updateDampeningId = this.session.prepare("UPDATE " + this.keyspace + ".dampenings " + "SET type = ?, evalTrueSetting = ?, evalTotalSetting = ?, evalTimeSetting = ? " + "WHERE tenantId = ? AND triggerId = ? AND triggerMode = ? AND dampeningId = ? ");
        }
        if (this.selectConditionId == null) {
            this.selectConditionId = this.session.prepare("SELECT triggerId, triggerMode, type, conditionSetSize, conditionSetIndex, conditionId, dataId, operator, data2Id, data2Multiplier, pattern, ignoreCase, threshold, operatorLow, operatorHigh, thresholdLow, thresholdHigh, inRange, tenantId FROM " + this.keyspace + ".conditions WHERE tenantId = ? AND conditionId = ? ");
        }
        if (this.insertActionPlugin == null) {
            this.insertActionPlugin = this.session.prepare("INSERT INTO " + this.keyspace + ".action_plugins (actionPlugin, " + "properties) VALUES (?, ?) ");
        }
        if (this.deleteActionPlugin == null) {
            this.deleteActionPlugin = this.session.prepare("DELETE FROM " + this.keyspace + ".action_plugins WHERE actionPlugin = ? ");
        }
        if (this.updateActionPlugin == null) {
            this.updateActionPlugin = this.session.prepare("UPDATE " + this.keyspace + ".action_plugins " + "SET properties = ? WHERE actionPlugin = ? ");
        }
        if (this.selectActionPlugins == null) {
            this.selectActionPlugins = this.session.prepare("SELECT actionPlugin FROM " + this.keyspace + ".action_plugins ");
        }
        if (this.selectActionPlugin == null) {
            this.selectActionPlugin = this.session.prepare("SELECT properties FROM " + this.keyspace + ".action_plugins " + "WHERE actionPlugin = ? ");
        }
        if (this.deleteAction == null) {
            this.deleteAction = this.session.prepare("DELETE FROM " + this.keyspace + ".actions " + "WHERE tenantId = ? AND actionPlugin = ? AND actionId = ? ");
        }
        if (this.updateAction == null) {
            this.updateAction = this.session.prepare("UPDATE " + this.keyspace + ".actions " + "SET properties = ? " + "WHERE tenantId = ? AND actionPlugin = ? AND actionId = ? ");
        }
        if (this.selectActionsPlugin == null) {
            this.selectActionsPlugin = this.session.prepare("SELECT actionId FROM " + this.keyspace + ".actions " + "WHERE tenantId = ? AND actionPlugin = ? ");
        }
        if (this.selectAction == null) {
            this.selectAction = this.session.prepare("SELECT properties FROM " + this.keyspace + ".actions " + "WHERE tenantId = ? AND actionPlugin = ? AND actionId = ? ");
        }
        if (this.selectTagsTriggers == null) {
            this.selectTagsTriggers = this.session.prepare("SELECT triggers FROM " + this.keyspace + ".tags_triggers " + "WHERE tenantId = ? AND category = ? AND name = ? ");
        }
        if (this.insertTagsTriggers == null) {
            this.insertTagsTriggers = this.session.prepare("INSERT INTO " + this.keyspace + ".tags_triggers " + "(tenantId, category, name, triggers) VALUES (?, ?, ?, ?) ");
        }
        if (this.updateTagsTriggers == null) {
            this.updateTagsTriggers = this.session.prepare("UPDATE " + this.keyspace + ".tags_triggers " + "SET triggers = ? " + "WHERE tenantId = ? AND name = ? ");
        }
        if (this.deleteTagsTriggers == null) {
            this.deleteTagsTriggers = this.session.prepare("DELETE FROM " + this.keyspace + ".tags_triggers " + "WHERE tenantId = ? AND name = ? ");
        }
        if (this.selectTags == null) {
            this.selectTags = this.session.prepare("SELECT tenantId, triggerId, category, name, visible FROM " + this.keyspace + ".tags WHERE tenantId = ? AND triggerId = ? ORDER BY triggerId, name ");
        }
        if (this.selectTagsByCategoryAndName == null) {
            this.selectTagsByCategoryAndName = this.session.prepare("SELECT tenantId, triggerId, category, name, visible FROM " + this.keyspace + ".tags WHERE tenantId = ? AND triggerId = ? AND category = ? AND name = ? ");
        }
        if (this.selectTagsByCategory == null) {
            this.selectTagsByCategory = this.session.prepare("SELECT tenantId, triggerId, category, name, visible FROM " + this.keyspace + ".tags WHERE tenantId = ? AND triggerId = ? AND category = ? ");
        }
        if (this.selectTagsByName == null) {
            this.selectTagsByName = this.session.prepare("SELECT tenantId, triggerId, category, name, visible FROM " + this.keyspace + ".tags WHERE tenantId = ? AND triggerId = ? AND name = ? ");
        }
        if (this.deleteTags == null) {
            this.deleteTags = this.session.prepare("DELETE FROM " + this.keyspace + ".tags WHERE tenantId = ? AND triggerId = ? ");
        }
        if (this.deleteTagsByName == null) {
            this.deleteTagsByName = this.session.prepare("DELETE FROM " + this.keyspace + ".tags " + "WHERE tenantId = ? AND triggerId = ? AND name = ?");
        }
    }

    private void initFiles(String folder) {
        if (folder == null) {
            this.msgLog.errorFolderMustBeNotNull();
            return;
        }
        if (this.session == null) {
            this.msgLog.errorDatabaseException("Cassandra session is null. Initialization can not work.");
            return;
        }
        File fFolder = new File(folder);
        if (!fFolder.exists()) {
            this.log.debugf("Data folder doesn't exits. Skipping initialization.", new Object[0]);
            return;
        }
        try {
            this.initTriggers(fFolder);
            this.initConditions(fFolder);
            this.initDampenings(fFolder);
            this.initActions(fFolder);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.msgLog.errorDatabaseException("Error initializing files. Msg: " + e);
        }
    }

    private void initTriggers(File fFolder) throws Exception {
        File triggers = new File(fFolder, "triggers.data");
        if (triggers.exists() && triggers.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(triggers.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.log.debugf(e.toString(), (Object)e);
                this.msgLog.warningReadingFile("triggers.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length != 11) continue;
                    String tenantId = fields[0];
                    String triggerId = fields[1];
                    boolean enabled = Boolean.parseBoolean(fields[2]);
                    String name = fields[3];
                    String description = fields[4];
                    boolean autoDisable = Boolean.parseBoolean(fields[5]);
                    boolean autoResolve = Boolean.parseBoolean(fields[6]);
                    boolean autoResolveAlerts = Boolean.parseBoolean(fields[7]);
                    TriggerTemplate.Match firingMatch = TriggerTemplate.Match.valueOf((String)fields[8]);
                    TriggerTemplate.Match autoResolveMatch = TriggerTemplate.Match.valueOf((String)fields[9]);
                    String[] notifiers = fields[10].split("\\|");
                    Trigger trigger = new Trigger(triggerId, name);
                    trigger.setEnabled(enabled);
                    trigger.setAutoDisable(autoDisable);
                    trigger.setAutoResolve(autoResolve);
                    trigger.setAutoResolveAlerts(autoResolveAlerts);
                    trigger.setDescription(description);
                    trigger.setFiringMatch(firingMatch);
                    trigger.setAutoResolveMatch(autoResolveMatch);
                    trigger.setTenantId(tenantId);
                    for (String notifier : notifiers) {
                        String[] actions = notifier.split("#");
                        String actionPlugin = actions[0];
                        String actionId = actions[1];
                        trigger.addAction(actionPlugin, actionId);
                    }
                    this.addTrigger(tenantId, trigger);
                    this.log.debugf("Init file - Inserting [%s]", (Object)trigger);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("triggers.data");
        }
    }

    private void initConditions(File initFolder) throws Exception {
        File conditions = new File(initFolder, "conditions.data");
        if (conditions.exists() && conditions.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(conditions.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.msgLog.warningReadingFile("conditions.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    CompareCondition newCondition;
                    String operator;
                    String dataId;
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length <= 5) continue;
                    String tenantId = fields[0];
                    String triggerId = fields[1];
                    Trigger.Mode triggerMode = Trigger.Mode.valueOf((String)fields[2]);
                    int conditionSetSize = Integer.parseInt(fields[3]);
                    int conditionSetIndex = Integer.parseInt(fields[4]);
                    String type = fields[5];
                    if (type != null && !type.isEmpty() && type.equals("threshold") && fields.length == 9) {
                        dataId = fields[6];
                        operator = fields[7];
                        Double threshold = Double.parseDouble(fields[8]);
                        ThresholdCondition newCondition2 = new ThresholdCondition();
                        newCondition2.setTriggerId(triggerId);
                        newCondition2.setTriggerMode(triggerMode);
                        newCondition2.setConditionSetSize(conditionSetSize);
                        newCondition2.setConditionSetIndex(conditionSetIndex);
                        newCondition2.setDataId(dataId);
                        newCondition2.setOperator(ThresholdCondition.Operator.valueOf((String)operator));
                        newCondition2.setThreshold(threshold);
                        newCondition2.setTenantId(tenantId);
                        this.initCondition((Condition)newCondition2);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition2);
                    }
                    if (type != null && !type.isEmpty() && type.equals("range") && fields.length == 12) {
                        dataId = fields[6];
                        String operatorLow = fields[7];
                        String operatorHigh = fields[8];
                        Double thresholdLow = Double.parseDouble(fields[9]);
                        Double thresholdHigh = Double.parseDouble(fields[10]);
                        boolean inRange = Boolean.parseBoolean(fields[11]);
                        ThresholdRangeCondition newCondition3 = new ThresholdRangeCondition();
                        newCondition3.setTriggerId(triggerId);
                        newCondition3.setTriggerMode(triggerMode);
                        newCondition3.setConditionSetSize(conditionSetSize);
                        newCondition3.setConditionSetIndex(conditionSetIndex);
                        newCondition3.setDataId(dataId);
                        newCondition3.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)operatorLow));
                        newCondition3.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)operatorHigh));
                        newCondition3.setThresholdLow(thresholdLow);
                        newCondition3.setThresholdHigh(thresholdHigh);
                        newCondition3.setInRange(inRange);
                        newCondition3.setTenantId(tenantId);
                        this.initCondition((Condition)newCondition3);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition3);
                    }
                    if (type != null && !type.isEmpty() && type.equals("compare") && fields.length == 10) {
                        dataId = fields[6];
                        operator = fields[7];
                        Double data2Multiplier = Double.parseDouble(fields[8]);
                        String data2Id = fields[9];
                        newCondition = new CompareCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(CompareCondition.Operator.valueOf((String)operator));
                        newCondition.setData2Multiplier(data2Multiplier);
                        newCondition.setData2Id(data2Id);
                        newCondition.setTenantId(tenantId);
                        this.initCondition((Condition)newCondition);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition);
                    }
                    if (type != null && !type.isEmpty() && type.equals("string") && fields.length == 10) {
                        dataId = fields[6];
                        operator = fields[7];
                        String pattern = fields[8];
                        boolean ignoreCase = Boolean.parseBoolean(fields[9]);
                        newCondition = new StringCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(StringCondition.Operator.valueOf((String)operator));
                        newCondition.setPattern(pattern);
                        newCondition.setIgnoreCase(ignoreCase);
                        newCondition.setTenantId(tenantId);
                        this.initCondition((Condition)newCondition);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition);
                    }
                    if (type == null || type.isEmpty() || !type.equals("availability") || fields.length != 8) continue;
                    dataId = fields[6];
                    operator = fields[7];
                    AvailabilityCondition newCondition4 = new AvailabilityCondition();
                    newCondition4.setTriggerId(triggerId);
                    newCondition4.setTriggerMode(triggerMode);
                    newCondition4.setConditionSetSize(conditionSetSize);
                    newCondition4.setConditionSetIndex(conditionSetIndex);
                    newCondition4.setDataId(dataId);
                    newCondition4.setOperator(AvailabilityCondition.Operator.valueOf((String)operator));
                    newCondition4.setTenantId(tenantId);
                    this.initCondition((Condition)newCondition4);
                    this.log.debugf("Init file - Inserting [%s]", (Object)newCondition4);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("conditions.data");
        }
    }

    private void initCondition(Condition condition) throws Exception {
        Collection<Condition> conditions = this.getTriggerConditions(condition.getTenantId(), condition.getTriggerId(), condition.getTriggerMode());
        conditions.add(condition);
        this.setConditions(condition.getTenantId(), condition.getTriggerId(), condition.getTriggerMode(), conditions);
    }

    private void initDampenings(File initFolder) throws Exception {
        File dampening = new File(initFolder, "dampening.data");
        if (dampening.exists() && dampening.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(dampening.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.msgLog.warningReadingFile("dampening.data");
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length != 7) continue;
                    String tenantId = fields[0];
                    String triggerId = fields[1];
                    Trigger.Mode triggerMode = Trigger.Mode.valueOf((String)fields[2]);
                    String type = fields[3];
                    int evalTrueSetting = new Integer(fields[4]);
                    int evalTotalSetting = new Integer(fields[5]);
                    int evalTimeSetting = new Integer(fields[6]);
                    Dampening newDampening = new Dampening(triggerId, triggerMode, Dampening.Type.valueOf((String)type), evalTrueSetting, evalTotalSetting, (long)evalTimeSetting);
                    this.addDampening(tenantId, newDampening);
                    this.log.debugf("Init file - Inserting [%s]", (Object)newDampening);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("dampening.data");
        }
    }

    private void initActions(File initFolder) throws Exception {
        File actions = new File(initFolder, "actions.data");
        if (actions.exists() && actions.isFile()) {
            List<String> lines = null;
            try {
                lines = Files.readAllLines(Paths.get(actions.toURI()), Charset.forName("UTF-8"));
            }
            catch (IOException e) {
                this.log.error((Object)e.toString(), (Throwable)e);
            }
            if (lines != null && !lines.isEmpty()) {
                for (String line : lines) {
                    String[] fields;
                    if (line.startsWith("#") || (fields = line.split(",")).length <= 3) continue;
                    String tenantId = fields[0];
                    String actionPlugin = fields[1];
                    String actionId = fields[2];
                    HashMap<String, String> newAction = new HashMap<String, String>();
                    newAction.put("tenantId", tenantId);
                    newAction.put("actionPlugin", actionPlugin);
                    newAction.put("actionId", actionId);
                    for (int i = 3; i < fields.length; ++i) {
                        String property = fields[i];
                        String[] properties = property.split("=");
                        if (properties.length != 2) continue;
                        newAction.put(properties[0], properties[1]);
                    }
                    this.addAction(tenantId, actionPlugin, actionId, newAction);
                    this.log.debugf("Init file - Inserting [%s]", newAction);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("actions.data");
        }
    }

    public void addAction(String tenantId, String actionPlugin, String actionId, Map<String, String> properties) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        properties.put("actionId", actionId);
        properties.put("actionPlugin", actionPlugin);
        properties.put("tenantId", tenantId);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertAction == null) {
            throw new RuntimeException("insertAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.insertAction.bind(new Object[]{tenantId, actionPlugin, actionId, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addTrigger(String tenantId, Trigger trigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(trigger)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, trigger);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertTrigger == null) {
            throw new RuntimeException("insertTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.insertTrigger.bind(new Object[]{trigger.getName(), trigger.getDescription(), trigger.isAutoDisable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getFiringMatch().name(), trigger.getAutoResolveMatch().name(), trigger.getId(), trigger.isEnabled(), trigger.getTenantId()}));
            this.insertTriggerActions(trigger);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void insertTriggerActions(Trigger trigger) throws Exception {
        if (this.insertTriggerActions == null) {
            throw new RuntimeException("insertTriggerActions PreparedStatement is null");
        }
        if (trigger.getActions() != null) {
            List futures = trigger.getActions().keySet().stream().filter(actionPlugin -> trigger.getActions().get(actionPlugin) != null && !((Set)trigger.getActions().get(actionPlugin)).isEmpty()).map(actionPlugin -> this.session.executeAsync((Statement)this.insertTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId(), actionPlugin, trigger.getActions().get(actionPlugin)}))).collect(Collectors.toList());
            Futures.allAsList(futures).get();
        }
    }

    public void removeTrigger(String tenantId, String triggerId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteDampenings == null || this.deleteConditions == null || this.deleteTriggers == null) {
            throw new RuntimeException("delete*Triggers PreparedStatement is null");
        }
        try {
            this.deleteTags(tenantId, triggerId, null, null);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)this.deleteDampenings.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)this.deleteConditions.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)this.deleteTriggers.bind(new Object[]{tenantId, triggerId})));
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Trigger updateTrigger(String tenantId, Trigger trigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(trigger)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, trigger);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.updateTrigger == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.updateTrigger.bind(new Object[]{trigger.getName(), trigger.getDescription(), trigger.isAutoDisable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getFiringMatch().name(), trigger.getAutoResolveMatch().name(), trigger.isEnabled(), trigger.getTenantId(), trigger.getId()}));
            this.deleteTriggerActions(trigger);
            this.insertTriggerActions(trigger);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(trigger.getTenantId(), trigger.getId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.TRIGGER_CHANGE);
        return trigger;
    }

    private void deleteTriggerActions(Trigger trigger) throws Exception {
        if (this.deleteTriggerActions == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        this.session.execute((Statement)this.deleteTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId()}));
    }

    public Trigger getTrigger(String tenantId, String triggerId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectTrigger == null) {
            throw new RuntimeException("selectTrigger PreparedStatement is null");
        }
        Trigger trigger = null;
        try {
            ResultSet rsTrigger = this.session.execute((Statement)this.selectTrigger.bind(new Object[]{tenantId, triggerId}));
            Iterator itTrigger = rsTrigger.iterator();
            if (itTrigger.hasNext()) {
                Row row = (Row)itTrigger.next();
                trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return trigger;
    }

    public Collection<Trigger> getTriggers(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectTenantTriggers == null) {
            throw new RuntimeException("selectTenantTriggers PreparedStatement is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            ResultSet rsTriggers = this.session.execute((Statement)this.selectTenantTriggers.bind(new Object[]{tenantId}));
            for (Row row : rsTriggers) {
                Trigger trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
                triggers.add(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return triggers;
    }

    public Collection<Trigger> getAllTriggers() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllTriggers == null) {
            throw new RuntimeException("selectAllTriggers PreparedStatement is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            ResultSet rsTriggers = this.session.execute((Statement)this.selectAllTriggers.bind());
            for (Row row : rsTriggers) {
                Trigger trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
                triggers.add(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return triggers;
    }

    private void selectTriggerActions(Trigger trigger) throws Exception {
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        if (this.selectTriggerActions == null) {
            throw new RuntimeException("selectTriggerActions PreparedStatement is null");
        }
        ResultSet rsTriggerActions = this.session.execute((Statement)this.selectTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId()}));
        for (Row row : rsTriggerActions) {
            String actionPlugin = row.getString("actionPlugin");
            Set actions = row.getSet("actions", String.class);
            trigger.addActions(actionPlugin, actions);
        }
    }

    private Trigger mapTrigger(Row row) {
        Trigger trigger = new Trigger();
        trigger.setName(row.getString("name"));
        trigger.setDescription(row.getString("description"));
        trigger.setAutoDisable(row.getBool("autoDisable"));
        trigger.setAutoResolve(row.getBool("autoResolve"));
        trigger.setAutoResolveAlerts(row.getBool("autoResolveAlerts"));
        trigger.setFiringMatch(TriggerTemplate.Match.valueOf((String)row.getString("firingMatch")));
        trigger.setAutoResolveMatch(TriggerTemplate.Match.valueOf((String)row.getString("autoResolveMatch")));
        trigger.setId(row.getString("id"));
        trigger.setEnabled(row.getBool("enabled"));
        trigger.setTenantId(row.getString("tenantId"));
        return trigger;
    }

    public Trigger copyTrigger(String tenantId, String triggerId, Map<String, String> dataIdMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.isEmpty(dataIdMap)) {
            throw new IllegalArgumentException("DataIdMap must be not null");
        }
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger not found for tenantId [ " + tenantId + "] and triggerId [" + triggerId + "]");
        }
        HashSet<String> dataIdTokens = new HashSet<String>();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, null);
        for (Condition c : conditions) {
            if (c instanceof CompareCondition) {
                dataIdTokens.add(c.getDataId());
                dataIdTokens.add(((CompareCondition)c).getData2Id());
                continue;
            }
            dataIdTokens.add(c.getDataId());
        }
        if (!dataIdTokens.equals(dataIdMap.keySet())) {
            throw new IllegalArgumentException("DataIdMap must contain the exact dataIds (keyset) expected by the condition set. Expected: " + dataIdMap.keySet() + ", dataIdMap: " + dataIdMap.keySet());
        }
        Collection<Dampening> dampenings = this.getTriggerDampenings(tenantId, triggerId, null);
        Trigger newTrigger = new Trigger(trigger.getName());
        newTrigger.setName(trigger.getName());
        newTrigger.setDescription(trigger.getDescription());
        newTrigger.setFiringMatch(trigger.getFiringMatch());
        newTrigger.setAutoResolveMatch(trigger.getAutoResolveMatch());
        newTrigger.setActions(trigger.getActions());
        newTrigger.setTenantId(trigger.getTenantId());
        this.addTrigger(tenantId, newTrigger);
        for (Condition c : conditions) {
            ThresholdCondition newCondition = null;
            if (c instanceof ThresholdCondition) {
                newCondition = new ThresholdCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((ThresholdCondition)c).getOperator(), ((ThresholdCondition)c).getThreshold());
            } else if (c instanceof ThresholdRangeCondition) {
                newCondition = new ThresholdRangeCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((ThresholdRangeCondition)c).getOperatorLow(), ((ThresholdRangeCondition)c).getOperatorHigh(), ((ThresholdRangeCondition)c).getThresholdLow(), ((ThresholdRangeCondition)c).getThresholdHigh(), ((ThresholdRangeCondition)c).isInRange());
            } else if (c instanceof AvailabilityCondition) {
                newCondition = new AvailabilityCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((AvailabilityCondition)c).getOperator());
            } else if (c instanceof CompareCondition) {
                newCondition = new CompareCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((CompareCondition)c).getOperator(), ((CompareCondition)c).getData2Multiplier(), dataIdMap.get(((CompareCondition)c).getData2Id()));
            } else if (c instanceof StringCondition) {
                newCondition = new StringCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((StringCondition)c).getOperator(), ((StringCondition)c).getPattern(), ((StringCondition)c).isIgnoreCase());
            }
            if (newCondition == null) continue;
            newCondition.setTenantId(newTrigger.getTenantId());
            this.addCondition(newTrigger.getTenantId(), newTrigger.getId(), newCondition.getTriggerMode(), (Condition)newCondition);
        }
        for (Dampening d : dampenings) {
            Dampening newDampening = new Dampening(newTrigger.getId(), d.getTriggerMode(), d.getType(), d.getEvalTrueSetting(), d.getEvalTotalSetting(), d.getEvalTimeSetting());
            newDampening.setTenantId(newTrigger.getTenantId());
            this.addDampening(newTrigger.getTenantId(), newDampening);
        }
        return newTrigger;
    }

    public Dampening addDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertDampening == null) {
            throw new RuntimeException("insertDampening PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.insertDampening.bind(new Object[]{dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getDampeningId(), dampening.getTenantId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
        return dampening;
    }

    public void removeDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("dampeningId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteDampeningId == null) {
            throw new RuntimeException("deleteDampeningId PreparedStatement is null");
        }
        Dampening dampening = this.getDampening(tenantId, dampeningId);
        if (dampening == null) {
            this.log.debugf("Ignoring removeDampening(" + dampeningId + "), the Dampening does not exist.", new Object[0]);
            return;
        }
        try {
            this.session.execute((Statement)this.deleteDampeningId.bind(new Object[]{dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampeningId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
    }

    public Dampening updateDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.updateDampeningId == null) {
            throw new RuntimeException("updateDampeningId PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.updateDampeningId.bind(new Object[]{dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsService) {
            this.alertsService.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
        return dampening;
    }

    public Dampening getDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectDampeningId == null) {
            throw new RuntimeException("selectDampeningId PreparedStatement is null");
        }
        Dampening dampening = null;
        try {
            ResultSet rsDampening = this.session.execute((Statement)this.selectDampeningId.bind(new Object[]{tenantId, dampeningId}));
            Iterator itDampening = rsDampening.iterator();
            if (itDampening.hasNext()) {
                Row row = (Row)itDampening.next();
                dampening = this.mapDampening(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampening;
    }

    public Collection<Dampening> getTriggerDampenings(String tenantId, String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectTriggerDampenings == null || this.selectTriggerDampeningsMode == null) {
            throw new RuntimeException("selectTriggerDampenings* PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = triggerMode == null ? this.session.execute((Statement)this.selectTriggerDampenings.bind(new Object[]{tenantId, triggerId})) : this.session.execute((Statement)this.selectTriggerDampeningsMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getAllDampenings() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllDampenings == null) {
            throw new RuntimeException("selectAllDampenings PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)this.selectAllDampenings.bind());
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getDampenings(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllDampeningsByTenant == null) {
            throw new RuntimeException("selectAllDampeningsByTenant PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)this.selectAllDampeningsByTenant.bind(new Object[]{tenantId}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    private void mapDampenings(ResultSet rsDampenings, List<Dampening> dampenings) throws Exception {
        for (Row row : rsDampenings) {
            Dampening dampening = this.mapDampening(row);
            dampenings.add(dampening);
        }
    }

    private Dampening mapDampening(Row row) {
        Dampening dampening = new Dampening();
        dampening.setTenantId(row.getString("tenantId"));
        dampening.setTriggerId(row.getString("triggerId"));
        dampening.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
        dampening.setType(Dampening.Type.valueOf((String)row.getString("type")));
        dampening.setEvalTrueSetting(row.getInt("evalTrueSetting"));
        dampening.setEvalTotalSetting(row.getInt("evalTotalSetting"));
        dampening.setEvalTimeSetting(row.getLong("evalTimeSetting"));
        return dampening;
    }

    public Collection<Condition> addCondition(String tenantId, String triggerId, Trigger.Mode triggerMode, Condition condition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        conditions.add(condition);
        int i = 0;
        for (Condition c : conditions) {
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, conditions);
    }

    public Collection<Condition> removeCondition(String tenantId, String conditionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition condition = this.getCondition(tenantId, conditionId);
        if (null == condition) {
            this.log.debugf("Ignoring removeCondition [%s], the condition does not exist.", (Object)conditionId);
            return null;
        }
        String triggerId = condition.getTriggerId();
        Trigger.Mode triggerMode = condition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        int i = 0;
        int size = conditions.size() - 1;
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) continue;
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
            newConditions.add(c);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> updateCondition(String tenantId, Condition condition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        String conditionId = condition.getConditionId();
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition existingCondition = this.getCondition(tenantId, conditionId);
        if (null == existingCondition) {
            throw new IllegalArgumentException("ConditionId [" + conditionId + "] on tenant " + tenantId + " does not exist.");
        }
        String triggerId = existingCondition.getTriggerId();
        Trigger.Mode triggerMode = existingCondition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        int size = conditions.size();
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) {
                newConditions.add(condition);
                continue;
            }
            newConditions.add(c);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> setConditions(String tenantId, String triggerId, Trigger.Mode triggerMode, Collection<Condition> conditions) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("Conditions must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertAvailabilityCondition == null || this.insertCompareCondition == null || this.insertStringCondition == null || this.insertThresholdCondition == null || this.insertThresholdRangeCondition == null) {
            throw new RuntimeException("insert*Condition PreparedStatement is null");
        }
        this.removeConditions(tenantId, triggerId, triggerMode);
        try {
            ArrayList<String> dataIds = new ArrayList<String>(2);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            int i = 0;
            for (Condition cond : conditions) {
                cond.setTenantId(tenantId);
                cond.setTriggerId(triggerId);
                cond.setTriggerMode(triggerMode);
                cond.setConditionSetSize(conditions.size());
                cond.setConditionSetIndex(++i);
                dataIds.add(cond.getDataId());
                if (cond instanceof AvailabilityCondition) {
                    AvailabilityCondition aCond = (AvailabilityCondition)cond;
                    futures.add(this.session.executeAsync((Statement)this.insertAvailabilityCondition.bind(new Object[]{aCond.getTenantId(), aCond.getTriggerId(), aCond.getTriggerMode().name(), aCond.getConditionSetSize(), aCond.getConditionSetIndex(), aCond.getConditionId(), aCond.getDataId(), aCond.getOperator().name()})));
                } else if (cond instanceof CompareCondition) {
                    CompareCondition cCond = (CompareCondition)cond;
                    dataIds.add(cCond.getData2Id());
                    futures.add(this.session.executeAsync((Statement)this.insertCompareCondition.bind(new Object[]{cCond.getTenantId(), cCond.getTriggerId(), cCond.getTriggerMode().name(), cCond.getConditionSetSize(), cCond.getConditionSetIndex(), cCond.getConditionId(), cCond.getDataId(), cCond.getOperator().name(), cCond.getData2Id(), cCond.getData2Multiplier()})));
                } else if (cond instanceof StringCondition) {
                    StringCondition sCond = (StringCondition)cond;
                    futures.add(this.session.executeAsync((Statement)this.insertStringCondition.bind(new Object[]{sCond.getTenantId(), sCond.getTriggerId(), sCond.getTriggerMode().name(), sCond.getConditionSetSize(), sCond.getConditionSetIndex(), sCond.getConditionId(), sCond.getDataId(), sCond.getOperator().name(), sCond.getPattern(), sCond.isIgnoreCase()})));
                } else if (cond instanceof ThresholdCondition) {
                    ThresholdCondition tCond = (ThresholdCondition)cond;
                    futures.add(this.session.executeAsync((Statement)this.insertThresholdCondition.bind(new Object[]{tCond.getTenantId(), tCond.getTriggerId(), tCond.getTriggerMode().name(), tCond.getConditionSetSize(), tCond.getConditionSetIndex(), tCond.getConditionId(), tCond.getDataId(), tCond.getOperator().name(), tCond.getThreshold()})));
                } else if (cond instanceof ThresholdRangeCondition) {
                    ThresholdRangeCondition rCond = (ThresholdRangeCondition)cond;
                    futures.add(this.session.executeAsync((Statement)this.insertThresholdRangeCondition.bind(new Object[]{rCond.getTenantId(), rCond.getTriggerId(), rCond.getTriggerMode().name(), rCond.getConditionSetSize(), rCond.getConditionSetIndex(), rCond.getConditionId(), rCond.getDataId(), rCond.getOperatorLow().name(), rCond.getOperatorHigh().name(), rCond.getThresholdLow(), rCond.getThresholdHigh(), rCond.isInRange()})));
                }
                for (String dataId : dataIds) {
                    this.insertTag(cond.getTenantId(), cond.getTriggerId(), "dataId", dataId, false);
                }
                dataIds.clear();
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && this.alertsService != null) {
            this.alertsService.reloadTrigger(tenantId, triggerId);
        }
        this.notifyListeners(DefinitionsEvent.EventType.CONDITION_CHANGE);
        return conditions;
    }

    private void insertTag(String tenantId, String triggerId, String category, String name, boolean visible) throws Exception {
        if (!this.getTags(tenantId, triggerId, category, name).isEmpty()) {
            return;
        }
        this.session.execute((Statement)this.insertTag.bind(new Object[]{tenantId, triggerId, category, name, visible}));
        this.insertTriggerByTagIndex(tenantId, category, name, triggerId);
    }

    private void insertTriggerByTagIndex(String tenantId, String category, String name, String triggerId) {
        Set<String> triggers = this.getTriggersByTags(tenantId, category, name);
        if ((triggers = new HashSet<String>(triggers)).isEmpty()) {
            triggers.add(triggerId);
            this.session.execute((Statement)this.insertTagsTriggers.bind(new Object[]{tenantId, category, name, triggers}));
        } else if (!triggers.contains(triggerId)) {
            triggers.add(triggerId);
            this.session.execute((Statement)this.updateTagsTriggers.bind(new Object[]{triggers, tenantId, name}));
        }
    }

    private Set<String> getTriggersByTags(String tenantId, String category, String name) {
        Set<String> triggerTags = new HashSet<String>();
        ResultSet rsTriggersTags = this.session.execute((Statement)this.selectTagsTriggers.bind(new Object[]{tenantId, category, name}));
        for (Row row : rsTriggersTags) {
            triggerTags = row.getSet("triggers", String.class);
        }
        return triggerTags;
    }

    private List<Tag> getTags(String tenantId, String triggerId, String category, String name) throws Exception {
        BoundStatement boundTags = !this.isEmpty(category) && !this.isEmpty(name) ? this.selectTagsByCategoryAndName.bind(new Object[]{tenantId, triggerId, category, name}) : (!this.isEmpty(category) ? this.selectTagsByCategory.bind(new Object[]{tenantId, triggerId, category}) : (!this.isEmpty(name) ? this.selectTagsByName.bind(new Object[]{tenantId, triggerId, name}) : this.selectTags.bind(new Object[]{tenantId, triggerId})));
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ResultSet rsTags = this.session.execute((Statement)boundTags);
        for (Row row : rsTags) {
            Tag tag = new Tag();
            tag.setTenantId(row.getString("tenantId"));
            tag.setTriggerId(row.getString("triggerId"));
            tag.setCategory(row.getString("category"));
            tag.setName(row.getString("name"));
            tag.setVisible(row.getBool("visible"));
            tags.add(tag);
        }
        return tags;
    }

    private void notifyListeners(DefinitionsEvent.EventType eventType) {
        DefinitionsEvent de = new DefinitionsEvent(eventType);
        for (DefinitionsListener dl : this.listeners) {
            this.log.debugf("Notified Listener %s", (Object)eventType.name());
            dl.onChange(de);
        }
    }

    private void removeConditions(String tenantId, String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must not be null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must not be null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must not be null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteConditionsMode == null) {
            throw new RuntimeException("deleteConditionsMode PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.deleteConditionsMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.deleteTags(tenantId, triggerId, "dataId", null);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void deleteTags(String tenantId, String triggerId, String category, String name) throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        BoundStatement boundTags = !this.isEmpty(name) ? this.deleteTagsByName.bind(new Object[]{tenantId, triggerId, name}) : this.deleteTags.bind(new Object[]{tenantId, triggerId});
        try {
            this.deleteTriggerByTagIndex(tenantId, triggerId, category, name);
            this.session.execute((Statement)boundTags);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void deleteTriggerByTagIndex(String tenantId, String triggerId, String category, String name) throws Exception {
        List<Object> tags;
        if (category == null || name == null) {
            tags = this.getTriggerTags(tenantId, triggerId, category);
        } else {
            tags = new ArrayList();
            Tag singleTag = new Tag();
            singleTag.setTenantId(tenantId);
            singleTag.setCategory(category);
            singleTag.setName(name);
            tags.add(singleTag);
        }
        for (Tag tag : tags) {
            Set<String> triggers = this.getTriggersByTags(tag.getTenantId(), tag.getCategory(), tag.getName());
            if (triggers.size() > 1) {
                HashSet<String> updateTriggers = new HashSet<String>(triggers);
                updateTriggers.remove(triggerId);
                this.session.execute((Statement)this.updateTagsTriggers.bind(new Object[]{triggers, tag.getTenantId(), tag.getName()}));
                continue;
            }
            this.session.execute((Statement)this.deleteTagsTriggers.bind(new Object[]{tag.getTenantId(), tag.getName()}));
        }
    }

    public Condition getCondition(String tenantId, String conditionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("conditionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectConditionId == null) {
            throw new RuntimeException("selectConditionId PreparedStatement is null");
        }
        Condition condition = null;
        try {
            ResultSet rsCondition = this.session.execute((Statement)this.selectConditionId.bind(new Object[]{tenantId, conditionId}));
            Iterator itCondition = rsCondition.iterator();
            if (itCondition.hasNext()) {
                Row row = (Row)itCondition.next();
                condition = this.mapCondition(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return condition;
    }

    public Collection<Condition> getTriggerConditions(String tenantId, String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("triggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectTriggerConditions == null || this.selectTriggerConditionsTriggerMode == null) {
            throw new RuntimeException("selectTriggerConditions* PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = triggerMode == null ? this.session.execute((Statement)this.selectTriggerConditions.bind(new Object[]{tenantId, triggerId})) : this.session.execute((Statement)this.selectTriggerConditionsTriggerMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getAllConditions() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllConditions == null) {
            throw new RuntimeException("selectAllConditions PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)this.selectAllConditions.bind());
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getConditions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllConditionsByTenant == null) {
            throw new RuntimeException("selectAllConditionsByTenant PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)this.selectAllConditionsByTenant.bind(new Object[]{tenantId}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    private void mapConditions(ResultSet rsConditions, List<Condition> conditions) throws Exception {
        for (Row row : rsConditions) {
            Condition condition = this.mapCondition(row);
            if (condition == null) continue;
            conditions.add(condition);
        }
    }

    private Condition mapCondition(Row row) throws Exception {
        AvailabilityCondition condition = null;
        String type = row.getString("type");
        if (type != null && !type.isEmpty()) {
            if (type.equals(Condition.Type.AVAILABILITY.name())) {
                AvailabilityCondition aCondition = new AvailabilityCondition();
                aCondition.setTenantId(row.getString("tenantId"));
                aCondition.setTriggerId(row.getString("triggerId"));
                aCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                aCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                aCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                aCondition.setDataId(row.getString("dataId"));
                aCondition.setOperator(AvailabilityCondition.Operator.valueOf((String)row.getString("operator")));
                condition = aCondition;
            } else if (type.equals(Condition.Type.COMPARE.name())) {
                CompareCondition cCondition = new CompareCondition();
                cCondition.setTenantId(row.getString("tenantId"));
                cCondition.setTriggerId(row.getString("triggerId"));
                cCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                cCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                cCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                cCondition.setDataId(row.getString("dataId"));
                cCondition.setOperator(CompareCondition.Operator.valueOf((String)row.getString("operator")));
                cCondition.setData2Id(row.getString("data2Id"));
                cCondition.setData2Multiplier(Double.valueOf(row.getDouble("data2Multiplier")));
                condition = cCondition;
            } else if (type.equals(Condition.Type.STRING.name())) {
                StringCondition sCondition = new StringCondition();
                sCondition.setTenantId(row.getString("tenantId"));
                sCondition.setTriggerId(row.getString("triggerId"));
                sCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                sCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                sCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                sCondition.setDataId(row.getString("dataId"));
                sCondition.setOperator(StringCondition.Operator.valueOf((String)row.getString("operator")));
                sCondition.setPattern(row.getString("pattern"));
                sCondition.setIgnoreCase(row.getBool("ignoreCase"));
                condition = sCondition;
            } else if (type.equals(Condition.Type.THRESHOLD.name())) {
                ThresholdCondition tCondition = new ThresholdCondition();
                tCondition.setTenantId(row.getString("tenantId"));
                tCondition.setTriggerId(row.getString("triggerId"));
                tCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                tCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                tCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                tCondition.setDataId(row.getString("dataId"));
                tCondition.setOperator(ThresholdCondition.Operator.valueOf((String)row.getString("operator")));
                tCondition.setThreshold(Double.valueOf(row.getDouble("threshold")));
                condition = tCondition;
            } else if (type.equals(Condition.Type.RANGE.name())) {
                ThresholdRangeCondition rCondition = new ThresholdRangeCondition();
                rCondition.setTenantId(row.getString("tenantId"));
                rCondition.setTriggerId(row.getString("triggerId"));
                rCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                rCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                rCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                rCondition.setDataId(row.getString("dataId"));
                rCondition.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorLow")));
                rCondition.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorHigh")));
                rCondition.setThresholdLow(Double.valueOf(row.getDouble("thresholdLow")));
                rCondition.setThresholdHigh(Double.valueOf(row.getDouble("thresholdHigh")));
                rCondition.setInRange(row.getBool("inRange"));
                condition = rCondition;
            } else {
                this.log.debugf("Wrong condition type found: " + type, new Object[0]);
            }
        } else {
            this.log.debugf("Wrong condition type: null or empty", new Object[0]);
        }
        return condition;
    }

    public void addActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.insertActionPlugin == null) {
            throw new RuntimeException("insertActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.insertActionPlugin.bind(new Object[]{actionPlugin, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeActionPlugin(String actionPlugin) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteActionPlugin == null) {
            throw new RuntimeException("deleteActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.deleteActionPlugin.bind(new Object[]{actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.updateActionPlugin == null) {
            throw new RuntimeException("updateActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.updateActionPlugin.bind(new Object[]{properties, actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<String> getActionPlugins() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectActionPlugins == null) {
            throw new RuntimeException("selectActionPlugins PreparedStatement is null");
        }
        ArrayList<String> actionPlugins = new ArrayList<String>();
        try {
            ResultSet rsActionPlugins = this.session.execute((Statement)this.selectActionPlugins.bind());
            for (Row row : rsActionPlugins) {
                actionPlugins.add(row.getString("actionPlugin"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actionPlugins;
    }

    public Set<String> getActionPlugin(String actionPlugin) throws Exception {
        if (actionPlugin == null || actionPlugin.isEmpty()) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectActionPlugin == null) {
            throw new RuntimeException("selectActionPlugin PreparedStatement is null");
        }
        Set properties = null;
        try {
            ResultSet rsActionPlugin = this.session.execute((Statement)this.selectActionPlugin.bind(new Object[]{actionPlugin}));
            Iterator itActionPlugin = rsActionPlugin.iterator();
            if (itActionPlugin.hasNext()) {
                Row row = (Row)itActionPlugin.next();
                properties = row.getSet("properties", String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public void removeAction(String tenantId, String actionPlugin, String actionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.deleteAction == null) {
            throw new RuntimeException("deleteAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.deleteAction.bind(new Object[]{tenantId, actionPlugin, actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateAction(String tenantId, String actionPlugin, String actionId, Map<String, String> properties) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        properties.put("actionId", actionId);
        properties.put("actionPlugin", actionPlugin);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.updateAction == null) {
            throw new RuntimeException("updateAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)this.updateAction.bind(new Object[]{properties, tenantId, actionPlugin, actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Map<String, Map<String, Set<String>>> getAllActions() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllActions == null) {
            throw new RuntimeException("selectAllActions PreparedStatement is null");
        }
        HashMap<String, Map<String, Set<String>>> actions = new HashMap<String, Map<String, Set<String>>>();
        try {
            ResultSet rsActions = this.session.execute((Statement)this.selectAllActions.bind());
            for (Row row : rsActions) {
                String tenantId = row.getString("tenantId");
                String actionPlugin = row.getString("actionPlugin");
                String actionId = row.getString("actionId");
                if (actions.get(tenantId) == null) {
                    actions.put(tenantId, new HashMap());
                }
                if (((Map)actions.get(tenantId)).get(actionPlugin) == null) {
                    ((Map)actions.get(tenantId)).put(actionPlugin, new HashSet());
                }
                ((Set)((Map)actions.get(tenantId)).get(actionPlugin)).add(actionId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Map<String, Set<String>> getActions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAllActionsByTenant == null) {
            throw new RuntimeException("selectAllActionsByTenant PreparedStatement is null");
        }
        HashMap<String, Set<String>> actions = new HashMap<String, Set<String>>();
        try {
            ResultSet rsActions = this.session.execute((Statement)this.selectAllActionsByTenant.bind(new Object[]{tenantId}));
            for (Row row : rsActions) {
                String actionPlugin = row.getString("actionPlugin");
                String actionId = row.getString("actionId");
                if (actions.get(actionPlugin) == null) {
                    actions.put(actionPlugin, new HashSet());
                }
                ((Set)actions.get(actionPlugin)).add(actionId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Collection<String> getActions(String tenantId, String actionPlugin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectActionsPlugin == null) {
            throw new RuntimeException("selectActionsPlugin PreparedStatement is null");
        }
        ArrayList<String> actions = new ArrayList<String>();
        try {
            ResultSet rsActions = this.session.execute((Statement)this.selectActionsPlugin.bind(new Object[]{tenantId, actionPlugin}));
            for (Row row : rsActions) {
                actions.add(row.getString("actionId"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Map<String, String> getAction(String tenantId, String actionPlugin, String actionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("actionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.selectAction == null) {
            throw new RuntimeException("selectAction PreparedStatement is null");
        }
        Map properties = null;
        try {
            ResultSet rsAction = this.session.execute((Statement)this.selectAction.bind(new Object[]{tenantId, actionPlugin, actionId}));
            Iterator itAction = rsAction.iterator();
            if (itAction.hasNext()) {
                Row row = (Row)itAction.next();
                properties = row.getMap("properties", String.class, String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public void addTag(String tenantId, Tag tag) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (tag == null) {
            throw new IllegalArgumentException("Tag must be not null");
        }
        if (tag.getTriggerId() == null || tag.getTriggerId().trim().isEmpty()) {
            throw new IllegalArgumentException("Tag TriggerId must be not null or empty");
        }
        if (tag.getName() == null || tag.getName().trim().isEmpty()) {
            throw new IllegalArgumentException("Tag Name must be not null or empty");
        }
        this.checkTenantId(tenantId, tag);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            this.insertTag(tag.getTenantId(), tag.getTriggerId(), tag.getCategory(), tag.getName(), tag.isVisible());
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeTags(String tenantId, String triggerId, String category, String name) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        try {
            this.deleteTags(tenantId, triggerId, category, name);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public List<Tag> getTriggerTags(String tenantId, String triggerId, String category) throws Exception {
        List<Tag> tags;
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            tags = this.getTags(tenantId, triggerId, category, null);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return tags;
    }

    public void registerListener(DefinitionsListener listener) {
        this.listeners.add(listener);
    }

    private boolean isEmpty(Trigger trigger) {
        return trigger == null || trigger.getId() == null || trigger.getId().trim().isEmpty();
    }

    private boolean isEmpty(Dampening dampening) {
        return dampening == null || dampening.getTriggerId() == null || dampening.getTriggerId().trim().isEmpty() || dampening.getDampeningId() == null || dampening.getDampeningId().trim().isEmpty();
    }

    private boolean isEmpty(String id) {
        return id == null || id.trim().isEmpty();
    }

    public boolean isEmpty(Map<String, String> map) {
        return map == null || map.isEmpty();
    }

    private void checkTenantId(String tenantId, Object obj) {
        Tag tag;
        if (tenantId == null || tenantId.trim().isEmpty()) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Trigger) {
            Trigger trigger = (Trigger)obj;
            if (trigger.getTenantId() == null || !trigger.getTenantId().equals(tenantId)) {
                trigger.setTenantId(tenantId);
            }
        } else if (obj instanceof Dampening) {
            Dampening dampening = (Dampening)obj;
            if (dampening.getTenantId() == null || !dampening.getTenantId().equals(tenantId)) {
                dampening.setTenantId(tenantId);
            }
        } else if (obj instanceof Tag && ((tag = (Tag)obj).getTenantId() == null || !tag.getTenantId().equals(tenantId))) {
            tag.setTenantId(tenantId);
        }
    }
}

