/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;

public class GsonAdapter<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private static final String PAYLOAD = "pL";
    private static final String INSTANCE_TYPE = "typ";
    private final Gson gson = new GsonBuilder().create();

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject container = (JsonObject)json;
        JsonPrimitive type = this.getEmbeddedInfo(container, INSTANCE_TYPE);
        JsonPrimitive payload = this.getEmbeddedInfo(container, PAYLOAD);
        Type instanceType = this.getInstanceType(type.getAsString());
        return (T)this.gson.fromJson(payload.getAsString(), instanceType);
    }

    private JsonPrimitive getEmbeddedInfo(JsonObject container, String key) {
        JsonPrimitive value = container.getAsJsonPrimitive(key);
        if (value == null) {
            throw new JsonParseException("Essential Key : '" + key + "' Not Found. Corrupt Serialized String!");
        }
        return value;
    }

    private Type getInstanceType(String type) {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException((Throwable)e);
        }
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext serContext) {
        JsonObject container = new JsonObject();
        String name = src.getClass().getName();
        container.addProperty(INSTANCE_TYPE, name);
        container.addProperty(PAYLOAD, this.gson.toJson(src));
        return container;
    }
}

