/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.ejb.Singleton;
import org.drools.core.event.DebugAgendaEventListener;
import org.drools.core.event.DebugRuleRuntimeEventListener;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.engine.rules.RulesEngine;
import org.jboss.logging.Logger;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

@Singleton
public class DroolsRulesEngineImpl
implements RulesEngine {
    private final Logger log = Logger.getLogger(DroolsRulesEngineImpl.class);
    private static final String SESSION_NAME = "hawkular-alerts-engine-session";
    private KieServices ks;
    private KieContainer kc;
    private KieSession kSession;
    TreeSet<Data> pendingData = new TreeSet();

    public DroolsRulesEngineImpl() {
        this.log.debugf("Creating instance.", new Object[0]);
        this.ks = KieServices.Factory.get();
        this.kc = this.ks.getKieClasspathContainer();
        this.kSession = this.kc.newKieSession(SESSION_NAME);
        if (this.log.isEnabled(Logger.Level.TRACE)) {
            this.kSession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
            this.kSession.addEventListener((RuleRuntimeEventListener)new DebugRuleRuntimeEventListener());
        }
    }

    @Override
    public void addFact(Object fact) {
        if (fact instanceof Data) {
            throw new IllegalArgumentException(fact.toString());
        }
        this.log.debugf("Insert %s ", fact);
        this.kSession.insert(fact);
    }

    @Override
    public void addFacts(Collection facts) {
        for (Object fact : facts) {
            if (!(fact instanceof Data)) continue;
            throw new IllegalArgumentException(fact.toString());
        }
        for (Object fact : facts) {
            this.log.debugf("Insert %s ", fact);
            this.kSession.insert(fact);
        }
    }

    @Override
    public void addData(Data data) {
        this.pendingData.add(data);
    }

    @Override
    public void addData(Collection<Data> data) {
        this.pendingData.addAll(data);
    }

    @Override
    public void addGlobal(String name, Object global) {
        this.log.debugf("Add Global %s = %s", (Object)name, global);
        this.kSession.setGlobal(name, global);
    }

    @Override
    public void clear() {
        for (FactHandle factHandle : this.kSession.getFactHandles()) {
            this.log.debugf("Delete %s ", (Object)factHandle);
            this.kSession.delete(factHandle);
        }
    }

    @Override
    public void fire() {
        while (!this.pendingData.isEmpty()) {
            this.log.debugf("Data found. Firing rules on [%1$d] datums.", (Object)this.pendingData.size());
            TreeSet<Data> batchData = new TreeSet<Data>((SortedSet<Data>)this.pendingData);
            Data previousData = null;
            this.pendingData.clear();
            for (Data data : batchData) {
                if (null == previousData || !data.getId().equals(previousData.getId())) {
                    this.kSession.insert((Object)data);
                    previousData = data;
                    continue;
                }
                this.pendingData.add(data);
                this.log.debugf("Deferring more recent %1$s until older %2$s is processed", (Object)data, (Object)previousData);
            }
            if (!this.pendingData.isEmpty()) {
                this.log.debugf("Deferring [%1$d] Datum(s) to next firing !!", (Object)this.pendingData.size());
            }
            batchData.clear();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)"Drools session dumping before firing: ");
                for (FactHandle fact : this.kSession.getFactHandles()) {
                    Object o = this.kSession.getObject(fact);
                    this.log.trace((Object)("Fact: " + o.toString()));
                }
            }
            this.kSession.fireAllRules();
        }
    }

    @Override
    public void fireNoData() {
        this.kSession.fireAllRules();
    }

    @Override
    public Object getFact(Object o) {
        return this.kSession.getFactHandle(o);
    }

    @Override
    public void removeFact(Object fact) {
        FactHandle factHandle = this.kSession.getFactHandle(fact);
        if (factHandle != null) {
            this.log.debugf("Delete %s ", (Object)factHandle);
            this.kSession.delete(factHandle);
        }
    }

    @Override
    public void updateFact(Object fact) {
        FactHandle factHandle = this.kSession.getFactHandle(fact);
        if (factHandle != null) {
            this.log.debugf("Update %s ", (Object)factHandle);
            this.kSession.update(factHandle, fact);
        }
    }

    @Override
    public void removeFacts(Collection facts) {
        for (Object fact : facts) {
            this.removeFact(fact);
        }
    }

    @Override
    public void removeFacts(final Predicate<Object> factFilter) {
        Collection handles = this.kSession.getFactHandles(new ObjectFilter(){

            public boolean accept(Object object) {
                return factFilter.test(object);
            }
        });
        if (null == handles) {
            return;
        }
        for (FactHandle h : handles) {
            this.log.debugf("Delete %s ", (Object)h);
            this.removeFact(h);
        }
    }

    @Override
    public void removeGlobal(String name) {
        this.log.debugf("Remove Global %s ", (Object)name);
        this.kSession.setGlobal(name, null);
    }

    @Override
    public void reset() {
        this.log.debugf("Reset session", new Object[0]);
        this.kSession.dispose();
        this.kSession = this.kc.newKieSession(SESSION_NAME);
    }
}

