/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.model.trigger.TriggerTemplate;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.impl.CassStatement;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.jboss.logging.Logger;

@Singleton
public class CassDefinitionsServiceImpl
implements DefinitionsService {
    private static final String JBOSS_DATA_DIR = "jboss.server.data.dir";
    private static final String INIT_FOLDER = "hawkular-alerts";
    private static final String CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassDefinitionsServiceImpl.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private Session session;
    private String keyspace;
    private boolean initialized = false;
    private Map<DefinitionsListener, Set<DefinitionsEvent.EventType>> listeners = new HashMap<DefinitionsListener, Set<DefinitionsEvent.EventType>>();
    @EJB
    AlertsEngine alertsEngine;

    public AlertsEngine getAlertsEngine() {
        return this.alertsEngine;
    }

    public void setAlertsEngine(AlertsEngine alertsEngine) {
        this.alertsEngine = alertsEngine;
    }

    @PostConstruct
    public void init() {
        try {
            if (this.keyspace == null) {
                this.keyspace = AlertProperties.getProperty(CASSANDRA_KEYSPACE, "hawkular_alerts");
            }
            if (this.session == null) {
                this.session = CassCluster.getSession();
            }
            this.initialData();
        }
        catch (Throwable t) {
            this.msgLog.errorCannotInitializeDefinitionsService(t.getMessage());
            t.printStackTrace();
        }
    }

    @PreDestroy
    public void shutdown() {
        CassCluster.shutdown();
    }

    private void initialData() throws IOException {
        String data = System.getProperty(JBOSS_DATA_DIR);
        if (data == null || data.isEmpty()) {
            this.msgLog.errorFolderNotFound(data);
            return;
        }
        String folder = data + "/" + INIT_FOLDER;
        this.initFiles(folder);
        this.initialized = true;
    }

    private void initFiles(String folder) {
        if (folder == null) {
            this.msgLog.errorFolderMustBeNotNull();
            return;
        }
        if (this.session == null) {
            this.msgLog.errorDatabaseException("Cassandra session is null. Initialization can not work.");
            return;
        }
        File fFolder = new File(folder);
        if (!fFolder.exists()) {
            this.log.debugf("Data folder doesn't exits. Skipping initialization.", new Object[0]);
            return;
        }
        try {
            this.initTriggers(fFolder);
            this.initConditions(fFolder);
            this.initDampenings(fFolder);
            this.initActions(fFolder);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.msgLog.errorDatabaseException("Error initializing files. Msg: " + e);
        }
    }

    private void initTriggers(File fFolder) throws Exception {
        File triggersFile = new File(fFolder, "triggers-data.json");
        if (triggersFile.exists() && triggersFile.isFile()) {
            Map triggers = (Map)this.objectMapper.readValue(triggersFile, Map.class);
            if (triggers != null && !triggers.isEmpty() && triggers.get("triggers") != null) {
                List aTriggers = (List)triggers.get("triggers");
                for (Map t : aTriggers) {
                    String tenantId = (String)t.get("tenantId");
                    String triggerId = (String)t.get("triggerId");
                    boolean enabled = (Boolean)t.get("enabled");
                    String name = (String)t.get("name");
                    String description = (String)t.get("description");
                    boolean autoDisable = (Boolean)t.get("autoDisable");
                    boolean autoEnable = (Boolean)t.get("autoEnable");
                    boolean autoResolve = (Boolean)t.get("autoResolve");
                    boolean autoResolveAlerts = (Boolean)t.get("autoResolveAlerts");
                    Severity severity = Severity.valueOf((String)((String)t.get("severity")));
                    TriggerTemplate.Match firingMatch = TriggerTemplate.Match.valueOf((String)((String)t.get("firingMatch")));
                    TriggerTemplate.Match autoResolveMatch = TriggerTemplate.Match.valueOf((String)((String)t.get("autoResolveMatch")));
                    List actions = (List)t.get("actions");
                    Trigger trigger = new Trigger(triggerId, name);
                    trigger.setEnabled(enabled);
                    trigger.setAutoDisable(autoDisable);
                    trigger.setAutoEnable(autoEnable);
                    trigger.setAutoResolve(autoResolve);
                    trigger.setAutoResolveAlerts(autoResolveAlerts);
                    trigger.setSeverity(severity);
                    trigger.setDescription(description);
                    trigger.setFiringMatch(firingMatch);
                    trigger.setAutoResolveMatch(autoResolveMatch);
                    trigger.setTenantId(tenantId);
                    for (Map action : actions) {
                        trigger.addAction((String)action.get("actionPlugin"), (String)action.get("actionId"));
                    }
                    this.addTrigger(tenantId, trigger);
                    this.log.debugf("Init file - Inserting [%s]", (Object)trigger);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("triggers-data.json");
        }
    }

    private void initConditions(File initFolder) throws Exception {
        File conditionsFile = new File(initFolder, "conditions-data.json");
        if (conditionsFile.exists() && conditionsFile.isFile()) {
            Map conditions = (Map)this.objectMapper.readValue(conditionsFile, Map.class);
            if (conditions != null && !conditions.isEmpty() && conditions.get("conditions") != null) {
                List aConditions = (List)conditions.get("conditions");
                for (Map c : aConditions) {
                    CompareCondition newCondition;
                    String operator;
                    String dataId;
                    String tenantId = (String)c.get("tenantId");
                    String triggerId = (String)c.get("triggerId");
                    Trigger.Mode triggerMode = Trigger.Mode.valueOf((String)((String)c.get("triggerMode")));
                    int conditionSetSize = (Integer)c.get("conditionSetSize");
                    int conditionSetIndex = (Integer)c.get("conditionSetIndex");
                    String type = (String)c.get("type");
                    if (type != null && !type.isEmpty() && type.equals("threshold")) {
                        dataId = (String)c.get("dataId");
                        operator = (String)c.get("operator");
                        Double threshold = (Double)c.get("threshold");
                        ThresholdCondition newCondition2 = new ThresholdCondition();
                        newCondition2.setTriggerId(triggerId);
                        newCondition2.setTriggerMode(triggerMode);
                        newCondition2.setConditionSetSize(conditionSetSize);
                        newCondition2.setConditionSetIndex(conditionSetIndex);
                        newCondition2.setDataId(dataId);
                        newCondition2.setOperator(ThresholdCondition.Operator.valueOf((String)operator));
                        newCondition2.setThreshold(threshold);
                        newCondition2.setTenantId(tenantId);
                        this.initCondition((Condition)newCondition2);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition2);
                    }
                    if (type != null && !type.isEmpty() && type.equals("range")) {
                        dataId = (String)c.get("dataId");
                        String operatorLow = (String)c.get("operatorLow");
                        String operatorHigh = (String)c.get("operatorHigh");
                        Double thresholdLow = (Double)c.get("thresholdLow");
                        Double thresholdHigh = (Double)c.get("thresholdHigh");
                        boolean inRange = (Boolean)c.get("inRange");
                        ThresholdRangeCondition newCondition3 = new ThresholdRangeCondition();
                        newCondition3.setTriggerId(triggerId);
                        newCondition3.setTriggerMode(triggerMode);
                        newCondition3.setConditionSetSize(conditionSetSize);
                        newCondition3.setConditionSetIndex(conditionSetIndex);
                        newCondition3.setDataId(dataId);
                        newCondition3.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)operatorLow));
                        newCondition3.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)operatorHigh));
                        newCondition3.setThresholdLow(thresholdLow);
                        newCondition3.setThresholdHigh(thresholdHigh);
                        newCondition3.setInRange(inRange);
                        newCondition3.setTenantId(tenantId);
                        this.initCondition((Condition)newCondition3);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition3);
                    }
                    if (type != null && !type.isEmpty() && type.equals("compare")) {
                        dataId = (String)c.get("dataId");
                        operator = (String)c.get("operator");
                        Double data2Multiplier = (Double)c.get("data2Multiplier");
                        String data2Id = (String)c.get("data2Id");
                        newCondition = new CompareCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(CompareCondition.Operator.valueOf((String)operator));
                        newCondition.setData2Multiplier(data2Multiplier);
                        newCondition.setData2Id(data2Id);
                        newCondition.setTenantId(tenantId);
                        this.initCondition((Condition)newCondition);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition);
                    }
                    if (type != null && !type.isEmpty() && type.equals("string")) {
                        dataId = (String)c.get("dataId");
                        operator = (String)c.get("operator");
                        String pattern = (String)c.get("pattern");
                        boolean ignoreCase = (Boolean)c.get("ignoreCase");
                        newCondition = new StringCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(StringCondition.Operator.valueOf((String)operator));
                        newCondition.setPattern(pattern);
                        newCondition.setIgnoreCase(ignoreCase);
                        newCondition.setTenantId(tenantId);
                        this.initCondition((Condition)newCondition);
                        this.log.debugf("Init file - Inserting [%s]", (Object)newCondition);
                    }
                    if (type == null || type.isEmpty() || !type.equals("availability")) continue;
                    dataId = (String)c.get("dataId");
                    operator = (String)c.get("operator");
                    AvailabilityCondition newCondition4 = new AvailabilityCondition();
                    newCondition4.setTriggerId(triggerId);
                    newCondition4.setTriggerMode(triggerMode);
                    newCondition4.setConditionSetSize(conditionSetSize);
                    newCondition4.setConditionSetIndex(conditionSetIndex);
                    newCondition4.setDataId(dataId);
                    newCondition4.setOperator(AvailabilityCondition.Operator.valueOf((String)operator));
                    newCondition4.setTenantId(tenantId);
                    this.initCondition((Condition)newCondition4);
                    this.log.debugf("Init file - Inserting [%s]", (Object)newCondition4);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("conditions-data.json");
        }
    }

    private void initCondition(Condition condition) throws Exception {
        Collection<Condition> conditions = this.getTriggerConditions(condition.getTenantId(), condition.getTriggerId(), condition.getTriggerMode());
        conditions.add(condition);
        this.setConditions(condition.getTenantId(), condition.getTriggerId(), condition.getTriggerMode(), conditions);
    }

    private void initDampenings(File initFolder) throws Exception {
        File dampeningFile = new File(initFolder, "dampening-data.json");
        if (dampeningFile.exists() && dampeningFile.isFile()) {
            Map dampenings = (Map)this.objectMapper.readValue(dampeningFile, Map.class);
            if (dampenings != null && !dampenings.isEmpty() && dampenings.get("dampenings") != null) {
                List aDampenings = (List)dampenings.get("dampenings");
                for (Map d : aDampenings) {
                    String tenantId = (String)d.get("tenantId");
                    String triggerId = (String)d.get("triggerId");
                    Trigger.Mode triggerMode = Trigger.Mode.valueOf((String)((String)d.get("triggerMode")));
                    String type = (String)d.get("type");
                    int evalTrueSetting = (Integer)d.get("evalTrueSetting");
                    int evalTotalSetting = (Integer)d.get("evalTotalSetting");
                    long evalTimeSetting = ((Integer)d.get("evalTimeSetting")).intValue();
                    Dampening newDampening = new Dampening(triggerId, triggerMode, Dampening.Type.valueOf((String)type), evalTrueSetting, evalTotalSetting, evalTimeSetting);
                    this.addDampening(tenantId, newDampening);
                    this.log.debugf("Init file - Inserting [%s]", (Object)newDampening);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("dampening-data.json");
        }
    }

    private void initActions(File initFolder) throws Exception {
        File actionsFile = new File(initFolder, "actions-data.json");
        if (actionsFile.exists() && actionsFile.isFile()) {
            Map actions = (Map)this.objectMapper.readValue(actionsFile, Map.class);
            if (actions != null && !actions.isEmpty() && actions.get("actions") != null) {
                List aActions = (List)actions.get("actions");
                for (Map a : aActions) {
                    HashMap<String, String> newAction = new HashMap<String, String>();
                    String tenantId = (String)a.get("tenantId");
                    newAction.put("tenantId", tenantId);
                    String actionPlugin = (String)a.get("actionPlugin");
                    newAction.put("actionPlugin", actionPlugin);
                    String actionId = (String)a.get("actionId");
                    newAction.put("actionId", actionId);
                    Map properties = (Map)a.get("properties");
                    newAction.putAll(properties);
                    this.addAction(tenantId, actionPlugin, actionId, newAction);
                    this.log.debugf("Init file - Inserting [%s]", newAction);
                }
            }
        } else {
            this.msgLog.warningFileNotFound("actions-data.json");
        }
    }

    public void addAction(String tenantId, String actionPlugin, String actionId, Map<String, String> properties) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        properties.put("actionId", actionId);
        properties.put("actionPlugin", actionPlugin);
        properties.put("tenantId", tenantId);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement insertAction = CassStatement.get(this.session, CassStatement.INSERT_ACTION);
        if (insertAction == null) {
            throw new RuntimeException("insertAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertAction.bind(new Object[]{tenantId, actionPlugin, actionId, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addTrigger(String tenantId, Trigger trigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(trigger)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, trigger);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement insertTrigger = CassStatement.get(this.session, CassStatement.INSERT_TRIGGER);
        if (insertTrigger == null) {
            throw new RuntimeException("insertTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertTrigger.bind(new Object[]{trigger.getName(), trigger.getDescription(), trigger.isAutoDisable(), trigger.isAutoEnable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getSeverity().name(), trigger.getFiringMatch().name(), trigger.getAutoResolveMatch().name(), trigger.getId(), trigger.isEnabled(), trigger.getTenantId()}));
            this.insertTriggerActions(trigger);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        this.notifyListeners(DefinitionsEvent.EventType.TRIGGER_CREATE);
    }

    private void insertTriggerActions(Trigger trigger) throws Exception {
        PreparedStatement insertTriggerActions = CassStatement.get(this.session, CassStatement.INSERT_TRIGGER_ACTIONS);
        if (insertTriggerActions == null) {
            throw new RuntimeException("insertTriggerActions PreparedStatement is null");
        }
        if (trigger.getActions() != null) {
            List futures = trigger.getActions().keySet().stream().filter(actionPlugin -> trigger.getActions().get(actionPlugin) != null && !((Set)trigger.getActions().get(actionPlugin)).isEmpty()).map(actionPlugin -> this.session.executeAsync((Statement)insertTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId(), actionPlugin, trigger.getActions().get(actionPlugin)}))).collect(Collectors.toList());
            Futures.allAsList(futures).get();
        }
    }

    public void removeTrigger(String tenantId, String triggerId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement deleteDampenings = CassStatement.get(this.session, CassStatement.DELETE_DAMPENINGS);
        PreparedStatement deleteConditions = CassStatement.get(this.session, CassStatement.DELETE_CONDITIONS);
        PreparedStatement deleteTrigger = CassStatement.get(this.session, CassStatement.DELETE_TRIGGER);
        if (deleteDampenings == null || deleteConditions == null || deleteTrigger == null) {
            throw new RuntimeException("delete*Triggers PreparedStatement is null");
        }
        try {
            this.deleteTags(tenantId, triggerId, null, null);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)deleteDampenings.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)deleteConditions.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)deleteTrigger.bind(new Object[]{tenantId, triggerId})));
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        this.notifyListeners(DefinitionsEvent.EventType.TRIGGER_REMOVE);
    }

    public Trigger updateTrigger(String tenantId, Trigger trigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(trigger)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, trigger);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement updateTrigger = CassStatement.get(this.session, CassStatement.UPDATE_TRIGGER);
        if (updateTrigger == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateTrigger.bind(new Object[]{trigger.getName(), trigger.getDescription(), trigger.isAutoDisable(), trigger.isAutoEnable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getSeverity().name(), trigger.getFiringMatch().name(), trigger.getAutoResolveMatch().name(), trigger.isEnabled(), trigger.getTenantId(), trigger.getId()}));
            this.deleteTriggerActions(trigger);
            this.insertTriggerActions(trigger);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(trigger.getTenantId(), trigger.getId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.TRIGGER_UPDATE);
        return trigger;
    }

    private void deleteTriggerActions(Trigger trigger) throws Exception {
        PreparedStatement deleteTriggerActions = CassStatement.get(this.session, CassStatement.DELETE_TRIGGER_ACTIONS);
        if (deleteTriggerActions == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        this.session.execute((Statement)deleteTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId()}));
    }

    public Trigger getTrigger(String tenantId, String triggerId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
        if (selectTrigger == null) {
            throw new RuntimeException("selectTrigger PreparedStatement is null");
        }
        Trigger trigger = null;
        try {
            ResultSet rsTrigger = this.session.execute((Statement)selectTrigger.bind(new Object[]{tenantId, triggerId}));
            Iterator itTrigger = rsTrigger.iterator();
            if (itTrigger.hasNext()) {
                Row row = (Row)itTrigger.next();
                trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return trigger;
    }

    public Collection<Trigger> getAllTriggers() throws Exception {
        return this.selectTriggers(null);
    }

    public Collection<Trigger> getTriggers(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        return this.selectTriggers(tenantId);
    }

    private Collection<Trigger> selectTriggers(String tenantId) throws Exception {
        PreparedStatement selectTriggers;
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement preparedStatement = selectTriggers = this.isEmpty(tenantId) ? CassStatement.get(this.session, CassStatement.SELECT_TRIGGERS_ALL) : CassStatement.get(this.session, CassStatement.SELECT_TRIGGERS_TENANT);
        if (null == selectTriggers) {
            throw new RuntimeException("selectTriggersTenant PreparedStatement is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            ResultSet rsTriggers = this.session.execute((Statement)(this.isEmpty(tenantId) ? selectTriggers.bind() : selectTriggers.bind(new Object[]{tenantId})));
            for (Row row : rsTriggers) {
                Trigger trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
                triggers.add(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return triggers;
    }

    public Collection<Trigger> getAllTriggersByTag(String category, String name) throws Exception {
        if (this.isEmpty(name)) {
            throw new IllegalArgumentException("Name must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            PreparedStatement selectTagsTriggers;
            BoundStatement bs = CassStatement.get(this.session, CassStatement.SELECT_PARTITIONS_TAGS).bind();
            HashSet<String> tenants = new HashSet<String>();
            for (Row row : this.session.execute((Statement)bs)) {
                tenants.add(row.getString("tenantId"));
            }
            PreparedStatement preparedStatement = selectTagsTriggers = this.isEmpty(category) ? CassStatement.get(this.session, CassStatement.SELECT_TAGS_TRIGGERS_BY_NAME) : CassStatement.get(this.session, CassStatement.SELECT_TAGS_TRIGGERS_BY_CATEGORY_AND_NAME);
            if (selectTagsTriggers == null) {
                throw new RuntimeException("selectTagsTriggersByTag PreparedStatement is null");
            }
            HashMap tenantTriggerIdsMap = new HashMap();
            List futures = this.isEmpty(category) ? tenants.stream().map(tenantId -> this.session.executeAsync((Statement)selectTagsTriggers.bind(new Object[]{tenantId, name}))).collect(Collectors.toList()) : tenants.stream().map(tenantId -> this.session.executeAsync((Statement)selectTagsTriggers.bind(new Object[]{tenantId, category, name}))).collect(Collectors.toList());
            List rsTriggerIds = (List)Futures.allAsList(futures).get();
            rsTriggerIds.stream().forEach(rs -> {
                for (Row row : rs) {
                    String tenantId = row.getString("tenantId");
                    Set triggerIds = row.getSet("triggers", String.class);
                    Set storedTriggerIds = (Set)tenantTriggerIdsMap.get(tenantId);
                    if (null != storedTriggerIds) {
                        triggerIds.addAll(storedTriggerIds);
                    }
                    tenantTriggerIdsMap.put(tenantId, triggerIds);
                }
            });
            ArrayList<Trigger> triggers = new ArrayList<Trigger>();
            PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
            for (Map.Entry entry : tenantTriggerIdsMap.entrySet()) {
                String tenantId2 = (String)entry.getKey();
                Set triggerIds = (Set)entry.getValue();
                futures = triggerIds.stream().map(triggerId -> this.session.executeAsync((Statement)selectTrigger.bind(new Object[]{tenantId2, triggerId}))).collect(Collectors.toList());
                List rsTriggers = (List)Futures.allAsList(futures).get();
                rsTriggers.stream().forEach(r -> {
                    for (Row row : r) {
                        triggers.add(this.mapTrigger(row));
                    }
                });
            }
            return triggers;
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<Trigger> getTriggersByTag(String tenantId, String category, String name) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("tenantId must be not null");
        }
        if (this.isEmpty(category) && this.isEmpty(name)) {
            throw new IllegalArgumentException("Category and Name can not both be null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            Set<String> triggerIds = this.getTriggerIdsByTag(tenantId, category, name);
            ArrayList<Trigger> triggers = new ArrayList<Trigger>(triggerIds.size());
            PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
            List futures = triggerIds.stream().map(triggerId -> this.session.executeAsync((Statement)selectTrigger.bind(new Object[]{tenantId, triggerId}))).collect(Collectors.toList());
            List rsTriggers = (List)Futures.allAsList(futures).get();
            rsTriggers.stream().forEach(r -> {
                for (Row row : r) {
                    triggers.add(this.mapTrigger(row));
                }
            });
            return triggers;
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void selectTriggerActions(Trigger trigger) throws Exception {
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        PreparedStatement selectTriggerActions = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_ACTIONS);
        if (selectTriggerActions == null) {
            throw new RuntimeException("selectTriggerActions PreparedStatement is null");
        }
        ResultSet rsTriggerActions = this.session.execute((Statement)selectTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId()}));
        for (Row row : rsTriggerActions) {
            String actionPlugin = row.getString("actionPlugin");
            Set actions = row.getSet("actions", String.class);
            trigger.addActions(actionPlugin, actions);
        }
    }

    private Trigger mapTrigger(Row row) {
        Trigger trigger = new Trigger();
        trigger.setName(row.getString("name"));
        trigger.setDescription(row.getString("description"));
        trigger.setAutoDisable(row.getBool("autoDisable"));
        trigger.setAutoEnable(row.getBool("autoEnable"));
        trigger.setAutoResolve(row.getBool("autoResolve"));
        trigger.setAutoResolveAlerts(row.getBool("autoResolveAlerts"));
        trigger.setSeverity(Severity.valueOf((String)row.getString("severity")));
        trigger.setFiringMatch(TriggerTemplate.Match.valueOf((String)row.getString("firingMatch")));
        trigger.setAutoResolveMatch(TriggerTemplate.Match.valueOf((String)row.getString("autoResolveMatch")));
        trigger.setId(row.getString("id"));
        trigger.setEnabled(row.getBool("enabled"));
        trigger.setTenantId(row.getString("tenantId"));
        return trigger;
    }

    public Trigger copyTrigger(String tenantId, String triggerId, Map<String, String> dataIdMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.isEmpty(dataIdMap)) {
            throw new IllegalArgumentException("DataIdMap must be not null");
        }
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger not found for tenantId [ " + tenantId + "] and triggerId [" + triggerId + "]");
        }
        HashSet<String> dataIdTokens = new HashSet<String>();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, null);
        for (Condition c : conditions) {
            if (c instanceof CompareCondition) {
                dataIdTokens.add(c.getDataId());
                dataIdTokens.add(((CompareCondition)c).getData2Id());
                continue;
            }
            dataIdTokens.add(c.getDataId());
        }
        if (!dataIdTokens.equals(dataIdMap.keySet())) {
            throw new IllegalArgumentException("DataIdMap must contain the exact dataIds (keyset) expected by the condition set. Expected: " + dataIdMap.keySet() + ", dataIdMap: " + dataIdMap.keySet());
        }
        Collection<Dampening> dampenings = this.getTriggerDampenings(tenantId, triggerId, null);
        Trigger newTrigger = new Trigger(trigger.getName());
        newTrigger.setName(trigger.getName());
        newTrigger.setDescription(trigger.getDescription());
        newTrigger.setSeverity(trigger.getSeverity());
        newTrigger.setFiringMatch(trigger.getFiringMatch());
        newTrigger.setAutoResolveMatch(trigger.getAutoResolveMatch());
        newTrigger.setActions(trigger.getActions());
        newTrigger.setTenantId(trigger.getTenantId());
        this.addTrigger(tenantId, newTrigger);
        for (Condition c : conditions) {
            ThresholdCondition newCondition = null;
            if (c instanceof ThresholdCondition) {
                newCondition = new ThresholdCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((ThresholdCondition)c).getOperator(), ((ThresholdCondition)c).getThreshold());
            } else if (c instanceof ThresholdRangeCondition) {
                newCondition = new ThresholdRangeCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((ThresholdRangeCondition)c).getOperatorLow(), ((ThresholdRangeCondition)c).getOperatorHigh(), ((ThresholdRangeCondition)c).getThresholdLow(), ((ThresholdRangeCondition)c).getThresholdHigh(), ((ThresholdRangeCondition)c).isInRange());
            } else if (c instanceof AvailabilityCondition) {
                newCondition = new AvailabilityCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((AvailabilityCondition)c).getOperator());
            } else if (c instanceof CompareCondition) {
                newCondition = new CompareCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((CompareCondition)c).getOperator(), ((CompareCondition)c).getData2Multiplier(), dataIdMap.get(((CompareCondition)c).getData2Id()));
            } else if (c instanceof StringCondition) {
                newCondition = new StringCondition(newTrigger.getId(), c.getTriggerMode(), c.getConditionSetSize(), c.getConditionSetIndex(), dataIdMap.get(c.getDataId()), ((StringCondition)c).getOperator(), ((StringCondition)c).getPattern(), ((StringCondition)c).isIgnoreCase());
            }
            if (newCondition == null) continue;
            newCondition.setTenantId(newTrigger.getTenantId());
            this.addCondition(newTrigger.getTenantId(), newTrigger.getId(), newCondition.getTriggerMode(), (Condition)newCondition);
        }
        for (Dampening d : dampenings) {
            Dampening newDampening = new Dampening(newTrigger.getId(), d.getTriggerMode(), d.getType(), d.getEvalTrueSetting(), d.getEvalTotalSetting(), d.getEvalTimeSetting());
            newDampening.setTenantId(newTrigger.getTenantId());
            this.addDampening(newTrigger.getTenantId(), newDampening);
        }
        return newTrigger;
    }

    public Dampening addDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement insertDampening = CassStatement.get(this.session, CassStatement.INSERT_DAMPENING);
        if (insertDampening == null) {
            throw new RuntimeException("insertDampening PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertDampening.bind(new Object[]{dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getDampeningId(), dampening.getTenantId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
        return dampening;
    }

    public void removeDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("dampeningId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement deleteDampeningId = CassStatement.get(this.session, CassStatement.DELETE_DAMPENING_ID);
        if (deleteDampeningId == null) {
            throw new RuntimeException("deleteDampeningId PreparedStatement is null");
        }
        Dampening dampening = this.getDampening(tenantId, dampeningId);
        if (dampening == null) {
            this.log.debugf("Ignoring removeDampening(" + dampeningId + "), the Dampening does not exist.", new Object[0]);
            return;
        }
        try {
            this.session.execute((Statement)deleteDampeningId.bind(new Object[]{dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampeningId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
    }

    public Dampening updateDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement updateDampeningId = CassStatement.get(this.session, CassStatement.UPDATE_DAMPENING_ID);
        if (updateDampeningId == null) {
            throw new RuntimeException("updateDampeningId PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateDampeningId.bind(new Object[]{dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.EventType.DAMPENING_CHANGE);
        return dampening;
    }

    public Dampening getDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectDampeningId = CassStatement.get(this.session, CassStatement.SELECT_DAMPENING_ID);
        if (selectDampeningId == null) {
            throw new RuntimeException("selectDampeningId PreparedStatement is null");
        }
        Dampening dampening = null;
        try {
            ResultSet rsDampening = this.session.execute((Statement)selectDampeningId.bind(new Object[]{tenantId, dampeningId}));
            Iterator itDampening = rsDampening.iterator();
            if (itDampening.hasNext()) {
                Row row = (Row)itDampening.next();
                dampening = this.mapDampening(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampening;
    }

    public Collection<Dampening> getTriggerDampenings(String tenantId, String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectTriggerDampenings = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_DAMPENINGS);
        PreparedStatement selectTriggerDampeningsMode = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_DAMPENINGS_MODE);
        if (selectTriggerDampenings == null || selectTriggerDampeningsMode == null) {
            throw new RuntimeException("selectTriggerDampenings* PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = triggerMode == null ? this.session.execute((Statement)selectTriggerDampenings.bind(new Object[]{tenantId, triggerId})) : this.session.execute((Statement)selectTriggerDampeningsMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getAllDampenings() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectDampeningsAll = CassStatement.get(this.session, CassStatement.SELECT_DAMPENINGS_ALL);
        if (selectDampeningsAll == null) {
            throw new RuntimeException("selectDampeningsAll PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)selectDampeningsAll.bind());
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getDampenings(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectDampeningsByTenant = CassStatement.get(this.session, CassStatement.SELECT_DAMPENINGS_BY_TENANT);
        if (selectDampeningsByTenant == null) {
            throw new RuntimeException("selectDampeningsByTenant PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)selectDampeningsByTenant.bind(new Object[]{tenantId}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    private void mapDampenings(ResultSet rsDampenings, List<Dampening> dampenings) throws Exception {
        for (Row row : rsDampenings) {
            Dampening dampening = this.mapDampening(row);
            dampenings.add(dampening);
        }
    }

    private Dampening mapDampening(Row row) {
        Dampening dampening = new Dampening();
        dampening.setTenantId(row.getString("tenantId"));
        dampening.setTriggerId(row.getString("triggerId"));
        dampening.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
        dampening.setType(Dampening.Type.valueOf((String)row.getString("type")));
        dampening.setEvalTrueSetting(row.getInt("evalTrueSetting"));
        dampening.setEvalTotalSetting(row.getInt("evalTotalSetting"));
        dampening.setEvalTimeSetting(row.getLong("evalTimeSetting"));
        return dampening;
    }

    public Collection<Condition> addCondition(String tenantId, String triggerId, Trigger.Mode triggerMode, Condition condition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        conditions.add(condition);
        int i = 0;
        for (Condition c : conditions) {
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, conditions);
    }

    public Collection<Condition> removeCondition(String tenantId, String conditionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition condition = this.getCondition(tenantId, conditionId);
        if (null == condition) {
            this.log.debugf("Ignoring removeCondition [%s], the condition does not exist.", (Object)conditionId);
            return null;
        }
        String triggerId = condition.getTriggerId();
        Trigger.Mode triggerMode = condition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        int i = 0;
        int size = conditions.size() - 1;
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) continue;
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
            newConditions.add(c);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> updateCondition(String tenantId, Condition condition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        String conditionId = condition.getConditionId();
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition existingCondition = this.getCondition(tenantId, conditionId);
        if (null == existingCondition) {
            throw new IllegalArgumentException("ConditionId [" + conditionId + "] on tenant " + tenantId + " does not exist.");
        }
        String triggerId = existingCondition.getTriggerId();
        Trigger.Mode triggerMode = existingCondition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        int size = conditions.size();
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) {
                newConditions.add(condition);
                continue;
            }
            newConditions.add(c);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> setConditions(String tenantId, String triggerId, Trigger.Mode triggerMode, Collection<Condition> conditions) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("Conditions must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement insertConditionAvailability = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_AVAILABILITY);
        PreparedStatement insertConditionCompare = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_COMPARE);
        PreparedStatement insertConditionExternal = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_EXTERNAL);
        PreparedStatement insertConditionString = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_STRING);
        PreparedStatement insertConditionThreshold = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_THRESHOLD);
        PreparedStatement insertConditionThresholdRange = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_THRESHOLD_RANGE);
        if (insertConditionAvailability == null || insertConditionCompare == null || insertConditionExternal == null || insertConditionString == null || insertConditionThreshold == null || insertConditionThresholdRange == null) {
            throw new RuntimeException("insert*Condition PreparedStatement is null");
        }
        this.removeConditions(tenantId, triggerId, triggerMode);
        try {
            ArrayList<String> dataIds = new ArrayList<String>(2);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            int i = 0;
            for (Condition cond : conditions) {
                cond.setTenantId(tenantId);
                cond.setTriggerId(triggerId);
                cond.setTriggerMode(triggerMode);
                cond.setConditionSetSize(conditions.size());
                cond.setConditionSetIndex(++i);
                dataIds.add(cond.getDataId());
                if (cond instanceof AvailabilityCondition) {
                    AvailabilityCondition aCond = (AvailabilityCondition)cond;
                    futures.add(this.session.executeAsync((Statement)insertConditionAvailability.bind(new Object[]{aCond.getTenantId(), aCond.getTriggerId(), aCond.getTriggerMode().name(), aCond.getConditionSetSize(), aCond.getConditionSetIndex(), aCond.getConditionId(), aCond.getDataId(), aCond.getOperator().name()})));
                } else if (cond instanceof CompareCondition) {
                    CompareCondition cCond = (CompareCondition)cond;
                    dataIds.add(cCond.getData2Id());
                    futures.add(this.session.executeAsync((Statement)insertConditionCompare.bind(new Object[]{cCond.getTenantId(), cCond.getTriggerId(), cCond.getTriggerMode().name(), cCond.getConditionSetSize(), cCond.getConditionSetIndex(), cCond.getConditionId(), cCond.getDataId(), cCond.getOperator().name(), cCond.getData2Id(), cCond.getData2Multiplier()})));
                } else if (cond instanceof ExternalCondition) {
                    ExternalCondition eCond = (ExternalCondition)cond;
                    futures.add(this.session.executeAsync((Statement)insertConditionExternal.bind(new Object[]{eCond.getTenantId(), eCond.getTriggerId(), eCond.getTriggerMode().name(), eCond.getConditionSetSize(), eCond.getConditionSetIndex(), eCond.getConditionId(), eCond.getDataId(), eCond.getSystemId(), eCond.getExpression()})));
                } else if (cond instanceof StringCondition) {
                    StringCondition sCond = (StringCondition)cond;
                    futures.add(this.session.executeAsync((Statement)insertConditionString.bind(new Object[]{sCond.getTenantId(), sCond.getTriggerId(), sCond.getTriggerMode().name(), sCond.getConditionSetSize(), sCond.getConditionSetIndex(), sCond.getConditionId(), sCond.getDataId(), sCond.getOperator().name(), sCond.getPattern(), sCond.isIgnoreCase()})));
                } else if (cond instanceof ThresholdCondition) {
                    ThresholdCondition tCond = (ThresholdCondition)cond;
                    futures.add(this.session.executeAsync((Statement)insertConditionThreshold.bind(new Object[]{tCond.getTenantId(), tCond.getTriggerId(), tCond.getTriggerMode().name(), tCond.getConditionSetSize(), tCond.getConditionSetIndex(), tCond.getConditionId(), tCond.getDataId(), tCond.getOperator().name(), tCond.getThreshold()})));
                } else if (cond instanceof ThresholdRangeCondition) {
                    ThresholdRangeCondition rCond = (ThresholdRangeCondition)cond;
                    futures.add(this.session.executeAsync((Statement)insertConditionThresholdRange.bind(new Object[]{rCond.getTenantId(), rCond.getTriggerId(), rCond.getTriggerMode().name(), rCond.getConditionSetSize(), rCond.getConditionSetIndex(), rCond.getConditionId(), rCond.getDataId(), rCond.getOperatorLow().name(), rCond.getOperatorHigh().name(), rCond.getThresholdLow(), rCond.getThresholdHigh(), rCond.isInRange()})));
                } else {
                    throw new IllegalArgumentException("Unexpected ConditionType: " + cond);
                }
                for (String dataId : dataIds) {
                    this.insertTag(cond.getTenantId(), cond.getTriggerId(), "dataId", dataId, false);
                }
                dataIds.clear();
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && this.alertsEngine != null) {
            this.alertsEngine.reloadTrigger(tenantId, triggerId);
        }
        this.notifyListeners(DefinitionsEvent.EventType.CONDITION_CHANGE);
        return conditions;
    }

    private void insertTag(String tenantId, String triggerId, String category, String name, boolean visible) throws Exception {
        if (null == category) {
            category = "";
        }
        if (!this.getTags(tenantId, triggerId, category, name).isEmpty()) {
            return;
        }
        PreparedStatement insertTag = CassStatement.get(this.session, CassStatement.INSERT_TAG);
        if (insertTag == null) {
            throw new RuntimeException("insertTag PreparedStatement is null");
        }
        this.session.execute((Statement)insertTag.bind(new Object[]{tenantId, triggerId, category, name, visible}));
        this.insertTriggerByTagIndex(tenantId, category, name, triggerId);
    }

    private void insertTriggerByTagIndex(String tenantId, String category, String name, String triggerId) {
        Set<String> triggers = this.getTriggerIdsByTag(tenantId, category, name);
        if ((triggers = new HashSet<String>(triggers)).isEmpty()) {
            triggers.add(triggerId);
            PreparedStatement insertTagsTriggers = CassStatement.get(this.session, CassStatement.INSERT_TAGS_TRIGGERS);
            if (insertTagsTriggers == null) {
                throw new RuntimeException("insertTagsTriggers PreparedStatement is null");
            }
            this.session.execute((Statement)insertTagsTriggers.bind(new Object[]{tenantId, category, name, triggers}));
        } else if (!triggers.contains(triggerId)) {
            triggers.add(triggerId);
            PreparedStatement updateTagsTriggers = CassStatement.get(this.session, CassStatement.UPDATE_TAGS_TRIGGERS);
            if (updateTagsTriggers == null) {
                throw new RuntimeException("updateTagsTriggers PreparedStatement is null");
            }
            this.session.execute((Statement)updateTagsTriggers.bind(new Object[]{triggers, tenantId, name}));
        }
    }

    private Set<String> getTriggerIdsByTag(String tenantId, String category, String name) {
        Set<String> triggerTags = new HashSet<String>();
        PreparedStatement selectTagsTriggers = null;
        selectTagsTriggers = this.isEmpty(category) ? CassStatement.get(this.session, CassStatement.SELECT_TAGS_TRIGGERS_BY_NAME) : (this.isEmpty(name) ? CassStatement.get(this.session, CassStatement.SELECT_TAGS_TRIGGERS_BY_CATEGORY) : CassStatement.get(this.session, CassStatement.SELECT_TAGS_TRIGGERS_BY_CATEGORY_AND_NAME));
        if (selectTagsTriggers == null) {
            throw new RuntimeException("selectTagsTriggers PreparedStatement is null");
        }
        BoundStatement bs = null;
        bs = this.isEmpty(category) ? selectTagsTriggers.bind(new Object[]{tenantId, name}) : (this.isEmpty(name) ? selectTagsTriggers.bind(new Object[]{tenantId, category}) : selectTagsTriggers.bind(new Object[]{tenantId, category, name}));
        ResultSet rsTriggersTags = this.session.execute((Statement)bs);
        for (Row row : rsTriggersTags) {
            triggerTags = row.getSet("triggers", String.class);
        }
        return triggerTags;
    }

    private List<Tag> getTags(String tenantId, String triggerId, String category, String name) throws Exception {
        BoundStatement boundTags;
        if (!this.isEmpty(category) && !this.isEmpty(name)) {
            PreparedStatement selectTagsByCategoryAndName = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_CATEGORY_AND_NAME);
            if (selectTagsByCategoryAndName == null) {
                throw new RuntimeException("selectTagsByCategoryAndName PreparedStatement is null");
            }
            boundTags = selectTagsByCategoryAndName.bind(new Object[]{tenantId, triggerId, category, name});
        } else if (!this.isEmpty(category)) {
            PreparedStatement selectTagsByCategory = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_CATEGORY);
            if (selectTagsByCategory == null) {
                throw new RuntimeException("selectTagsByCategory PreparedStatement is null");
            }
            boundTags = selectTagsByCategory.bind(new Object[]{tenantId, triggerId, category});
        } else if (!this.isEmpty(name)) {
            PreparedStatement selectTagsByName = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME);
            if (selectTagsByName == null) {
                throw new RuntimeException("selectTagsByName PreparedStatement is null");
            }
            boundTags = selectTagsByName.bind(new Object[]{tenantId, triggerId, name});
        } else {
            PreparedStatement selectTags = CassStatement.get(this.session, CassStatement.SELECT_TAGS);
            boundTags = selectTags.bind(new Object[]{tenantId, triggerId});
        }
        ArrayList<Tag> tags = new ArrayList<Tag>();
        ResultSet rsTags = this.session.execute((Statement)boundTags);
        for (Row row : rsTags) {
            Tag tag = new Tag();
            tag.setTenantId(row.getString("tenantId"));
            tag.setTriggerId(row.getString("triggerId"));
            tag.setCategory(row.getString("category"));
            tag.setName(row.getString("name"));
            tag.setVisible(row.getBool("visible"));
            tags.add(tag);
        }
        return tags;
    }

    private void removeConditions(String tenantId, String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must not be null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must not be null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must not be null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement deleteConditionsMode = CassStatement.get(this.session, CassStatement.DELETE_CONDITIONS_MODE);
        if (deleteConditionsMode == null) {
            throw new RuntimeException("deleteConditionsMode PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteConditionsMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.deleteTags(tenantId, triggerId, "dataId", null);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void deleteTags(String tenantId, String triggerId, String category, String name) throws Exception {
        BoundStatement boundTags;
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (!this.isEmpty(name)) {
            PreparedStatement deleteTagsByName = CassStatement.get(this.session, CassStatement.DELETE_TAGS_BY_NAME);
            if (deleteTagsByName == null) {
                throw new RuntimeException("deleteTagsByName PreparedStatement is null");
            }
            boundTags = deleteTagsByName.bind(new Object[]{tenantId, triggerId, name});
        } else {
            PreparedStatement deleteTags = CassStatement.get(this.session, CassStatement.DELETE_TAGS);
            if (deleteTags == null) {
                throw new RuntimeException("deleteTags PreparedStatement is null");
            }
            boundTags = deleteTags.bind(new Object[]{tenantId, triggerId});
        }
        try {
            this.deleteTriggerByTagIndex(tenantId, triggerId, category, name);
            this.session.execute((Statement)boundTags);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void deleteTriggerByTagIndex(String tenantId, String triggerId, String category, String name) throws Exception {
        List<Object> tags;
        if (category == null || name == null) {
            tags = this.getTriggerTags(tenantId, triggerId, category);
        } else {
            tags = new ArrayList();
            Tag singleTag = new Tag();
            singleTag.setTenantId(tenantId);
            singleTag.setCategory(category);
            singleTag.setName(name);
            tags.add(singleTag);
        }
        for (Tag tag : tags) {
            Set<String> triggers = this.getTriggerIdsByTag(tag.getTenantId(), tag.getCategory(), tag.getName());
            if (triggers.size() > 1) {
                HashSet<String> updateTriggers = new HashSet<String>(triggers);
                updateTriggers.remove(triggerId);
                PreparedStatement updateTagsTriggers = CassStatement.get(this.session, CassStatement.UPDATE_TAGS_TRIGGERS);
                if (updateTagsTriggers == null) {
                    throw new RuntimeException("updateTagsTriggers PreparedStatement is null");
                }
                this.session.execute((Statement)updateTagsTriggers.bind(new Object[]{triggers, tag.getTenantId(), tag.getName()}));
                continue;
            }
            PreparedStatement deleteTagsTriggers = CassStatement.get(this.session, CassStatement.DELETE_TAGS_TRIGGERS);
            if (deleteTagsTriggers == null) {
                throw new RuntimeException("deleteTagsTriggers PreparedStatement is null");
            }
            this.session.execute((Statement)deleteTagsTriggers.bind(new Object[]{tag.getTenantId(), tag.getName()}));
        }
    }

    public Condition getCondition(String tenantId, String conditionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("conditionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectConditionId = CassStatement.get(this.session, CassStatement.SELECT_CONDITION_ID);
        if (selectConditionId == null) {
            throw new RuntimeException("selectConditionId PreparedStatement is null");
        }
        Condition condition = null;
        try {
            ResultSet rsCondition = this.session.execute((Statement)selectConditionId.bind(new Object[]{tenantId, conditionId}));
            Iterator itCondition = rsCondition.iterator();
            if (itCondition.hasNext()) {
                Row row = (Row)itCondition.next();
                condition = this.mapCondition(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return condition;
    }

    public Collection<Condition> getTriggerConditions(String tenantId, String triggerId, Trigger.Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("triggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectTriggerConditions = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_CONDITIONS);
        PreparedStatement selectTriggerConditionsTriggerMode = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_CONDITIONS_TRIGGER_MODE);
        if (selectTriggerConditions == null || selectTriggerConditionsTriggerMode == null) {
            throw new RuntimeException("selectTriggerConditions* PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = triggerMode == null ? this.session.execute((Statement)selectTriggerConditions.bind(new Object[]{tenantId, triggerId})) : this.session.execute((Statement)selectTriggerConditionsTriggerMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getAllConditions() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectConditionsAll = CassStatement.get(this.session, CassStatement.SELECT_CONDITIONS_ALL);
        if (selectConditionsAll == null) {
            throw new RuntimeException("selectConditionsAll PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)selectConditionsAll.bind());
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getConditions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectConditionsByTenant = CassStatement.get(this.session, CassStatement.SELECT_CONDITIONS_BY_TENANT);
        if (selectConditionsByTenant == null) {
            throw new RuntimeException("selectConditionsByTenant PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)selectConditionsByTenant.bind(new Object[]{tenantId}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    private void mapConditions(ResultSet rsConditions, List<Condition> conditions) throws Exception {
        for (Row row : rsConditions) {
            Condition condition = this.mapCondition(row);
            if (condition == null) continue;
            conditions.add(condition);
        }
    }

    private Condition mapCondition(Row row) throws Exception {
        AvailabilityCondition condition = null;
        String type = row.getString("type");
        if (type != null && !type.isEmpty()) {
            switch (Condition.Type.valueOf((String)type)) {
                case AVAILABILITY: {
                    AvailabilityCondition aCondition = new AvailabilityCondition();
                    aCondition.setTenantId(row.getString("tenantId"));
                    aCondition.setTriggerId(row.getString("triggerId"));
                    aCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                    aCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    aCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    aCondition.setDataId(row.getString("dataId"));
                    aCondition.setOperator(AvailabilityCondition.Operator.valueOf((String)row.getString("operator")));
                    condition = aCondition;
                    break;
                }
                case COMPARE: {
                    CompareCondition cCondition = new CompareCondition();
                    cCondition.setTenantId(row.getString("tenantId"));
                    cCondition.setTriggerId(row.getString("triggerId"));
                    cCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                    cCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    cCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    cCondition.setDataId(row.getString("dataId"));
                    cCondition.setOperator(CompareCondition.Operator.valueOf((String)row.getString("operator")));
                    cCondition.setData2Id(row.getString("data2Id"));
                    cCondition.setData2Multiplier(Double.valueOf(row.getDouble("data2Multiplier")));
                    condition = cCondition;
                    break;
                }
                case EXTERNAL: {
                    ExternalCondition eCondition = new ExternalCondition();
                    eCondition.setTenantId(row.getString("tenantId"));
                    eCondition.setTriggerId(row.getString("triggerId"));
                    eCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                    eCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    eCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    eCondition.setDataId(row.getString("dataId"));
                    eCondition.setSystemId(row.getString("operator"));
                    eCondition.setExpression(row.getString("pattern"));
                    condition = eCondition;
                    break;
                }
                case RANGE: {
                    ThresholdRangeCondition rCondition = new ThresholdRangeCondition();
                    rCondition.setTenantId(row.getString("tenantId"));
                    rCondition.setTriggerId(row.getString("triggerId"));
                    rCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                    rCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    rCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    rCondition.setDataId(row.getString("dataId"));
                    rCondition.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorLow")));
                    rCondition.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorHigh")));
                    rCondition.setThresholdLow(Double.valueOf(row.getDouble("thresholdLow")));
                    rCondition.setThresholdHigh(Double.valueOf(row.getDouble("thresholdHigh")));
                    rCondition.setInRange(row.getBool("inRange"));
                    condition = rCondition;
                    break;
                }
                case STRING: {
                    StringCondition sCondition = new StringCondition();
                    sCondition.setTenantId(row.getString("tenantId"));
                    sCondition.setTriggerId(row.getString("triggerId"));
                    sCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                    sCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    sCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    sCondition.setDataId(row.getString("dataId"));
                    sCondition.setOperator(StringCondition.Operator.valueOf((String)row.getString("operator")));
                    sCondition.setPattern(row.getString("pattern"));
                    sCondition.setIgnoreCase(row.getBool("ignoreCase"));
                    condition = sCondition;
                    break;
                }
                case THRESHOLD: {
                    ThresholdCondition tCondition = new ThresholdCondition();
                    tCondition.setTenantId(row.getString("tenantId"));
                    tCondition.setTriggerId(row.getString("triggerId"));
                    tCondition.setTriggerMode(Trigger.Mode.valueOf((String)row.getString("triggerMode")));
                    tCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    tCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    tCondition.setDataId(row.getString("dataId"));
                    tCondition.setOperator(ThresholdCondition.Operator.valueOf((String)row.getString("operator")));
                    tCondition.setThreshold(Double.valueOf(row.getDouble("threshold")));
                    condition = tCondition;
                    break;
                }
                default: {
                    this.log.debugf("Unexpected condition type found: " + type, new Object[0]);
                    break;
                }
            }
        } else {
            this.log.debugf("Invalid condition type: null or empty", new Object[0]);
        }
        return condition;
    }

    public void addActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement insertActionPlugin = CassStatement.get(this.session, CassStatement.INSERT_ACTION_PLUGIN);
        if (insertActionPlugin == null) {
            throw new RuntimeException("insertActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertActionPlugin.bind(new Object[]{actionPlugin, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addActionPlugin(String actionPlugin, Map<String, String> defaultProperties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (defaultProperties == null || defaultProperties.isEmpty()) {
            throw new IllegalArgumentException("defaultProperties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement insertActionPluginDefaulProperties = CassStatement.get(this.session, CassStatement.INSERT_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (insertActionPluginDefaulProperties == null) {
            throw new RuntimeException("insertDefaulPropertiesActionPlugin PreparedStatement is null");
        }
        try {
            Set<String> properties = defaultProperties.keySet();
            this.session.execute((Statement)insertActionPluginDefaulProperties.bind(new Object[]{actionPlugin, properties, defaultProperties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeActionPlugin(String actionPlugin) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement deleteActionPlugin = CassStatement.get(this.session, CassStatement.DELETE_ACTION_PLUGIN);
        if (deleteActionPlugin == null) {
            throw new RuntimeException("deleteActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteActionPlugin.bind(new Object[]{actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement updateActionPlugin = CassStatement.get(this.session, CassStatement.UPDATE_ACTION_PLUGIN);
        if (updateActionPlugin == null) {
            throw new RuntimeException("updateActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateActionPlugin.bind(new Object[]{properties, actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateActionPlugin(String actionPlugin, Map<String, String> defaultProperties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (defaultProperties == null || defaultProperties.isEmpty()) {
            throw new IllegalArgumentException("defaultProperties must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement updateDefaultPropertiesActionPlugin = CassStatement.get(this.session, CassStatement.UPDATE_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (updateDefaultPropertiesActionPlugin == null) {
            throw new RuntimeException("updateDefaultPropertiesActionPlugin PreparedStatement is null");
        }
        try {
            Set<String> properties = defaultProperties.keySet();
            this.session.execute((Statement)updateDefaultPropertiesActionPlugin.bind(new Object[]{properties, defaultProperties, actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<String> getActionPlugins() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectActionPlugins = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGINS);
        if (selectActionPlugins == null) {
            throw new RuntimeException("selectActionPlugins PreparedStatement is null");
        }
        ArrayList<String> actionPlugins = new ArrayList<String>();
        try {
            ResultSet rsActionPlugins = this.session.execute((Statement)selectActionPlugins.bind());
            for (Row row : rsActionPlugins) {
                actionPlugins.add(row.getString("actionPlugin"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actionPlugins;
    }

    public Set<String> getActionPlugin(String actionPlugin) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectActionPlugin = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGIN);
        if (selectActionPlugin == null) {
            throw new RuntimeException("selectActionPlugin PreparedStatement is null");
        }
        Set properties = null;
        try {
            ResultSet rsActionPlugin = this.session.execute((Statement)selectActionPlugin.bind(new Object[]{actionPlugin}));
            Iterator itActionPlugin = rsActionPlugin.iterator();
            if (itActionPlugin.hasNext()) {
                Row row = (Row)itActionPlugin.next();
                properties = row.getSet("properties", String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public Map<String, String> getDefaultActionPlugin(String actionPlugin) {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectActionPluginDefaultProperties = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (selectActionPluginDefaultProperties == null) {
            throw new RuntimeException("selectDefaultPropertiesActionPlugin PreparedStatement is null");
        }
        Map defaultProperties = null;
        try {
            ResultSet rsActionPlugin = this.session.execute((Statement)selectActionPluginDefaultProperties.bind(new Object[]{actionPlugin}));
            Iterator itActionPlugin = rsActionPlugin.iterator();
            if (itActionPlugin.hasNext()) {
                Row row = (Row)itActionPlugin.next();
                defaultProperties = row.getMap("defaultProperties", String.class, String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return defaultProperties;
    }

    public void removeAction(String tenantId, String actionPlugin, String actionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement deleteAction = CassStatement.get(this.session, CassStatement.DELETE_ACTION);
        if (deleteAction == null) {
            throw new RuntimeException("deleteAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteAction.bind(new Object[]{tenantId, actionPlugin, actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateAction(String tenantId, String actionPlugin, String actionId, Map<String, String> properties) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        properties.put("actionId", actionId);
        properties.put("actionPlugin", actionPlugin);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement updateAction = CassStatement.get(this.session, CassStatement.UPDATE_ACTION);
        if (updateAction == null) {
            throw new RuntimeException("updateAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateAction.bind(new Object[]{properties, tenantId, actionPlugin, actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Map<String, Map<String, Set<String>>> getAllActions() throws Exception {
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectActionsAll = CassStatement.get(this.session, CassStatement.SELECT_ACTIONS_ALL);
        if (selectActionsAll == null) {
            throw new RuntimeException("selectActionsAll PreparedStatement is null");
        }
        HashMap<String, Map<String, Set<String>>> actions = new HashMap<String, Map<String, Set<String>>>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsAll.bind());
            for (Row row : rsActions) {
                String tenantId = row.getString("tenantId");
                String actionPlugin = row.getString("actionPlugin");
                String actionId = row.getString("actionId");
                if (actions.get(tenantId) == null) {
                    actions.put(tenantId, new HashMap());
                }
                if (((Map)actions.get(tenantId)).get(actionPlugin) == null) {
                    ((Map)actions.get(tenantId)).put(actionPlugin, new HashSet());
                }
                ((Set)((Map)actions.get(tenantId)).get(actionPlugin)).add(actionId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Map<String, Set<String>> getActions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectActionsByTenant = CassStatement.get(this.session, CassStatement.SELECT_ACTIONS_BY_TENANT);
        if (selectActionsByTenant == null) {
            throw new RuntimeException("selectActionsByTenant PreparedStatement is null");
        }
        HashMap<String, Set<String>> actions = new HashMap<String, Set<String>>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsByTenant.bind(new Object[]{tenantId}));
            for (Row row : rsActions) {
                String actionPlugin = row.getString("actionPlugin");
                String actionId = row.getString("actionId");
                if (actions.get(actionPlugin) == null) {
                    actions.put(actionPlugin, new HashSet());
                }
                ((Set)actions.get(actionPlugin)).add(actionId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Collection<String> getActions(String tenantId, String actionPlugin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectActionsPlugin = CassStatement.get(this.session, CassStatement.SELECT_ACTIONS_PLUGIN);
        if (selectActionsPlugin == null) {
            throw new RuntimeException("selectActionsPlugin PreparedStatement is null");
        }
        ArrayList<String> actions = new ArrayList<String>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsPlugin.bind(new Object[]{tenantId, actionPlugin}));
            for (Row row : rsActions) {
                actions.add(row.getString("actionId"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Map<String, String> getAction(String tenantId, String actionPlugin, String actionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("actionId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        PreparedStatement selectAction = CassStatement.get(this.session, CassStatement.SELECT_ACTION);
        if (selectAction == null) {
            throw new RuntimeException("selectAction PreparedStatement is null");
        }
        Map properties = null;
        try {
            ResultSet rsAction = this.session.execute((Statement)selectAction.bind(new Object[]{tenantId, actionPlugin, actionId}));
            Iterator itAction = rsAction.iterator();
            if (itAction.hasNext()) {
                Row row = (Row)itAction.next();
                properties = row.getMap("properties", String.class, String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public void addTag(String tenantId, Tag tag) throws Exception {
        if (tag == null) {
            throw new IllegalArgumentException("Tag must be not null");
        }
        if (this.isEmpty(tag.getTriggerId())) {
            throw new IllegalArgumentException("Tag TriggerId must be not null or empty");
        }
        if (this.isEmpty(tag.getName())) {
            throw new IllegalArgumentException("Tag Name must be not null or empty");
        }
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null or empty");
        }
        this.checkTenantId(tenantId, tag);
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            this.insertTag(tag.getTenantId(), tag.getTriggerId(), tag.getCategory(), tag.getName(), tag.isVisible());
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeTags(String tenantId, String triggerId, String category, String name) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        try {
            this.deleteTags(tenantId, triggerId, category, name);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public List<Tag> getTriggerTags(String tenantId, String triggerId, String category) throws Exception {
        List<Tag> tags;
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        try {
            tags = this.getTags(tenantId, triggerId, category, null);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return tags;
    }

    public void registerListener(DefinitionsListener listener, DefinitionsEvent.EventType eventType, DefinitionsEvent.EventType ... eventTypes) {
        EnumSet<DefinitionsEvent.EventType[]> types = EnumSet.of(eventType, eventTypes);
        this.log.debugf("Registering listeners %s for event types", (Object)listener, types);
        this.listeners.put(listener, types);
    }

    private void notifyListeners(DefinitionsEvent.EventType eventType) {
        DefinitionsEvent de = new DefinitionsEvent(eventType);
        this.log.debugf("Notifying applicable listeners %s of event %s", this.listeners, (Object)eventType.name());
        for (Map.Entry<DefinitionsListener, Set<DefinitionsEvent.EventType>> me : this.listeners.entrySet()) {
            if (!me.getValue().contains(eventType)) continue;
            this.log.debugf("Notified Listener %s", (Object)eventType.name());
            me.getKey().onChange(de);
        }
    }

    private boolean isEmpty(Trigger trigger) {
        return trigger == null || trigger.getId() == null || trigger.getId().trim().isEmpty();
    }

    private boolean isEmpty(Dampening dampening) {
        return dampening == null || dampening.getTriggerId() == null || dampening.getTriggerId().trim().isEmpty() || dampening.getDampeningId() == null || dampening.getDampeningId().trim().isEmpty();
    }

    private boolean isEmpty(String id) {
        return id == null || id.trim().isEmpty();
    }

    public boolean isEmpty(Map<String, String> map) {
        return map == null || map.isEmpty();
    }

    private void checkTenantId(String tenantId, Object obj) {
        Tag tag;
        if (this.isEmpty(tenantId)) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Trigger) {
            Trigger trigger = (Trigger)obj;
            if (trigger.getTenantId() == null || !trigger.getTenantId().equals(tenantId)) {
                trigger.setTenantId(tenantId);
            }
        } else if (obj instanceof Dampening) {
            Dampening dampening = (Dampening)obj;
            if (dampening.getTenantId() == null || !dampening.getTenantId().equals(tenantId)) {
                dampening.setTenantId(tenantId);
            }
        } else if (obj instanceof Tag && ((tag = (Tag)obj).getTenantId() == null || !tag.getTenantId().equals(tenantId))) {
            tag.setTenantId(tenantId);
        }
    }
}

