/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.paging.AlertComparator;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.PageContext;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Tag;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.impl.CassStatement;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.jboss.logging.Logger;

@Local(value={AlertsService.class})
@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CassAlertsServiceImpl
implements AlertsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassAlertsServiceImpl.class);
    private Session session;
    @EJB
    AlertsEngine alertsEngine;
    @EJB
    DefinitionsService definitionsService;
    @EJB
    ActionsService actionsService;

    @PostConstruct
    public void initServices() {
        try {
            this.session = CassCluster.getSession();
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                t.printStackTrace();
            }
            this.msgLog.errorCannotInitializeAlertsService(t.getMessage());
        }
    }

    public void addAlerts(Collection<Alert> alerts) throws Exception {
        if (alerts == null) {
            throw new IllegalArgumentException("Alerts must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement insertAlert = CassStatement.get(this.session, CassStatement.INSERT_ALERT);
        PreparedStatement insertAlertTrigger = CassStatement.get(this.session, CassStatement.INSERT_ALERT_TRIGGER);
        PreparedStatement insertAlertCtime = CassStatement.get(this.session, CassStatement.INSERT_ALERT_CTIME);
        PreparedStatement insertAlertStatus = CassStatement.get(this.session, CassStatement.INSERT_ALERT_STATUS);
        PreparedStatement insertAlertSeverity = CassStatement.get(this.session, CassStatement.INSERT_ALERT_SEVERITY);
        try {
            ArrayList futures = new ArrayList();
            alerts.stream().forEach(a -> {
                futures.add(this.session.executeAsync((Statement)insertAlert.bind(new Object[]{a.getTenantId(), a.getAlertId(), JsonUtil.toJson((Object)a)})));
                futures.add(this.session.executeAsync((Statement)insertAlertTrigger.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getTriggerId()})));
                futures.add(this.session.executeAsync((Statement)insertAlertCtime.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getCtime()})));
                futures.add(this.session.executeAsync((Statement)insertAlertStatus.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getStatus().name()})));
                futures.add(this.session.executeAsync((Statement)insertAlertSeverity.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getSeverity().name()})));
            });
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Alert getAlert(String tenantId, String alertId, boolean thin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertId)) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectAlert = CassStatement.get(this.session, CassStatement.SELECT_ALERT);
        if (selectAlert == null) {
            throw new RuntimeException("selectAlert PreparedStatement is null");
        }
        Alert alert = null;
        try {
            ResultSet rsAlert = this.session.execute((Statement)selectAlert.bind(new Object[]{tenantId, alertId}));
            Iterator itAlert = rsAlert.iterator();
            if (itAlert.hasNext()) {
                Row row = (Row)itAlert.next();
                alert = (Alert)JsonUtil.fromJson((String)row.getString("payload"), Alert.class, (boolean)thin);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alert;
    }

    public Page<Alert> getAlerts(String tenantId, AlertsCriteria criteria, Pager pager) throws Exception {
        boolean thin;
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        this.session = CassCluster.getSession();
        boolean filter = null != criteria && criteria.hasCriteria();
        boolean bl = thin = null != criteria && criteria.isThin();
        if (filter) {
            this.log.debugf("getAlerts criteria: %s", (Object)criteria.toString());
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        HashSet<String> alertIds = new HashSet<String>();
        try {
            if (filter) {
                HashSet<String> alertIdsFilteredByStatus;
                boolean filterByStatus;
                HashSet<String> alertIdsFilteredBySeverity;
                boolean filterBySeverity;
                HashSet<String> alertIdsFilteredByCtime;
                boolean filterByCtime;
                Object alertIdsFilteredByTriggers;
                boolean filterByTriggers;
                HashSet<String> alertIdsFilteredByAlerts = new HashSet<String>();
                boolean filterByAlerts = this.filterByAlerts(alertIdsFilteredByAlerts, criteria);
                if (filterByAlerts) {
                    alertIds.addAll(alertIdsFilteredByAlerts);
                }
                if (filterByTriggers = this.filterByTriggers(tenantId, (Set<String>)(alertIdsFilteredByTriggers = new HashSet<String>()), criteria)) {
                    if (alertIds.isEmpty()) {
                        alertIds.addAll((Collection<String>)alertIdsFilteredByTriggers);
                    } else {
                        alertIds.retainAll((Collection<?>)alertIdsFilteredByTriggers);
                    }
                    if (alertIds.isEmpty()) {
                        return new Page(alerts, (PageContext)pager, 0L);
                    }
                }
                if (filterByCtime = this.filterByCtime(tenantId, alertIdsFilteredByCtime = new HashSet<String>(), criteria)) {
                    if (alertIds.isEmpty()) {
                        alertIds.addAll(alertIdsFilteredByCtime);
                    } else {
                        alertIds.retainAll(alertIdsFilteredByCtime);
                    }
                    if (alertIds.isEmpty()) {
                        return new Page(alerts, (PageContext)pager, 0L);
                    }
                }
                if (filterBySeverity = this.filterBySeverities(tenantId, alertIdsFilteredBySeverity = new HashSet<String>(), criteria)) {
                    if (alertIds.isEmpty()) {
                        alertIds.addAll(alertIdsFilteredBySeverity);
                    } else {
                        alertIds.retainAll(alertIdsFilteredBySeverity);
                    }
                    if (alertIds.isEmpty()) {
                        return new Page(alerts, (PageContext)pager, 0L);
                    }
                }
                if (filterByStatus = this.filterByStatuses(tenantId, alertIdsFilteredByStatus = new HashSet<String>(), criteria)) {
                    if (alertIds.isEmpty()) {
                        alertIds.addAll(alertIdsFilteredByStatus);
                    } else {
                        alertIds.retainAll(alertIdsFilteredByStatus);
                    }
                    if (alertIds.isEmpty()) {
                        return new Page(alerts, (PageContext)pager, 0L);
                    }
                }
            }
            if (!filter) {
                PreparedStatement selectAlertsByTenant = CassStatement.get(this.session, CassStatement.SELECT_ALERTS_BY_TENANT);
                ResultSet rsAlerts = this.session.execute((Statement)selectAlertsByTenant.bind(new Object[]{tenantId}));
                for (Row row : rsAlerts) {
                    String payload = row.getString("payload");
                    Alert alert = (Alert)JsonUtil.fromJson((String)payload, Alert.class, (boolean)thin);
                    alerts.add(alert);
                }
            } else {
                PreparedStatement selectAlertsByTenantAndAlert = CassStatement.get(this.session, CassStatement.SELECT_ALERT);
                List futures = alertIds.stream().map(alertId -> this.session.executeAsync((Statement)selectAlertsByTenantAndAlert.bind(new Object[]{tenantId, alertId}))).collect(Collectors.toList());
                List rsAlerts = (List)Futures.allAsList(futures).get();
                rsAlerts.stream().forEach(r -> {
                    for (Row row : r) {
                        String payload = row.getString("payload");
                        Alert alert = (Alert)JsonUtil.fromJson((String)payload, Alert.class, (boolean)thin);
                        alerts.add(alert);
                    }
                });
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return this.preparePage(alerts, pager);
    }

    private Page<Alert> preparePage(List<Alert> alerts, Pager pager) {
        if (pager != null) {
            if (pager.getOrder() != null && !pager.getOrder().isEmpty() && ((Order)pager.getOrder().get(0)).getField() == null) {
                pager = Pager.builder().withPageSize(pager.getPageSize()).withStartPage(pager.getPageNumber()).orderBy(AlertComparator.Field.ALERT_ID.getText(), Order.Direction.DESCENDING).build();
            }
            List<Alert> ordered = alerts;
            if (pager.getOrder() != null) {
                pager.getOrder().stream().filter(o -> o.getField() != null && o.getDirection() != null).forEach(o -> {
                    AlertComparator comparator = new AlertComparator(AlertComparator.Field.getField((String)o.getField()), o.getDirection());
                    Collections.sort(ordered, comparator);
                });
            }
            if (!pager.isLimited() || ordered.size() < pager.getStart()) {
                pager = new Pager(0, ordered.size(), (Iterable)pager.getOrder());
                return new Page(ordered, (PageContext)pager, (long)ordered.size());
            }
            if (pager.getEnd() >= ordered.size()) {
                return new Page(ordered.subList(pager.getStart(), ordered.size()), (PageContext)pager, (long)ordered.size());
            }
            return new Page(ordered.subList(pager.getStart(), pager.getEnd()), (PageContext)pager, (long)ordered.size());
        }
        pager = Pager.builder().withPageSize(alerts.size()).orderBy(AlertComparator.Field.ALERT_ID.getText(), Order.Direction.ASCENDING).build();
        return new Page(alerts, (PageContext)pager, (long)alerts.size());
    }

    private boolean extractTriggerIds(Set<String> triggerIds, AlertsCriteria criteria) throws Exception {
        boolean hasTags;
        boolean hasTriggerId = !this.isEmpty(criteria.getTriggerId());
        boolean hasTriggerIds = !this.isEmpty(criteria.getTriggerIds());
        boolean hasTag = null != criteria.getTag();
        boolean bl = hasTags = !this.isEmpty(criteria.getTags());
        if (!hasTriggerIds) {
            if (hasTriggerId) {
                triggerIds.add(criteria.getTriggerId());
            }
        } else {
            for (String triggerId : criteria.getTriggerIds()) {
                if (this.isEmpty(triggerId)) continue;
                triggerIds.add(triggerId);
            }
        }
        if (hasTag || hasTags) {
            HashSet<Tag> tags = new HashSet<Tag>();
            if (hasTags) {
                tags.addAll(criteria.getTags());
            }
            if (hasTag) {
                tags.add(criteria.getTag());
            }
            triggerIds.addAll(this.getTriggersIdByTags(tags));
        }
        return hasTriggerId || hasTriggerIds || hasTag || hasTags;
    }

    private boolean filterByTriggers(String tenantId, Set<String> alertsId, AlertsCriteria criteria) throws Exception {
        HashSet<String> triggerIds = new HashSet<String>();
        boolean filterByTriggers = this.extractTriggerIds(triggerIds, criteria);
        if (triggerIds.size() > 0) {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            PreparedStatement selectAlertsTriggers = CassStatement.get(this.session, CassStatement.SELECT_ALERTS_TRIGGERS);
            for (String triggerId : triggerIds) {
                if (this.isEmpty(triggerId)) continue;
                futures.add(this.session.executeAsync((Statement)selectAlertsTriggers.bind(new Object[]{tenantId, triggerId})));
            }
            List rsAlertIdsByTriggerIds = (List)Futures.allAsList(futures).get();
            rsAlertIdsByTriggerIds.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertsId.add(alertId);
                }
            });
            if (alertsId.isEmpty()) {
                alertsId.add("no-result-fake-alert-id");
            }
        }
        return filterByTriggers;
    }

    private boolean filterByCtime(String tenantId, Set<String> alertsId, AlertsCriteria criteria) throws Exception {
        boolean filterByCtime = false;
        if (criteria.getStartTime() != null || criteria.getEndTime() != null) {
            BoundStatement boundCtime;
            filterByCtime = true;
            if (criteria.getStartTime() != null && criteria.getEndTime() != null) {
                PreparedStatement selectAlertCTimeStartEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_CTIME_START_END);
                boundCtime = selectAlertCTimeStartEnd.bind(new Object[]{tenantId, criteria.getStartTime(), criteria.getEndTime()});
            } else if (criteria.getStartTime() != null) {
                PreparedStatement selectAlertCTimeStart = CassStatement.get(this.session, CassStatement.SELECT_ALERT_CTIME_START);
                boundCtime = selectAlertCTimeStart.bind(new Object[]{tenantId, criteria.getStartTime()});
            } else {
                PreparedStatement selectAlertCTimeEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_CTIME_END);
                boundCtime = selectAlertCTimeEnd.bind(new Object[]{tenantId, criteria.getEndTime()});
            }
            ResultSet rsAlertsCtimes = this.session.execute((Statement)boundCtime);
            if (rsAlertsCtimes.isExhausted()) {
                alertsId.add("no-result-fake-alert-id");
            } else {
                for (Row row : rsAlertsCtimes) {
                    String alertId = row.getString("alertId");
                    alertsId.add(alertId);
                }
            }
        }
        return filterByCtime;
    }

    private boolean filterByStatuses(String tenantId, Set<String> alertsId, AlertsCriteria criteria) throws Exception {
        boolean filterByStatus = false;
        HashSet<Alert.Status> statuses = new HashSet<Alert.Status>();
        if (this.isEmpty(criteria.getStatusSet())) {
            if (criteria.getStatus() != null) {
                statuses.add(criteria.getStatus());
            }
        } else {
            statuses.addAll(criteria.getStatusSet());
        }
        if (statuses.size() > 0) {
            filterByStatus = true;
            PreparedStatement selectAlertStatusByTenantAndStatus = CassStatement.get(this.session, CassStatement.SELECT_ALERT_STATUS_BY_TENANT_AND_STATUS);
            List futures = statuses.stream().map(status -> this.session.executeAsync((Statement)selectAlertStatusByTenantAndStatus.bind(new Object[]{tenantId, status.name()}))).collect(Collectors.toList());
            List rsAlertStatuses = (List)Futures.allAsList(futures).get();
            rsAlertStatuses.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertsId.add(alertId);
                }
            });
            if (alertsId.isEmpty()) {
                alertsId.add("no-result-fake-alert-id");
            }
        }
        return filterByStatus;
    }

    private boolean filterBySeverities(String tenantId, Set<String> alertsId, AlertsCriteria criteria) throws Exception {
        boolean filterBySeverity = false;
        HashSet<Severity> severities = new HashSet<Severity>();
        if (this.isEmpty(criteria.getSeverities())) {
            if (criteria.getSeverity() != null) {
                severities.add(criteria.getSeverity());
            }
        } else {
            severities.addAll(criteria.getSeverities());
        }
        if (severities.size() > 0) {
            filterBySeverity = true;
            PreparedStatement selectAlertSeverityByTenantAndSeverity = CassStatement.get(this.session, CassStatement.SELECT_ALERT_SEVERITY_BY_TENANT_AND_SEVERITY);
            List futures = severities.stream().map(severity -> this.session.executeAsync((Statement)selectAlertSeverityByTenantAndSeverity.bind(new Object[]{tenantId, severity.name()}))).collect(Collectors.toList());
            List rsAlertSeverities = (List)Futures.allAsList(futures).get();
            rsAlertSeverities.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertsId.add(alertId);
                }
            });
            if (alertsId.isEmpty()) {
                alertsId.add("no-result-fake-alert-id");
            }
        }
        return filterBySeverity;
    }

    private boolean filterByAlerts(Set<String> alertsId, AlertsCriteria criteria) {
        boolean filterByAlerts = false;
        if (this.isEmpty(criteria.getAlertIds())) {
            if (!this.isEmpty(criteria.getAlertId())) {
                filterByAlerts = true;
                alertsId.add(criteria.getAlertId());
            }
        } else {
            filterByAlerts = true;
            alertsId.addAll(criteria.getAlertIds());
        }
        return filterByAlerts;
    }

    private Collection<String> getTriggersIdByTags(Collection<Tag> tags) throws Exception {
        HashSet<String> triggerIds = new HashSet<String>();
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        PreparedStatement selectTagsTriggersByCategoryAndName = CassStatement.get(this.session, CassStatement.SELECT_TAGS_TRIGGERS_BY_CATEGORY_AND_NAME);
        PreparedStatement selectTagsTriggersByCategory = CassStatement.get(this.session, CassStatement.SELECT_TAGS_TRIGGERS_BY_CATEGORY);
        PreparedStatement selectTagsTriggersByName = CassStatement.get(this.session, CassStatement.SELECT_TAGS_TRIGGERS_BY_NAME);
        for (Tag tag : tags) {
            if (tag.getCategory() == null && tag.getName() == null) continue;
            BoundStatement boundTag = !this.isEmpty(tag.getCategory()) && !this.isEmpty(tag.getName()) ? selectTagsTriggersByCategoryAndName.bind(new Object[]{tag.getTenantId(), tag.getCategory(), tag.getName()}) : (!this.isEmpty(tag.getCategory()) ? selectTagsTriggersByCategory.bind(new Object[]{tag.getTenantId(), tag.getCategory()}) : selectTagsTriggersByName.bind(new Object[]{tag.getTenantId(), tag.getName()}));
            futures.add(this.session.executeAsync((Statement)boundTag));
        }
        List rsTriggers = (List)Futures.allAsList(futures).get();
        rsTriggers.stream().forEach(r -> {
            for (Row row : r) {
                Set triggers = row.getSet("triggers", String.class);
                triggerIds.addAll(triggers);
            }
        });
        return triggerIds;
    }

    public void ackAlerts(String tenantId, Collection<String> alertIds, String ackBy, String ackNotes) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> alertsToAck = this.getAlerts(tenantId, criteria, null);
        for (Alert a : alertsToAck) {
            a.setStatus(Alert.Status.ACKNOWLEDGED);
            a.setAckBy(ackBy);
            a.setAckTime(System.currentTimeMillis());
            a.setAckNotes(ackNotes);
            this.updateAlertStatus(a);
            this.sendAction(a);
        }
    }

    public int deleteAlerts(String tenantId, AlertsCriteria criteria) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (null == criteria) {
            throw new IllegalArgumentException("Criteria must be not null");
        }
        criteria.setThin(true);
        Page<Alert> alertsToDelete = this.getAlerts(tenantId, criteria, null);
        if (alertsToDelete.isEmpty()) {
            return 0;
        }
        PreparedStatement deleteAlert = CassStatement.get(this.session, CassStatement.DELETE_ALERT);
        PreparedStatement deleteAlertCtime = CassStatement.get(this.session, CassStatement.DELETE_ALERT_CTIME);
        PreparedStatement deleteAlertSeverity = CassStatement.get(this.session, CassStatement.DELETE_ALERT_SEVERITY);
        PreparedStatement deleteAlertStatus = CassStatement.get(this.session, CassStatement.DELETE_ALERT_STATUS);
        PreparedStatement deleteAlertTrigger = CassStatement.get(this.session, CassStatement.DELETE_ALERT_TRIGGER);
        if (deleteAlert == null || deleteAlertCtime == null || deleteAlertSeverity == null || deleteAlertStatus == null || deleteAlertTrigger == null) {
            throw new RuntimeException("delete*Alerts PreparedStatement is null");
        }
        for (Alert a : alertsToDelete) {
            String id = a.getAlertId();
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)deleteAlert.bind(new Object[]{tenantId, id})));
            futures.add(this.session.executeAsync((Statement)deleteAlertCtime.bind(new Object[]{tenantId, a.getCtime(), id})));
            futures.add(this.session.executeAsync((Statement)deleteAlertSeverity.bind(new Object[]{tenantId, a.getSeverity().name(), id})));
            futures.add(this.session.executeAsync((Statement)deleteAlertStatus.bind(new Object[]{tenantId, a.getStatus().name(), id})));
            futures.add(this.session.executeAsync((Statement)deleteAlertTrigger.bind(new Object[]{tenantId, a.getTriggerId(), id})));
            Futures.allAsList(futures).get();
        }
        return alertsToDelete.size();
    }

    public void resolveAlerts(String tenantId, Collection<String> alertIds, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> alertsToResolve = this.getAlerts(tenantId, criteria, null);
        for (Alert a2 : alertsToResolve) {
            a2.setStatus(Alert.Status.RESOLVED);
            a2.setResolvedBy(resolvedBy);
            a2.setResolvedTime(System.currentTimeMillis());
            a2.setResolvedNotes(resolvedNotes);
            a2.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a2);
            this.sendAction(a2);
        }
        Set triggerIds = alertsToResolve.stream().map(a -> a.getTriggerId()).collect(Collectors.toSet());
        triggerIds.stream().forEach(tid -> this.handleResolveOptions(tenantId, (String)tid, true));
    }

    public void resolveAlertsForTrigger(String tenantId, String triggerId, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setTriggerId(triggerId);
        criteria.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
        Page<Alert> alertsToResolve = this.getAlerts(tenantId, criteria, null);
        for (Alert a : alertsToResolve) {
            a.setStatus(Alert.Status.RESOLVED);
            a.setResolvedBy(resolvedBy);
            a.setResolvedTime(System.currentTimeMillis());
            a.setResolvedNotes(resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a);
            this.sendAction(a);
        }
        this.handleResolveOptions(tenantId, triggerId, false);
    }

    private Alert updateAlertStatus(Alert alert) throws Exception {
        if (alert == null || alert.getAlertId() == null || alert.getAlertId().isEmpty()) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        this.session = CassCluster.getSession();
        try {
            PreparedStatement selectAlertStatus = CassStatement.get(this.session, CassStatement.SELECT_ALERT_STATUS);
            PreparedStatement insertAlertStatus = CassStatement.get(this.session, CassStatement.INSERT_ALERT_STATUS);
            PreparedStatement deleteAlertStatus = CassStatement.get(this.session, CassStatement.DELETE_ALERT_STATUS);
            PreparedStatement updateAlert = CassStatement.get(this.session, CassStatement.UPDATE_ALERT);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)selectAlertStatus.bind(new Object[]{alert.getTenantId(), Alert.Status.OPEN.name(), alert.getAlertId()})));
            futures.add(this.session.executeAsync((Statement)selectAlertStatus.bind(new Object[]{alert.getTenantId(), Alert.Status.ACKNOWLEDGED.name(), alert.getAlertId()})));
            futures.add(this.session.executeAsync((Statement)selectAlertStatus.bind(new Object[]{alert.getTenantId(), Alert.Status.RESOLVED.name(), alert.getAlertId()})));
            List rsAlertsStatusToDelete = (List)Futures.allAsList(futures).get();
            rsAlertsStatusToDelete.stream().forEach(r -> {
                for (Row row : r) {
                    String alertIdToDelete = row.getString("alertId");
                    String statusToDelete = row.getString("status");
                    this.session.execute((Statement)deleteAlertStatus.bind(new Object[]{alert.getTenantId(), statusToDelete, alertIdToDelete}));
                }
            });
            this.session.execute((Statement)insertAlertStatus.bind(new Object[]{alert.getTenantId(), alert.getAlertId(), alert.getStatus().name()}));
            this.session.execute((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)alert), alert.getTenantId(), alert.getAlertId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alert;
    }

    private void handleResolveOptions(String tenantId, String triggerId, boolean checkIfAllResolved) {
        try {
            Trigger loadedTrigger;
            Trigger trigger = this.definitionsService.getTrigger(tenantId, triggerId);
            if (null == trigger) {
                return;
            }
            boolean setEnabled = trigger.isAutoEnable() && !trigger.isEnabled();
            boolean setFiring = trigger.isAutoResolve();
            if (setFiring && null != (loadedTrigger = this.alertsEngine.getLoadedTrigger(trigger)) && Mode.FIRING == loadedTrigger.getMode()) {
                this.log.debugf("Ignoring setFiring, loaded Trigger already in firing mode %s", (Object)loadedTrigger);
                setFiring = false;
            }
            if (!setEnabled && !setFiring) {
                return;
            }
            boolean allResolved = true;
            if (checkIfAllResolved) {
                AlertsCriteria ac = new AlertsCriteria();
                ac.setTriggerId(triggerId);
                ac.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
                Page<Alert> unresolvedAlerts = this.getAlerts(tenantId, ac, new Pager(0, 1, new Order[]{Order.unspecified()}));
                allResolved = unresolvedAlerts.isEmpty();
            }
            if (!allResolved) {
                this.log.debugf("Ignoring resolveOptions, not all Alerts for Trigger %s are resolved", (Object)trigger);
                return;
            }
            if (setEnabled) {
                trigger.setEnabled(true);
                this.definitionsService.updateTrigger(tenantId, trigger);
            } else {
                this.alertsEngine.reloadTrigger(tenantId, triggerId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
        }
    }

    public void sendData(Data data) throws Exception {
        this.alertsEngine.sendData(data);
    }

    public void sendData(Collection<Data> data) throws Exception {
        this.alertsEngine.sendData(data);
    }

    private void sendAction(Alert a) {
        if (this.actionsService != null && a != null && a.getTrigger() != null && a.getTrigger().getActions() != null) {
            Map actions = a.getTrigger().getActions();
            for (String actionPlugin : actions.keySet()) {
                for (String actionId : (Set)actions.get(actionPlugin)) {
                    Action action = new Action(a.getTrigger().getTenantId(), actionPlugin, actionId, a);
                    this.actionsService.send(action);
                }
            }
        }
    }

    private boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }
}

