/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.EventCondition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.condition.RateCondition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.event.EventType;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.PageContext;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.model.paging.TriggerComparator;
import org.hawkular.alerts.api.model.trigger.Match;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.TriggersCriteria;
import org.hawkular.alerts.engine.exception.NotFoundApplicationException;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.impl.CassStatement;
import org.hawkular.alerts.engine.impl.TagType;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.jboss.logging.Logger;

@Local(value={DefinitionsService.class})
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CassDefinitionsServiceImpl
implements DefinitionsService {
    public static final String SKIP_INIT_DATA = "hawkular-alerts.skip-init-data";
    private static final String JBOSS_DATA_DIR = "jboss.server.data.dir";
    private static final String INIT_FOLDER = "hawkular-alerts";
    private static final String CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassDefinitionsServiceImpl.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private Session session;
    private String keyspace;
    private boolean initialized = false;
    private Map<DefinitionsListener, Set<DefinitionsEvent.Type>> listeners = new HashMap<DefinitionsListener, Set<DefinitionsEvent.Type>>();
    @EJB
    AlertsEngine alertsEngine;

    public AlertsEngine getAlertsEngine() {
        return this.alertsEngine;
    }

    public void setAlertsEngine(AlertsEngine alertsEngine) {
        this.alertsEngine = alertsEngine;
    }

    @PostConstruct
    public void init() {
        try {
            if (this.keyspace == null) {
                this.keyspace = AlertProperties.getProperty(CASSANDRA_KEYSPACE, "hawkular_alerts");
            }
            this.session = CassCluster.getSession();
            this.initialData();
        }
        catch (Throwable t) {
            this.msgLog.errorCannotInitializeDefinitionsService(t.getMessage());
            t.printStackTrace();
        }
    }

    @PreDestroy
    public void shutdown() {
        CassCluster.shutdown();
    }

    private void initialData() throws IOException {
        if (!System.getProperties().containsKey(SKIP_INIT_DATA)) {
            String data = System.getProperty(JBOSS_DATA_DIR);
            if (data == null || data.isEmpty()) {
                this.msgLog.errorFolderNotFound(data);
                return;
            }
            String folder = data + "/" + INIT_FOLDER;
            this.initFiles(folder);
        }
        this.initialized = true;
    }

    private void initFiles(String folder) {
        if (folder == null) {
            this.msgLog.errorFolderMustBeNotNull();
            return;
        }
        File fFolder = new File(folder);
        if (!fFolder.exists()) {
            this.log.debug((Object)"Data folder doesn't exits. Skipping initialization.");
            return;
        }
        try {
            this.initTriggers(fFolder);
            this.initConditions(fFolder);
            this.initDampenings(fFolder);
            this.initActions(fFolder);
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            this.msgLog.errorDatabaseException("Error initializing files. Msg: " + e);
        }
    }

    private void initTriggers(File fFolder) throws Exception {
        File triggersFile = new File(fFolder, "triggers-data.json");
        if (triggersFile.exists() && triggersFile.isFile()) {
            Map triggers = (Map)this.objectMapper.readValue(triggersFile, Map.class);
            if (triggers != null && !triggers.isEmpty() && triggers.get("triggers") != null) {
                List aTriggers = (List)triggers.get("triggers");
                for (Map t : aTriggers) {
                    String tenantId = (String)t.get("tenantId");
                    String triggerId = (String)t.get("triggerId");
                    String eventTypeName = (String)t.get("eventType");
                    EventType eventType = null != eventTypeName ? EventType.valueOf((String)eventTypeName) : EventType.ALERT;
                    boolean enabled = (Boolean)t.get("enabled");
                    String name = (String)t.get("name");
                    String description = (String)t.get("description");
                    boolean autoDisable = (Boolean)t.get("autoDisable");
                    boolean autoEnable = (Boolean)t.get("autoEnable");
                    boolean autoResolve = (Boolean)t.get("autoResolve");
                    boolean autoResolveAlerts = (Boolean)t.get("autoResolveAlerts");
                    Severity severity = Severity.valueOf((String)((String)t.get("severity")));
                    Match firingMatch = Match.valueOf((String)((String)t.get("firingMatch")));
                    Match autoResolveMatch = Match.valueOf((String)((String)t.get("autoResolveMatch")));
                    List actions = (List)t.get("actions");
                    Map context = (Map)t.get("context");
                    Map tags = (Map)t.get("tags");
                    boolean group = (Boolean)t.get("group");
                    String memberOf = (String)t.get("memberOf");
                    boolean orphan = (Boolean)t.get("orphan");
                    Trigger trigger = new Trigger(tenantId, triggerId, name);
                    trigger.setEventType(eventType);
                    trigger.setEnabled(enabled);
                    trigger.setAutoDisable(autoDisable);
                    trigger.setAutoEnable(autoEnable);
                    trigger.setAutoResolve(autoResolve);
                    trigger.setAutoResolveAlerts(autoResolveAlerts);
                    trigger.setSeverity(severity);
                    trigger.setDescription(description);
                    trigger.setFiringMatch(firingMatch);
                    trigger.setAutoResolveMatch(autoResolveMatch);
                    for (Map action : actions) {
                        trigger.addAction((String)action.get("actionPlugin"), (String)action.get("actionId"));
                    }
                    trigger.setContext(context);
                    trigger.setTags(tags);
                    trigger.setGroup(group);
                    trigger.setMemberOf(memberOf);
                    trigger.setOrphan(orphan);
                    this.addTrigger(trigger);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Init registration - Inserting [" + trigger + "]"));
                }
            }
        } else {
            this.msgLog.warningFileNotFound("triggers-data.json");
        }
    }

    private void initConditions(File initFolder) throws Exception {
        File conditionsFile = new File(initFolder, "conditions-data.json");
        if (conditionsFile.exists() && conditionsFile.isFile()) {
            Map conditions = (Map)this.objectMapper.readValue(conditionsFile, Map.class);
            if (conditions != null && !conditions.isEmpty() && conditions.get("conditions") != null) {
                List aConditions = (List)conditions.get("conditions");
                for (Map c : aConditions) {
                    CompareCondition newCondition;
                    String operator;
                    String dataId;
                    String tenantId = (String)c.get("tenantId");
                    String triggerId = (String)c.get("triggerId");
                    Mode triggerMode = Mode.valueOf((String)((String)c.get("triggerMode")));
                    int conditionSetSize = (Integer)c.get("conditionSetSize");
                    int conditionSetIndex = (Integer)c.get("conditionSetIndex");
                    String type = (String)c.get("type");
                    Map context = (Map)c.get("context");
                    if (type != null && !type.isEmpty() && type.equals("threshold")) {
                        dataId = (String)c.get("dataId");
                        operator = (String)c.get("operator");
                        Double threshold = (Double)c.get("threshold");
                        ThresholdCondition newCondition2 = new ThresholdCondition();
                        newCondition2.setTriggerId(triggerId);
                        newCondition2.setTriggerMode(triggerMode);
                        newCondition2.setConditionSetSize(conditionSetSize);
                        newCondition2.setConditionSetIndex(conditionSetIndex);
                        newCondition2.setDataId(dataId);
                        newCondition2.setOperator(ThresholdCondition.Operator.valueOf((String)operator));
                        newCondition2.setThreshold(threshold);
                        newCondition2.setTenantId(tenantId);
                        newCondition2.setContext(context);
                        this.initCondition((Condition)newCondition2);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Init registration - Inserting [" + newCondition2 + "]"));
                        }
                    }
                    if (type != null && !type.isEmpty() && type.equals("range")) {
                        dataId = (String)c.get("dataId");
                        String operatorLow = (String)c.get("operatorLow");
                        String operatorHigh = (String)c.get("operatorHigh");
                        Double thresholdLow = (Double)c.get("thresholdLow");
                        Double thresholdHigh = (Double)c.get("thresholdHigh");
                        boolean inRange = (Boolean)c.get("inRange");
                        ThresholdRangeCondition newCondition3 = new ThresholdRangeCondition();
                        newCondition3.setTriggerId(triggerId);
                        newCondition3.setTriggerMode(triggerMode);
                        newCondition3.setConditionSetSize(conditionSetSize);
                        newCondition3.setConditionSetIndex(conditionSetIndex);
                        newCondition3.setDataId(dataId);
                        newCondition3.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)operatorLow));
                        newCondition3.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)operatorHigh));
                        newCondition3.setThresholdLow(thresholdLow);
                        newCondition3.setThresholdHigh(thresholdHigh);
                        newCondition3.setInRange(inRange);
                        newCondition3.setTenantId(tenantId);
                        newCondition3.setContext(context);
                        this.initCondition((Condition)newCondition3);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Init registration - Inserting [" + newCondition3 + "]"));
                        }
                    }
                    if (type != null && !type.isEmpty() && type.equals("compare")) {
                        dataId = (String)c.get("dataId");
                        operator = (String)c.get("operator");
                        Double data2Multiplier = (Double)c.get("data2Multiplier");
                        String data2Id = (String)c.get("data2Id");
                        newCondition = new CompareCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(CompareCondition.Operator.valueOf((String)operator));
                        newCondition.setData2Multiplier(data2Multiplier);
                        newCondition.setData2Id(data2Id);
                        newCondition.setTenantId(tenantId);
                        newCondition.setContext(context);
                        this.initCondition((Condition)newCondition);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Init registration - Inserting [" + newCondition + "]"));
                        }
                    }
                    if (type != null && !type.isEmpty() && type.equals("string")) {
                        dataId = (String)c.get("dataId");
                        operator = (String)c.get("operator");
                        String pattern = (String)c.get("pattern");
                        boolean ignoreCase = (Boolean)c.get("ignoreCase");
                        newCondition = new StringCondition();
                        newCondition.setTriggerId(triggerId);
                        newCondition.setTriggerMode(triggerMode);
                        newCondition.setConditionSetSize(conditionSetSize);
                        newCondition.setConditionSetIndex(conditionSetIndex);
                        newCondition.setDataId(dataId);
                        newCondition.setOperator(StringCondition.Operator.valueOf((String)operator));
                        newCondition.setPattern(pattern);
                        newCondition.setIgnoreCase(ignoreCase);
                        newCondition.setTenantId(tenantId);
                        newCondition.setContext(context);
                        this.initCondition((Condition)newCondition);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Init registration - Inserting [" + newCondition + "]"));
                        }
                    }
                    if (type == null || type.isEmpty() || !type.equals("availability")) continue;
                    dataId = (String)c.get("dataId");
                    operator = (String)c.get("operator");
                    AvailabilityCondition newCondition4 = new AvailabilityCondition();
                    newCondition4.setTriggerId(triggerId);
                    newCondition4.setTriggerMode(triggerMode);
                    newCondition4.setConditionSetSize(conditionSetSize);
                    newCondition4.setConditionSetIndex(conditionSetIndex);
                    newCondition4.setDataId(dataId);
                    newCondition4.setOperator(AvailabilityCondition.Operator.valueOf((String)operator));
                    newCondition4.setTenantId(tenantId);
                    newCondition4.setContext(context);
                    this.initCondition((Condition)newCondition4);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Init registration - Inserting [" + newCondition4 + "]"));
                }
            }
        } else {
            this.msgLog.warningFileNotFound("conditions-data.json");
        }
    }

    private void initCondition(Condition condition) throws Exception {
        Collection<Condition> conditions = this.getTriggerConditions(condition.getTenantId(), condition.getTriggerId(), condition.getTriggerMode());
        conditions.add(condition);
        this.setConditions(condition.getTenantId(), condition.getTriggerId(), condition.getTriggerMode(), conditions);
    }

    private void initDampenings(File initFolder) throws Exception {
        File dampeningFile = new File(initFolder, "dampening-data.json");
        if (dampeningFile.exists() && dampeningFile.isFile()) {
            Map dampenings = (Map)this.objectMapper.readValue(dampeningFile, Map.class);
            if (dampenings != null && !dampenings.isEmpty() && dampenings.get("dampenings") != null) {
                List aDampenings = (List)dampenings.get("dampenings");
                for (Map d : aDampenings) {
                    String tenantId = (String)d.get("tenantId");
                    String triggerId = (String)d.get("triggerId");
                    Mode triggerMode = Mode.valueOf((String)((String)d.get("triggerMode")));
                    String type = (String)d.get("type");
                    int evalTrueSetting = (Integer)d.get("evalTrueSetting");
                    int evalTotalSetting = (Integer)d.get("evalTotalSetting");
                    long evalTimeSetting = ((Integer)d.get("evalTimeSetting")).intValue();
                    Dampening newDampening = new Dampening(triggerId, triggerMode, Dampening.Type.valueOf((String)type), evalTrueSetting, evalTotalSetting, evalTimeSetting);
                    newDampening.setTenantId(tenantId);
                    this.addDampening(newDampening);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Init registration - Inserting [" + newDampening + "]"));
                }
            }
        } else {
            this.msgLog.warningFileNotFound("dampening-data.json");
        }
    }

    private void initActions(File initFolder) throws Exception {
        File actionsFile = new File(initFolder, "actions-data.json");
        if (actionsFile.exists() && actionsFile.isFile()) {
            Map actions = (Map)this.objectMapper.readValue(actionsFile, Map.class);
            if (actions != null && !actions.isEmpty() && actions.get("actions") != null) {
                List aActions = (List)actions.get("actions");
                for (Map a : aActions) {
                    HashMap<String, String> newAction = new HashMap<String, String>();
                    String tenantId = (String)a.get("tenantId");
                    newAction.put("tenantId", tenantId);
                    String actionPlugin = (String)a.get("actionPlugin");
                    newAction.put("actionPlugin", actionPlugin);
                    String actionId = (String)a.get("actionId");
                    newAction.put("actionId", actionId);
                    Map properties = (Map)a.get("properties");
                    newAction.putAll(properties);
                    this.addAction(tenantId, actionPlugin, actionId, newAction);
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Init registration - Inserting [" + newAction + "]"));
                }
            }
        } else {
            this.msgLog.warningFileNotFound("actions-data.json");
        }
    }

    public void addAction(String tenantId, String actionPlugin, String actionId, Map<String, String> properties) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        properties.put("actionId", actionId);
        properties.put("actionPlugin", actionPlugin);
        properties.put("tenantId", tenantId);
        this.session = CassCluster.getSession();
        PreparedStatement insertAction = CassStatement.get(this.session, CassStatement.INSERT_ACTION);
        if (insertAction == null) {
            throw new RuntimeException("insertAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertAction.bind(new Object[]{tenantId, actionPlugin, actionId, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addTrigger(String tenantId, Trigger trigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(trigger)) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        this.checkTenantId(tenantId, trigger);
        trigger.setGroup(false);
        this.addTrigger(trigger);
    }

    public void addGroupTrigger(String tenantId, Trigger groupTrigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupTrigger)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, groupTrigger);
        groupTrigger.setGroup(true);
        this.addTrigger(groupTrigger);
    }

    private void addTrigger(Trigger trigger) throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement insertTrigger = CassStatement.get(this.session, CassStatement.INSERT_TRIGGER);
        if (insertTrigger == null) {
            throw new RuntimeException("insertTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertTrigger.bind(new Object[]{trigger.getTenantId(), trigger.getId(), trigger.isAutoDisable(), trigger.isAutoEnable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getAutoResolveMatch().name(), trigger.getContext(), trigger.getDescription(), trigger.isEnabled(), trigger.getEventCategory(), trigger.getEventText(), trigger.getEventType(), trigger.getFiringMatch().name(), trigger.isGroup(), trigger.getMemberOf(), trigger.getName(), trigger.isOrphan(), trigger.getSeverity().name(), trigger.getTags()}));
            this.insertTriggerActions(trigger);
            this.insertTags(trigger.getTenantId(), TagType.TRIGGER, trigger.getId(), trigger.getTags());
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.addTrigger(trigger.getTenantId(), trigger.getId());
        }
        this.notifyListeners(DefinitionsEvent.Type.TRIGGER_CREATE);
    }

    private void insertTriggerActions(Trigger trigger) throws Exception {
        PreparedStatement insertTriggerActions = CassStatement.get(this.session, CassStatement.INSERT_TRIGGER_ACTIONS);
        if (insertTriggerActions == null) {
            throw new RuntimeException("insertTriggerActions PreparedStatement is null");
        }
        if (trigger.getActions() != null) {
            List futures = trigger.getActions().keySet().stream().filter(actionPlugin -> trigger.getActions().get(actionPlugin) != null && !((Set)trigger.getActions().get(actionPlugin)).isEmpty()).map(actionPlugin -> this.session.executeAsync((Statement)insertTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId(), actionPlugin, trigger.getActions().get(actionPlugin)}))).collect(Collectors.toList());
            Futures.allAsList(futures).get();
        }
    }

    public void removeTrigger(String tenantId, String triggerId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger doomedTrigger = this.getTrigger(tenantId, triggerId);
        if (null == doomedTrigger) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, triggerId);
        }
        if (doomedTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (doomedTrigger.isMember()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be removed via the group.");
        }
        this.removeTrigger(doomedTrigger);
    }

    public void removeGroupTrigger(String tenantId, String groupId, boolean keepNonOrphans, boolean keepOrphans) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupId)) {
            throw new IllegalArgumentException("GroupId must be not null");
        }
        Trigger doomedTrigger = this.getTrigger(tenantId, groupId);
        if (null == doomedTrigger) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, groupId);
        }
        if (!doomedTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger");
        }
        Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, true);
        for (Trigger member : memberTriggers) {
            if (keepNonOrphans && !member.isOrphan() || keepOrphans && member.isOrphan()) {
                member.setMemberOf(null);
                member.setOrphan(false);
                this.updateTrigger(member, member.getActions(), member.getTags());
                continue;
            }
            this.removeTrigger(member);
        }
        this.removeTrigger(doomedTrigger);
    }

    private void removeTrigger(Trigger trigger) throws Exception {
        this.session = CassCluster.getSession();
        String tenantId = trigger.getTenantId();
        String triggerId = trigger.getId();
        PreparedStatement deleteDampenings = CassStatement.get(this.session, CassStatement.DELETE_DAMPENINGS);
        PreparedStatement deleteConditions = CassStatement.get(this.session, CassStatement.DELETE_CONDITIONS);
        PreparedStatement deleteActions = CassStatement.get(this.session, CassStatement.DELETE_TRIGGER_ACTIONS);
        PreparedStatement deleteTrigger = CassStatement.get(this.session, CassStatement.DELETE_TRIGGER);
        this.session.execute((Statement)deleteActions.bind(new Object[]{trigger.getTenantId(), trigger.getId()}));
        if (deleteDampenings == null || deleteConditions == null || deleteActions == null || deleteTrigger == null) {
            throw new RuntimeException("delete*Triggers PreparedStatement is null");
        }
        try {
            this.deleteTags(tenantId, TagType.TRIGGER, triggerId, trigger.getTags());
            this.deleteTriggerActions(tenantId, triggerId);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)deleteDampenings.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)deleteConditions.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)deleteActions.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)deleteTrigger.bind(new Object[]{tenantId, triggerId})));
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.removeTrigger(tenantId, triggerId);
        }
        this.notifyListeners(DefinitionsEvent.Type.TRIGGER_REMOVE);
    }

    public Trigger updateTrigger(String tenantId, Trigger trigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(trigger)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, trigger);
        String triggerId = trigger.getId();
        Trigger existingTrigger = this.getTrigger(tenantId, trigger.getId());
        if (null == existingTrigger) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, trigger.getId());
        }
        if (existingTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (existingTrigger.isMember()) {
            if (!existingTrigger.isOrphan()) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be updated via the group.");
            }
            if (!existingTrigger.getMemberOf().equals(trigger.getMemberOf())) {
                throw new IllegalArgumentException("A member trigger can not change groups.");
            }
            if (existingTrigger.isOrphan() != trigger.isOrphan()) {
                throw new IllegalArgumentException("Orphan status can not be changed by this method.");
            }
        }
        return this.updateTrigger(trigger, existingTrigger.getActions(), existingTrigger.getTags());
    }

    public Trigger updateGroupTrigger(String tenantId, Trigger groupTrigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupTrigger)) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        this.checkTenantId(tenantId, groupTrigger);
        String groupId = groupTrigger.getId();
        Trigger existingGroupTrigger = this.getTrigger(tenantId, groupId);
        if (null == existingGroupTrigger) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, groupTrigger.getId());
        }
        if (!existingGroupTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger");
        }
        groupTrigger.setGroup(true);
        Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
        Map existingActions = existingGroupTrigger.getActions();
        Map existingTags = existingGroupTrigger.getTags();
        for (Trigger member : memberTriggers) {
            this.copyGroupTrigger(groupTrigger, member);
            this.updateTrigger(member, existingActions, existingTags);
        }
        return this.updateTrigger(groupTrigger, existingActions, existingTags);
    }

    private Trigger copyGroupTrigger(Trigger group, Trigger member) {
        member.setActions(group.getActions());
        member.setAutoDisable(group.isAutoDisable());
        member.setAutoEnable(group.isAutoEnable());
        member.setAutoResolve(group.isAutoResolve());
        member.setAutoResolveAlerts(group.isAutoResolveAlerts());
        member.setAutoResolveMatch(group.getAutoResolveMatch());
        member.setMemberOf(group.getId());
        member.setContext(group.getContext());
        member.setDescription(group.getDescription());
        member.setEnabled(group.isEnabled());
        member.setFiringMatch(group.getFiringMatch());
        member.setSeverity(group.getSeverity());
        member.setTags(group.getTags());
        member.setEventType(group.getEventType());
        return member;
    }

    private Trigger updateTrigger(Trigger trigger, Map<String, Set<String>> existingActions, Map<String, String> existingTags) throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement updateTrigger = CassStatement.get(this.session, CassStatement.UPDATE_TRIGGER);
        if (updateTrigger == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateTrigger.bind(new Object[]{trigger.isAutoDisable(), trigger.isAutoEnable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getAutoResolveMatch().name(), trigger.getContext(), trigger.getDescription(), trigger.isEnabled(), trigger.getEventCategory(), trigger.getEventText(), trigger.getFiringMatch().name(), trigger.isGroup(), trigger.getMemberOf(), trigger.getName(), trigger.isOrphan(), trigger.getSeverity().name(), trigger.getTags(), trigger.getTenantId(), trigger.getId()}));
            if (!trigger.getActions().equals(existingActions)) {
                this.deleteTriggerActions(trigger.getTenantId(), trigger.getId());
                this.insertTriggerActions(trigger);
            }
            if (!trigger.getTags().equals(existingTags)) {
                this.deleteTags(trigger.getTenantId(), TagType.TRIGGER, trigger.getId(), existingTags);
                this.insertTags(trigger.getTenantId(), TagType.TRIGGER, trigger.getId(), trigger.getTags());
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(trigger.getTenantId(), trigger.getId());
        }
        this.notifyListeners(DefinitionsEvent.Type.TRIGGER_UPDATE);
        return trigger;
    }

    public Trigger orphanMemberTrigger(String tenantId, String memberId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(memberId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger member = this.getTrigger(tenantId, memberId);
        if (null == member) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, memberId);
        }
        if (!member.isMember()) {
            throw new IllegalArgumentException("Trigger is not a member trigger: [" + tenantId + "/" + memberId + "]");
        }
        if (member.isOrphan()) {
            throw new IllegalArgumentException("Trigger is already an orphan: [" + tenantId + "/" + memberId + "]");
        }
        member.setOrphan(true);
        return this.updateTrigger(member, member.getActions(), member.getTags());
    }

    public Trigger unorphanMemberTrigger(String tenantId, String memberId, Map<String, String> memberContext, Map<String, String> dataIdMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(memberId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger orphanMember = this.getTrigger(tenantId, memberId);
        if (null == orphanMember) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, memberId);
        }
        if (!orphanMember.isMember()) {
            throw new IllegalArgumentException("Trigger is not a member trigger: [" + tenantId + "/" + memberId + "]");
        }
        if (!orphanMember.isOrphan()) {
            throw new IllegalArgumentException("Trigger is not an orphan: [" + tenantId + "/" + memberId + "]");
        }
        String groupId = orphanMember.getMemberOf();
        String memberName = orphanMember.getName();
        this.removeTrigger(orphanMember);
        Trigger member = this.addMemberTrigger(tenantId, groupId, memberId, memberName, memberContext, dataIdMap);
        return member;
    }

    private void deleteTriggerActions(String tenantId, String triggerId) throws Exception {
        PreparedStatement deleteTriggerActions = CassStatement.get(this.session, CassStatement.DELETE_TRIGGER_ACTIONS);
        if (deleteTriggerActions == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        this.session.execute((Statement)deleteTriggerActions.bind(new Object[]{tenantId, triggerId}));
    }

    public Trigger getTrigger(String tenantId, String triggerId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
        if (selectTrigger == null) {
            throw new RuntimeException("selectTrigger PreparedStatement is null");
        }
        Trigger trigger = null;
        try {
            ResultSet rsTrigger = this.session.execute((Statement)selectTrigger.bind(new Object[]{tenantId, triggerId}));
            Iterator itTrigger = rsTrigger.iterator();
            if (itTrigger.hasNext()) {
                Row row = (Row)itTrigger.next();
                trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return trigger;
    }

    public Collection<Trigger> getAllTriggers() throws Exception {
        return this.selectTriggers(null);
    }

    public Page<Trigger> getTriggers(String tenantId, TriggersCriteria criteria, Pager pager) throws Exception {
        boolean thin;
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        this.session = CassCluster.getSession();
        boolean filter = null != criteria && criteria.hasCriteria();
        boolean bl = thin = null != criteria && criteria.isThin();
        if (filter && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getTriggers criteria: " + criteria.toString()));
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        HashSet<String> triggerIds = new HashSet<String>();
        boolean activeFilter = false;
        try {
            if (filter) {
                if (criteria.hasTriggerIdCriteria()) {
                    Set<String> idsFilteredByTriggers = this.filterByTriggers(criteria);
                    if (activeFilter) {
                        triggerIds.retainAll(idsFilteredByTriggers);
                        if (triggerIds.isEmpty()) {
                            return new Page(triggers, (PageContext)pager, 0L);
                        }
                    } else {
                        triggerIds.addAll(idsFilteredByTriggers);
                    }
                    activeFilter = true;
                }
                if (criteria.hasTagCriteria()) {
                    Set<String> idsFilteredByTags = this.getIdsByTags(tenantId, TagType.TRIGGER, criteria.getTags());
                    if (activeFilter) {
                        triggerIds.retainAll(idsFilteredByTags);
                        if (triggerIds.isEmpty()) {
                            return new Page(triggers, (PageContext)pager, 0L);
                        }
                    } else {
                        triggerIds.addAll(idsFilteredByTags);
                    }
                    activeFilter = true;
                }
                PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
                List futures = triggerIds.stream().map(id -> this.session.executeAsync((Statement)selectTrigger.bind(new Object[]{tenantId, id}))).collect(Collectors.toList());
                List rsTriggers = (List)Futures.allAsList(futures).get();
                rsTriggers.stream().forEach(r -> {
                    for (Row row : r) {
                        triggers.add(this.mapTrigger(row));
                    }
                });
            } else {
                triggers.addAll(this.selectTriggers(tenantId));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return this.prepareTriggersPage(triggers, pager);
    }

    private Set<String> filterByTriggers(TriggersCriteria criteria) {
        HashSet<String> result = Collections.EMPTY_SET;
        if (this.isEmpty(criteria.getTriggerIds())) {
            if (!this.isEmpty(criteria.getTriggerId())) {
                result = new HashSet(1);
                result.add(criteria.getTriggerId());
            }
        } else {
            result = new HashSet<String>();
            result.addAll(criteria.getTriggerIds());
        }
        return result;
    }

    private Set<String> getIdsByTags(String tenantId, TagType tagType, Map<String, String> tags) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        PreparedStatement selectTagsByName = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME);
        PreparedStatement selectTagsByNameAndValue = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME_AND_VALUE);
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            boolean nameOnly = "*".equals(tag.getValue());
            BoundStatement bs = nameOnly ? selectTagsByName.bind(new Object[]{tenantId, tagType.name(), tag.getKey()}) : selectTagsByNameAndValue.bind(new Object[]{tenantId, tagType.name(), tag.getKey(), tag.getValue()});
            futures.add(this.session.executeAsync((Statement)bs));
        }
        List rsTags = (List)Futures.allAsList(futures).get();
        rsTags.stream().forEach(r -> {
            for (Row row : r) {
                ids.add(row.getString("id"));
            }
        });
        return ids;
    }

    private Collection<Trigger> selectTriggers(String tenantId) throws Exception {
        PreparedStatement selectTriggers;
        this.session = CassCluster.getSession();
        PreparedStatement preparedStatement = selectTriggers = this.isEmpty(tenantId) ? CassStatement.get(this.session, CassStatement.SELECT_TRIGGERS_ALL) : CassStatement.get(this.session, CassStatement.SELECT_TRIGGERS_TENANT);
        if (null == selectTriggers) {
            throw new RuntimeException("selectTriggersTenant PreparedStatement is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            ResultSet rsTriggers = this.session.execute((Statement)(this.isEmpty(tenantId) ? selectTriggers.bind() : selectTriggers.bind(new Object[]{tenantId})));
            for (Row row : rsTriggers) {
                Trigger trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
                triggers.add(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return triggers;
    }

    private Page<Trigger> prepareTriggersPage(List<Trigger> triggers, Pager pager) {
        if (pager != null) {
            if (pager.getOrder() != null && !pager.getOrder().isEmpty() && ((Order)pager.getOrder().get(0)).getField() == null) {
                pager = Pager.builder().withPageSize(pager.getPageSize()).withStartPage(pager.getPageNumber()).orderBy(TriggerComparator.Field.NAME.getName(), Order.Direction.DESCENDING).build();
            }
            List<Trigger> ordered = triggers;
            if (pager.getOrder() != null) {
                pager.getOrder().stream().filter(o -> o.getField() != null && o.getDirection() != null).forEach(o -> {
                    TriggerComparator comparator = new TriggerComparator(TriggerComparator.Field.getName((String)o.getField()), o.getDirection());
                    Collections.sort(ordered, comparator);
                });
            }
            if (!pager.isLimited() || ordered.size() < pager.getStart()) {
                pager = new Pager(0, ordered.size(), (Iterable)pager.getOrder());
                return new Page(ordered, (PageContext)pager, (long)ordered.size());
            }
            if (pager.getEnd() >= ordered.size()) {
                return new Page(ordered.subList(pager.getStart(), ordered.size()), (PageContext)pager, (long)ordered.size());
            }
            return new Page(ordered.subList(pager.getStart(), pager.getEnd()), (PageContext)pager, (long)ordered.size());
        }
        pager = Pager.builder().withPageSize(triggers.size()).orderBy(TriggerComparator.Field.ID.getName(), Order.Direction.ASCENDING).build();
        return new Page(triggers, (PageContext)pager, (long)triggers.size());
    }

    public Collection<Trigger> getAllTriggersByTag(String name, String value) throws Exception {
        if (this.isEmpty(name)) {
            throw new IllegalArgumentException("name must be not null");
        }
        if (this.isEmpty(value)) {
            throw new IllegalArgumentException("value must be not null (use '*' for all");
        }
        this.session = CassCluster.getSession();
        try {
            PreparedStatement selectTags;
            BoundStatement bs = CassStatement.get(this.session, CassStatement.SELECT_PARTITIONS_TRIGGERS).bind();
            HashSet<String> tenants = new HashSet<String>();
            for (Row row : this.session.execute((Statement)bs)) {
                tenants.add(row.getString("tenantId"));
            }
            boolean nameOnly = "*".equals(value);
            PreparedStatement preparedStatement = selectTags = nameOnly ? CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME) : CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME_AND_VALUE);
            if (selectTags == null) {
                throw new RuntimeException("selectTags PreparedStatement is null");
            }
            HashMap tenantTriggerIdsMap = new HashMap();
            List futures = nameOnly ? tenants.stream().map(tenantId -> this.session.executeAsync((Statement)selectTags.bind(new Object[]{tenantId, TagType.TRIGGER, name}))).collect(Collectors.toList()) : tenants.stream().map(tenantId -> this.session.executeAsync((Statement)selectTags.bind(new Object[]{tenantId, TagType.TRIGGER, name, value}))).collect(Collectors.toList());
            List rsTriggerIds = (List)Futures.allAsList(futures).get();
            rsTriggerIds.stream().forEach(rs -> {
                for (Row row : rs) {
                    String tenantId = row.getString("tenantId");
                    String triggerId = row.getString("id");
                    HashSet<String> storedTriggerIds = (HashSet<String>)tenantTriggerIdsMap.get(tenantId);
                    if (null == storedTriggerIds) {
                        storedTriggerIds = new HashSet<String>();
                    }
                    storedTriggerIds.add(triggerId);
                    tenantTriggerIdsMap.put(tenantId, storedTriggerIds);
                }
            });
            ArrayList<Trigger> triggers = new ArrayList<Trigger>();
            PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
            for (Map.Entry entry : tenantTriggerIdsMap.entrySet()) {
                String tenantId2 = (String)entry.getKey();
                Set triggerIds = (Set)entry.getValue();
                futures = triggerIds.stream().map(triggerId -> this.session.executeAsync((Statement)selectTrigger.bind(new Object[]{tenantId2, triggerId}))).collect(Collectors.toList());
                List rsTriggers = (List)Futures.allAsList(futures).get();
                rsTriggers.stream().forEach(r -> {
                    for (Row row : r) {
                        triggers.add(this.mapTrigger(row));
                    }
                });
            }
            return triggers;
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<Trigger> getMemberTriggers(String tenantId, String groupId, boolean includeOrphans) throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement selectTriggersTenant = CassStatement.get(this.session, CassStatement.SELECT_TRIGGERS_TENANT);
        if (null == selectTriggersTenant) {
            throw new RuntimeException("selectTriggersMemberOf PreparedStatement is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            ResultSet rsTriggers = this.session.execute((Statement)selectTriggersTenant.bind(new Object[]{tenantId}));
            for (Row row : rsTriggers) {
                if (!groupId.equals(row.getString("memberOf")) || !includeOrphans && row.getBool("orphan")) continue;
                Trigger trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
                triggers.add(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return triggers;
    }

    private void selectTriggerActions(Trigger trigger) throws Exception {
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        PreparedStatement selectTriggerActions = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_ACTIONS);
        if (selectTriggerActions == null) {
            throw new RuntimeException("selectTriggerActions PreparedStatement is null");
        }
        ResultSet rsTriggerActions = this.session.execute((Statement)selectTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId()}));
        for (Row row : rsTriggerActions) {
            String actionPlugin = row.getString("actionPlugin");
            Set actions = row.getSet("actions", String.class);
            trigger.addActions(actionPlugin, actions);
        }
    }

    private Trigger mapTrigger(Row row) {
        Trigger trigger = new Trigger();
        trigger.setTenantId(row.getString("tenantId"));
        trigger.setId(row.getString("id"));
        trigger.setAutoDisable(row.getBool("autoDisable"));
        trigger.setAutoEnable(row.getBool("autoEnable"));
        trigger.setAutoResolve(row.getBool("autoResolve"));
        trigger.setAutoResolveAlerts(row.getBool("autoResolveAlerts"));
        trigger.setAutoResolveMatch(Match.valueOf((String)row.getString("autoResolveMatch")));
        trigger.setContext(row.getMap("context", String.class, String.class));
        trigger.setDescription(row.getString("description"));
        trigger.setEnabled(row.getBool("enabled"));
        trigger.setEventCategory(row.getString("eventCategory"));
        trigger.setEventText(row.getString("eventText"));
        trigger.setEventType(EventType.valueOf((String)row.getString("eventType")));
        trigger.setFiringMatch(Match.valueOf((String)row.getString("firingMatch")));
        trigger.setGroup(row.getBool("group"));
        trigger.setMemberOf(row.getString("memberOf"));
        trigger.setName(row.getString("name"));
        trigger.setOrphan(row.getBool("orphan"));
        trigger.setSeverity(Severity.valueOf((String)row.getString("severity")));
        trigger.setTags(row.getMap("tags", String.class, String.class));
        return trigger;
    }

    public Trigger addMemberTrigger(String tenantId, String groupId, String memberId, String memberName, Map<String, String> memberContext, Map<String, String> dataIdMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.isEmpty(memberName)) {
            throw new IllegalArgumentException("MemberName must be not null");
        }
        if (this.isEmpty(dataIdMap)) {
            throw new IllegalArgumentException("DataIdMap must be not null");
        }
        Trigger group = this.getTrigger(tenantId, groupId);
        if (group == null) {
            throw new IllegalArgumentException("Trigger not found for tenantId/triggerId [ " + tenantId + "]/[" + groupId + "]");
        }
        HashSet<String> dataIdTokens = new HashSet<String>();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, groupId, null);
        for (Condition condition : conditions) {
            if (Condition.Type.COMPARE == condition.getType()) {
                dataIdTokens.add(condition.getDataId());
                dataIdTokens.add(((CompareCondition)condition).getData2Id());
                continue;
            }
            dataIdTokens.add(condition.getDataId());
        }
        if (!dataIdTokens.equals(dataIdMap.keySet())) {
            throw new IllegalArgumentException("DataIdMap must contain the exact dataIds (keyset) expected by the condition set. Expected: " + dataIdTokens + ", dataIdMap: " + dataIdMap.keySet());
        }
        memberId = null == memberId ? Trigger.generateId() : memberId;
        Trigger member = new Trigger(tenantId, memberId, memberName);
        this.copyGroupTrigger(group, member);
        if (null != memberContext) {
            member.setContext(memberContext);
        }
        this.addTrigger(tenantId, member);
        for (Condition c : conditions) {
            Condition newCondition = this.getMemberCondition(member, c, dataIdMap);
            if (newCondition == null) continue;
            this.addCondition(newCondition);
        }
        Collection<Dampening> collection = this.getTriggerDampenings(tenantId, groupId, null);
        for (Dampening d : collection) {
            Dampening newDampening = new Dampening(member.getId(), d.getTriggerMode(), d.getType(), d.getEvalTrueSetting(), d.getEvalTotalSetting(), d.getEvalTimeSetting());
            newDampening.setTenantId(member.getTenantId());
            this.addDampening(newDampening);
        }
        this.insertTags(tenantId, TagType.TRIGGER, member.getId(), member.getTags());
        return member;
    }

    private Condition getMemberCondition(Trigger member, Condition groupCondition, Map<String, String> dataIdMap) {
        AvailabilityCondition newCondition = null;
        switch (groupCondition.getType()) {
            case AVAILABILITY: {
                newCondition = new AvailabilityCondition(member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((AvailabilityCondition)groupCondition).getOperator());
                break;
            }
            case COMPARE: {
                newCondition = new CompareCondition(member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((CompareCondition)groupCondition).getOperator(), ((CompareCondition)groupCondition).getData2Multiplier(), dataIdMap.get(((CompareCondition)groupCondition).getData2Id()));
                break;
            }
            case EXTERNAL: {
                String tokenDataId = groupCondition.getDataId();
                String memberDataId = dataIdMap.get(tokenDataId);
                String tokenExpression = ((ExternalCondition)groupCondition).getExpression();
                String memberExpression = this.isEmpty(tokenExpression) ? tokenExpression : tokenExpression.replace(tokenDataId, memberDataId);
                newCondition = new ExternalCondition(member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), memberDataId, ((ExternalCondition)groupCondition).getSystemId(), memberExpression);
                break;
            }
            case RANGE: {
                newCondition = new ThresholdRangeCondition(member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((ThresholdRangeCondition)groupCondition).getOperatorLow(), ((ThresholdRangeCondition)groupCondition).getOperatorHigh(), ((ThresholdRangeCondition)groupCondition).getThresholdLow(), ((ThresholdRangeCondition)groupCondition).getThresholdHigh(), ((ThresholdRangeCondition)groupCondition).isInRange());
                break;
            }
            case RATE: {
                newCondition = new RateCondition(member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((RateCondition)groupCondition).getDirection(), ((RateCondition)groupCondition).getPeriod(), ((RateCondition)groupCondition).getOperator(), ((ThresholdCondition)groupCondition).getThreshold());
                break;
            }
            case STRING: {
                newCondition = new StringCondition(member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((StringCondition)groupCondition).getOperator(), ((StringCondition)groupCondition).getPattern(), ((StringCondition)groupCondition).isIgnoreCase());
                break;
            }
            case THRESHOLD: {
                newCondition = new ThresholdCondition(member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((ThresholdCondition)groupCondition).getOperator(), ((ThresholdCondition)groupCondition).getThreshold());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Condition type: " + groupCondition.getType().name());
            }
        }
        newCondition.setTenantId(member.getTenantId());
        return newCondition;
    }

    public Dampening addDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        String triggerId = dampening.getTriggerId();
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        return this.addDampening(dampening);
    }

    public Dampening addGroupDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        String groupId = dampening.getTriggerId();
        Trigger groupTrigger = this.getTrigger(tenantId, groupId);
        if (null == groupTrigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] does not exist.");
        }
        if (!groupTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger.");
        }
        Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
        for (Trigger member : memberTriggers) {
            dampening.setTriggerId(member.getId());
            this.addDampening(dampening);
        }
        dampening.setTriggerId(groupTrigger.getId());
        return this.addDampening(dampening);
    }

    private Dampening addDampening(Dampening dampening) throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement insertDampening = CassStatement.get(this.session, CassStatement.INSERT_DAMPENING);
        if (insertDampening == null) {
            throw new RuntimeException("insertDampening PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertDampening.bind(new Object[]{dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getDampeningId(), dampening.getTenantId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.Type.DAMPENING_CHANGE);
        return dampening;
    }

    public void removeDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("dampeningId must be not null");
        }
        Dampening dampening = this.getDampening(tenantId, dampeningId);
        if (null == dampening) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring removeDampening(" + dampeningId + "), the Dampening does not exist."));
            }
            return;
        }
        String triggerId = dampening.getTriggerId();
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        this.removeDampening(dampening);
    }

    public void removeGroupDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("dampeningId must be not null");
        }
        Dampening dampening = this.getDampening(tenantId, dampeningId);
        if (null == dampening) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring removeDampening(" + dampeningId + "), the Dampening does not exist."));
            }
            return;
        }
        String groupId = dampening.getTriggerId();
        Trigger groupTrigger = this.getTrigger(tenantId, groupId);
        if (null == groupTrigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] does not exist.");
        }
        if (!groupTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger.");
        }
        Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
        for (Trigger member : memberTriggers) {
            Collection<Dampening> dampenings = this.getTriggerDampenings(tenantId, member.getId(), dampening.getTriggerMode());
            if (dampenings.isEmpty()) continue;
            this.removeDampening(dampenings.iterator().next());
        }
        this.removeDampening(dampening);
    }

    private void removeDampening(Dampening dampening) throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement deleteDampeningId = CassStatement.get(this.session, CassStatement.DELETE_DAMPENING_ID);
        if (deleteDampeningId == null) {
            throw new RuntimeException("deleteDampeningId PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteDampeningId.bind(new Object[]{dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.Type.DAMPENING_CHANGE);
    }

    public Dampening updateDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        String triggerId = dampening.getTriggerId();
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        return this.updateDampening(dampening);
    }

    public Dampening updateGroupDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        String groupId = dampening.getTriggerId();
        Trigger groupTrigger = this.getTrigger(tenantId, groupId);
        if (null == groupTrigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] does not exist.");
        }
        if (!groupTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger.");
        }
        Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
        for (Trigger member : memberTriggers) {
            dampening.setTriggerId(member.getId());
            this.updateDampening(dampening);
        }
        dampening.setTriggerId(groupTrigger.getId());
        return this.updateDampening(dampening);
    }

    private Dampening updateDampening(Dampening dampening) throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement updateDampeningId = CassStatement.get(this.session, CassStatement.UPDATE_DAMPENING_ID);
        if (updateDampeningId == null) {
            throw new RuntimeException("updateDampeningId PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateDampeningId.bind(new Object[]{dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(DefinitionsEvent.Type.DAMPENING_CHANGE);
        return dampening;
    }

    public Dampening getDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectDampeningId = CassStatement.get(this.session, CassStatement.SELECT_DAMPENING_ID);
        if (selectDampeningId == null) {
            throw new RuntimeException("selectDampeningId PreparedStatement is null");
        }
        Dampening dampening = null;
        try {
            ResultSet rsDampening = this.session.execute((Statement)selectDampeningId.bind(new Object[]{tenantId, dampeningId}));
            Iterator itDampening = rsDampening.iterator();
            if (itDampening.hasNext()) {
                Row row = (Row)itDampening.next();
                dampening = this.mapDampening(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampening;
    }

    public Collection<Dampening> getTriggerDampenings(String tenantId, String triggerId, Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectTriggerDampenings = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_DAMPENINGS);
        PreparedStatement selectTriggerDampeningsMode = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_DAMPENINGS_MODE);
        if (selectTriggerDampenings == null || selectTriggerDampeningsMode == null) {
            throw new RuntimeException("selectTriggerDampenings* PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = triggerMode == null ? this.session.execute((Statement)selectTriggerDampenings.bind(new Object[]{tenantId, triggerId})) : this.session.execute((Statement)selectTriggerDampeningsMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getAllDampenings() throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement selectDampeningsAll = CassStatement.get(this.session, CassStatement.SELECT_DAMPENINGS_ALL);
        if (selectDampeningsAll == null) {
            throw new RuntimeException("selectDampeningsAll PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)selectDampeningsAll.bind());
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getDampenings(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectDampeningsByTenant = CassStatement.get(this.session, CassStatement.SELECT_DAMPENINGS_BY_TENANT);
        if (selectDampeningsByTenant == null) {
            throw new RuntimeException("selectDampeningsByTenant PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)selectDampeningsByTenant.bind(new Object[]{tenantId}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    private void mapDampenings(ResultSet rsDampenings, List<Dampening> dampenings) throws Exception {
        for (Row row : rsDampenings) {
            Dampening dampening = this.mapDampening(row);
            dampenings.add(dampening);
        }
    }

    private Dampening mapDampening(Row row) {
        Dampening dampening = new Dampening();
        dampening.setTenantId(row.getString("tenantId"));
        dampening.setTriggerId(row.getString("triggerId"));
        dampening.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
        dampening.setType(Dampening.Type.valueOf((String)row.getString("type")));
        dampening.setEvalTrueSetting(row.getInt("evalTrueSetting"));
        dampening.setEvalTotalSetting(row.getInt("evalTotalSetting"));
        dampening.setEvalTimeSetting(row.getLong("evalTimeSetting"));
        return dampening;
    }

    @Deprecated
    public Collection<Condition> addCondition(String tenantId, String triggerId, Mode triggerMode, Condition condition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        condition.setTenantId(tenantId);
        condition.setTriggerId(triggerId);
        condition.setTriggerMode(triggerMode);
        return this.addCondition(condition);
    }

    public Collection<Condition> setGroupConditions(String tenantId, String groupId, Mode triggerMode, Collection<Condition> groupConditions, Map<String, Map<String, String>> dataIdMemberMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (groupConditions == null) {
            throw new IllegalArgumentException("GroupConditions must be not null");
        }
        Trigger group = this.getTrigger(tenantId, groupId);
        if (null == group) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, groupId);
        }
        if (!group.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger.");
        }
        Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
        if (!memberTriggers.isEmpty()) {
            if (dataIdMemberMap == null) {
                throw new IllegalArgumentException("DataIdMemberMap must be not null when member triggers exist.");
            }
            for (Condition groupCondition : groupConditions) {
                CompareCondition cc;
                if (!dataIdMemberMap.containsKey(groupCondition.getDataId())) {
                    throw new IllegalArgumentException("Missing dataIdMap entry for dataId token [" + groupCondition.getDataId() + "]");
                }
                if (Condition.Type.COMPARE == groupCondition.getType() && !dataIdMemberMap.containsKey((cc = (CompareCondition)groupCondition).getData2Id())) {
                    throw new IllegalArgumentException("Missing dataIdMap entry for CompareCondition data2Id token [" + cc.getData2Id() + "]");
                }
                for (Map.Entry entry : dataIdMemberMap.entrySet()) {
                    Iterator<Condition> dataId = (String)entry.getKey();
                    Map map = (Map)entry.getValue();
                    if (map.size() != memberTriggers.size()) {
                        throw new IllegalArgumentException("memberMap size [" + map.size() + "] for dataId [" + dataId + "] must equal number of member triggers [" + memberTriggers.size() + "]");
                    }
                    for (Trigger member : memberTriggers) {
                        String value = (String)map.get(member.getId());
                        if (!this.isEmpty(value)) continue;
                        throw new IllegalArgumentException("Invalid mapping. DataId=[" + dataId + "], Member=[" + member.getId() + "], value=[" + value + "]");
                    }
                }
            }
        }
        for (Condition groupCondition : groupConditions) {
            groupCondition.setTenantId(group.getTenantId());
            groupCondition.setTriggerId(group.getId());
            groupCondition.setTriggerMode(triggerMode);
        }
        HashMap<String, String> dataIdMap = new HashMap<String, String>();
        ArrayList<Condition> memberConditions = new ArrayList<Condition>(groupConditions.size());
        for (Trigger trigger : memberTriggers) {
            dataIdMap.clear();
            memberConditions.clear();
            for (Map.Entry entry : dataIdMemberMap.entrySet()) {
                dataIdMap.put((String)entry.getKey(), (String)((Map)entry.getValue()).get(trigger.getId()));
            }
            for (Condition condition : groupConditions) {
                Condition memberCondition = this.getMemberCondition(trigger, condition, dataIdMap);
                memberConditions.add(memberCondition);
            }
            Collection<Condition> memberConditionSet = this.setConditions(tenantId, trigger.getId(), triggerMode, memberConditions);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Member condition set: " + memberConditionSet));
        }
        return this.setConditions(tenantId, groupId, triggerMode, groupConditions);
    }

    private Collection<Condition> addCondition(Condition condition) throws Exception {
        String tenantId = condition.getTenantId();
        String triggerId = condition.getTriggerId();
        Mode triggerMode = condition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        conditions.add(condition);
        int i = 0;
        for (Condition c : conditions) {
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, conditions);
    }

    @Deprecated
    public Collection<Condition> removeCondition(String tenantId, String conditionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition condition = this.getCondition(tenantId, conditionId);
        if (null == condition) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring removeCondition [" + conditionId + "], the condition does not exist."));
            }
            return null;
        }
        String triggerId = condition.getTriggerId();
        Mode triggerMode = condition.getTriggerMode();
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        return this.removeCondition(condition);
    }

    private Collection<Condition> removeCondition(Condition condition) throws Exception {
        String tenantId = condition.getTenantId();
        String triggerId = condition.getTriggerId();
        Mode triggerMode = condition.getTriggerMode();
        String conditionId = condition.getConditionId();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        int i = 0;
        int size = conditions.size() - 1;
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) continue;
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
            newConditions.add(c);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, newConditions);
    }

    @Deprecated
    public Collection<Condition> updateCondition(String tenantId, Condition condition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        String conditionId = condition.getConditionId();
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition existingCondition = this.getCondition(tenantId, conditionId);
        if (null == existingCondition) {
            throw new IllegalArgumentException("ConditionId [" + conditionId + "] on tenant " + tenantId + " does not exist.");
        }
        if (existingCondition.getTriggerMode() != condition.getTriggerMode()) {
            throw new IllegalArgumentException("The condition trigger mode [" + existingCondition.getTriggerMode().name() + "] can not be changed.");
        }
        String triggerId = existingCondition.getTriggerId();
        Trigger existingTrigger = this.getTrigger(tenantId, triggerId);
        if (null == existingTrigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (existingTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (existingTrigger.isMember() && !existingTrigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        return this.updateCondition(existingTrigger, condition);
    }

    private Collection<Condition> updateCondition(Trigger trigger, Condition condition) throws Exception {
        String tenantId = trigger.getTenantId();
        String triggerId = trigger.getId();
        Mode triggerMode = condition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        int size = conditions.size();
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(condition.getConditionId())) {
                newConditions.add(condition);
                continue;
            }
            newConditions.add(c);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> setConditions(String tenantId, String triggerId, Mode triggerMode, Collection<Condition> conditions) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("Conditions must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement insertConditionAvailability = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_AVAILABILITY);
        PreparedStatement insertConditionCompare = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_COMPARE);
        PreparedStatement insertConditionEvent = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_EVENT);
        PreparedStatement insertConditionExternal = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_EXTERNAL);
        PreparedStatement insertConditionRate = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_RATE);
        PreparedStatement insertConditionString = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_STRING);
        PreparedStatement insertConditionThreshold = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_THRESHOLD);
        PreparedStatement insertConditionThresholdRange = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_THRESHOLD_RANGE);
        if (insertConditionAvailability == null || insertConditionCompare == null || insertConditionEvent == null || insertConditionExternal == null || insertConditionRate == null || insertConditionString == null || insertConditionThreshold == null || insertConditionThresholdRange == null) {
            throw new RuntimeException("insert*Condition PreparedStatement is null");
        }
        this.removeConditions(tenantId, triggerId, triggerMode);
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            int i = 0;
            block12: for (Condition cond : conditions) {
                cond.setTenantId(tenantId);
                cond.setTriggerId(triggerId);
                cond.setTriggerMode(triggerMode);
                cond.setConditionSetSize(conditions.size());
                cond.setConditionSetIndex(++i);
                switch (cond.getType()) {
                    case AVAILABILITY: {
                        AvailabilityCondition aCond = (AvailabilityCondition)cond;
                        futures.add(this.session.executeAsync((Statement)insertConditionAvailability.bind(new Object[]{aCond.getTenantId(), aCond.getTriggerId(), aCond.getTriggerMode().name(), aCond.getContext(), aCond.getConditionSetSize(), aCond.getConditionSetIndex(), aCond.getConditionId(), aCond.getDataId(), aCond.getOperator().name()})));
                        continue block12;
                    }
                    case COMPARE: {
                        CompareCondition cCond = (CompareCondition)cond;
                        futures.add(this.session.executeAsync((Statement)insertConditionCompare.bind(new Object[]{cCond.getTenantId(), cCond.getTriggerId(), cCond.getTriggerMode().name(), cCond.getContext(), cCond.getConditionSetSize(), cCond.getConditionSetIndex(), cCond.getConditionId(), cCond.getDataId(), cCond.getOperator().name(), cCond.getData2Id(), cCond.getData2Multiplier()})));
                        continue block12;
                    }
                    case EVENT: {
                        EventCondition evCond = (EventCondition)cond;
                        futures.add(this.session.executeAsync((Statement)insertConditionEvent.bind(new Object[]{evCond.getTenantId(), evCond.getTriggerId(), evCond.getTriggerMode().name(), evCond.getContext(), evCond.getConditionSetSize(), evCond.getConditionSetIndex(), evCond.getConditionId(), evCond.getDataId(), evCond.getExpression()})));
                        continue block12;
                    }
                    case EXTERNAL: {
                        ExternalCondition eCond = (ExternalCondition)cond;
                        futures.add(this.session.executeAsync((Statement)insertConditionExternal.bind(new Object[]{eCond.getTenantId(), eCond.getTriggerId(), eCond.getTriggerMode().name(), eCond.getContext(), eCond.getConditionSetSize(), eCond.getConditionSetIndex(), eCond.getConditionId(), eCond.getDataId(), eCond.getSystemId(), eCond.getExpression()})));
                        continue block12;
                    }
                    case RANGE: {
                        ThresholdRangeCondition rCond = (ThresholdRangeCondition)cond;
                        futures.add(this.session.executeAsync((Statement)insertConditionThresholdRange.bind(new Object[]{rCond.getTenantId(), rCond.getTriggerId(), rCond.getTriggerMode().name(), rCond.getContext(), rCond.getConditionSetSize(), rCond.getConditionSetIndex(), rCond.getConditionId(), rCond.getDataId(), rCond.getOperatorLow().name(), rCond.getOperatorHigh().name(), rCond.getThresholdLow(), rCond.getThresholdHigh(), rCond.isInRange()})));
                        continue block12;
                    }
                    case RATE: {
                        RateCondition rateCond = (RateCondition)cond;
                        futures.add(this.session.executeAsync((Statement)insertConditionRate.bind(new Object[]{rateCond.getTenantId(), rateCond.getTriggerId(), rateCond.getTriggerMode().name(), rateCond.getContext(), rateCond.getConditionSetSize(), rateCond.getConditionSetIndex(), rateCond.getConditionId(), rateCond.getDataId(), rateCond.getDirection(), rateCond.getPeriod(), rateCond.getOperator().name(), rateCond.getThreshold()})));
                        continue block12;
                    }
                    case STRING: {
                        StringCondition sCond = (StringCondition)cond;
                        futures.add(this.session.executeAsync((Statement)insertConditionString.bind(new Object[]{sCond.getTenantId(), sCond.getTriggerId(), sCond.getTriggerMode().name(), sCond.getContext(), sCond.getConditionSetSize(), sCond.getConditionSetIndex(), sCond.getConditionId(), sCond.getDataId(), sCond.getOperator().name(), sCond.getPattern(), sCond.isIgnoreCase()})));
                        continue block12;
                    }
                    case THRESHOLD: {
                        ThresholdCondition tCond = (ThresholdCondition)cond;
                        futures.add(this.session.executeAsync((Statement)insertConditionThreshold.bind(new Object[]{tCond.getTenantId(), tCond.getTriggerId(), tCond.getTriggerMode().name(), tCond.getContext(), tCond.getConditionSetSize(), tCond.getConditionSetIndex(), tCond.getConditionId(), tCond.getDataId(), tCond.getOperator().name(), tCond.getThreshold()})));
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unexpected ConditionType: " + cond);
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.initialized && this.alertsEngine != null) {
            this.alertsEngine.reloadTrigger(tenantId, triggerId);
        }
        this.notifyListeners(DefinitionsEvent.Type.CONDITION_CHANGE);
        return conditions;
    }

    private void insertTags(String tenantId, TagType type, String id, Map<String, String> tags) throws Exception {
        if (this.isEmpty(tags)) {
            return;
        }
        PreparedStatement insertTag = CassStatement.get(this.session, CassStatement.INSERT_TAG);
        if (insertTag == null) {
            throw new RuntimeException("insertTag PreparedStatement is null");
        }
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>(tags.size());
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            futures.add(this.session.executeAsync((Statement)insertTag.bind(new Object[]{tenantId, type.name(), tag.getKey(), tag.getValue(), id})));
        }
        Futures.allAsList(futures).get();
    }

    private void removeConditions(String tenantId, String triggerId, Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must not be null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must not be null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must not be null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement deleteConditionsMode = CassStatement.get(this.session, CassStatement.DELETE_CONDITIONS_MODE);
        if (deleteConditionsMode == null) {
            throw new RuntimeException("deleteConditionsMode PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteConditionsMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void deleteTags(String tenantId, TagType type, String id, Map<String, String> tags) throws Exception {
        if (this.isEmpty(tags)) {
            return;
        }
        PreparedStatement deleteTag = CassStatement.get(this.session, CassStatement.DELETE_TAG);
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>(tags.size());
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            futures.add(this.session.executeAsync((Statement)deleteTag.bind(new Object[]{tenantId, type.name(), tag.getKey(), tag.getValue(), id})));
        }
        Futures.allAsList(futures).get();
    }

    @Deprecated
    public Condition getCondition(String tenantId, String conditionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("conditionId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectConditionId = CassStatement.get(this.session, CassStatement.SELECT_CONDITION_ID);
        if (selectConditionId == null) {
            throw new RuntimeException("selectConditionId PreparedStatement is null");
        }
        Condition condition = null;
        try {
            ResultSet rsCondition = this.session.execute((Statement)selectConditionId.bind(new Object[]{tenantId, conditionId}));
            Iterator itCondition = rsCondition.iterator();
            if (itCondition.hasNext()) {
                Row row = (Row)itCondition.next();
                condition = this.mapCondition(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return condition;
    }

    public Collection<Condition> getTriggerConditions(String tenantId, String triggerId, Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("triggerId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectTriggerConditions = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_CONDITIONS);
        PreparedStatement selectTriggerConditionsTriggerMode = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_CONDITIONS_TRIGGER_MODE);
        if (selectTriggerConditions == null || selectTriggerConditionsTriggerMode == null) {
            throw new RuntimeException("selectTriggerConditions* PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = triggerMode == null ? this.session.execute((Statement)selectTriggerConditions.bind(new Object[]{tenantId, triggerId})) : this.session.execute((Statement)selectTriggerConditionsTriggerMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getAllConditions() throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement selectConditionsAll = CassStatement.get(this.session, CassStatement.SELECT_CONDITIONS_ALL);
        if (selectConditionsAll == null) {
            throw new RuntimeException("selectConditionsAll PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)selectConditionsAll.bind());
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getConditions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectConditionsByTenant = CassStatement.get(this.session, CassStatement.SELECT_CONDITIONS_BY_TENANT);
        if (selectConditionsByTenant == null) {
            throw new RuntimeException("selectConditionsByTenant PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)selectConditionsByTenant.bind(new Object[]{tenantId}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    private void mapConditions(ResultSet rsConditions, List<Condition> conditions) throws Exception {
        for (Row row : rsConditions) {
            Condition condition = this.mapCondition(row);
            if (condition == null) continue;
            conditions.add(condition);
        }
    }

    private Condition mapCondition(Row row) throws Exception {
        EventCondition condition = null;
        String type = row.getString("type");
        if (type != null && !type.isEmpty()) {
            switch (Condition.Type.valueOf((String)type)) {
                case AVAILABILITY: {
                    AvailabilityCondition aCondition = new AvailabilityCondition();
                    aCondition.setTenantId(row.getString("tenantId"));
                    aCondition.setTriggerId(row.getString("triggerId"));
                    aCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    aCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    aCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    aCondition.setDataId(row.getString("dataId"));
                    aCondition.setOperator(AvailabilityCondition.Operator.valueOf((String)row.getString("operator")));
                    aCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = aCondition;
                    break;
                }
                case COMPARE: {
                    CompareCondition cCondition = new CompareCondition();
                    cCondition.setTenantId(row.getString("tenantId"));
                    cCondition.setTriggerId(row.getString("triggerId"));
                    cCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    cCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    cCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    cCondition.setDataId(row.getString("dataId"));
                    cCondition.setOperator(CompareCondition.Operator.valueOf((String)row.getString("operator")));
                    cCondition.setData2Id(row.getString("data2Id"));
                    cCondition.setData2Multiplier(Double.valueOf(row.getDouble("data2Multiplier")));
                    cCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = cCondition;
                    break;
                }
                case EXTERNAL: {
                    ExternalCondition eCondition = new ExternalCondition();
                    eCondition.setTenantId(row.getString("tenantId"));
                    eCondition.setTriggerId(row.getString("triggerId"));
                    eCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    eCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    eCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    eCondition.setDataId(row.getString("dataId"));
                    eCondition.setSystemId(row.getString("operator"));
                    eCondition.setExpression(row.getString("pattern"));
                    eCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = eCondition;
                    break;
                }
                case EVENT: {
                    EventCondition evCondition = new EventCondition();
                    evCondition.setTenantId(row.getString("tenantId"));
                    evCondition.setTriggerId(row.getString("triggerId"));
                    evCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    evCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    evCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    evCondition.setDataId(row.getString("dataId"));
                    evCondition.setExpression(row.getString("pattern"));
                    evCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = evCondition;
                    break;
                }
                case RANGE: {
                    ThresholdRangeCondition rCondition = new ThresholdRangeCondition();
                    rCondition.setTenantId(row.getString("tenantId"));
                    rCondition.setTriggerId(row.getString("triggerId"));
                    rCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    rCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    rCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    rCondition.setDataId(row.getString("dataId"));
                    rCondition.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorLow")));
                    rCondition.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorHigh")));
                    rCondition.setThresholdLow(Double.valueOf(row.getDouble("thresholdLow")));
                    rCondition.setThresholdHigh(Double.valueOf(row.getDouble("thresholdHigh")));
                    rCondition.setInRange(row.getBool("inRange"));
                    rCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = rCondition;
                    break;
                }
                case RATE: {
                    RateCondition rateCondition = new RateCondition();
                    rateCondition.setTenantId(row.getString("tenantId"));
                    rateCondition.setTriggerId(row.getString("triggerId"));
                    rateCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    rateCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    rateCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    rateCondition.setDataId(row.getString("dataId"));
                    rateCondition.setDirection(RateCondition.Direction.valueOf((String)row.getString("direction")));
                    rateCondition.setPeriod(RateCondition.Period.valueOf((String)row.getString("period")));
                    rateCondition.setOperator(RateCondition.Operator.valueOf((String)row.getString("operator")));
                    rateCondition.setThreshold(Double.valueOf(row.getDouble("threshold")));
                    rateCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = rateCondition;
                    break;
                }
                case STRING: {
                    StringCondition sCondition = new StringCondition();
                    sCondition.setTenantId(row.getString("tenantId"));
                    sCondition.setTriggerId(row.getString("triggerId"));
                    sCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    sCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    sCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    sCondition.setDataId(row.getString("dataId"));
                    sCondition.setOperator(StringCondition.Operator.valueOf((String)row.getString("operator")));
                    sCondition.setPattern(row.getString("pattern"));
                    sCondition.setIgnoreCase(row.getBool("ignoreCase"));
                    sCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = sCondition;
                    break;
                }
                case THRESHOLD: {
                    ThresholdCondition tCondition = new ThresholdCondition();
                    tCondition.setTenantId(row.getString("tenantId"));
                    tCondition.setTriggerId(row.getString("triggerId"));
                    tCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    tCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    tCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    tCondition.setDataId(row.getString("dataId"));
                    tCondition.setOperator(ThresholdCondition.Operator.valueOf((String)row.getString("operator")));
                    tCondition.setThreshold(Double.valueOf(row.getDouble("threshold")));
                    tCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = tCondition;
                    break;
                }
                default: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Unexpected condition type found: " + type));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            this.log.debug((Object)"Invalid condition type: null or empty");
        }
        return condition;
    }

    public void addActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement insertActionPlugin = CassStatement.get(this.session, CassStatement.INSERT_ACTION_PLUGIN);
        if (insertActionPlugin == null) {
            throw new RuntimeException("insertActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertActionPlugin.bind(new Object[]{actionPlugin, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addActionPlugin(String actionPlugin, Map<String, String> defaultProperties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (defaultProperties == null || defaultProperties.isEmpty()) {
            throw new IllegalArgumentException("defaultProperties must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement insertActionPluginDefaulProperties = CassStatement.get(this.session, CassStatement.INSERT_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (insertActionPluginDefaulProperties == null) {
            throw new RuntimeException("insertDefaulPropertiesActionPlugin PreparedStatement is null");
        }
        try {
            Set<String> properties = defaultProperties.keySet();
            this.session.execute((Statement)insertActionPluginDefaulProperties.bind(new Object[]{actionPlugin, properties, defaultProperties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeActionPlugin(String actionPlugin) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement deleteActionPlugin = CassStatement.get(this.session, CassStatement.DELETE_ACTION_PLUGIN);
        if (deleteActionPlugin == null) {
            throw new RuntimeException("deleteActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteActionPlugin.bind(new Object[]{actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement updateActionPlugin = CassStatement.get(this.session, CassStatement.UPDATE_ACTION_PLUGIN);
        if (updateActionPlugin == null) {
            throw new RuntimeException("updateActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateActionPlugin.bind(new Object[]{properties, actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateActionPlugin(String actionPlugin, Map<String, String> defaultProperties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (defaultProperties == null || defaultProperties.isEmpty()) {
            throw new IllegalArgumentException("defaultProperties must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement updateDefaultPropertiesActionPlugin = CassStatement.get(this.session, CassStatement.UPDATE_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (updateDefaultPropertiesActionPlugin == null) {
            throw new RuntimeException("updateDefaultPropertiesActionPlugin PreparedStatement is null");
        }
        try {
            Set<String> properties = defaultProperties.keySet();
            this.session.execute((Statement)updateDefaultPropertiesActionPlugin.bind(new Object[]{properties, defaultProperties, actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<String> getActionPlugins() throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement selectActionPlugins = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGINS);
        if (selectActionPlugins == null) {
            throw new RuntimeException("selectActionPlugins PreparedStatement is null");
        }
        ArrayList<String> actionPlugins = new ArrayList<String>();
        try {
            ResultSet rsActionPlugins = this.session.execute((Statement)selectActionPlugins.bind());
            for (Row row : rsActionPlugins) {
                actionPlugins.add(row.getString("actionPlugin"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actionPlugins;
    }

    public Set<String> getActionPlugin(String actionPlugin) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectActionPlugin = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGIN);
        if (selectActionPlugin == null) {
            throw new RuntimeException("selectActionPlugin PreparedStatement is null");
        }
        Set properties = null;
        try {
            ResultSet rsActionPlugin = this.session.execute((Statement)selectActionPlugin.bind(new Object[]{actionPlugin}));
            Iterator itActionPlugin = rsActionPlugin.iterator();
            if (itActionPlugin.hasNext()) {
                Row row = (Row)itActionPlugin.next();
                properties = row.getSet("properties", String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public Map<String, String> getDefaultActionPlugin(String actionPlugin) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectActionPluginDefaultProperties = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (selectActionPluginDefaultProperties == null) {
            throw new RuntimeException("selectDefaultPropertiesActionPlugin PreparedStatement is null");
        }
        Map defaultProperties = null;
        try {
            ResultSet rsActionPlugin = this.session.execute((Statement)selectActionPluginDefaultProperties.bind(new Object[]{actionPlugin}));
            Iterator itActionPlugin = rsActionPlugin.iterator();
            if (itActionPlugin.hasNext()) {
                Row row = (Row)itActionPlugin.next();
                defaultProperties = row.getMap("defaultProperties", String.class, String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return defaultProperties;
    }

    public void removeAction(String tenantId, String actionPlugin, String actionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement deleteAction = CassStatement.get(this.session, CassStatement.DELETE_ACTION);
        if (deleteAction == null) {
            throw new RuntimeException("deleteAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteAction.bind(new Object[]{tenantId, actionPlugin, actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateAction(String tenantId, String actionPlugin, String actionId, Map<String, String> properties) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        properties.put("actionId", actionId);
        properties.put("actionPlugin", actionPlugin);
        this.session = CassCluster.getSession();
        PreparedStatement updateAction = CassStatement.get(this.session, CassStatement.UPDATE_ACTION);
        if (updateAction == null) {
            throw new RuntimeException("updateAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateAction.bind(new Object[]{properties, tenantId, actionPlugin, actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Map<String, Map<String, Set<String>>> getAllActions() throws Exception {
        this.session = CassCluster.getSession();
        PreparedStatement selectActionsAll = CassStatement.get(this.session, CassStatement.SELECT_ACTIONS_ALL);
        if (selectActionsAll == null) {
            throw new RuntimeException("selectActionsAll PreparedStatement is null");
        }
        HashMap<String, Map<String, Set<String>>> actions = new HashMap<String, Map<String, Set<String>>>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsAll.bind());
            for (Row row : rsActions) {
                String tenantId = row.getString("tenantId");
                String actionPlugin = row.getString("actionPlugin");
                String actionId = row.getString("actionId");
                if (actions.get(tenantId) == null) {
                    actions.put(tenantId, new HashMap());
                }
                if (((Map)actions.get(tenantId)).get(actionPlugin) == null) {
                    ((Map)actions.get(tenantId)).put(actionPlugin, new HashSet());
                }
                ((Set)((Map)actions.get(tenantId)).get(actionPlugin)).add(actionId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Map<String, Set<String>> getActions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectActionsByTenant = CassStatement.get(this.session, CassStatement.SELECT_ACTIONS_BY_TENANT);
        if (selectActionsByTenant == null) {
            throw new RuntimeException("selectActionsByTenant PreparedStatement is null");
        }
        HashMap<String, Set<String>> actions = new HashMap<String, Set<String>>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsByTenant.bind(new Object[]{tenantId}));
            for (Row row : rsActions) {
                String actionPlugin = row.getString("actionPlugin");
                String actionId = row.getString("actionId");
                if (actions.get(actionPlugin) == null) {
                    actions.put(actionPlugin, new HashSet());
                }
                ((Set)actions.get(actionPlugin)).add(actionId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Collection<String> getActions(String tenantId, String actionPlugin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectActionsPlugin = CassStatement.get(this.session, CassStatement.SELECT_ACTIONS_PLUGIN);
        if (selectActionsPlugin == null) {
            throw new RuntimeException("selectActionsPlugin PreparedStatement is null");
        }
        ArrayList<String> actions = new ArrayList<String>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsPlugin.bind(new Object[]{tenantId, actionPlugin}));
            for (Row row : rsActions) {
                actions.add(row.getString("actionId"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Map<String, String> getAction(String tenantId, String actionPlugin, String actionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("actionId must be not null");
        }
        this.session = CassCluster.getSession();
        PreparedStatement selectAction = CassStatement.get(this.session, CassStatement.SELECT_ACTION);
        if (selectAction == null) {
            throw new RuntimeException("selectAction PreparedStatement is null");
        }
        Map properties = null;
        try {
            ResultSet rsAction = this.session.execute((Statement)selectAction.bind(new Object[]{tenantId, actionPlugin, actionId}));
            Iterator itAction = rsAction.iterator();
            if (itAction.hasNext()) {
                Row row = (Row)itAction.next();
                properties = row.getMap("properties", String.class, String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public void registerListener(DefinitionsListener listener, DefinitionsEvent.Type eventType, DefinitionsEvent.Type ... eventTypes) {
        EnumSet<DefinitionsEvent.Type[]> types = EnumSet.of(eventType, eventTypes);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering listeners " + listener + " for event types " + types));
        }
        this.listeners.put(listener, types);
    }

    private void notifyListeners(DefinitionsEvent.Type eventType) {
        DefinitionsEvent de = new DefinitionsEvent(eventType);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Notifying applicable listeners " + this.listeners + " of event " + eventType.name()));
        }
        for (Map.Entry<DefinitionsListener, Set<DefinitionsEvent.Type>> me : this.listeners.entrySet()) {
            if (!me.getValue().contains(eventType)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Notified Listener " + eventType.name()));
            }
            me.getKey().onChange(de);
        }
    }

    private boolean isEmpty(Trigger trigger) {
        return trigger == null || trigger.getId() == null || trigger.getId().trim().isEmpty();
    }

    private boolean isEmpty(Dampening dampening) {
        return dampening == null || dampening.getTriggerId() == null || dampening.getTriggerId().trim().isEmpty() || dampening.getDampeningId() == null || dampening.getDampeningId().trim().isEmpty();
    }

    private boolean isEmpty(String id) {
        return id == null || id.trim().isEmpty();
    }

    public boolean isEmpty(Map<String, String> map) {
        return map == null || map.isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    private void checkTenantId(String tenantId, Object obj) {
        Dampening dampening;
        if (this.isEmpty(tenantId)) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Trigger) {
            Trigger trigger = (Trigger)obj;
            if (trigger.getTenantId() == null || !trigger.getTenantId().equals(tenantId)) {
                trigger.setTenantId(tenantId);
            }
        } else if (obj instanceof Dampening && ((dampening = (Dampening)obj).getTenantId() == null || !dampening.getTenantId().equals(tenantId))) {
            dampening.setTenantId(tenantId);
        }
    }
}

