/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassDefinitionsServiceImpl;
import org.jboss.logging.Logger;

public class CassCluster {
    private static final Logger log = Logger.getLogger(CassDefinitionsServiceImpl.class);
    private static final String ALERTS_CASSANDRA_PORT = "hawkular-alerts.cassandra-cql-port";
    private static final String ALERTS_CASSANDRA_PORT_ENV = "CASSANDRA_CQL_PORT";
    private static final String ALERTS_CASSANDRA_NODES = "hawkular-alerts.cassandra-nodes";
    private static final String ALERTS_CASSANDRA_NODES_ENV = "CASSANDRA_NODES";
    private static final String ALERTS_CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private static final String ALERTS_CASSANDRA_RETRY_ATTEMPTS = "hawkular-alerts.cassandra-retry-attempts";
    private static final String ALERTS_CASSANDRA_RETRY_TIMEOUT = "hawkular-alerts.cassandra-retry-timeout";
    private Cluster cluster = null;
    private Session session = null;
    private boolean initialized = false;
    private static CassCluster instance = new CassCluster();

    private CassCluster() {
    }

    private void initScheme(Session session, String keyspace) throws IOException {
        ResultSet resultSet;
        if (keyspace == null) {
            keyspace = AlertProperties.getProperty(ALERTS_CASSANDRA_KEYSPACE, "hawkular_alerts");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking Schema existence for keyspace: " + keyspace));
        }
        if (!(resultSet = session.execute("SELECT * FROM system.schema_keyspaces WHERE keyspace_name = '" + keyspace + "'")).isExhausted()) {
            log.debug((Object)"Schema already exist. Skipping schema creation.");
            this.initialized = true;
            return;
        }
        log.infof("Creating Schema for keyspace %s", (Object)keyspace);
        ImmutableMap schemaVars = ImmutableMap.of((Object)"keyspace", (Object)keyspace);
        String updatedCQL = null;
        try (InputStream inputStream = CassCluster.class.getResourceAsStream("/hawkular-alerts-schema.cql");
             InputStreamReader reader = new InputStreamReader(inputStream);){
            String content = CharStreams.toString((Readable)reader);
            for (String cql : content.split("(?m)^-- #.*$")) {
                if (cql.startsWith("--")) continue;
                updatedCQL = this.substituteVars(cql.trim(), (Map<String, String>)schemaVars);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Executing CQL:\n" + updatedCQL + "\n"));
                }
                session.execute(updatedCQL);
            }
        }
        catch (Exception e) {
            log.errorf("Failed schema creation: %s\nEXECUTING CQL:\n%s", (Object)e, updatedCQL);
        }
        this.initialized = true;
        log.infof("Done creating Schema for keyspace: " + keyspace, new Object[0]);
    }

    /*
     * Exception decompiling
     */
    private String substituteVars(String cql, Map<String, String> vars) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized Session getSession() throws Exception {
        if (CassCluster.instance.cluster == null && CassCluster.instance.session == null) {
            String cqlPort = AlertProperties.getProperty(ALERTS_CASSANDRA_PORT, ALERTS_CASSANDRA_PORT_ENV, "9042");
            String nodes = AlertProperties.getProperty(ALERTS_CASSANDRA_NODES, ALERTS_CASSANDRA_NODES_ENV, "127.0.0.1");
            int attempts = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_RETRY_ATTEMPTS, "5"));
            int timeout = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_RETRY_TIMEOUT, "2000"));
            while (CassCluster.instance.session == null && !Thread.currentThread().isInterrupted() && attempts >= 0) {
                block9: {
                    try {
                        CassCluster.instance.cluster = new Cluster.Builder().addContactPoints(nodes.split(",")).withPort(new Integer(cqlPort).intValue()).withProtocolVersion(ProtocolVersion.V3).build();
                        CassCluster.instance.session = CassCluster.instance.cluster.connect();
                    }
                    catch (Exception e) {
                        log.warn((Object)("Could not connect to Cassandra cluster - assuming is not up yet. Cause: " + (e.getCause() == null ? e : e.getCause())));
                        if (attempts != 0) break block9;
                        throw e;
                    }
                }
                if (CassCluster.instance.session != null) continue;
                log.warn((Object)("[" + attempts + "] Retrying connecting to Cassandra cluster in [" + timeout + "]ms..."));
                --attempts;
                try {
                    Thread.sleep(timeout);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (CassCluster.instance.session != null && !CassCluster.instance.initialized) {
                String keyspace = AlertProperties.getProperty(ALERTS_CASSANDRA_KEYSPACE, "hawkular_alerts");
                instance.initScheme(CassCluster.instance.session, keyspace);
            }
        }
        if (CassCluster.instance.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (CassCluster.instance.session != null && !CassCluster.instance.initialized) {
            throw new RuntimeException("Cassandra alerts keyspace is not initialized");
        }
        return CassCluster.instance.session;
    }

    public static void shutdown() {
        if (instance != null && CassCluster.instance.session != null && !CassCluster.instance.session.isClosed()) {
            CassCluster.instance.session.close();
        }
    }
}

