/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.ejb.Asynchronous;
import javax.ejb.Local;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.paging.ActionComparator;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.PageContext;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.ActionsCriteria;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.impl.CassStatement;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.jboss.logging.Logger;

@Local(value={ActionsService.class})
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CassActionsServiceImpl
implements ActionsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassActionsServiceImpl.class);
    private static final String WAITING_RESULT = "WAITING";
    private static final String UNKNOWN_RESULT = "UNKWON";
    List<ActionListener> listeners = new CopyOnWriteArrayList<ActionListener>();
    private Session session;

    public CassActionsServiceImpl() {
        this.log.debug((Object)"Creating instance.");
    }

    @Asynchronous
    public void send(Action action) {
        if (action == null || action.getActionPlugin() == null || action.getActionId() == null || action.getActionPlugin().isEmpty() || action.getActionId().isEmpty()) {
            throw new IllegalArgumentException("Action must be not null");
        }
        if (action.getEvent() == null) {
            throw new IllegalArgumentException("Action must have an alert");
        }
        for (ActionListener listener : this.listeners) {
            listener.process(action);
        }
        this.insertActionHistory(action);
    }

    @Asynchronous
    public void updateResult(Action action) {
        if (action == null || action.getActionPlugin() == null || action.getActionId() == null || action.getActionPlugin().isEmpty() || action.getActionId().isEmpty()) {
            throw new IllegalArgumentException("Action must be not null");
        }
        if (action.getEvent() == null) {
            throw new IllegalArgumentException("Action must have an alert");
        }
        this.updateActionHistory(action);
    }

    private void insertActionHistory(Action action) {
        if (action.getResult() == null) {
            action.setResult(WAITING_RESULT);
        }
        try {
            this.session = CassCluster.getSession();
            PreparedStatement insertActionHistory = CassStatement.get(this.session, CassStatement.INSERT_ACTION_HISTORY);
            PreparedStatement insertActionHistoryAction = CassStatement.get(this.session, CassStatement.INSERT_ACTION_HISTORY_ACTION);
            PreparedStatement insertActionHistoryAlert = CassStatement.get(this.session, CassStatement.INSERT_ACTION_HISTORY_ALERT);
            PreparedStatement insertActionHistoryCtime = CassStatement.get(this.session, CassStatement.INSERT_ACTION_HISTORY_CTIME);
            PreparedStatement insertActionHistoryResult = CassStatement.get(this.session, CassStatement.INSERT_ACTION_HISTORY_RESULT);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)insertActionHistory.bind(new Object[]{action.getTenantId(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId(), action.getCtime(), JsonUtil.toJson((Object)action)})));
            futures.add(this.session.executeAsync((Statement)insertActionHistoryAction.bind(new Object[]{action.getTenantId(), action.getActionId(), action.getActionPlugin(), action.getEvent().getId(), action.getCtime()})));
            futures.add(this.session.executeAsync((Statement)insertActionHistoryAlert.bind(new Object[]{action.getTenantId(), action.getEvent().getId(), action.getActionPlugin(), action.getActionId(), action.getCtime()})));
            futures.add(this.session.executeAsync((Statement)insertActionHistoryCtime.bind(new Object[]{action.getTenantId(), action.getCtime(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId()})));
            futures.add(this.session.executeAsync((Statement)insertActionHistoryResult.bind(new Object[]{action.getTenantId(), action.getResult(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId(), action.getCtime()})));
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
        }
    }

    private Action selectActionHistory(String tenantId, String actionPlugin, String actionId, String alertId, long ctime) {
        Action actionHistory = null;
        try {
            this.session = CassCluster.getSession();
            PreparedStatement selectActionHistory = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY);
            ResultSet rsActionHistory = this.session.execute((Statement)selectActionHistory.bind(new Object[]{tenantId, actionPlugin, actionId, alertId, ctime}));
            Iterator itActionHistory = rsActionHistory.iterator();
            if (itActionHistory.hasNext()) {
                Row row = (Row)itActionHistory.next();
                actionHistory = (Action)JsonUtil.fromJson((String)row.getString("payload"), Action.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
        }
        return actionHistory;
    }

    private void updateActionHistory(Action action) {
        if (action.getResult() == null) {
            action.setResult(UNKNOWN_RESULT);
        }
        try {
            Action oldActionHistory = this.selectActionHistory(action.getTenantId(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId(), action.getCtime());
            if (oldActionHistory == null) {
                this.insertActionHistory(action);
                return;
            }
            String oldResult = oldActionHistory.getResult();
            this.session = CassCluster.getSession();
            PreparedStatement deleteActionHistoryResult = CassStatement.get(this.session, CassStatement.DELETE_ACTION_HISTORY_RESULT);
            PreparedStatement insertActionHistoryResult = CassStatement.get(this.session, CassStatement.INSERT_ACTION_HISTORY_RESULT);
            PreparedStatement updateActionHistory = CassStatement.get(this.session, CassStatement.UPDATE_ACTION_HISTORY);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)deleteActionHistoryResult.bind(new Object[]{action.getTenantId(), oldResult, action.getActionPlugin(), action.getActionId(), action.getEvent().getId(), action.getCtime()})));
            futures.add(this.session.executeAsync((Statement)insertActionHistoryResult.bind(new Object[]{action.getTenantId(), action.getResult(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId(), action.getCtime()})));
            futures.add(this.session.executeAsync((Statement)updateActionHistory.bind(new Object[]{JsonUtil.toJson((Object)action), action.getTenantId(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId(), action.getCtime()})));
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
        }
    }

    public void addListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ActionListener must not be null");
        }
        this.listeners.add(listener);
        this.msgLog.infoActionListenerRegistered(listener.toString());
    }

    public Page<Action> getActions(String tenantId, ActionsCriteria criteria, Pager pager) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        this.session = CassCluster.getSession();
        boolean thin = null != criteria && criteria.isThin();
        boolean filter = null != criteria && criteria.hasCriteria();
        ArrayList<Action> actions = new ArrayList<Action>();
        HashSet<ActionHistoryPK> actionPks = new HashSet<ActionHistoryPK>();
        if (filter) {
            HashSet<ActionHistoryPK> actionPKsfilteredByResult;
            boolean filterByResult;
            HashSet<ActionHistoryPK> actionPKsfilteredByAlertId;
            boolean filterByAlertId;
            HashSet<ActionHistoryPK> actionPKsfilteredByActionId;
            boolean filterByActionId;
            HashSet<ActionHistoryPK> actionPKsfilteredByActionPlugin;
            boolean filterByActionPlugin;
            HashSet<ActionHistoryPK> actionPKsfilteredByCtime = new HashSet<ActionHistoryPK>();
            boolean filterByCtime = this.filterByCtime(tenantId, actionPKsfilteredByCtime, criteria);
            if (filterByCtime) {
                actionPks.addAll(actionPKsfilteredByCtime);
                if (actionPks.isEmpty()) {
                    return new Page(actions, (PageContext)pager, 0L);
                }
            }
            if (filterByActionPlugin = this.filterByActionPlugin(tenantId, actionPKsfilteredByActionPlugin = new HashSet<ActionHistoryPK>(), criteria)) {
                if (actionPks.isEmpty()) {
                    actionPks.addAll(actionPKsfilteredByActionPlugin);
                } else {
                    actionPks.retainAll(actionPKsfilteredByActionPlugin);
                }
                if (actionPks.isEmpty()) {
                    return new Page(actions, (PageContext)pager, 0L);
                }
            }
            if (filterByActionId = this.filterByActionId(tenantId, actionPKsfilteredByActionId = new HashSet<ActionHistoryPK>(), criteria)) {
                if (actionPks.isEmpty()) {
                    actionPks.addAll(actionPKsfilteredByActionId);
                } else {
                    actionPks.retainAll(actionPKsfilteredByActionId);
                }
                if (actionPks.isEmpty()) {
                    return new Page(actions, (PageContext)pager, 0L);
                }
            }
            if (filterByAlertId = this.filterByAlertId(tenantId, actionPKsfilteredByAlertId = new HashSet<ActionHistoryPK>(), criteria)) {
                if (actionPks.isEmpty()) {
                    actionPks.addAll(actionPKsfilteredByAlertId);
                } else {
                    actionPks.retainAll(actionPKsfilteredByAlertId);
                }
                if (actionPks.isEmpty()) {
                    return new Page(actions, (PageContext)pager, 0L);
                }
            }
            if (filterByResult = this.filterByResult(tenantId, actionPKsfilteredByResult = new HashSet<ActionHistoryPK>(), criteria)) {
                if (actionPks.isEmpty()) {
                    actionPks.addAll(actionPKsfilteredByResult);
                } else {
                    actionPks.retainAll(actionPKsfilteredByResult);
                }
                if (actionPks.isEmpty()) {
                    return new Page(actions, (PageContext)pager, 0L);
                }
            }
        }
        if (!filter) {
            PreparedStatement selectActionHistoryByTenant = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY_BY_TENANT);
            ResultSet rsActionHistoryByTenant = this.session.execute((Statement)selectActionHistoryByTenant.bind(new Object[]{tenantId}));
            for (Row row : rsActionHistoryByTenant) {
                Action actionHistory = (Action)JsonUtil.fromJson((String)row.getString("payload"), Action.class, (boolean)thin);
                actions.add(actionHistory);
            }
        } else {
            PreparedStatement selectActionHistory = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY);
            List futures = actionPks.stream().map(actionPk -> this.session.executeAsync((Statement)selectActionHistory.bind(new Object[]{actionPk.tenantId, actionPk.actionPlugin, actionPk.actionId, actionPk.alertId, actionPk.ctime}))).collect(Collectors.toList());
            List rsActionHistory = (List)Futures.allAsList(futures).get();
            rsActionHistory.stream().forEach(r -> {
                for (Row row : r) {
                    Action actionHistory = (Action)JsonUtil.fromJson((String)row.getString("payload"), Action.class, (boolean)thin);
                    actions.add(actionHistory);
                }
            });
        }
        return this.preparePage(actions, pager);
    }

    private boolean filterByCtime(String tenantId, Set<ActionHistoryPK> actionPks, ActionsCriteria criteria) throws Exception {
        boolean filterByCtime = false;
        if (criteria.getStartTime() != null || criteria.getEndTime() != null) {
            BoundStatement boundCtime;
            filterByCtime = true;
            if (criteria.getStartTime() != null && criteria.getEndTime() != null) {
                PreparedStatement selectActionHistoryCTimeStartEnd = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY_CTIME_START_END);
                boundCtime = selectActionHistoryCTimeStartEnd.bind(new Object[]{tenantId, criteria.getStartTime(), criteria.getEndTime()});
            } else if (criteria.getStartTime() != null) {
                PreparedStatement selectActionHistoryCTimeStart = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY_CTIME_START);
                boundCtime = selectActionHistoryCTimeStart.bind(new Object[]{tenantId, criteria.getStartTime()});
            } else {
                PreparedStatement selectActionHistoryCTimeEnd = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY_CTIME_END);
                boundCtime = selectActionHistoryCTimeEnd.bind(new Object[]{tenantId, criteria.getEndTime()});
            }
            ResultSet rsActionHistoryCtimes = this.session.execute((Statement)boundCtime);
            for (Row row : rsActionHistoryCtimes) {
                ActionHistoryPK actionHistoryPK = new ActionHistoryPK();
                actionHistoryPK.tenantId = tenantId;
                actionHistoryPK.actionPlugin = row.getString("actionPlugin");
                actionHistoryPK.actionId = row.getString("actionId");
                actionHistoryPK.alertId = row.getString("alertId");
                actionHistoryPK.ctime = row.getLong("ctime");
                actionPks.add(actionHistoryPK);
            }
        }
        return filterByCtime;
    }

    private boolean filterByActionPlugin(String tenantId, Set<ActionHistoryPK> actionPks, ActionsCriteria criteria) throws Exception {
        boolean filterByActionPlugin = false;
        if (criteria.getActionPlugin() != null || criteria.getActionPlugins() != null && !criteria.getActionPlugins().isEmpty()) {
            filterByActionPlugin = true;
            PreparedStatement selectActionHistoryActionPlugin = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY_ACTION_PLUGIN);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            if (criteria.getActionPlugin() != null) {
                futures.add(this.session.executeAsync((Statement)selectActionHistoryActionPlugin.bind(new Object[]{tenantId, criteria.getActionPlugin()})));
            }
            if (criteria.getActionPlugins() != null && !criteria.getActionPlugins().isEmpty()) {
                for (String actionPlugin : criteria.getActionPlugins()) {
                    futures.add(this.session.executeAsync((Statement)selectActionHistoryActionPlugin.bind(new Object[]{tenantId, actionPlugin})));
                }
            }
            List rsActionHistory = (List)Futures.allAsList(futures).get();
            rsActionHistory.stream().forEach(r -> {
                for (Row row : r) {
                    ActionHistoryPK actionHistoryPK = new ActionHistoryPK();
                    actionHistoryPK.tenantId = tenantId;
                    actionHistoryPK.actionPlugin = row.getString("actionPlugin");
                    actionHistoryPK.actionId = row.getString("actionId");
                    actionHistoryPK.alertId = row.getString("alertId");
                    actionHistoryPK.ctime = row.getLong("ctime");
                    actionPks.add(actionHistoryPK);
                }
            });
        }
        return filterByActionPlugin;
    }

    private boolean filterByActionId(String tenantId, Set<ActionHistoryPK> actionPks, ActionsCriteria criteria) throws Exception {
        boolean filterByActionId = false;
        if (criteria.getActionId() != null || criteria.getActionIds() != null && !criteria.getActionIds().isEmpty()) {
            filterByActionId = true;
            PreparedStatement selectActionHistoryActionId = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY_ACTION_ID);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            if (criteria.getActionId() != null) {
                futures.add(this.session.executeAsync((Statement)selectActionHistoryActionId.bind(new Object[]{tenantId, criteria.getActionId()})));
            }
            if (criteria.getActionIds() != null && !criteria.getActionIds().isEmpty()) {
                for (String actionId : criteria.getActionIds()) {
                    futures.add(this.session.executeAsync((Statement)selectActionHistoryActionId.bind(new Object[]{tenantId, actionId})));
                }
            }
            List rsActionHistory = (List)Futures.allAsList(futures).get();
            rsActionHistory.stream().forEach(r -> {
                for (Row row : r) {
                    ActionHistoryPK actionHistoryPK = new ActionHistoryPK();
                    actionHistoryPK.tenantId = tenantId;
                    actionHistoryPK.actionPlugin = row.getString("actionPlugin");
                    actionHistoryPK.actionId = row.getString("actionId");
                    actionHistoryPK.alertId = row.getString("alertId");
                    actionHistoryPK.ctime = row.getLong("ctime");
                    actionPks.add(actionHistoryPK);
                }
            });
        }
        return filterByActionId;
    }

    private boolean filterByAlertId(String tenantId, Set<ActionHistoryPK> actionPks, ActionsCriteria criteria) throws Exception {
        boolean filterByAlertId = false;
        if (criteria.getAlertId() != null || criteria.getAlertIds() != null && !criteria.getAlertIds().isEmpty()) {
            filterByAlertId = true;
            PreparedStatement selectActionHistoryAlertId = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY_ALERT_ID);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            if (criteria.getAlertId() != null) {
                futures.add(this.session.executeAsync((Statement)selectActionHistoryAlertId.bind(new Object[]{tenantId, criteria.getAlertId()})));
            }
            if (criteria.getAlertIds() != null && !criteria.getAlertIds().isEmpty()) {
                for (String alertId : criteria.getAlertIds()) {
                    futures.add(this.session.executeAsync((Statement)selectActionHistoryAlertId.bind(new Object[]{tenantId, alertId})));
                }
            }
            List rsActionHistory = (List)Futures.allAsList(futures).get();
            rsActionHistory.stream().forEach(r -> {
                for (Row row : r) {
                    ActionHistoryPK actionHistoryPK = new ActionHistoryPK();
                    actionHistoryPK.tenantId = tenantId;
                    actionHistoryPK.actionPlugin = row.getString("actionPlugin");
                    actionHistoryPK.actionId = row.getString("actionId");
                    actionHistoryPK.alertId = row.getString("alertId");
                    actionHistoryPK.ctime = row.getLong("ctime");
                    actionPks.add(actionHistoryPK);
                }
            });
        }
        return filterByAlertId;
    }

    private boolean filterByResult(String tenantId, Set<ActionHistoryPK> actionPks, ActionsCriteria criteria) throws Exception {
        boolean filterByResult = false;
        if (criteria.getResult() != null || criteria.getResults() != null && !criteria.getResults().isEmpty()) {
            filterByResult = true;
            PreparedStatement selectActionHistoryResult = CassStatement.get(this.session, CassStatement.SELECT_ACTION_HISTORY_RESULT);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            if (criteria.getResult() != null) {
                futures.add(this.session.executeAsync((Statement)selectActionHistoryResult.bind(new Object[]{tenantId, criteria.getResult()})));
            }
            if (criteria.getResults() != null && !criteria.getResults().isEmpty()) {
                for (String result : criteria.getResults()) {
                    futures.add(this.session.executeAsync((Statement)selectActionHistoryResult.bind(new Object[]{tenantId, result})));
                }
            }
            List rsActionHistory = (List)Futures.allAsList(futures).get();
            rsActionHistory.stream().forEach(r -> {
                for (Row row : r) {
                    ActionHistoryPK actionHistoryPK = new ActionHistoryPK();
                    actionHistoryPK.tenantId = tenantId;
                    actionHistoryPK.actionPlugin = row.getString("actionPlugin");
                    actionHistoryPK.actionId = row.getString("actionId");
                    actionHistoryPK.alertId = row.getString("alertId");
                    actionHistoryPK.ctime = row.getLong("ctime");
                    actionPks.add(actionHistoryPK);
                }
            });
        }
        return filterByResult;
    }

    private Page<Action> preparePage(List<Action> actions, Pager pager) {
        if (pager != null) {
            if (pager.getOrder() != null && !pager.getOrder().isEmpty() && ((Order)pager.getOrder().get(0)).getField() == null) {
                pager = Pager.builder().withPageSize(pager.getPageSize()).withStartPage(pager.getPageNumber()).orderBy(ActionComparator.Field.ALERT_ID.getText(), Order.Direction.DESCENDING).build();
            }
            List<Action> ordered = actions;
            if (pager.getOrder() != null) {
                pager.getOrder().stream().filter(o -> o.getField() != null && o.getDirection() != null).forEach(o -> {
                    ActionComparator comparator = new ActionComparator(ActionComparator.Field.getField((String)o.getField()), o.getDirection());
                    Collections.sort(ordered, comparator);
                });
            }
            if (!pager.isLimited() || ordered.size() < pager.getStart()) {
                pager = new Pager(0, ordered.size(), (Iterable)pager.getOrder());
                return new Page(ordered, (PageContext)pager, (long)ordered.size());
            }
            if (pager.getEnd() >= ordered.size()) {
                return new Page(ordered.subList(pager.getStart(), ordered.size()), (PageContext)pager, (long)ordered.size());
            }
            return new Page(ordered.subList(pager.getStart(), pager.getEnd()), (PageContext)pager, (long)ordered.size());
        }
        pager = Pager.builder().withPageSize(actions.size()).orderBy(ActionComparator.Field.ALERT_ID.getText(), Order.Direction.ASCENDING).build();
        return new Page(actions, (PageContext)pager, (long)actions.size());
    }

    public int deleteActions(String tenantId, ActionsCriteria criteria) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (null == criteria) {
            throw new IllegalArgumentException("Criteria must be not null");
        }
        Page<Action> actionsToDelete = this.getActions(tenantId, criteria, null);
        if (actionsToDelete == null || actionsToDelete.isEmpty()) {
            return 0;
        }
        PreparedStatement deleteActionHistory = CassStatement.get(this.session, CassStatement.DELETE_ACTION_HISTORY);
        PreparedStatement deleteActionHistoryAction = CassStatement.get(this.session, CassStatement.DELETE_ACTION_HISTORY_ACTION);
        PreparedStatement deleteActionHistoryAlert = CassStatement.get(this.session, CassStatement.DELETE_ACTION_HISTORY_ALERT);
        PreparedStatement deleteActionHistoryCtime = CassStatement.get(this.session, CassStatement.DELETE_ACTION_HISTORY_CTIME);
        PreparedStatement deleteActionHistoryResult = CassStatement.get(this.session, CassStatement.DELETE_ACTION_HISTORY_RESULT);
        for (Action action : actionsToDelete) {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)deleteActionHistory.bind(new Object[]{action.getTenantId(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId(), action.getCtime()})));
            futures.add(this.session.executeAsync((Statement)deleteActionHistoryAction.bind(new Object[]{action.getTenantId(), action.getActionId(), action.getActionPlugin(), action.getEvent().getId(), action.getCtime()})));
            futures.add(this.session.executeAsync((Statement)deleteActionHistoryAlert.bind(new Object[]{action.getTenantId(), action.getEvent().getId(), action.getActionPlugin(), action.getActionId(), action.getCtime()})));
            futures.add(this.session.executeAsync((Statement)deleteActionHistoryCtime.bind(new Object[]{action.getTenantId(), action.getCtime(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId()})));
            futures.add(this.session.executeAsync((Statement)deleteActionHistoryResult.bind(new Object[]{action.getTenantId(), action.getResult(), action.getActionPlugin(), action.getActionId(), action.getEvent().getId(), action.getCtime()})));
            Futures.allAsList(futures).get();
        }
        return actionsToDelete.size();
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private class ActionHistoryPK {
        public String tenantId;
        public String actionPlugin;
        public String actionId;
        public String alertId;
        public long ctime;

        private ActionHistoryPK() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionHistoryPK that = (ActionHistoryPK)o;
            if (this.ctime != that.ctime) {
                return false;
            }
            if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
                return false;
            }
            if (this.actionPlugin != null ? !this.actionPlugin.equals(that.actionPlugin) : that.actionPlugin != null) {
                return false;
            }
            if (this.actionId != null ? !this.actionId.equals(that.actionId) : that.actionId != null) {
                return false;
            }
            return !(this.alertId == null ? that.alertId != null : !this.alertId.equals(that.alertId));
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.actionPlugin != null ? this.actionPlugin.hashCode() : 0);
            result = 31 * result + (this.actionId != null ? this.actionId.hashCode() : 0);
            result = 31 * result + (this.alertId != null ? this.alertId.hashCode() : 0);
            result = 31 * result + (int)(this.ctime ^ this.ctime >>> 32);
            return result;
        }
    }
}

