/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.ejb.Singleton;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.drools.core.event.DebugAgendaEventListener;
import org.drools.core.event.DebugRuleRuntimeEventListener;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.engine.service.RulesEngine;
import org.jboss.logging.Logger;
import org.kie.api.KieServices;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.FactHandle;

@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class DroolsRulesEngineImpl
implements RulesEngine {
    private final Logger log = Logger.getLogger(DroolsRulesEngineImpl.class);
    private static final String SESSION_NAME = "hawkular-alerts-engine-session";
    private KieServices ks;
    private KieContainer kc;
    private KieSession kSession;
    TreeSet<Data> pendingData = new TreeSet();
    TreeSet<Event> pendingEvents = new TreeSet();

    public DroolsRulesEngineImpl() {
        this.log.debug((Object)"Creating instance.");
        this.ks = KieServices.Factory.get();
        this.kc = this.ks.getKieClasspathContainer();
        this.kSession = this.kc.newKieSession(SESSION_NAME);
        if (this.log.isEnabled(Logger.Level.TRACE)) {
            this.kSession.addEventListener((AgendaEventListener)new DebugAgendaEventListener());
            this.kSession.addEventListener((RuleRuntimeEventListener)new DebugRuleRuntimeEventListener());
        }
    }

    @Override
    public void addFact(Object fact) {
        if (fact instanceof Data || fact instanceof Event) {
            throw new IllegalArgumentException(fact.toString());
        }
        this.kSession.insert(fact);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("addFact(" + fact.toString() + ")"));
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle f : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(f);
                this.log.debug((Object)("Fact:  " + sessionObject.toString()));
            }
            this.log.debug((Object)"==> End Dump");
        }
    }

    @Override
    public void addFacts(Collection facts) {
        for (Object fact : facts) {
            if (!(fact instanceof Data) && !(fact instanceof Event)) continue;
            throw new IllegalArgumentException(fact.toString());
        }
        for (Object fact : facts) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Insert " + fact));
            }
            this.kSession.insert(fact);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("addFacts(" + facts.toString() + ")"));
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle f : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(f);
                this.log.debug((Object)("Fact:  " + sessionObject.toString()));
            }
            this.log.debug((Object)"==> End Dump");
        }
    }

    @Override
    public void addData(Data data) {
        this.pendingData.add(data);
    }

    @Override
    public void addData(Collection<Data> data) {
        this.pendingData.addAll(data);
    }

    @Override
    public void addEvent(Event event) {
        this.pendingEvents.add(event);
    }

    @Override
    public void addEvents(Collection<Event> events) {
        this.pendingEvents.addAll(events);
    }

    @Override
    public void addGlobal(String name, Object global) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Add Global " + name + " = " + global));
        }
        this.kSession.setGlobal(name, global);
    }

    @Override
    public void clear() {
        for (FactHandle factHandle : this.kSession.getFactHandles()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Delete " + factHandle));
            }
            this.kSession.delete(factHandle);
        }
    }

    @Override
    public void fire() {
        this.log.debug((Object)"firing rules...");
        int fireCycle = 0;
        while (!this.pendingData.isEmpty() || !this.pendingEvents.isEmpty()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Data found. Firing rules on [" + this.pendingData.size() + "] datums and " + "[" + this.pendingEvents.size() + "] events."));
            }
            TreeSet<Data> batchData = new TreeSet<Data>((SortedSet<Data>)this.pendingData);
            Data previousData = null;
            this.pendingData.clear();
            for (Data data : batchData) {
                if (null == previousData || !data.getId().equals(previousData.getId())) {
                    this.kSession.insert((Object)data);
                    previousData = data;
                    continue;
                }
                this.pendingData.add(data);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Deferring more recent " + data + " until older " + previousData + " is " + "processed"));
            }
            if (!this.pendingData.isEmpty() && this.log.isDebugEnabled()) {
                this.log.debug((Object)("Deferring [" + this.pendingData.size() + "] Datum(s) to next firing !!"));
            }
            batchData.clear();
            TreeSet<Event> batchEvent = new TreeSet<Event>((SortedSet<Event>)this.pendingEvents);
            Event previousEvent = null;
            this.pendingEvents.clear();
            for (Event event : batchEvent) {
                if (null == previousEvent || null != event.getDataId() && !event.getDataId().equals(previousEvent.getDataId())) {
                    this.kSession.insert((Object)event);
                    previousEvent = event;
                    continue;
                }
                this.pendingEvents.add(event);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Deferring more recent " + event + " until older " + previousEvent + " is " + "processed "));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Firing cycle [" + fireCycle + "] - with these facts: "));
                for (FactHandle fact : this.kSession.getFactHandles()) {
                    Object o = this.kSession.getObject(fact);
                    this.log.debug((Object)("Fact:  " + o.toString()));
                }
            }
            this.kSession.fireAllRules();
            ++fireCycle;
        }
    }

    @Override
    public void fireNoData() {
        this.kSession.fireAllRules();
    }

    @Override
    public Object getFact(Object o) {
        Object result = null;
        FactHandle factHandle = this.kSession.getFactHandle(o);
        if (null != factHandle) {
            result = this.kSession.getObject(factHandle);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getFact(" + o.toString() + ")"));
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle fact : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(fact);
                this.log.debug((Object)("Fact:  " + sessionObject.toString()));
            }
            this.log.debug((Object)"==> End Dump");
        }
        return result;
    }

    @Override
    public void removeFact(Object fact) {
        FactHandle factHandle = this.kSession.getFactHandle(fact);
        if (factHandle != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Delete " + factHandle));
            }
            this.kSession.delete(factHandle);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("removeFact(" + fact.toString() + ")"));
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle f : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(f);
                this.log.debug((Object)("Fact:  " + sessionObject.toString()));
            }
            this.log.debug((Object)"==> End Dump");
        }
    }

    @Override
    public void updateFact(Object fact) {
        FactHandle factHandle = this.kSession.getFactHandle(fact);
        if (factHandle != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Update " + factHandle));
            }
            this.kSession.update(factHandle, fact);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("updateFact(" + fact.toString() + ")"));
            this.log.debug((Object)"==> Begin Dump");
            for (FactHandle f : this.kSession.getFactHandles()) {
                Object sessionObject = this.kSession.getObject(f);
                this.log.debug((Object)("Fact:  " + sessionObject.toString()));
            }
            this.log.debug((Object)"==> End Dump");
        }
    }

    @Override
    public void removeFacts(Collection facts) {
        for (Object fact : facts) {
            this.removeFact(fact);
        }
    }

    @Override
    public void removeFacts(final Predicate<Object> factFilter) {
        Collection handles = this.kSession.getFactHandles(new ObjectFilter(){

            public boolean accept(Object object) {
                return factFilter.test(object);
            }
        });
        if (null == handles) {
            return;
        }
        for (FactHandle h : handles) {
            this.removeFact(h);
        }
    }

    @Override
    public void removeGlobal(String name) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Remove Global " + name));
        }
        this.kSession.setGlobal(name, null);
    }

    @Override
    public void reset() {
        this.log.debug((Object)"Reset session");
        this.kSession.dispose();
        this.kSession = this.kc.newKieSession(SESSION_NAME);
    }
}

