/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.paging.AlertComparator;
import org.hawkular.alerts.api.model.paging.EventComparator;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.PageContext;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.EventsCriteria;
import org.hawkular.alerts.engine.impl.CassCluster;
import org.hawkular.alerts.engine.impl.CassStatement;
import org.hawkular.alerts.engine.impl.DataDrivenGroupCacheManager;
import org.hawkular.alerts.engine.impl.TagType;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.jboss.logging.Logger;

@Local(value={AlertsService.class})
@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CassAlertsServiceImpl
implements AlertsService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassAlertsServiceImpl.class);
    @EJB
    AlertsEngine alertsEngine;
    @EJB
    DefinitionsService definitionsService;
    @EJB
    ActionsService actionsService;
    @EJB
    DataDrivenGroupCacheManager dataDrivenGroupCacheManager;

    public void addAlerts(Collection<Alert> alerts) throws Exception {
        if (alerts == null) {
            throw new IllegalArgumentException("Alerts must be not null");
        }
        if (alerts.isEmpty()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding " + alerts.size() + " alerts"));
        }
        Session session = CassCluster.getSession();
        PreparedStatement insertAlert = CassStatement.get(session, CassStatement.INSERT_ALERT);
        PreparedStatement insertAlertTrigger = CassStatement.get(session, CassStatement.INSERT_ALERT_TRIGGER);
        PreparedStatement insertAlertCtime = CassStatement.get(session, CassStatement.INSERT_ALERT_CTIME);
        PreparedStatement insertAlertStatus = CassStatement.get(session, CassStatement.INSERT_ALERT_STATUS);
        PreparedStatement insertAlertSeverity = CassStatement.get(session, CassStatement.INSERT_ALERT_SEVERITY);
        PreparedStatement insertTag = CassStatement.get(session, CassStatement.INSERT_TAG);
        try {
            ArrayList futures = new ArrayList();
            alerts.stream().forEach(a -> {
                futures.add(session.executeAsync((Statement)insertAlert.bind(new Object[]{a.getTenantId(), a.getAlertId(), JsonUtil.toJson((Object)a)})));
                futures.add(session.executeAsync((Statement)insertAlertTrigger.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getTriggerId()})));
                futures.add(session.executeAsync((Statement)insertAlertCtime.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getCtime()})));
                futures.add(session.executeAsync((Statement)insertAlertStatus.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getStatus().name()})));
                futures.add(session.executeAsync((Statement)insertAlertSeverity.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getSeverity().name()})));
                a.getTags().entrySet().stream().forEach(tag -> futures.add(session.executeAsync((Statement)insertTag.bind(new Object[]{a.getTenantId(), TagType.ALERT.name(), tag.getKey(), tag.getValue(), a.getId()}))));
            });
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        List<Event> events = alerts.stream().map(Event::new).collect(Collectors.toList());
        this.persistEvents(events);
    }

    public void persistEvents(Collection<Event> events) throws Exception {
        if (events == null) {
            throw new IllegalArgumentException("Events must be not null");
        }
        if (events.isEmpty()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding " + events.size() + " events"));
        }
        Session session = CassCluster.getSession();
        PreparedStatement insertEvent = CassStatement.get(session, CassStatement.INSERT_EVENT);
        PreparedStatement insertEventCategory = CassStatement.get(session, CassStatement.INSERT_EVENT_CATEGORY);
        PreparedStatement insertEventCtime = CassStatement.get(session, CassStatement.INSERT_EVENT_CTIME);
        PreparedStatement insertEventTrigger = CassStatement.get(session, CassStatement.INSERT_EVENT_TRIGGER);
        PreparedStatement insertTag = CassStatement.get(session, CassStatement.INSERT_TAG);
        try {
            ArrayList futures = new ArrayList();
            events.stream().forEach(e -> {
                futures.add(session.executeAsync((Statement)insertEvent.bind(new Object[]{e.getTenantId(), e.getId(), JsonUtil.toJson((Object)e)})));
                futures.add(session.executeAsync((Statement)insertEventCategory.bind(new Object[]{e.getTenantId(), e.getCategory(), e.getId()})));
                futures.add(session.executeAsync((Statement)insertEventCtime.bind(new Object[]{e.getTenantId(), e.getCtime(), e.getId()})));
                if (null != e.getTrigger()) {
                    futures.add(session.executeAsync((Statement)insertEventTrigger.bind(new Object[]{e.getTenantId(), e.getTrigger().getId(), e.getId()})));
                }
                e.getTags().entrySet().stream().forEach(tag -> futures.add(session.executeAsync((Statement)insertTag.bind(new Object[]{e.getTenantId(), TagType.EVENT.name(), tag.getKey(), tag.getValue(), e.getId()}))));
            });
            Futures.allAsList(futures).get();
        }
        catch (Exception e2) {
            this.msgLog.errorDatabaseException(e2.getMessage());
            throw e2;
        }
    }

    public void addNote(String tenantId, String alertId, String user, String text) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertId)) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        if (this.isEmpty(user) || this.isEmpty(text)) {
            throw new IllegalArgumentException("user or text must be not null");
        }
        Alert alert = this.getAlert(tenantId, alertId, false);
        if (alert == null) {
            return;
        }
        alert.addNote(user, text);
        Session session = CassCluster.getSession();
        PreparedStatement updateAlert = CassStatement.get(session, CassStatement.UPDATE_ALERT);
        if (updateAlert == null) {
            throw new RuntimeException("updateAlert PreparedStatement is null");
        }
        try {
            session.execute((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)alert), alert.getTenantId(), alert.getAlertId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addAlertTags(String tenantId, Collection<String> alertIds, Map<String, String> tags) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            throw new IllegalArgumentException("AlertIds must be not null");
        }
        if (this.isEmpty(tags)) {
            throw new IllegalArgumentException("Tags must be not null");
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> existingAlerts = this.getAlerts(tenantId, criteria, null);
        Session session = CassCluster.getSession();
        PreparedStatement updateAlert = CassStatement.get(session, CassStatement.UPDATE_ALERT);
        PreparedStatement insertTag = CassStatement.get(session, CassStatement.INSERT_TAG);
        try {
            ArrayList futures = new ArrayList();
            existingAlerts.stream().forEach(a -> {
                tags.entrySet().stream().forEach(tag -> {
                    a.addTag((String)tag.getKey(), (String)tag.getValue());
                    futures.add(session.executeAsync((Statement)insertTag.bind(new Object[]{tenantId, TagType.ALERT.name(), tag.getKey(), tag.getValue(), a.getId()})));
                });
                futures.add(session.executeAsync((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)a), tenantId, a.getAlertId()})));
            });
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addEventTags(String tenantId, Collection<String> eventIds, Map<String, String> tags) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(eventIds)) {
            throw new IllegalArgumentException("EventIds must be not null");
        }
        if (this.isEmpty(tags)) {
            throw new IllegalArgumentException("Tags must be not null");
        }
        EventsCriteria criteria = new EventsCriteria();
        criteria.setEventIds(eventIds);
        Page<Event> existingEvents = this.getEvents(tenantId, criteria, null);
        Session session = CassCluster.getSession();
        PreparedStatement updateEvent = CassStatement.get(session, CassStatement.UPDATE_EVENT);
        PreparedStatement insertTag = CassStatement.get(session, CassStatement.INSERT_TAG);
        try {
            ArrayList futures = new ArrayList();
            existingEvents.stream().forEach(a -> {
                tags.entrySet().stream().forEach(tag -> {
                    a.addTag((String)tag.getKey(), (String)tag.getValue());
                    futures.add(session.executeAsync((Statement)insertTag.bind(new Object[]{tenantId, TagType.EVENT.name(), tag.getKey(), tag.getValue(), a.getId()})));
                });
                futures.add(session.executeAsync((Statement)updateEvent.bind(new Object[]{JsonUtil.toJson((Object)a), tenantId, a.getId()})));
            });
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeAlertTags(String tenantId, Collection<String> alertIds, Collection<String> tags) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            throw new IllegalArgumentException("AlertIds must be not null");
        }
        if (this.isEmpty(tags)) {
            throw new IllegalArgumentException("Tags must be not null");
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> existingAlerts = this.getAlerts(tenantId, criteria, null);
        Session session = CassCluster.getSession();
        PreparedStatement updateAlert = CassStatement.get(session, CassStatement.UPDATE_ALERT);
        PreparedStatement deleteTag = CassStatement.get(session, CassStatement.DELETE_TAG);
        try {
            ArrayList futures = new ArrayList();
            existingAlerts.stream().forEach(a -> {
                tags.stream().forEach(tag -> {
                    if (a.getTags().containsKey(tag)) {
                        futures.add(session.executeAsync((Statement)deleteTag.bind(new Object[]{tenantId, TagType.ALERT.name(), tag, a.getTags().get(tag), a.getId()})));
                        a.removeTag(tag);
                    }
                });
                futures.add(session.executeAsync((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)a), tenantId, a.getAlertId()})));
            });
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeEventTags(String tenantId, Collection<String> eventIds, Collection<String> tags) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(eventIds)) {
            throw new IllegalArgumentException("EventIds must be not null");
        }
        if (this.isEmpty(tags)) {
            throw new IllegalArgumentException("Tags must be not null");
        }
        EventsCriteria criteria = new EventsCriteria();
        criteria.setEventIds(eventIds);
        Page<Event> existingEvents = this.getEvents(tenantId, criteria, null);
        Session session = CassCluster.getSession();
        PreparedStatement updateEvent = CassStatement.get(session, CassStatement.UPDATE_EVENT);
        PreparedStatement deleteTag = CassStatement.get(session, CassStatement.DELETE_TAG);
        try {
            ArrayList futures = new ArrayList();
            existingEvents.stream().forEach(e -> {
                tags.stream().forEach(tag -> {
                    if (e.getTags().containsKey(tag)) {
                        futures.add(session.executeAsync((Statement)deleteTag.bind(new Object[]{tenantId, TagType.EVENT.name(), tag, e.getTags().get(tag), e.getId()})));
                        e.removeTag(tag);
                    }
                });
                futures.add(session.executeAsync((Statement)updateEvent.bind(new Object[]{JsonUtil.toJson((Object)e), tenantId, e.getId()})));
            });
            Futures.allAsList(futures).get();
        }
        catch (Exception e2) {
            this.msgLog.errorDatabaseException(e2.getMessage());
            throw e2;
        }
    }

    public Alert getAlert(String tenantId, String alertId, boolean thin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertId)) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        Session session = CassCluster.getSession();
        PreparedStatement selectAlert = CassStatement.get(session, CassStatement.SELECT_ALERT);
        if (selectAlert == null) {
            throw new RuntimeException("selectAlert PreparedStatement is null");
        }
        Alert alert = null;
        try {
            ResultSet rsAlert = session.execute((Statement)selectAlert.bind(new Object[]{tenantId, alertId}));
            Iterator itAlert = rsAlert.iterator();
            if (itAlert.hasNext()) {
                Row row = (Row)itAlert.next();
                alert = (Alert)JsonUtil.fromJson((String)row.getString("payload"), Alert.class, (boolean)thin);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alert;
    }

    public Event getEvent(String tenantId, String eventId, boolean thin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(eventId)) {
            throw new IllegalArgumentException("EventId must be not null");
        }
        Session session = CassCluster.getSession();
        PreparedStatement selectEvent = CassStatement.get(session, CassStatement.SELECT_EVENT);
        if (selectEvent == null) {
            throw new RuntimeException("selectEvent PreparedStatement is null");
        }
        Event event = null;
        try {
            ResultSet rsEvent = session.execute((Statement)selectEvent.bind(new Object[]{tenantId, eventId}));
            Iterator itEvent = rsEvent.iterator();
            if (itEvent.hasNext()) {
                Row row = (Row)itEvent.next();
                event = (Event)JsonUtil.fromJson((String)row.getString("payload"), Event.class, (boolean)thin);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return event;
    }

    public Page<Alert> getAlerts(String tenantId, AlertsCriteria criteria, Pager pager) throws Exception {
        boolean thin;
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        Session session = CassCluster.getSession();
        boolean filter = null != criteria && criteria.hasCriteria();
        boolean bl = thin = null != criteria && criteria.isThin();
        if (filter && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getAlerts criteria: " + criteria.toString()));
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        HashSet<String> alertIds = new HashSet<String>();
        boolean activeFilter = false;
        try {
            if (filter) {
                if (criteria.hasAlertIdCriteria()) {
                    Set<String> alertIdsFilteredByAlerts = this.filterByAlerts(criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByAlerts);
                        if (alertIds.isEmpty()) {
                            return new Page(alerts, (PageContext)pager, 0L);
                        }
                    } else {
                        alertIds.addAll(alertIdsFilteredByAlerts);
                    }
                    activeFilter = true;
                }
                if (criteria.hasTagCriteria()) {
                    Set<String> alertIdsFilteredByTags = this.getIdsByTags(tenantId, TagType.ALERT, criteria.getTags());
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByTags);
                        if (alertIds.isEmpty()) {
                            return new Page(alerts, (PageContext)pager, 0L);
                        }
                    } else {
                        alertIds.addAll(alertIdsFilteredByTags);
                    }
                    activeFilter = true;
                }
                if (criteria.hasTriggerIdCriteria()) {
                    Set<String> alertIdsFilteredByTriggers = this.filterByTriggers(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByTriggers);
                        if (alertIds.isEmpty()) {
                            return new Page(alerts, (PageContext)pager, 0L);
                        }
                    } else {
                        alertIds.addAll(alertIdsFilteredByTriggers);
                    }
                    activeFilter = true;
                }
                if (criteria.hasCTimeCriteria()) {
                    Set<String> alertIdsFilteredByTime = this.filterByCTime(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByTime);
                        if (alertIds.isEmpty()) {
                            return new Page(alerts, (PageContext)pager, 0L);
                        }
                    } else {
                        alertIds.addAll(alertIdsFilteredByTime);
                    }
                    activeFilter = true;
                }
                if (criteria.hasSeverityCriteria()) {
                    Set<String> alertIdsFilteredBySeverity = this.filterBySeverities(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredBySeverity);
                        if (alertIds.isEmpty()) {
                            return new Page(alerts, (PageContext)pager, 0L);
                        }
                    } else {
                        alertIds.addAll(alertIdsFilteredBySeverity);
                    }
                    activeFilter = true;
                }
                if (criteria.hasStatusCriteria()) {
                    Set<String> alertIdsFilteredByStatus = this.filterByStatuses(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByStatus);
                        if (alertIds.isEmpty()) {
                            return new Page(alerts, (PageContext)pager, 0L);
                        }
                    } else {
                        alertIds.addAll(alertIdsFilteredByStatus);
                    }
                    activeFilter = true;
                }
                PreparedStatement selectAlertsByTenantAndAlert = CassStatement.get(session, CassStatement.SELECT_ALERT);
                List futures = alertIds.stream().map(alertId -> session.executeAsync((Statement)selectAlertsByTenantAndAlert.bind(new Object[]{tenantId, alertId}))).collect(Collectors.toList());
                List rsAlerts = (List)Futures.allAsList(futures).get();
                rsAlerts.stream().forEach(r -> {
                    for (Row row : r) {
                        String payload = row.getString("payload");
                        Alert alert = (Alert)JsonUtil.fromJson((String)payload, Alert.class, (boolean)thin);
                        alerts.add(alert);
                    }
                });
            } else {
                PreparedStatement selectAlertsByTenant = CassStatement.get(session, CassStatement.SELECT_ALERTS_BY_TENANT);
                ResultSet rsAlerts = session.execute((Statement)selectAlertsByTenant.bind(new Object[]{tenantId}));
                for (Row row : rsAlerts) {
                    String payload = row.getString("payload");
                    Alert alert = (Alert)JsonUtil.fromJson((String)payload, Alert.class, (boolean)thin);
                    alerts.add(alert);
                }
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return this.preparePage(alerts, pager);
    }

    private Page<Alert> preparePage(List<Alert> alerts, Pager pager) {
        if (pager != null) {
            if (pager.getOrder() != null && !pager.getOrder().isEmpty() && ((Order)pager.getOrder().get(0)).getField() == null) {
                pager = Pager.builder().withPageSize(pager.getPageSize()).withStartPage(pager.getPageNumber()).orderBy(AlertComparator.Field.ALERT_ID.getText(), Order.Direction.DESCENDING).build();
            }
            List<Alert> ordered = alerts;
            if (pager.getOrder() != null) {
                pager.getOrder().stream().filter(o -> o.getField() != null && o.getDirection() != null).forEach(o -> {
                    AlertComparator comparator = new AlertComparator(o.getField(), o.getDirection());
                    Collections.sort(ordered, comparator);
                });
            }
            if (!pager.isLimited() || ordered.size() < pager.getStart()) {
                pager = new Pager(0, ordered.size(), (Iterable)pager.getOrder());
                return new Page(ordered, (PageContext)pager, (long)ordered.size());
            }
            if (pager.getEnd() >= ordered.size()) {
                return new Page(ordered.subList(pager.getStart(), ordered.size()), (PageContext)pager, (long)ordered.size());
            }
            return new Page(ordered.subList(pager.getStart(), pager.getEnd()), (PageContext)pager, (long)ordered.size());
        }
        pager = Pager.builder().withPageSize(alerts.size()).orderBy(AlertComparator.Field.ALERT_ID.getText(), Order.Direction.ASCENDING).build();
        return new Page(alerts, (PageContext)pager, (long)alerts.size());
    }

    private Set<String> filterByAlerts(AlertsCriteria criteria) {
        Set<String> result = Collections.emptySet();
        if (this.isEmpty(criteria.getAlertIds())) {
            if (!this.isEmpty(criteria.getAlertId())) {
                result = new HashSet<String>(1);
                result.add(criteria.getAlertId());
            }
        } else {
            result = new HashSet();
            result.addAll(criteria.getAlertIds());
        }
        return result;
    }

    private Set<String> filterByTriggers(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        Set<String> triggerIds = this.extractTriggerIds(tenantId, criteria);
        if (triggerIds.size() > 0) {
            Session session = CassCluster.getSession();
            PreparedStatement selectAlertsTriggers = CassStatement.get(session, CassStatement.SELECT_ALERT_TRIGGER);
            List futures = triggerIds.stream().map(triggerId -> session.executeAsync((Statement)selectAlertsTriggers.bind(new Object[]{tenantId, triggerId}))).collect(Collectors.toList());
            List rsAlertIdsByTriggerIds = (List)Futures.allAsList(futures).get();
            HashSet<String> alertIds = new HashSet<String>();
            rsAlertIdsByTriggerIds.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertIds.add(alertId);
                }
            });
            result = alertIds;
        }
        return result;
    }

    private Set<String> extractTriggerIds(String tenantId, AlertsCriteria criteria) {
        HashSet<String> triggerIds;
        boolean hasTriggerId = !this.isEmpty(criteria.getTriggerId());
        boolean hasTriggerIds = !this.isEmpty(criteria.getTriggerIds());
        Set<Object> set = triggerIds = hasTriggerId || hasTriggerIds ? new HashSet() : Collections.emptySet();
        if (!hasTriggerIds) {
            if (hasTriggerId) {
                triggerIds.add(criteria.getTriggerId());
            }
        } else {
            for (String triggerId : criteria.getTriggerIds()) {
                if (this.isEmpty(triggerId)) continue;
                triggerIds.add(triggerId);
            }
        }
        return triggerIds;
    }

    private Set<String> filterByCTime(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        if (criteria.getStartTime() != null || criteria.getEndTime() != null) {
            BoundStatement boundCtime;
            result = new HashSet();
            Session session = CassCluster.getSession();
            if (criteria.getStartTime() != null && criteria.getEndTime() != null) {
                PreparedStatement selectAlertCTimeStartEnd = CassStatement.get(session, CassStatement.SELECT_ALERT_CTIME_START_END);
                boundCtime = selectAlertCTimeStartEnd.bind(new Object[]{tenantId, criteria.getStartTime(), criteria.getEndTime()});
            } else if (criteria.getStartTime() != null) {
                PreparedStatement selectAlertCTimeStart = CassStatement.get(session, CassStatement.SELECT_ALERT_CTIME_START);
                boundCtime = selectAlertCTimeStart.bind(new Object[]{tenantId, criteria.getStartTime()});
            } else {
                PreparedStatement selectAlertCTimeEnd = CassStatement.get(session, CassStatement.SELECT_ALERT_CTIME_END);
                boundCtime = selectAlertCTimeEnd.bind(new Object[]{tenantId, criteria.getEndTime()});
            }
            ResultSet rsAlertsCtimes = session.execute((Statement)boundCtime);
            for (Row row : rsAlertsCtimes) {
                String alertId = row.getString("alertId");
                result.add(alertId);
            }
        }
        return result;
    }

    private Set<String> filterByStatuses(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        HashSet<Alert.Status> statuses = new HashSet<Alert.Status>();
        if (this.isEmpty(criteria.getStatusSet())) {
            if (criteria.getStatus() != null) {
                statuses.add(criteria.getStatus());
            }
        } else {
            statuses.addAll(criteria.getStatusSet());
        }
        if (statuses.size() > 0) {
            Session session = CassCluster.getSession();
            PreparedStatement selectAlertStatusByTenantAndStatus = CassStatement.get(session, CassStatement.SELECT_ALERT_STATUS);
            List futures = statuses.stream().map(status -> session.executeAsync((Statement)selectAlertStatusByTenantAndStatus.bind(new Object[]{tenantId, status.name()}))).collect(Collectors.toList());
            List rsAlertStatuses = (List)Futures.allAsList(futures).get();
            HashSet<String> alertIds = new HashSet<String>();
            rsAlertStatuses.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertIds.add(alertId);
                }
            });
            result = alertIds;
        }
        return result;
    }

    private Set<String> filterBySeverities(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        HashSet<Severity> severities = new HashSet<Severity>();
        if (this.isEmpty(criteria.getSeverities())) {
            if (criteria.getSeverity() != null) {
                severities.add(criteria.getSeverity());
            }
        } else {
            severities.addAll(criteria.getSeverities());
        }
        if (severities.size() > 0) {
            Session session = CassCluster.getSession();
            PreparedStatement selectAlertSeverityByTenantAndSeverity = CassStatement.get(session, CassStatement.SELECT_ALERT_SEVERITY);
            List futures = severities.stream().map(severity -> session.executeAsync((Statement)selectAlertSeverityByTenantAndSeverity.bind(new Object[]{tenantId, severity.name()}))).collect(Collectors.toList());
            List rsAlertSeverities = (List)Futures.allAsList(futures).get();
            HashSet<String> alertIds = new HashSet<String>();
            rsAlertSeverities.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertIds.add(alertId);
                }
            });
            result = alertIds;
        }
        return result;
    }

    private Set<String> filterByEvents(EventsCriteria criteria) {
        Set<String> result = Collections.emptySet();
        if (this.isEmpty(criteria.getEventIds())) {
            if (!this.isEmpty(criteria.getEventId())) {
                result = new HashSet<String>(1);
                result.add(criteria.getEventId());
            }
        } else {
            result = new HashSet();
            result.addAll(criteria.getEventIds());
        }
        return result;
    }

    private Set<String> getIdsByTags(String tenantId, TagType tagType, Map<String, String> tags) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        Session session = CassCluster.getSession();
        PreparedStatement selectTagsByName = CassStatement.get(session, CassStatement.SELECT_TAGS_BY_NAME);
        PreparedStatement selectTagsByNameAndValue = CassStatement.get(session, CassStatement.SELECT_TAGS_BY_NAME_AND_VALUE);
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            boolean nameOnly = "*".equals(tag.getValue());
            BoundStatement bs = nameOnly ? selectTagsByName.bind(new Object[]{tenantId, tagType.name(), tag.getKey()}) : selectTagsByNameAndValue.bind(new Object[]{tenantId, tagType.name(), tag.getKey(), tag.getValue()});
            futures.add(session.executeAsync((Statement)bs));
        }
        List rsTags = (List)Futures.allAsList(futures).get();
        rsTags.stream().forEach(r -> {
            for (Row row : r) {
                ids.add(row.getString("id"));
            }
        });
        return ids;
    }

    public Page<Event> getEvents(String tenantId, EventsCriteria criteria, Pager pager) throws Exception {
        boolean thin;
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        Session session = CassCluster.getSession();
        boolean filter = null != criteria && criteria.hasCriteria();
        boolean bl = thin = null != criteria && criteria.isThin();
        if (filter && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getEvents criteria: " + criteria.toString()));
        }
        ArrayList<Event> events = new ArrayList<Event>();
        HashSet<String> eventIds = new HashSet<String>();
        boolean activeFilter = false;
        try {
            if (filter) {
                if (criteria.hasEventIdCriteria()) {
                    Set<String> idsFilteredByEvents = this.filterByEvents(criteria);
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByEvents);
                        if (eventIds.isEmpty()) {
                            return new Page(events, (PageContext)pager, 0L);
                        }
                    } else {
                        eventIds.addAll(idsFilteredByEvents);
                    }
                    activeFilter = true;
                }
                if (criteria.hasTagCriteria()) {
                    Set<String> idsFilteredByTags = this.getIdsByTags(tenantId, TagType.EVENT, criteria.getTags());
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByTags);
                        if (eventIds.isEmpty()) {
                            return new Page(events, (PageContext)pager, 0L);
                        }
                    } else {
                        eventIds.addAll(idsFilteredByTags);
                    }
                    activeFilter = true;
                }
                if (criteria.hasTriggerIdCriteria()) {
                    Set<String> idsFilteredByTriggers = this.filterByTriggers(tenantId, criteria);
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByTriggers);
                        if (eventIds.isEmpty()) {
                            return new Page(events, (PageContext)pager, 0L);
                        }
                    } else {
                        eventIds.addAll(idsFilteredByTriggers);
                    }
                    activeFilter = true;
                }
                if (criteria.hasCTimeCriteria()) {
                    Set<String> idsFilteredByTime = this.filterByCTime(tenantId, criteria);
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByTime);
                        if (eventIds.isEmpty()) {
                            return new Page(events, (PageContext)pager, 0L);
                        }
                    } else {
                        eventIds.addAll(idsFilteredByTime);
                    }
                    activeFilter = true;
                }
                if (criteria.hasCategoryCriteria()) {
                    Set<String> idsFilteredByCategory = this.filterByCategories(tenantId, criteria);
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByCategory);
                        if (eventIds.isEmpty()) {
                            return new Page(events, (PageContext)pager, 0L);
                        }
                    } else {
                        eventIds.addAll(idsFilteredByCategory);
                    }
                    activeFilter = true;
                }
                PreparedStatement selectEvent = CassStatement.get(session, CassStatement.SELECT_EVENT);
                List futures = eventIds.stream().map(id -> session.executeAsync((Statement)selectEvent.bind(new Object[]{tenantId, id}))).collect(Collectors.toList());
                List rsEvents = (List)Futures.allAsList(futures).get();
                rsEvents.stream().forEach(r -> {
                    for (Row row : r) {
                        String payload = row.getString("payload");
                        Event event = (Event)JsonUtil.fromJson((String)payload, Event.class, (boolean)thin);
                        events.add(event);
                    }
                });
            } else {
                PreparedStatement selectEventsByTenant = CassStatement.get(session, CassStatement.SELECT_EVENTS_BY_TENANT);
                ResultSet rsEvents = session.execute((Statement)selectEventsByTenant.bind(new Object[]{tenantId}));
                for (Row row : rsEvents) {
                    String payload = row.getString("payload");
                    Event event = (Event)JsonUtil.fromJson((String)payload, Event.class, (boolean)thin);
                    events.add(event);
                }
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return this.prepareEventsPage(events, pager);
    }

    private Page<Event> prepareEventsPage(List<Event> events, Pager pager) {
        if (pager != null) {
            if (pager.getOrder() != null && !pager.getOrder().isEmpty() && ((Order)pager.getOrder().get(0)).getField() == null) {
                pager = Pager.builder().withPageSize(pager.getPageSize()).withStartPage(pager.getPageNumber()).orderBy(EventComparator.Field.ID.getName(), Order.Direction.DESCENDING).build();
            }
            List<Event> ordered = events;
            if (pager.getOrder() != null) {
                pager.getOrder().stream().filter(o -> o.getField() != null && o.getDirection() != null).forEach(o -> {
                    EventComparator comparator = new EventComparator(o.getField(), o.getDirection());
                    Collections.sort(ordered, comparator);
                });
            }
            if (!pager.isLimited() || ordered.size() < pager.getStart()) {
                pager = new Pager(0, ordered.size(), (Iterable)pager.getOrder());
                return new Page(ordered, (PageContext)pager, (long)ordered.size());
            }
            if (pager.getEnd() >= ordered.size()) {
                return new Page(ordered.subList(pager.getStart(), ordered.size()), (PageContext)pager, (long)ordered.size());
            }
            return new Page(ordered.subList(pager.getStart(), pager.getEnd()), (PageContext)pager, (long)ordered.size());
        }
        pager = Pager.builder().withPageSize(events.size()).orderBy(EventComparator.Field.ID.getName(), Order.Direction.ASCENDING).build();
        return new Page(events, (PageContext)pager, (long)events.size());
    }

    private Set<String> filterByTriggers(String tenantId, EventsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        Set<String> triggerIds = this.extractTriggerIds(tenantId, criteria);
        if (triggerIds.size() > 0) {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            Session session = CassCluster.getSession();
            PreparedStatement selectEventsTriggers = CassStatement.get(session, CassStatement.SELECT_EVENT_TRIGGER);
            for (String triggerId : triggerIds) {
                if (this.isEmpty(triggerId)) continue;
                futures.add(session.executeAsync((Statement)selectEventsTriggers.bind(new Object[]{tenantId, triggerId})));
            }
            List rsIdsByTriggerIds = (List)Futures.allAsList(futures).get();
            HashSet<String> eventIds = new HashSet<String>();
            rsIdsByTriggerIds.stream().forEach(r -> {
                for (Row row : r) {
                    String eventId = row.getString("id");
                    eventIds.add(eventId);
                }
            });
            result = eventIds;
        }
        return result;
    }

    private Set<String> extractTriggerIds(String tenantId, EventsCriteria criteria) {
        HashSet<String> triggerIds;
        boolean hasTriggerId = !this.isEmpty(criteria.getTriggerId());
        boolean hasTriggerIds = !this.isEmpty(criteria.getTriggerIds());
        Set<Object> set = triggerIds = hasTriggerId || hasTriggerIds ? new HashSet() : Collections.emptySet();
        if (!hasTriggerIds) {
            if (hasTriggerId) {
                triggerIds.add(criteria.getTriggerId());
            }
        } else {
            for (String triggerId : criteria.getTriggerIds()) {
                if (this.isEmpty(triggerId)) continue;
                triggerIds.add(triggerId);
            }
        }
        return triggerIds;
    }

    private Set<String> filterByCTime(String tenantId, EventsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        if (criteria.getStartTime() != null || criteria.getEndTime() != null) {
            BoundStatement boundCtime;
            result = new HashSet();
            Session session = CassCluster.getSession();
            if (criteria.getStartTime() != null && criteria.getEndTime() != null) {
                PreparedStatement selectEventCTimeStartEnd = CassStatement.get(session, CassStatement.SELECT_EVENT_CTIME_START_END);
                boundCtime = selectEventCTimeStartEnd.bind(new Object[]{tenantId, criteria.getStartTime(), criteria.getEndTime()});
            } else if (criteria.getStartTime() != null) {
                PreparedStatement selectEventCTimeStart = CassStatement.get(session, CassStatement.SELECT_EVENT_CTIME_START);
                boundCtime = selectEventCTimeStart.bind(new Object[]{tenantId, criteria.getStartTime()});
            } else {
                PreparedStatement selectEventCTimeEnd = CassStatement.get(session, CassStatement.SELECT_EVENT_CTIME_END);
                boundCtime = selectEventCTimeEnd.bind(new Object[]{tenantId, criteria.getEndTime()});
            }
            ResultSet rsIdsCtimes = session.execute((Statement)boundCtime);
            for (Row row : rsIdsCtimes) {
                String eventId = row.getString("id");
                result.add(eventId);
            }
        }
        return result;
    }

    private Set<String> filterByCategories(String tenantId, EventsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        HashSet<String> categories = new HashSet<String>();
        if (this.isEmpty(criteria.getCategories())) {
            if (criteria.getCategory() != null) {
                categories.add(criteria.getCategory());
            }
        } else {
            categories.addAll(criteria.getCategories());
        }
        if (categories.size() > 0) {
            Session session = CassCluster.getSession();
            PreparedStatement selectEventCategory = CassStatement.get(session, CassStatement.SELECT_EVENT_CATEGORY);
            List futures = categories.stream().map(category -> session.executeAsync((Statement)selectEventCategory.bind(new Object[]{tenantId, category}))).collect(Collectors.toList());
            List rsAlertStatuses = (List)Futures.allAsList(futures).get();
            HashSet<String> eventIds = new HashSet<String>();
            rsAlertStatuses.stream().forEach(r -> {
                for (Row row : r) {
                    String eventId = row.getString("id");
                    eventIds.add(eventId);
                }
            });
            result = eventIds;
        }
        return result;
    }

    public void ackAlerts(String tenantId, Collection<String> alertIds, String ackBy, String ackNotes) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        if (this.isEmpty(ackBy)) {
            ackBy = "unknown";
        }
        if (this.isEmpty(ackNotes)) {
            ackNotes = "none";
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> alertsToAck = this.getAlerts(tenantId, criteria, null);
        for (Alert a : alertsToAck) {
            a.setStatus(Alert.Status.ACKNOWLEDGED);
            a.setAckBy(ackBy);
            a.setAckTime(System.currentTimeMillis());
            a.addNote(ackBy, ackNotes);
            this.updateAlertStatus(a);
            this.sendAction(a);
        }
    }

    public int deleteAlerts(String tenantId, AlertsCriteria criteria) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (null == criteria) {
            throw new IllegalArgumentException("Criteria must be not null");
        }
        criteria.setThin(true);
        Page<Alert> alertsToDelete = this.getAlerts(tenantId, criteria, null);
        if (alertsToDelete.isEmpty()) {
            return 0;
        }
        Session session = CassCluster.getSession();
        PreparedStatement deleteAlert = CassStatement.get(session, CassStatement.DELETE_ALERT);
        PreparedStatement deleteAlertCtime = CassStatement.get(session, CassStatement.DELETE_ALERT_CTIME);
        PreparedStatement deleteAlertSeverity = CassStatement.get(session, CassStatement.DELETE_ALERT_SEVERITY);
        PreparedStatement deleteAlertStatus = CassStatement.get(session, CassStatement.DELETE_ALERT_STATUS);
        PreparedStatement deleteAlertTrigger = CassStatement.get(session, CassStatement.DELETE_ALERT_TRIGGER);
        if (deleteAlert == null || deleteAlertCtime == null || deleteAlertSeverity == null || deleteAlertStatus == null || deleteAlertTrigger == null) {
            throw new RuntimeException("delete*Alerts PreparedStatement is null");
        }
        for (Alert a : alertsToDelete) {
            String id = a.getAlertId();
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(session.executeAsync((Statement)deleteAlert.bind(new Object[]{tenantId, id})));
            futures.add(session.executeAsync((Statement)deleteAlertCtime.bind(new Object[]{tenantId, a.getCtime(), id})));
            futures.add(session.executeAsync((Statement)deleteAlertSeverity.bind(new Object[]{tenantId, a.getSeverity().name(), id})));
            futures.add(session.executeAsync((Statement)deleteAlertStatus.bind(new Object[]{tenantId, a.getStatus().name(), id})));
            futures.add(session.executeAsync((Statement)deleteAlertTrigger.bind(new Object[]{tenantId, a.getTriggerId(), id})));
            Futures.allAsList(futures).get();
        }
        return alertsToDelete.size();
    }

    public int deleteEvents(String tenantId, EventsCriteria criteria) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (null == criteria) {
            throw new IllegalArgumentException("Criteria must be not null");
        }
        criteria.setThin(true);
        Page<Event> eventsToDelete = this.getEvents(tenantId, criteria, null);
        if (eventsToDelete.isEmpty()) {
            return 0;
        }
        Session session = CassCluster.getSession();
        PreparedStatement deleteEvent = CassStatement.get(session, CassStatement.DELETE_EVENT);
        PreparedStatement deleteEventCategory = CassStatement.get(session, CassStatement.DELETE_EVENT_CATEGORY);
        PreparedStatement deleteEventCTime = CassStatement.get(session, CassStatement.DELETE_EVENT_CTIME);
        PreparedStatement deleteEventTrigger = CassStatement.get(session, CassStatement.DELETE_EVENT_TRIGGER);
        if (deleteEvent == null || deleteEventCTime == null || deleteEventCategory == null || deleteEventTrigger == null) {
            throw new RuntimeException("delete*Events PreparedStatement is null");
        }
        for (Event e : eventsToDelete) {
            String id = e.getId();
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(session.executeAsync((Statement)deleteEvent.bind(new Object[]{tenantId, id})));
            futures.add(session.executeAsync((Statement)deleteEventCategory.bind(new Object[]{tenantId, e.getCategory(), id})));
            futures.add(session.executeAsync((Statement)deleteEventCTime.bind(new Object[]{tenantId, e.getCtime(), id})));
            if (null != e.getTrigger()) {
                futures.add(session.executeAsync((Statement)deleteEventTrigger.bind(new Object[]{tenantId, e.getTrigger().getId(), id})));
            }
            Futures.allAsList(futures).get();
        }
        return eventsToDelete.size();
    }

    public void resolveAlerts(String tenantId, Collection<String> alertIds, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        if (this.isEmpty(resolvedBy)) {
            resolvedBy = "unknown";
        }
        if (this.isEmpty(resolvedNotes)) {
            resolvedNotes = "none";
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> alertsToResolve = this.getAlerts(tenantId, criteria, null);
        for (Alert a2 : alertsToResolve) {
            a2.setStatus(Alert.Status.RESOLVED);
            a2.setResolvedBy(resolvedBy);
            a2.setResolvedTime(System.currentTimeMillis());
            a2.addNote(resolvedBy, resolvedNotes);
            a2.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a2);
            this.sendAction(a2);
        }
        Set triggerIds = alertsToResolve.stream().map(a -> a.getTriggerId()).collect(Collectors.toSet());
        triggerIds.stream().forEach(tid -> this.handleResolveOptions(tenantId, (String)tid, true));
    }

    public void resolveAlertsForTrigger(String tenantId, String triggerId, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.isEmpty(resolvedBy)) {
            resolvedBy = "unknown";
        }
        if (this.isEmpty(resolvedNotes)) {
            resolvedNotes = "none";
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setTriggerId(triggerId);
        criteria.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
        Page<Alert> alertsToResolve = this.getAlerts(tenantId, criteria, null);
        for (Alert a : alertsToResolve) {
            a.setStatus(Alert.Status.RESOLVED);
            a.setResolvedBy(resolvedBy);
            a.setResolvedTime(System.currentTimeMillis());
            a.addNote(resolvedBy, resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            this.updateAlertStatus(a);
            this.sendAction(a);
        }
        this.handleResolveOptions(tenantId, triggerId, false);
    }

    private Alert updateAlertStatus(Alert alert) throws Exception {
        if (alert == null || alert.getAlertId() == null || alert.getAlertId().isEmpty()) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        Session session = CassCluster.getSession();
        try {
            PreparedStatement deleteAlertStatus = CassStatement.get(session, CassStatement.DELETE_ALERT_STATUS);
            PreparedStatement insertAlertStatus = CassStatement.get(session, CassStatement.INSERT_ALERT_STATUS);
            PreparedStatement updateAlert = CassStatement.get(session, CassStatement.UPDATE_ALERT);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            for (Alert.Status statusToDelete : EnumSet.complementOf(EnumSet.of(alert.getStatus()))) {
                futures.add(session.executeAsync((Statement)deleteAlertStatus.bind(new Object[]{alert.getTenantId(), statusToDelete.name(), alert.getAlertId()})));
            }
            futures.add(session.executeAsync((Statement)insertAlertStatus.bind(new Object[]{alert.getTenantId(), alert.getAlertId(), alert.getStatus().name()})));
            futures.add(session.executeAsync((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)alert), alert.getTenantId(), alert.getAlertId()})));
            List list = (List)Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alert;
    }

    private void handleResolveOptions(String tenantId, String triggerId, boolean checkIfAllResolved) {
        try {
            Trigger loadedTrigger;
            Trigger trigger = this.definitionsService.getTrigger(tenantId, triggerId);
            if (null == trigger) {
                return;
            }
            boolean setEnabled = trigger.isAutoEnable() && !trigger.isEnabled();
            boolean setFiring = trigger.isAutoResolve();
            if (setFiring && null != (loadedTrigger = this.alertsEngine.getLoadedTrigger(trigger)) && Mode.FIRING == loadedTrigger.getMode()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Ignoring setFiring, loaded Trigger already in firing mode " + loadedTrigger.toString()));
                }
                setFiring = false;
            }
            if (!setEnabled && !setFiring) {
                return;
            }
            boolean allResolved = true;
            if (checkIfAllResolved) {
                AlertsCriteria ac = new AlertsCriteria();
                ac.setTriggerId(triggerId);
                ac.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
                Page<Alert> unresolvedAlerts = this.getAlerts(tenantId, ac, new Pager(0, 1, new Order[]{Order.unspecified()}));
                allResolved = unresolvedAlerts.isEmpty();
            }
            if (!allResolved) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Ignoring resolveOptions, not all Alerts for Trigger " + trigger.toString() + " are resolved"));
                }
                return;
            }
            if (setEnabled) {
                trigger.setEnabled(true);
                this.definitionsService.updateTrigger(tenantId, trigger);
            } else {
                this.alertsEngine.reloadTrigger(tenantId, triggerId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
        }
    }

    public void sendData(Data data) throws Exception {
        this.sendData(Collections.singleton(data));
    }

    public void sendData(Collection<Data> data) throws Exception {
        this.checkDataDrivenGroupTriggers(data);
        this.alertsEngine.sendData(data);
    }

    private void checkDataDrivenGroupTriggers(Collection<Data> data) throws Exception {
        if (!this.dataDrivenGroupCacheManager.isCacheActive()) {
            return;
        }
        for (Data d : data) {
            if (this.isEmpty(d.getSource())) continue;
            String tenantId = d.getTenantId();
            String dataId = d.getId();
            String dataSource = d.getSource();
            Set<String> groupTriggerIds = this.dataDrivenGroupCacheManager.needsSourceMember(tenantId, dataId, dataSource);
            for (String groupTriggerId : groupTriggerIds) {
                this.definitionsService.addDataDrivenMemberTrigger(tenantId, groupTriggerId, dataSource);
            }
        }
    }

    public void addEvents(Collection<Event> events) throws Exception {
        if (null == events || events.isEmpty()) {
            return;
        }
        this.persistEvents(events);
        this.alertsEngine.sendEvents(events);
    }

    private void sendAction(Alert a) {
        if (this.actionsService != null && a != null && a.getTrigger() != null && a.getTrigger().getActions() != null) {
            a.getTrigger().getActions().stream().forEach(triggerAction -> this.actionsService.send(triggerAction, (Event)a));
        }
    }

    private boolean isEmpty(Map<?, ?> m) {
        return null == m || m.isEmpty();
    }

    private boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }
}

