/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.data.CacheKey;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.PropertiesService;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.jboss.logging.Logger;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CacheManager {
    private final Logger log = Logger.getLogger(CacheManager.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String PUBLISH_REQUIRE_PREFIX_PROP = "hawkular-alerts.publish-require-prefix";
    private static final String PUBLISH_REQUIRE_PREFIX_ENV = "PUBLISH_REQUIRE_PREFIX";
    private static final String DISABLE_PUBLISH_FILTERING_PROP = "hawkular-alerts.disable-publish-filtering";
    private static final String DISABLE_PUBLISH_FILTERING_ENV = "DISABLE_PUBLISH_FILTERING";
    private static final String RESET_PUBLISH_CACHE_PROP = "hawkular-alerts.reset-publish-cache";
    private static final String RESET_PUBLISH_CACHE_ENV = "RESET_PUBLISH_CACHE";
    private static final Set<String> DATA_ID_PREFIXES = new HashSet<String>();
    private static boolean PUBLISH_REQUIRE_PREFIX;
    @EJB
    PropertiesService properties;
    @EJB
    DefinitionsService definitions;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/publish")
    private Cache<CacheKey, String> publishCache;

    @PostConstruct
    public void init() {
        PUBLISH_REQUIRE_PREFIX = Boolean.parseBoolean(this.properties.getProperty(PUBLISH_REQUIRE_PREFIX_PROP, PUBLISH_REQUIRE_PREFIX_ENV, "true"));
        boolean disablePublish = Boolean.parseBoolean(this.properties.getProperty(DISABLE_PUBLISH_FILTERING_PROP, DISABLE_PUBLISH_FILTERING_ENV, "false"));
        boolean resetCache = Boolean.parseBoolean(this.properties.getProperty(RESET_PUBLISH_CACHE_PROP, RESET_PUBLISH_CACHE_ENV, "true"));
        if (!disablePublish) {
            if (resetCache) {
                this.msgLog.warnClearPublishCache();
                this.publishCache.clear();
            }
            this.msgLog.infoInitPublishCache();
            this.updateActiveIds();
            this.definitions.registerListener(e -> this.updateActiveIds(), DefinitionsEvent.Type.CONDITION_CHANGE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.TRIGGER_REMOVE});
        } else {
            this.msgLog.warnDisabledPublishCache();
        }
    }

    public Set<DataIdKey> getActiveDataIds() {
        return Collections.emptySet();
    }

    public Set<DataIdKey> getActiveAvailabilityIds() {
        return Collections.emptySet();
    }

    private synchronized void updateActiveIds() {
        try {
            CacheSet currentlyPublished = this.publishCache.keySet();
            this.log.debugf("Published before update=%s", currentlyPublished.size());
            if (this.log.isTraceEnabled()) {
                this.publishCache.entrySet().stream().forEach(e -> this.log.tracef("Published: %s", e.getValue()));
            }
            Collection conditions = this.definitions.getAllConditions();
            HashSet<CacheKey> activeKeys = new HashSet<CacheKey>();
            for (Condition c : conditions) {
                if (c instanceof ExternalCondition) continue;
                DataIdKey dataIdKey = new DataIdKey(c.getTenantId(), c.getDataId());
                CacheKey cacheKey = dataIdKey.getCacheKey();
                if (dataIdKey.isValid() && !activeKeys.contains(cacheKey)) {
                    activeKeys.add(cacheKey);
                    if (!currentlyPublished.contains((Object)cacheKey)) {
                        this.publish(dataIdKey);
                    }
                }
                if (!(c instanceof CompareCondition)) continue;
                String data2Id = ((CompareCondition)c).getData2Id();
                DataIdKey dataIdKey2 = new DataIdKey(c.getTenantId(), data2Id);
                CacheKey cacheKey2 = dataIdKey2.getCacheKey();
                if (!dataIdKey2.isValid() || activeKeys.contains(cacheKey2)) continue;
                activeKeys.add(cacheKey2);
                if (currentlyPublished.contains((Object)cacheKey2)) continue;
                this.publish(dataIdKey2);
            }
            HashSet<CacheKey> doomedKeys = new HashSet<CacheKey>();
            if (!currentlyPublished.isEmpty()) {
                currentlyPublished.stream().filter(k -> !activeKeys.contains(k)).forEach(k -> doomedKeys.add((CacheKey)k));
            }
            this.unpublish(doomedKeys);
            this.log.debugf("Published after update=%s", this.publishCache.size());
            if (this.log.isTraceEnabled()) {
                this.publishCache.entrySet().stream().forEach(e -> this.log.tracef("Published: %s", e.getValue()));
            }
        }
        catch (Exception e2) {
            this.log.error((Object)"FAILED to load conditions to create Id filters. All data being forwarded to alerting!", (Throwable)e2);
            return;
        }
    }

    private void publish(DataIdKey dataIdKey) {
        CacheKey cacheKey = dataIdKey.getCacheKey();
        if (cacheKey != null && this.publishCache != null) {
            this.log.debugf("Publishing:%s ", (Object)cacheKey);
            this.publishCache.put((Object)cacheKey, (Object)dataIdKey.getDataId());
        }
    }

    private void unpublish(Set<CacheKey> cacheKeys) {
        for (CacheKey cacheKey : cacheKeys) {
            if (cacheKey == null || this.publishCache == null) continue;
            this.log.debugf("UN-Publishing:%s ", (Object)cacheKey);
            this.publishCache.remove((Object)cacheKey);
        }
    }

    static {
        DATA_ID_PREFIXES.add("hm_a_");
        DATA_ID_PREFIXES.add("hm_c_");
        DATA_ID_PREFIXES.add("hm_cr_");
        DATA_ID_PREFIXES.add("hm_g_");
        DATA_ID_PREFIXES.add("hm_gr_");
        DATA_ID_PREFIXES.add("hm_s_");
        DATA_ID_PREFIXES.add("hm_u_");
    }

    public static class DataIdKey {
        private final Logger log = Logger.getLogger(DataIdKey.class);
        private String tenantId;
        private String dataId;
        private CacheKey cacheKey;

        public DataIdKey(String tenantId, String dataId) {
            this.tenantId = tenantId;
            this.dataId = dataId;
            String prefix = null;
            String suffix = null;
            for (String p : DATA_ID_PREFIXES) {
                if (!dataId.startsWith(p)) continue;
                prefix = p;
                suffix = dataId.substring(p.length());
                break;
            }
            if (null != prefix) {
                this.cacheKey = new CacheKey(tenantId, prefix, suffix);
            } else if (!PUBLISH_REQUIRE_PREFIX) {
                this.log.debugf("Allowing Non-Prefixed Metric DataId: [%s]", (Object)dataId);
                this.cacheKey = new CacheKey(tenantId, "", dataId);
            } else {
                this.log.debugf("Ignoring Non-Prefixed Metric DataId: [%s]", (Object)dataId);
            }
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getDataId() {
            return this.dataId;
        }

        public CacheKey getCacheKey() {
            return this.cacheKey;
        }

        public boolean isValid() {
            return this.cacheKey != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataIdKey dataIdKey = (DataIdKey)o;
            if (this.tenantId != null ? !this.tenantId.equals(dataIdKey.tenantId) : dataIdKey.tenantId != null) {
                return false;
            }
            return this.dataId != null ? this.dataId.equals(dataIdKey.dataId) : dataIdKey.dataId == null;
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.dataId != null ? this.dataId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "DataIdKey [tenantId=" + this.tenantId + ", dataId=" + this.dataId + "]";
        }
    }
}

