/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.cache;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import org.hawkular.alerts.api.model.data.CacheKey;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Event;
import org.infinispan.Cache;

@ApplicationScoped
public class CacheClient {
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/publish")
    private Cache<CacheKey, String> cache;

    public Set<CacheKey> keySet() {
        return this.cache.keySet();
    }

    public boolean containsKey(CacheKey key) {
        return this.cache.containsKey((Object)key);
    }

    public String get(CacheKey key) {
        return (String)this.cache.get((Object)key);
    }

    public Collection<Data> filterData(Collection<Data> data) {
        CacheKey tester = new CacheKey("", "");
        return data.stream().filter(d -> this.cache.containsKey((Object)this.fillKey(tester, (Data)d))).collect(Collectors.toList());
    }

    public Collection<Event> filterEvents(Collection<Event> events) {
        CacheKey tester = new CacheKey("", "");
        return events.stream().filter(e -> this.cache.containsKey((Object)this.fillKey(tester, (Event)e))).collect(Collectors.toList());
    }

    private CacheKey fillKey(CacheKey key, Data data) {
        key.setTenantId(data.getTenantId());
        key.setDataId(data.getId());
        return key;
    }

    private CacheKey fillKey(CacheKey key, Event event) {
        key.setTenantId(event.getTenantId());
        key.setDataId(event.getDataId());
        return key;
    }
}

