/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SocketOptions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.AccessTimeout;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.inject.Produces;
import javax.net.ssl.SSLContext;
import org.cassalog.core.Cassalog;
import org.cassalog.core.CassalogBuilder;
import org.hawkular.alerts.engine.impl.AlertProperties;
import org.hawkular.alerts.engine.impl.CassClusterSession;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class CassCluster {
    private static final Logger log = Logger.getLogger(CassCluster.class);
    private static final String ALERTS_CASSANDRA_PORT = "hawkular-alerts.cassandra-cql-port";
    private static final String ALERTS_CASSANDRA_PORT_ENV = "CASSANDRA_CQL_PORT";
    private static final String ALERTS_CASSANDRA_NODES = "hawkular-alerts.cassandra-nodes";
    private static final String ALERTS_CASSANDRA_NODES_ENV = "CASSANDRA_NODES";
    private static final String ALERTS_CASSANDRA_KEYSPACE = "hawkular-alerts.cassandra-keyspace";
    private static final String ALERTS_CASSANDRA_RETRY_ATTEMPTS = "hawkular-alerts.cassandra-retry-attempts";
    private static final String ALERTS_CASSANDRA_RETRY_TIMEOUT = "hawkular-alerts.cassandra-retry-timeout";
    private static final String ALERTS_CASSANDRA_CONNECT_TIMEOUT = "hawkular-alerts.cassandra-connect-timeout";
    private static final String ALERTS_CASSANDRA_CONNECT_TIMEOUT_ENV = "CASSANDRA_CONNECT_TIMEOUT";
    private static final String ALERTS_CASSANDRA_READ_TIMEOUT = "hawkular-alerts.cassandra-read-timeout";
    private static final String ALERTS_CASSANDRA_READ_TIMEOUT_ENV = "CASSANDRA_READ_TIMEOUT";
    private static final String ALERTS_CASSANDRA_OVERWRITE = "hawkular-alerts.cassandra-overwrite";
    private static final String ALERTS_CASSANDRA_OVERWRITE_ENV = "CASSANDRA_OVERWRITE";
    private static final String ALERTS_CASSANDRA_USESSL = "hawkular-alerts.cassandra-use-ssl";
    private static final String ALERTS_CASSANDRA_USESSL_ENV = "CASSANDRA_USESSL";
    private int attempts;
    private int timeout;
    private String cqlPort;
    private String nodes;
    private int connTimeout;
    private int readTimeout;
    private boolean overwrite = false;
    private String keyspace;
    private boolean cassandraUseSSL;
    private Cluster cluster = null;
    private Session session = null;
    private boolean initialized = false;
    private boolean distributed = false;
    @Resource(lookup="java:jboss/infinispan/container/hawkular-alerts")
    private EmbeddedCacheManager cacheManager;
    private static final String SCHEMA = "schema";
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/schema")
    private Cache schemaCache;

    private void readProperties() {
        this.attempts = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_RETRY_ATTEMPTS, "5"));
        this.timeout = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_RETRY_TIMEOUT, "2000"));
        this.cqlPort = AlertProperties.getProperty(ALERTS_CASSANDRA_PORT, ALERTS_CASSANDRA_PORT_ENV, "9042");
        this.nodes = AlertProperties.getProperty(ALERTS_CASSANDRA_NODES, ALERTS_CASSANDRA_NODES_ENV, "127.0.0.1");
        this.connTimeout = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_CONNECT_TIMEOUT, ALERTS_CASSANDRA_CONNECT_TIMEOUT_ENV, String.valueOf(5000)));
        this.readTimeout = Integer.parseInt(AlertProperties.getProperty(ALERTS_CASSANDRA_READ_TIMEOUT, ALERTS_CASSANDRA_READ_TIMEOUT_ENV, String.valueOf(12000)));
        this.overwrite = Boolean.parseBoolean(AlertProperties.getProperty(ALERTS_CASSANDRA_OVERWRITE, ALERTS_CASSANDRA_OVERWRITE_ENV, "false"));
        this.keyspace = AlertProperties.getProperty(ALERTS_CASSANDRA_KEYSPACE, "hawkular_alerts");
        this.cassandraUseSSL = Boolean.parseBoolean(AlertProperties.getProperty(ALERTS_CASSANDRA_USESSL, ALERTS_CASSANDRA_USESSL_ENV, "false"));
    }

    @PostConstruct
    public void initCassCluster() {
        this.readProperties();
        if (this.cacheManager != null) {
            this.distributed = this.cacheManager.getTransport() != null;
        }
        int currentAttempts = this.attempts;
        SocketOptions socketOptions = null;
        if (this.connTimeout != 5000 || this.readTimeout != 12000) {
            socketOptions = new SocketOptions();
            if (this.connTimeout != 5000) {
                socketOptions.setConnectTimeoutMillis(this.connTimeout);
            }
            if (this.readTimeout != 12000) {
                socketOptions.setReadTimeoutMillis(this.readTimeout);
            }
        }
        Cluster.Builder clusterBuilder = new Cluster.Builder().addContactPoints(this.nodes.split(",")).withPort(new Integer(this.cqlPort).intValue()).withProtocolVersion(ProtocolVersion.V3).withQueryOptions(new QueryOptions().setRefreshSchemaIntervalMillis(0));
        if (socketOptions != null) {
            clusterBuilder.withSocketOptions(socketOptions);
        }
        if (this.cassandraUseSSL) {
            JdkSSLOptions sslOptions = null;
            try {
                String[] defaultCipherSuites = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
                sslOptions = JdkSSLOptions.builder().withSSLContext(SSLContext.getDefault()).withCipherSuites(defaultCipherSuites).build();
                clusterBuilder.withSSL((SSLOptions)sslOptions);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("SSL support is required but is not available in the JVM.", e);
            }
        }
        while (this.session == null && !Thread.currentThread().isInterrupted() && currentAttempts >= 0) {
            block20: {
                try {
                    this.cluster = clusterBuilder.build();
                    this.session = this.cluster.connect();
                }
                catch (Exception e) {
                    log.warn((Object)("Could not connect to Cassandra cluster - assuming is not up yet. Cause: " + (e.getCause() == null ? e : e.getCause())));
                    if (this.attempts != 0) break block20;
                    throw e;
                }
            }
            if (this.session != null) continue;
            log.warn((Object)("[" + currentAttempts + "] Retrying connecting to Cassandra cluster in [" + this.timeout + "]ms..."));
            --currentAttempts;
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.session != null) {
            try {
                if (this.distributed) {
                    this.initSchemeDistributed();
                } else {
                    this.initScheme();
                }
            }
            catch (IOException e) {
                log.error((Object)"Error on initialization of Alerts scheme", (Throwable)e);
            }
        }
        if (this.session == null) {
            throw new RuntimeException("Cassandra session is null");
        }
        if (this.session != null && !this.initialized) {
            throw new RuntimeException("Cassandra alerts keyspace is not initialized");
        }
    }

    private void initSchemeDistributed() throws IOException {
        this.schemaCache.getAdvancedCache().lock(new Object[]{SCHEMA});
        this.initScheme();
    }

    private void initScheme() throws IOException {
        log.infof("Checking Schema existence for keyspace: %s", (Object)this.keyspace);
        KeyspaceMetadata keyspaceMetadata = this.cluster.getMetadata().getKeyspace(this.keyspace);
        if (keyspaceMetadata != null) {
            if (!this.overwrite) {
                this.waitForSchemaCheck();
                if (!this.checkSchema()) {
                    log.errorf("Keyspace %s detected, but failed on check phase.", (Object)this.keyspace);
                    this.initialized = false;
                } else {
                    log.infof("Schema already exist. Skipping schema creation.", new Object[0]);
                    this.initialized = true;
                }
            }
        } else {
            log.infof("Creating Schema for keyspace %s", (Object)this.keyspace);
            this.createSchema(this.session, this.keyspace, this.overwrite);
            this.waitForSchemaCheck();
            if (!this.checkSchema()) {
                log.errorf("Schema %s not created correctly", (Object)this.keyspace);
                this.initialized = false;
            } else {
                this.initialized = true;
                log.infof("Done creating Schema for keyspace: %s", (Object)this.keyspace);
            }
        }
    }

    private void waitForSchemaCheck() {
        int currentAttempts = this.attempts;
        while (!this.checkSchema() && !Thread.currentThread().isInterrupted() && currentAttempts >= 0) {
            log.warnf("[%s] Keyspace detected but schema not fully created. Retrying in [%s] ms...", (Object)currentAttempts, (Object)this.timeout);
            --currentAttempts;
            try {
                Thread.sleep(this.timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean checkSchema() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 27[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String substituteVars(String cql, Map<String, String> vars) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI getCassalogScript() {
        try {
            return this.getClass().getResource("/org/hawkular/alerts/schema/cassalog.groovy").toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to load schema change script", e);
        }
    }

    private String getNewHawkularAlertingVersion() {
        try {
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                Manifest manifest = new Manifest(resource.openStream());
                String vendorId = manifest.getMainAttributes().getValue("Implementation-Vendor-Id");
                if (vendorId == null || !vendorId.equals("org.hawkular.alerts")) continue;
                return manifest.getMainAttributes().getValue("Implementation-Version");
            }
            throw new RuntimeException("Unable to determine implementation version for Hawkular Alerting");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void createSchema(Session session, String keyspace, boolean resetDB) {
        CassalogBuilder builder = new CassalogBuilder();
        Cassalog cassalog = builder.withKeyspace(keyspace).withSession(session).build();
        ImmutableMap vars = ImmutableMap.of((Object)"keyspace", (Object)keyspace, (Object)"reset", (Object)resetDB, (Object)"session", (Object)session);
        URI script = this.getCassalogScript();
        cassalog.execute(script, (Map)vars);
        session.execute("INSERT INTO " + keyspace + ".sys_config (config_id, name, value) VALUES ('org.hawkular.alerts', 'version', '" + this.getNewHawkularAlertingVersion() + "')");
    }

    @Produces
    @AccessTimeout(value=300L, unit=TimeUnit.SECONDS)
    @CassClusterSession
    public Session getSession() {
        return this.session;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @PreDestroy
    public void shutdown() {
        log.info((Object)"Closing Cassandra cluster session");
        if (this.session != null && !this.session.isClosed()) {
            this.session.close();
        }
    }
}

