/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.AccessTimeout;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.service.PartitionDataListener;
import org.hawkular.alerts.engine.service.PartitionManager;
import org.hawkular.alerts.engine.service.PartitionTriggerListener;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.ViewChanged;
import org.infinispan.notifications.cachemanagerlistener.event.ViewChangedEvent;
import org.jboss.logging.Logger;

@Local(value={PartitionManager.class})
@Startup
@Singleton
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class PartitionManagerImpl
implements PartitionManager {
    private static final String LIFESPAN_PROPERTY = "hawkular-alerts.partition-lifespan";
    private static final int LIFESPAN = Integer.parseInt(System.getProperty("hawkular-alerts.partition-lifespan", "100"));
    public static final String BUCKETS = "buckets";
    public static final String PREVIOUS = "previousPartition";
    public static final String CURRENT = "currentPartition";
    public static final String PARTITION_CHANGE = "partitionChangeFlag";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(PartitionManagerImpl.class);
    @EJB
    DefinitionsService definitionsService;
    private boolean distributed = false;
    private final Map<String, String> status = new HashMap<String, String>();
    @Resource(lookup="java:jboss/infinispan/container/hawkular-alerts")
    private EmbeddedCacheManager cacheManager;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/partition")
    private Cache partitionCache;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/triggers")
    private Cache triggersCache;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/data")
    private Cache dataCache;
    private Integer currentNode = null;
    private Set<PartitionTriggerListener> triggerListeners = new HashSet<PartitionTriggerListener>();
    private Set<PartitionDataListener> dataListeners = new HashSet<PartitionDataListener>();
    private TopologyChangeListener topologyChangeListener = new TopologyChangeListener();
    private PartitionChangeListener partitionChangeListener = new PartitionChangeListener();
    private NewTriggerListener newTriggerListener = new NewTriggerListener();
    private NewDataListener newDataListener = new NewDataListener();

    @Override
    @Lock(value=LockType.READ)
    public boolean isDistributed() {
        return this.distributed;
    }

    @Override
    public Map<String, String> getStatus() {
        if (this.distributed) {
            this.status.put("members", this.cacheManager.getMembers().stream().map(Object::toString).collect(Collectors.joining(", ")));
        }
        return this.status;
    }

    @PostConstruct
    public void init() {
        boolean bl = this.distributed = this.cacheManager.getTransport() != null;
        if (!this.distributed) {
            this.msgLog.infoPartitionManagerDisabled();
        } else {
            this.status.put("currentNode", this.cacheManager.getAddress().toString());
            this.currentNode = this.cacheManager.getAddress().hashCode();
            this.cacheManager.addListener((Object)this.topologyChangeListener);
            this.partitionCache.addListener((Object)this.partitionChangeListener);
            this.triggersCache.addListener((Object)this.newTriggerListener);
            this.dataCache.addListener((Object)this.newDataListener);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Initial partition for node: " + this.currentNode));
            }
            this.processTopologyChange();
            this.msgLog.infoPartitionManagerEnabled();
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.distributed) {
            this.cacheManager.removeListener((Object)this.topologyChangeListener);
            this.partitionCache.removeListener((Object)this.partitionChangeListener);
            this.triggersCache.removeListener((Object)this.newTriggerListener);
            this.dataCache.removeListener((Object)this.newDataListener);
            this.dataCache.stop();
            this.triggersCache.stop();
            this.partitionCache.stop();
            this.cacheManager.stop();
        }
    }

    @Override
    public void notifyTrigger(PartitionManager.Operation operation, String tenantId, String triggerId) {
        if (this.distributed) {
            PartitionEntry newEntry = new PartitionEntry(tenantId, triggerId);
            int toNode = this.calculateNewEntry(newEntry, (Map)this.partitionCache.get((Object)BUCKETS));
            NotifyTrigger nTrigger = new NotifyTrigger(this.currentNode, toNode, operation, tenantId, triggerId);
            Integer key = nTrigger.hashCode();
            this.triggersCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).putAsync((Object)key, (Object)nTrigger, (long)LIFESPAN, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void registerTriggerListener(PartitionTriggerListener triggerListener) {
        this.triggerListeners.add(triggerListener);
    }

    @Override
    public void notifyData(Collection<Data> data) {
        if (this.distributed) {
            NotifyData nData = new NotifyData(this.currentNode, data, Data.class);
            Integer key = nData.hashCode();
            this.dataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).putAsync((Object)key, (Object)nData, (long)LIFESPAN, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void notifyEvents(Collection<Event> events) {
        if (this.distributed) {
            NotifyData nEvent = new NotifyData(this.currentNode, events, Event.class);
            Integer key = nEvent.hashCode();
            this.dataCache.getAdvancedCache().withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).putAsync((Object)key, (Object)nEvent, (long)LIFESPAN, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void registerDataListener(PartitionDataListener dataListener) {
        this.dataListeners.add(dataListener);
    }

    @AccessTimeout(value=5L, unit=TimeUnit.MINUTES)
    private void processTopologyChange() {
        if (this.distributed && this.cacheManager.isCoordinator()) {
            Map oldBuckets = (Map)this.partitionCache.get((Object)BUCKETS);
            ArrayList<Integer> members = new ArrayList<Integer>();
            this.cacheManager.getMembers().stream().forEach(a -> members.add(a.hashCode()));
            Map<Integer, Integer> newBuckets = this.updateBuckets(oldBuckets, members);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Processing Topology Change");
                this.log.debug((Object)("Old buckets: " + oldBuckets));
                this.log.debug((Object)("New buckets: " + newBuckets));
            }
            ArrayList<PartitionEntry> entries = new ArrayList<PartitionEntry>();
            Map oldPartition = (Map)this.partitionCache.get((Object)CURRENT);
            if (oldPartition == null) {
                try {
                    Collection triggers = this.definitionsService.getAllTriggers();
                    triggers.stream().forEach(t -> {
                        PartitionEntry entry = new PartitionEntry(t.getTenantId(), t.getId());
                        entries.add(entry);
                    });
                }
                catch (Exception e2) {
                    this.msgLog.errorCannotInitializePartitionManager(e2.toString());
                }
            } else {
                oldPartition.keySet().stream().forEach(e -> entries.add((PartitionEntry)e));
            }
            Map<PartitionEntry, Integer> newPartition = this.calculatePartition(entries, newBuckets);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Old partition: " + oldPartition));
                this.log.debug((Object)("New partition: " + newPartition));
            }
            this.partitionCache.startBatch();
            this.partitionCache.put((Object)BUCKETS, newBuckets);
            if (oldPartition != null) {
                this.partitionCache.put((Object)PREVIOUS, (Object)oldPartition);
            }
            this.partitionCache.put((Object)CURRENT, newPartition);
            this.partitionCache.endBatch(true);
            this.partitionCache.put((Object)PARTITION_CHANGE, (Object)new Date(), (long)LIFESPAN, TimeUnit.MILLISECONDS);
        }
    }

    public Map<Integer, Integer> updateBuckets(Map<Integer, Integer> oldBuckets, List<Integer> members) {
        if (members == null || members.isEmpty()) {
            throw new IllegalArgumentException("newMembers must be not null");
        }
        if (oldBuckets == null || oldBuckets.isEmpty()) {
            HashMap<Integer, Integer> newBuckets = new HashMap<Integer, Integer>();
            for (int i = 0; i < members.size(); ++i) {
                newBuckets.put(i, members.get(i));
            }
            return newBuckets;
        }
        HashMap<Integer, Integer> newBuckets = new HashMap<Integer, Integer>();
        for (int newBucket = 0; newBucket < members.size(); ++newBucket) {
            int bucket = 0;
            boolean placed = false;
            while (bucket < oldBuckets.size() && !placed) {
                Integer oldMember = oldBuckets.get(bucket);
                if (!newBuckets.containsValue(oldMember) && members.contains(oldMember) && (bucket == newBucket || bucket >= members.size())) {
                    newBuckets.put(newBucket, oldMember);
                    placed = true;
                    continue;
                }
                ++bucket;
            }
            if (bucket != oldBuckets.size() || placed) continue;
            newBuckets.put(newBucket, members.get(newBucket));
        }
        return newBuckets;
    }

    public Map<PartitionEntry, Integer> calculatePartition(List<PartitionEntry> entries, Map<Integer, Integer> buckets) {
        if (entries == null) {
            throw new IllegalArgumentException("entries must be not null");
        }
        if (buckets == null || buckets.isEmpty()) {
            throw new IllegalArgumentException("entries must be not null");
        }
        HashFunction md5 = Hashing.md5();
        int numBuckets = buckets.size();
        HashMap<PartitionEntry, Integer> newPartition = new HashMap<PartitionEntry, Integer>();
        for (PartitionEntry entry : entries) {
            newPartition.put(entry, buckets.get(Hashing.consistentHash((HashCode)md5.hashInt(entry.hashCode()), (int)numBuckets)));
        }
        return newPartition;
    }

    public Integer calculateNewEntry(PartitionEntry newEntry, Map<Integer, Integer> buckets) {
        if (newEntry == null) {
            throw new IllegalArgumentException("newEntry must be not null");
        }
        if (buckets == null || buckets.isEmpty()) {
            throw new IllegalArgumentException("buckets must be not null");
        }
        HashFunction md5 = Hashing.md5();
        int numBuckets = buckets.size();
        return buckets.get(Hashing.consistentHash((HashCode)md5.hashInt(newEntry.hashCode()), (int)numBuckets));
    }

    public Map<String, List<String>> getNodePartition(Map<PartitionEntry, Integer> partition, Integer node) {
        HashMap<String, List<String>> nodePartition = new HashMap<String, List<String>>();
        if (partition != null) {
            for (Map.Entry<PartitionEntry, Integer> entry : partition.entrySet()) {
                if (!entry.getValue().equals(node)) continue;
                this.add(nodePartition, entry.getKey());
            }
        }
        return nodePartition;
    }

    private void add(Map<String, List<String>> partition, PartitionEntry entry) {
        String tenantId = entry.getTenantId();
        String triggerId = entry.getTriggerId();
        if (partition.get(tenantId) == null) {
            partition.put(tenantId, new ArrayList());
        }
        partition.get(tenantId).add(triggerId);
    }

    protected Map<String, Map<String, List<String>>> getAddedRemovedPartition(Map<PartitionEntry, Integer> previous, Map<PartitionEntry, Integer> current, Integer node) {
        HashMap<String, Map<String, List<String>>> output = new HashMap<String, Map<String, List<String>>>();
        output.put("added", new HashMap());
        output.put("removed", new HashMap());
        if (previous == null || previous.isEmpty()) {
            current.entrySet().stream().forEach(entry -> this.add((Map)output.get("added"), (PartitionEntry)entry.getKey()));
        } else {
            ArrayList<PartitionEntry> previousNode = new ArrayList<PartitionEntry>();
            for (Map.Entry<PartitionEntry, Integer> entry2 : previous.entrySet()) {
                if (!entry2.getValue().equals(node)) continue;
                previousNode.add(entry2.getKey());
            }
            ArrayList<PartitionEntry> currentNode = new ArrayList<PartitionEntry>();
            for (Map.Entry<PartitionEntry, Integer> entry2 : current.entrySet()) {
                if (!entry2.getValue().equals(node)) continue;
                currentNode.add(entry2.getKey());
            }
            for (PartitionEntry partitionEntry : previousNode) {
                if (currentNode.contains(partitionEntry)) continue;
                this.add((Map)output.get("removed"), partitionEntry);
            }
            for (PartitionEntry partitionEntry : currentNode) {
                if (previousNode.contains(partitionEntry)) continue;
                this.add((Map)output.get("added"), partitionEntry);
            }
        }
        return output;
    }

    private void invokePartitionChangeListener() {
        if (!this.triggerListeners.isEmpty()) {
            Map current = (Map)this.partitionCache.get((Object)CURRENT);
            Map previous = (Map)this.partitionCache.get((Object)PREVIOUS);
            Map<String, List<String>> partition = this.getNodePartition(current, this.currentNode);
            Map<String, Map<String, List<String>>> addedRemoved = this.getAddedRemovedPartition(previous, current, this.currentNode);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Invoke a Change Listener");
                this.log.debug((Object)("Previous: " + previous));
                this.log.debug((Object)("Current: " + current));
                this.log.debug((Object)("Partition: " + partition));
                this.log.debug((Object)("Added: " + addedRemoved.get("added")));
                this.log.debug((Object)("Removed: " + addedRemoved.get("removed")));
            }
            this.triggerListeners.stream().forEach(triggerListener -> triggerListener.onPartitionChange(partition, (Map)addedRemoved.get("removed"), (Map)addedRemoved.get("added")));
        }
    }

    public static class PartitionEntry
    implements Serializable {
        private String tenantId;
        private String triggerId;

        public PartitionEntry(String tenantId, String triggerId) {
            this.tenantId = tenantId;
            this.triggerId = triggerId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTriggerId() {
            return this.triggerId;
        }

        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionEntry that = (PartitionEntry)o;
            if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
                return false;
            }
            return !(this.triggerId == null ? that.triggerId != null : !this.triggerId.equals(that.triggerId));
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PartitionEntry[tenantId='" + this.tenantId + '\'' + ", triggerId='" + this.triggerId + '\'' + ']';
        }
    }

    public static class NotifyData
    implements Serializable {
        private Integer fromNode = null;
        private Data data = null;
        private Event event = null;
        private Collection<Data> dataCollection = null;
        private Collection<Event> eventCollection = null;

        public NotifyData(Integer fromNode, Data data) {
            this.fromNode = fromNode;
            this.data = data;
        }

        public NotifyData(Integer fromNode, Event event) {
            this.fromNode = fromNode;
            this.event = event;
        }

        public NotifyData(Integer fromNode, Collection collection, Class c) {
            this.fromNode = fromNode;
            if (Data.class.equals((Object)c)) {
                this.dataCollection = collection;
            } else if (Event.class.equals((Object)c)) {
                this.eventCollection = collection;
            }
        }

        public Integer getFromNode() {
            return this.fromNode;
        }

        public void setFromNode(Integer fromNode) {
            this.fromNode = fromNode;
        }

        public Data getData() {
            return this.data;
        }

        public void setData(Data data) {
            this.data = data;
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }

        public Collection<Data> getDataCollection() {
            return this.dataCollection;
        }

        public void setDataCollection(Collection<Data> dataCollection) {
            this.dataCollection = dataCollection;
        }

        public Collection<Event> getEventCollection() {
            return this.eventCollection;
        }

        public void setEventCollection(Collection<Event> eventCollection) {
            this.eventCollection = eventCollection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotifyData that = (NotifyData)o;
            if (this.fromNode != null ? !this.fromNode.equals(that.fromNode) : that.fromNode != null) {
                return false;
            }
            if (this.data != null ? !this.data.equals((Object)that.data) : that.data != null) {
                return false;
            }
            if (this.event != null ? !this.event.equals((Object)that.event) : that.event != null) {
                return false;
            }
            if (this.dataCollection != null ? !this.dataCollection.equals(that.dataCollection) : that.dataCollection != null) {
                return false;
            }
            return !(this.eventCollection == null ? that.eventCollection != null : !this.eventCollection.equals(that.eventCollection));
        }

        public int hashCode() {
            int result = this.fromNode != null ? this.fromNode.hashCode() : 0;
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
            result = 31 * result + (this.dataCollection != null ? this.dataCollection.hashCode() : 0);
            result = 31 * result + (this.eventCollection != null ? this.eventCollection.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "NotifyData[fromNode=" + this.fromNode + ", data=" + this.data + ", event=" + this.event + ", dataCollection=" + this.dataCollection + ", eventCollection=" + this.eventCollection + ']';
        }
    }

    public static class NotifyTrigger
    implements Serializable {
        private Integer fromNode;
        private Integer toNode;
        private PartitionManager.Operation operation;
        private String tenantId;
        private String triggerId;

        public NotifyTrigger(Integer fromNode, Integer toNode, PartitionManager.Operation operation, String tenantId, String triggerId) {
            this.fromNode = fromNode;
            this.toNode = toNode;
            this.operation = operation;
            this.tenantId = tenantId;
            this.triggerId = triggerId;
        }

        public Integer getFromNode() {
            return this.fromNode;
        }

        public void setFromNode(Integer fromNode) {
            this.fromNode = fromNode;
        }

        public Integer getToNode() {
            return this.toNode;
        }

        public void setToNode(Integer toNode) {
            this.toNode = toNode;
        }

        public PartitionManager.Operation getOperation() {
            return this.operation;
        }

        public void setOperation(PartitionManager.Operation operation) {
            this.operation = operation;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTriggerId() {
            return this.triggerId;
        }

        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotifyTrigger that = (NotifyTrigger)o;
            if (this.fromNode != null ? !this.fromNode.equals(that.fromNode) : that.fromNode != null) {
                return false;
            }
            if (this.toNode != null ? !this.toNode.equals(that.toNode) : that.toNode != null) {
                return false;
            }
            if (this.operation != that.operation) {
                return false;
            }
            if (this.tenantId != null ? !this.tenantId.equals(that.tenantId) : that.tenantId != null) {
                return false;
            }
            return !(this.triggerId == null ? that.triggerId != null : !this.triggerId.equals(that.triggerId));
        }

        public int hashCode() {
            int result = this.fromNode != null ? this.fromNode.hashCode() : 0;
            result = 31 * result + (this.toNode != null ? this.toNode.hashCode() : 0);
            result = 31 * result + (this.operation != null ? this.operation.hashCode() : 0);
            result = 31 * result + (this.tenantId != null ? this.tenantId.hashCode() : 0);
            result = 31 * result + (this.triggerId != null ? this.triggerId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "NotifyTrigger[fromNode=" + this.fromNode + ", toNode=" + this.toNode + ", operation=" + (Object)((Object)this.operation) + ", tenantId='" + this.tenantId + '\'' + ", triggerId='" + this.triggerId + '\'' + ']';
        }
    }

    @Listener
    public class NewDataListener {
        @CacheEntryCreated
        public void onNewNotifyData(CacheEntryCreatedEvent cacheEvent) {
            if (cacheEvent.isPre()) {
                if (PartitionManagerImpl.this.log.isTraceEnabled()) {
                    PartitionManagerImpl.this.log.trace((Object)"Discarding pre onNewNotifyData(@CacheEntryCreated) event");
                }
                return;
            }
            NotifyData notifyData = (NotifyData)PartitionManagerImpl.this.dataCache.get(cacheEvent.getKey());
            if (PartitionManagerImpl.this.log.isDebugEnabled()) {
                PartitionManagerImpl.this.log.debug((Object)"onNewNotifyData(@CacheEntryCreated) received.");
                PartitionManagerImpl.this.log.debug((Object)("NotifyData: " + notifyData));
            }
            this.processNotifyData(notifyData);
        }

        @CacheEntryModified
        public void onModifiedNotifyData(CacheEntryModifiedEvent cacheEvent) {
            if (cacheEvent.isPre()) {
                if (PartitionManagerImpl.this.log.isTraceEnabled()) {
                    PartitionManagerImpl.this.log.trace((Object)"Discarding pre onModifiedNotifyData(@CacheEntryModified) event");
                }
                return;
            }
            NotifyData notifyData = (NotifyData)PartitionManagerImpl.this.dataCache.get(cacheEvent.getKey());
            if (PartitionManagerImpl.this.log.isDebugEnabled()) {
                PartitionManagerImpl.this.log.debug((Object)"onModifiedNotifyData(@CacheEntryModified) received.");
                PartitionManagerImpl.this.log.debug((Object)("NotifyData: " + notifyData));
            }
            this.processNotifyData(notifyData);
        }

        private void processNotifyData(NotifyData notifyData) {
            if (!PartitionManagerImpl.this.dataListeners.isEmpty() && notifyData.getFromNode() != PartitionManagerImpl.this.currentNode) {
                if (notifyData.getDataCollection() != null) {
                    PartitionManagerImpl.this.dataListeners.stream().forEach(dataListener -> dataListener.onNewData(notifyData.getDataCollection()));
                } else if (notifyData.getEventCollection() != null) {
                    PartitionManagerImpl.this.dataListeners.stream().forEach(dataListener -> dataListener.onNewEvents(notifyData.getEventCollection()));
                }
            }
        }
    }

    @Listener
    public class NewTriggerListener {
        @CacheEntryCreated
        public void onNewNotifyTrigger(CacheEntryCreatedEvent cacheEvent) {
            if (cacheEvent.isPre()) {
                if (PartitionManagerImpl.this.log.isTraceEnabled()) {
                    PartitionManagerImpl.this.log.trace((Object)"Discarding pre onNewNotifyTrigger(@CacheEntryCreated) event");
                }
                return;
            }
            NotifyTrigger notifyTrigger = (NotifyTrigger)PartitionManagerImpl.this.triggersCache.get(cacheEvent.getKey());
            if (PartitionManagerImpl.this.log.isDebugEnabled()) {
                PartitionManagerImpl.this.log.debug((Object)("onNewNotifyTrigger(@CacheEntryCreated) received on " + PartitionManagerImpl.this.currentNode));
                PartitionManagerImpl.this.log.debug((Object)("CacheEvent: " + cacheEvent));
                PartitionManagerImpl.this.log.debug((Object)("NotifyTrigger: " + notifyTrigger));
            }
            this.processNotifyTrigger(notifyTrigger);
        }

        @CacheEntryModified
        public void onModifiedNotifyTrigger(CacheEntryModifiedEvent cacheEvent) {
            if (cacheEvent.isPre()) {
                if (PartitionManagerImpl.this.log.isTraceEnabled()) {
                    PartitionManagerImpl.this.log.trace((Object)"Discarding pre onModifiedNotifyTrigger(@CacheEntryModified) event");
                }
                return;
            }
            NotifyTrigger notifyTrigger = (NotifyTrigger)PartitionManagerImpl.this.triggersCache.get(cacheEvent.getKey());
            if (PartitionManagerImpl.this.log.isDebugEnabled()) {
                PartitionManagerImpl.this.log.debug((Object)("onModifiedNotifyTrigger(@CacheEntryModified) received on " + PartitionManagerImpl.this.currentNode));
                PartitionManagerImpl.this.log.debug((Object)("CacheEvent: " + cacheEvent));
                PartitionManagerImpl.this.log.debug((Object)("NotifyTrigger: " + notifyTrigger));
            }
            this.processNotifyTrigger(notifyTrigger);
        }

        private void processNotifyTrigger(NotifyTrigger notifyTrigger) {
            if (null != notifyTrigger.toNode && null != PartitionManagerImpl.this.currentNode && notifyTrigger.toNode.equals(PartitionManagerImpl.this.currentNode)) {
                PartitionEntry newEntry;
                Map current = (Map)PartitionManagerImpl.this.partitionCache.get((Object)PartitionManagerImpl.CURRENT);
                boolean exist = current.containsKey(newEntry = new PartitionEntry(notifyTrigger.getTenantId(), notifyTrigger.getTriggerId()));
                if (exist) {
                    Integer partitionNode = (Integer)current.get(newEntry);
                    switch (notifyTrigger.getOperation()) {
                        case ADD: 
                        case UPDATE: {
                            if (partitionNode.equals(PartitionManagerImpl.this.currentNode)) break;
                            this.modifyPartition(newEntry, current, notifyTrigger.getOperation());
                            break;
                        }
                        case REMOVE: {
                            this.modifyPartition(newEntry, current, notifyTrigger.getOperation());
                        }
                    }
                } else if (!notifyTrigger.getOperation().equals((Object)PartitionManager.Operation.REMOVE)) {
                    this.modifyPartition(newEntry, current, notifyTrigger.getOperation());
                }
                if (!PartitionManagerImpl.this.triggerListeners.isEmpty()) {
                    PartitionManagerImpl.this.triggerListeners.stream().forEach(triggerListener -> triggerListener.onTriggerChange(notifyTrigger.getOperation(), notifyTrigger.getTenantId(), notifyTrigger.getTriggerId()));
                }
            }
        }

        private void modifyPartition(PartitionEntry entry, Map<PartitionEntry, Integer> current, PartitionManager.Operation operation) {
            HashMap<PartitionEntry, Integer> newPartition = new HashMap<PartitionEntry, Integer>(current);
            if (operation.equals((Object)PartitionManager.Operation.REMOVE)) {
                newPartition.remove(entry);
            } else {
                newPartition.put(entry, PartitionManagerImpl.this.currentNode);
            }
            PartitionManagerImpl.this.partitionCache.startBatch();
            PartitionManagerImpl.this.partitionCache.put((Object)PartitionManagerImpl.PREVIOUS, current);
            PartitionManagerImpl.this.partitionCache.put((Object)PartitionManagerImpl.CURRENT, newPartition);
            PartitionManagerImpl.this.partitionCache.endBatch(true);
            if (PartitionManagerImpl.this.log.isDebugEnabled()) {
                PartitionManagerImpl.this.log.debug((Object)"modifyPartition()");
                PartitionManagerImpl.this.log.debug((Object)("Previous: " + current));
                PartitionManagerImpl.this.log.debug((Object)("Current: " + newPartition));
            }
        }
    }

    @Listener
    public class PartitionChangeListener {
        @CacheEntryCreated
        public void onPartitionModified(CacheEntryCreatedEvent cacheEvent) {
            if (cacheEvent.isPre()) {
                if (PartitionManagerImpl.this.log.isTraceEnabled()) {
                    PartitionManagerImpl.this.log.trace((Object)"Discarding pre onPartitionModified(@CacheEntryModified) event");
                }
                return;
            }
            if (cacheEvent.getKey().equals(PartitionManagerImpl.PARTITION_CHANGE)) {
                PartitionManagerImpl.this.invokePartitionChangeListener();
            }
        }
    }

    @Listener
    public class TopologyChangeListener {
        @ViewChanged
        public void onTopologyChange(ViewChangedEvent cacheEvent) {
            PartitionManagerImpl.this.processTopologyChange();
        }
    }
}

