/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.AccessTimeout;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.inject.Inject;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.action.ActionDefinition;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.EventCondition;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.condition.MissingCondition;
import org.hawkular.alerts.api.model.condition.RateCondition;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.event.EventType;
import org.hawkular.alerts.api.model.export.Definitions;
import org.hawkular.alerts.api.model.export.ImportType;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.PageContext;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.model.paging.TriggerComparator;
import org.hawkular.alerts.api.model.trigger.FullTrigger;
import org.hawkular.alerts.api.model.trigger.Match;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.model.trigger.TriggerAction;
import org.hawkular.alerts.api.model.trigger.TriggerType;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.PropertiesService;
import org.hawkular.alerts.api.services.TriggersCriteria;
import org.hawkular.alerts.engine.exception.NotFoundApplicationException;
import org.hawkular.alerts.engine.impl.AlertsContext;
import org.hawkular.alerts.engine.impl.CassClusterSession;
import org.hawkular.alerts.engine.impl.CassStatement;
import org.hawkular.alerts.engine.impl.TagType;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.jboss.logging.Logger;

@Local(value={DefinitionsService.class})
@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CassDefinitionsServiceImpl
implements DefinitionsService {
    private static final String BATCH_SIZE = "hawkular-alerts.batch-size";
    private static final String BATCH_SIZE_ENV = "BATCH_SIZE";
    private static final String BATCH_SIZE_DEFAULT = "10";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(CassDefinitionsServiceImpl.class);
    private Set<DefinitionsEvent> deferredNotifications = new HashSet<DefinitionsEvent>();
    private int deferNotificationsCount = 0;
    private int batchSize;
    private final BatchStatement.Type batchType = BatchStatement.Type.LOGGED;
    @EJB
    AlertsEngine alertsEngine;
    @EJB
    AlertsContext alertsContext;
    @EJB
    PropertiesService properties;
    @Inject
    @CassClusterSession
    Session session;

    @PostConstruct
    public void init() {
        this.batchSize = Integer.valueOf(this.properties.getProperty(BATCH_SIZE, BATCH_SIZE_ENV, BATCH_SIZE_DEFAULT));
    }

    public void setAlertsEngine(AlertsEngine alertsEngine) {
        this.alertsEngine = alertsEngine;
    }

    public void setAlertsContext(AlertsContext alertsContext) {
        this.alertsContext = alertsContext;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setProperties(PropertiesService properties) {
        this.properties = properties;
    }

    public void addActionDefinition(String tenantId, ActionDefinition actionDefinition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (actionDefinition == null) {
            throw new IllegalArgumentException("ActionDefinition must be not null");
        }
        actionDefinition.setTenantId(tenantId);
        if (this.isEmpty(actionDefinition.getActionPlugin())) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionDefinition.getActionId())) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (this.isEmpty(actionDefinition.getProperties())) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        String plugin = actionDefinition.getActionPlugin();
        if (!this.getActionPlugins().contains(plugin)) {
            throw new IllegalArgumentException("Plugin: " + plugin + " is not deployed");
        }
        Set<String> pluginProperties = this.getActionPlugin(plugin);
        actionDefinition.getProperties().keySet().stream().forEach(property -> {
            boolean isPluginProperty = false;
            for (String pluginProperty : pluginProperties) {
                if (!property.startsWith(pluginProperty)) continue;
                isPluginProperty = true;
                break;
            }
            if (!isPluginProperty) {
                throw new IllegalArgumentException("Property: " + property + " is not valid on plugin: " + plugin);
            }
        });
        PreparedStatement insertAction = CassStatement.get(this.session, CassStatement.INSERT_ACTION_DEFINITION);
        if (insertAction == null) {
            throw new RuntimeException("insertAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertAction.bind(new Object[]{tenantId, actionDefinition.getActionPlugin(), actionDefinition.getActionId(), JsonUtil.toJson((Object)actionDefinition)}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.ACTION_DEFINITION_CREATE, actionDefinition));
    }

    public void addTrigger(String tenantId, Trigger trigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(trigger)) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        this.checkTenantId(tenantId, trigger);
        trigger.setType(TriggerType.STANDARD);
        this.addTrigger(trigger);
    }

    public void addGroupTrigger(String tenantId, Trigger groupTrigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupTrigger)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, groupTrigger);
        if (!groupTrigger.isGroup()) {
            groupTrigger.setType(TriggerType.GROUP);
        }
        this.addTrigger(groupTrigger);
    }

    private void addTrigger(Trigger trigger) throws Exception {
        PreparedStatement insertTrigger;
        if (trigger.getActions() != null) {
            List<ActionDefinition> actionDefinitions = this.getActionDefinitions(trigger.getTenantId());
            trigger.getActions().stream().forEach(actionDefinition -> {
                boolean found = actionDefinitions.stream().filter(a -> a.getActionPlugin().equals(actionDefinition.getActionPlugin()) && a.getActionId().equals(actionDefinition.getActionId())).findFirst().isPresent();
                if (!found) {
                    throw new IllegalArgumentException("Action " + actionDefinition.getActionId() + " on plugin: " + actionDefinition.getActionPlugin() + " is not found");
                }
            });
        }
        if ((insertTrigger = CassStatement.get(this.session, CassStatement.INSERT_TRIGGER)) == null) {
            throw new RuntimeException("insertTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertTrigger.bind(new Object[]{trigger.getTenantId(), trigger.getId(), trigger.isAutoDisable(), trigger.isAutoEnable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getAutoResolveMatch().name(), trigger.getContext(), trigger.getDataIdMap(), trigger.getDescription(), trigger.isEnabled(), trigger.getEventCategory(), trigger.getEventText(), trigger.getEventType().name(), trigger.getFiringMatch().name(), trigger.getMemberOf(), trigger.getName(), trigger.getSeverity().name(), trigger.getSource(), trigger.getTags(), trigger.getType().name()}));
            this.insertTriggerActions(trigger);
            this.insertTags(trigger.getTenantId(), TagType.TRIGGER, trigger.getId(), trigger.getTags());
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (null != this.alertsEngine) {
            this.alertsEngine.addTrigger(trigger.getTenantId(), trigger.getId());
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.TRIGGER_CREATE, trigger));
    }

    private void insertTriggerActions(Trigger trigger) throws Exception {
        PreparedStatement insertTriggerActions = CassStatement.get(this.session, CassStatement.INSERT_TRIGGER_ACTIONS);
        if (insertTriggerActions == null) {
            throw new RuntimeException("insertTriggerActions PreparedStatement is null");
        }
        if (trigger.getActions() != null) {
            trigger.getActions().forEach(triggerAction -> triggerAction.setTenantId(trigger.getTenantId()));
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            BatchStatement batch = new BatchStatement(this.batchType);
            int i = 0;
            for (TriggerAction triggerAction2 : trigger.getActions()) {
                batch.add((Statement)insertTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId(), triggerAction2.getActionPlugin(), triggerAction2.getActionId(), JsonUtil.toJson((Object)triggerAction2)}));
                if ((i += batch.size()) <= this.batchSize) continue;
                futures.add(this.session.executeAsync((Statement)batch));
                batch.clear();
                i = 0;
            }
            if (batch.size() > 0) {
                futures.add(this.session.executeAsync((Statement)batch));
            }
            Futures.allAsList(futures).get();
        }
    }

    public void removeTrigger(String tenantId, String triggerId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger doomedTrigger = this.getTrigger(tenantId, triggerId);
        if (null == doomedTrigger) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, triggerId);
        }
        if (doomedTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        this.removeTrigger(doomedTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupTrigger(String tenantId, String groupId, boolean keepNonOrphans, boolean keepOrphans) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupId)) {
            throw new IllegalArgumentException("GroupId must be not null");
        }
        try {
            this.deferNotifications();
            Trigger doomedTrigger = this.getTrigger(tenantId, groupId);
            if (null == doomedTrigger) {
                throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, groupId);
            }
            if (!doomedTrigger.isGroup()) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger");
            }
            Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, true);
            for (Trigger member : memberTriggers) {
                if (keepNonOrphans && !member.isOrphan() || keepOrphans && member.isOrphan()) {
                    member.setMemberOf(null);
                    member.setType(TriggerType.STANDARD);
                    this.updateTrigger(member, member.getActions(), member.getTags());
                    continue;
                }
                this.removeTrigger(member);
            }
            this.removeTrigger(doomedTrigger);
        }
        finally {
            this.releaseNotifications();
        }
    }

    private void deferNotifications() {
        ++this.deferNotificationsCount;
    }

    private void releaseNotifications() {
        if (this.deferNotificationsCount > 0 && --this.deferNotificationsCount == 0) {
            this.notifyListenersDeferred();
        }
    }

    private boolean isDeferredNotifications() {
        return this.deferNotificationsCount > 0;
    }

    private void removeTrigger(Trigger trigger) throws Exception {
        String tenantId = trigger.getTenantId();
        String triggerId = trigger.getId();
        PreparedStatement deleteDampenings = CassStatement.get(this.session, CassStatement.DELETE_DAMPENINGS);
        PreparedStatement deleteConditions = CassStatement.get(this.session, CassStatement.DELETE_CONDITIONS);
        PreparedStatement deleteActions = CassStatement.get(this.session, CassStatement.DELETE_TRIGGER_ACTIONS);
        PreparedStatement deleteTrigger = CassStatement.get(this.session, CassStatement.DELETE_TRIGGER);
        if (deleteDampenings == null || deleteConditions == null || deleteActions == null || deleteTrigger == null) {
            throw new RuntimeException("delete*Triggers PreparedStatement is null");
        }
        try {
            this.deleteTags(tenantId, TagType.TRIGGER, triggerId, trigger.getTags());
            this.deleteTriggerActions(tenantId, triggerId);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            futures.add(this.session.executeAsync((Statement)deleteDampenings.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)deleteConditions.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)deleteActions.bind(new Object[]{tenantId, triggerId})));
            futures.add(this.session.executeAsync((Statement)deleteTrigger.bind(new Object[]{tenantId, triggerId})));
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (null != this.alertsEngine) {
            this.alertsEngine.removeTrigger(tenantId, triggerId);
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.TRIGGER_REMOVE, tenantId, triggerId));
    }

    public Trigger updateTrigger(String tenantId, Trigger trigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(trigger)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, trigger);
        String triggerId = trigger.getId();
        Trigger existingTrigger = this.getTrigger(tenantId, trigger.getId());
        if (null == existingTrigger) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, trigger.getId());
        }
        if (existingTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (existingTrigger.isMember()) {
            if (!existingTrigger.isOrphan()) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be updated via the group.");
            }
            if (!existingTrigger.getMemberOf().equals(trigger.getMemberOf())) {
                throw new IllegalArgumentException("A member trigger can not change groups.");
            }
            if (existingTrigger.isOrphan() != trigger.isOrphan()) {
                throw new IllegalArgumentException("Orphan status can not be changed by this method.");
            }
        }
        return this.updateTrigger(trigger, existingTrigger.getActions(), existingTrigger.getTags());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger updateGroupTrigger(String tenantId, Trigger groupTrigger) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupTrigger)) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        try {
            this.deferNotifications();
            this.checkTenantId(tenantId, groupTrigger);
            String groupId = groupTrigger.getId();
            Trigger existingGroupTrigger = this.getTrigger(tenantId, groupId);
            if (null == existingGroupTrigger) {
                throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, groupTrigger.getId());
            }
            if (!existingGroupTrigger.isGroup()) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger");
            }
            groupTrigger.setType(existingGroupTrigger.getType());
            Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
            Set existingActions = existingGroupTrigger.getActions();
            Map existingTags = existingGroupTrigger.getTags();
            for (Trigger member : memberTriggers) {
                this.copyGroupTrigger(groupTrigger, member, false);
                this.updateTrigger(member, existingActions, existingTags);
            }
            Trigger trigger = this.updateTrigger(groupTrigger, existingActions, existingTags);
            return trigger;
        }
        finally {
            this.releaseNotifications();
        }
    }

    public void updateTriggerEnablement(String tenantId, String triggerId, boolean enabled) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger existingTrigger = this.getTrigger(tenantId, triggerId);
        if (null == existingTrigger) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, triggerId);
        }
        if (existingTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (enabled == existingTrigger.isEnabled()) {
            this.log.debugf("Ignoring enable/disable request. Trigger %s is already set enabled=%s", (Object)triggerId, (Object)enabled);
            return;
        }
        PreparedStatement updateTriggerEnabled = CassStatement.get(this.session, CassStatement.UPDATE_TRIGGER_ENABLED);
        if (updateTriggerEnabled == null) {
            throw new RuntimeException("updateTriggerEnabled PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateTriggerEnabled.bind(new Object[]{enabled, tenantId, triggerId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(tenantId, triggerId);
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.TRIGGER_UPDATE, tenantId, triggerId));
    }

    private Trigger copyGroupTrigger(Trigger group, Trigger member, boolean isNewMember) {
        member.setActions(group.getActions());
        member.setAutoDisable(group.isAutoDisable());
        member.setAutoEnable(group.isAutoEnable());
        member.setAutoResolve(group.isAutoResolve());
        member.setAutoResolveAlerts(group.isAutoResolveAlerts());
        member.setAutoResolveMatch(group.getAutoResolveMatch());
        member.setEnabled(group.isEnabled());
        member.setEventType(group.getEventType());
        member.setFiringMatch(group.getFiringMatch());
        member.setMemberOf(group.getId());
        member.setSeverity(group.getSeverity());
        member.setType(TriggerType.MEMBER);
        if (isNewMember) {
            member.setDataIdMap(group.getDataIdMap());
            member.setDescription(group.getDescription());
            member.setContext(group.getContext());
            member.setTags(group.getTags());
        } else {
            if (!this.isEmpty(group.getContext())) {
                HashMap combinedContext = new HashMap();
                combinedContext.putAll(member.getContext());
                for (Map.Entry entry : group.getContext().entrySet()) {
                    combinedContext.putIfAbsent(entry.getKey(), entry.getValue());
                }
                member.setContext(combinedContext);
            }
            if (!this.isEmpty(group.getTags())) {
                HashMap combinedTags = new HashMap();
                combinedTags.putAll(member.getTags());
                for (Map.Entry entry : group.getTags().entrySet()) {
                    combinedTags.putIfAbsent(entry.getKey(), entry.getValue());
                }
                member.setTags(combinedTags);
            }
        }
        return member;
    }

    private Trigger updateTrigger(Trigger trigger, Set<TriggerAction> existingActions, Map<String, String> existingTags) throws Exception {
        PreparedStatement updateTrigger = CassStatement.get(this.session, CassStatement.UPDATE_TRIGGER);
        if (updateTrigger == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateTrigger.bind(new Object[]{trigger.isAutoDisable(), trigger.isAutoEnable(), trigger.isAutoResolve(), trigger.isAutoResolveAlerts(), trigger.getAutoResolveMatch().name(), trigger.getContext(), trigger.getDataIdMap(), trigger.getDescription(), trigger.isEnabled(), trigger.getEventCategory(), trigger.getEventText(), trigger.getFiringMatch().name(), trigger.getMemberOf(), trigger.getName(), trigger.getSeverity().name(), trigger.getSource(), trigger.getTags(), trigger.getType().name(), trigger.getTenantId(), trigger.getId()}));
            if (!trigger.getActions().equals(existingActions)) {
                this.deleteTriggerActions(trigger.getTenantId(), trigger.getId());
                this.insertTriggerActions(trigger);
            }
            if (!trigger.getTags().equals(existingTags)) {
                this.deleteTags(trigger.getTenantId(), TagType.TRIGGER, trigger.getId(), existingTags);
                this.insertTags(trigger.getTenantId(), TagType.TRIGGER, trigger.getId(), trigger.getTags());
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(trigger.getTenantId(), trigger.getId());
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.TRIGGER_UPDATE, trigger));
        return trigger;
    }

    public Trigger orphanMemberTrigger(String tenantId, String memberId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(memberId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger member = this.getTrigger(tenantId, memberId);
        if (null == member) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, memberId);
        }
        if (!member.isMember()) {
            throw new IllegalArgumentException("Trigger is not a member trigger: [" + tenantId + "/" + memberId + "]");
        }
        if (member.isOrphan()) {
            throw new IllegalArgumentException("Trigger is already an orphan: [" + tenantId + "/" + memberId + "]");
        }
        member.setType(TriggerType.ORPHAN);
        return this.updateTrigger(member, member.getActions(), member.getTags());
    }

    public Trigger unorphanMemberTrigger(String tenantId, String memberId, Map<String, String> memberContext, Map<String, String> memberTags, Map<String, String> dataIdMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(memberId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        Trigger orphanMember = this.getTrigger(tenantId, memberId);
        if (null == orphanMember) {
            throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, memberId);
        }
        if (!orphanMember.isMember()) {
            throw new IllegalArgumentException("Trigger is not a member trigger: [" + tenantId + "/" + memberId + "]");
        }
        if (!orphanMember.isOrphan()) {
            throw new IllegalArgumentException("Trigger is not an orphan: [" + tenantId + "/" + memberId + "]");
        }
        String groupId = orphanMember.getMemberOf();
        String memberName = orphanMember.getName();
        String memberDescription = orphanMember.getDescription();
        this.removeTrigger(orphanMember);
        Trigger member = this.addMemberTrigger(tenantId, groupId, memberId, memberName, memberDescription, memberContext, memberTags, dataIdMap);
        return member;
    }

    private void deleteTriggerActions(String tenantId, String triggerId) throws Exception {
        PreparedStatement deleteTriggerActions = CassStatement.get(this.session, CassStatement.DELETE_TRIGGER_ACTIONS);
        if (deleteTriggerActions == null) {
            throw new RuntimeException("updateTrigger PreparedStatement is null");
        }
        this.session.execute((Statement)deleteTriggerActions.bind(new Object[]{tenantId, triggerId}));
    }

    public Trigger getTrigger(String tenantId, String triggerId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
        if (selectTrigger == null) {
            throw new RuntimeException("selectTrigger PreparedStatement is null");
        }
        Trigger trigger = null;
        try {
            ResultSet rsTrigger = this.session.execute((Statement)selectTrigger.bind(new Object[]{tenantId, triggerId}));
            Iterator itTrigger = rsTrigger.iterator();
            if (itTrigger.hasNext()) {
                Row row = (Row)itTrigger.next();
                trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return trigger;
    }

    @AccessTimeout(value=60L, unit=TimeUnit.SECONDS)
    public Collection<Trigger> getAllTriggers() throws Exception {
        return this.selectTriggers(null);
    }

    public Page<Trigger> getTriggers(String tenantId, TriggersCriteria criteria, Pager pager) throws Exception {
        boolean thin;
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        boolean filter = null != criteria && criteria.hasCriteria();
        boolean bl = thin = null != criteria && criteria.isThin();
        if (filter && this.log.isDebugEnabled()) {
            this.log.debug((Object)("getTriggers criteria: " + criteria.toString()));
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        HashSet<String> triggerIds = new HashSet<String>();
        boolean activeFilter = false;
        try {
            if (filter) {
                if (criteria.hasTriggerIdCriteria()) {
                    Set<String> idsFilteredByTriggers = this.filterByTriggers(criteria);
                    if (activeFilter) {
                        triggerIds.retainAll(idsFilteredByTriggers);
                        if (triggerIds.isEmpty()) {
                            return new Page(triggers, (PageContext)pager, 0L);
                        }
                    } else {
                        triggerIds.addAll(idsFilteredByTriggers);
                    }
                    activeFilter = true;
                }
                if (criteria.hasTagCriteria()) {
                    Set<String> idsFilteredByTags = this.getIdsByTags(tenantId, TagType.TRIGGER, criteria.getTags());
                    if (activeFilter) {
                        triggerIds.retainAll(idsFilteredByTags);
                        if (triggerIds.isEmpty()) {
                            return new Page(triggers, (PageContext)pager, 0L);
                        }
                    } else {
                        triggerIds.addAll(idsFilteredByTags);
                    }
                    activeFilter = true;
                }
                PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
                List futures = triggerIds.stream().map(id -> this.session.executeAsync((Statement)selectTrigger.bind(new Object[]{tenantId, id}))).collect(Collectors.toList());
                List rsTriggers = (List)Futures.allAsList(futures).get();
                for (ResultSet rs : rsTriggers) {
                    for (Row row : rs) {
                        Trigger trigger = this.mapTrigger(row);
                        this.selectTriggerActions(trigger);
                        triggers.add(trigger);
                    }
                }
            } else {
                triggers.addAll(this.selectTriggers(tenantId));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return this.prepareTriggersPage(triggers, pager);
    }

    private Set<String> filterByTriggers(TriggersCriteria criteria) {
        Set<String> result = Collections.emptySet();
        if (this.isEmpty(criteria.getTriggerIds())) {
            if (!this.isEmpty(criteria.getTriggerId())) {
                result = new HashSet<String>(1);
                result.add(criteria.getTriggerId());
            }
        } else {
            result = new HashSet();
            result.addAll(criteria.getTriggerIds());
        }
        return result;
    }

    private Set<String> getIdsByTags(String tenantId, TagType tagType, Map<String, String> tags) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        PreparedStatement selectTagsByName = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME);
        PreparedStatement selectTagsByNameAndValue = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME_AND_VALUE);
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            boolean nameOnly = "*".equals(tag.getValue());
            BoundStatement bs = nameOnly ? selectTagsByName.bind(new Object[]{tenantId, tagType.name(), tag.getKey()}) : selectTagsByNameAndValue.bind(new Object[]{tenantId, tagType.name(), tag.getKey(), tag.getValue()});
            futures.add(this.session.executeAsync((Statement)bs));
        }
        List rsTags = (List)Futures.allAsList(futures).get();
        rsTags.stream().forEach(r -> {
            for (Row row : r) {
                ids.add(row.getString("id"));
            }
        });
        return ids;
    }

    private Collection<Trigger> selectTriggers(String tenantId) throws Exception {
        PreparedStatement selectTriggers;
        PreparedStatement preparedStatement = selectTriggers = this.isEmpty(tenantId) ? CassStatement.get(this.session, CassStatement.SELECT_TRIGGERS_ALL) : CassStatement.get(this.session, CassStatement.SELECT_TRIGGERS_TENANT);
        if (null == selectTriggers) {
            throw new RuntimeException("selectTriggersTenant PreparedStatement is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            ResultSet rsTriggers = this.session.execute((Statement)(this.isEmpty(tenantId) ? selectTriggers.bind() : selectTriggers.bind(new Object[]{tenantId})));
            for (Row row : rsTriggers) {
                Trigger trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
                triggers.add(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return triggers;
    }

    private Page<Trigger> prepareTriggersPage(List<Trigger> triggers, Pager pager) {
        if (pager != null) {
            if (pager.getOrder() != null && !pager.getOrder().isEmpty() && ((Order)pager.getOrder().get(0)).getField() == null) {
                pager = Pager.builder().withPageSize(pager.getPageSize()).withStartPage(pager.getPageNumber()).orderBy(TriggerComparator.Field.NAME.getName(), Order.Direction.DESCENDING).build();
            }
            List<Trigger> ordered = triggers;
            if (pager.getOrder() != null) {
                pager.getOrder().stream().filter(o -> o.getField() != null && o.getDirection() != null).forEach(o -> {
                    TriggerComparator comparator = new TriggerComparator(o.getField(), o.getDirection());
                    Collections.sort(ordered, comparator);
                });
            }
            if (!pager.isLimited() || ordered.size() < pager.getStart()) {
                pager = new Pager(0, ordered.size(), (Iterable)pager.getOrder());
                return new Page(ordered, (PageContext)pager, (long)ordered.size());
            }
            if (pager.getEnd() >= ordered.size()) {
                return new Page(ordered.subList(pager.getStart(), ordered.size()), (PageContext)pager, (long)ordered.size());
            }
            return new Page(ordered.subList(pager.getStart(), pager.getEnd()), (PageContext)pager, (long)ordered.size());
        }
        pager = Pager.builder().withPageSize(triggers.size()).orderBy(TriggerComparator.Field.ID.getName(), Order.Direction.ASCENDING).build();
        return new Page(triggers, (PageContext)pager, (long)triggers.size());
    }

    public Collection<Trigger> getAllTriggersByTag(String name, String value) throws Exception {
        if (this.isEmpty(name)) {
            throw new IllegalArgumentException("name must be not null");
        }
        if (this.isEmpty(value)) {
            throw new IllegalArgumentException("value must be not null (use '*' for all");
        }
        try {
            PreparedStatement selectTags;
            BoundStatement bs = CassStatement.get(this.session, CassStatement.SELECT_PARTITIONS_TRIGGERS).bind();
            HashSet<String> tenants = new HashSet<String>();
            for (Row row : this.session.execute((Statement)bs)) {
                tenants.add(row.getString("tenantId"));
            }
            boolean nameOnly = "*".equals(value);
            PreparedStatement preparedStatement = selectTags = nameOnly ? CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME) : CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME_AND_VALUE);
            if (selectTags == null) {
                throw new RuntimeException("selectTags PreparedStatement is null");
            }
            String triggerType = TagType.TRIGGER.name();
            HashMap tenantTriggerIdsMap = new HashMap();
            List futures = nameOnly ? tenants.stream().map(tenantId -> this.session.executeAsync((Statement)selectTags.bind(new Object[]{tenantId, triggerType, name}))).collect(Collectors.toList()) : tenants.stream().map(tenantId -> this.session.executeAsync((Statement)selectTags.bind(new Object[]{tenantId, triggerType, name, value}))).collect(Collectors.toList());
            List rsTriggerIds = (List)Futures.allAsList(futures).get();
            rsTriggerIds.stream().forEach(rs -> {
                for (Row row : rs) {
                    String tenantId = row.getString("tenantId");
                    String triggerId = row.getString("id");
                    HashSet<String> storedTriggerIds = (HashSet<String>)tenantTriggerIdsMap.get(tenantId);
                    if (null == storedTriggerIds) {
                        storedTriggerIds = new HashSet<String>();
                    }
                    storedTriggerIds.add(triggerId);
                    tenantTriggerIdsMap.put(tenantId, storedTriggerIds);
                }
            });
            ArrayList<Trigger> triggers = new ArrayList<Trigger>();
            PreparedStatement selectTrigger = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER);
            for (Map.Entry entry : tenantTriggerIdsMap.entrySet()) {
                String tenantId2 = (String)entry.getKey();
                Set triggerIds = (Set)entry.getValue();
                futures = triggerIds.stream().map(triggerId -> this.session.executeAsync((Statement)selectTrigger.bind(new Object[]{tenantId2, triggerId}))).collect(Collectors.toList());
                List rsTriggers = (List)Futures.allAsList(futures).get();
                for (ResultSet rs2 : rsTriggers) {
                    for (Row row : rs2) {
                        Trigger trigger = this.mapTrigger(row);
                        this.selectTriggerActions(trigger);
                        triggers.add(trigger);
                    }
                }
            }
            return triggers;
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<Trigger> getMemberTriggers(String tenantId, String groupId, boolean includeOrphans) throws Exception {
        PreparedStatement selectTriggersTenant = CassStatement.get(this.session, CassStatement.SELECT_TRIGGERS_TENANT);
        if (null == selectTriggersTenant) {
            throw new RuntimeException("selectTriggersMemberOf PreparedStatement is null");
        }
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        try {
            ResultSet rsTriggers = this.session.execute((Statement)selectTriggersTenant.bind(new Object[]{tenantId}));
            for (Row row : rsTriggers) {
                if (!groupId.equals(row.getString("memberOf")) || !includeOrphans && TriggerType.MEMBER != TriggerType.valueOf((String)row.getString("type"))) continue;
                Trigger trigger = this.mapTrigger(row);
                this.selectTriggerActions(trigger);
                triggers.add(trigger);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return triggers;
    }

    private void selectTriggerActions(Trigger trigger) throws Exception {
        if (trigger == null) {
            throw new IllegalArgumentException("Trigger must be not null");
        }
        PreparedStatement selectTriggerActions = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_ACTIONS);
        if (selectTriggerActions == null) {
            throw new RuntimeException("selectTriggerActions PreparedStatement is null");
        }
        ResultSet rsTriggerActions = this.session.execute((Statement)selectTriggerActions.bind(new Object[]{trigger.getTenantId(), trigger.getId()}));
        HashSet<TriggerAction> actions = new HashSet<TriggerAction>();
        for (Row row : rsTriggerActions) {
            TriggerAction action = (TriggerAction)JsonUtil.fromJson((String)row.getString("payload"), TriggerAction.class);
            actions.add(action);
        }
        trigger.setActions(actions);
    }

    private Trigger mapTrigger(Row row) {
        Trigger trigger = new Trigger();
        trigger.setTenantId(row.getString("tenantId"));
        trigger.setId(row.getString("id"));
        trigger.setAutoDisable(row.getBool("autoDisable"));
        trigger.setAutoEnable(row.getBool("autoEnable"));
        trigger.setAutoResolve(row.getBool("autoResolve"));
        trigger.setAutoResolveAlerts(row.getBool("autoResolveAlerts"));
        trigger.setAutoResolveMatch(Match.valueOf((String)row.getString("autoResolveMatch")));
        trigger.setContext(row.getMap("context", String.class, String.class));
        trigger.setDataIdMap(row.getMap("dataIdMap", String.class, String.class));
        trigger.setDescription(row.getString("description"));
        trigger.setEnabled(row.getBool("enabled"));
        trigger.setEventCategory(row.getString("eventCategory"));
        trigger.setEventText(row.getString("eventText"));
        trigger.setEventType(EventType.valueOf((String)row.getString("eventType")));
        trigger.setFiringMatch(Match.valueOf((String)row.getString("firingMatch")));
        trigger.setMemberOf(row.getString("memberOf"));
        trigger.setName(row.getString("name"));
        trigger.setSource(row.getString("source"));
        trigger.setSeverity(Severity.valueOf((String)row.getString("severity")));
        trigger.setType(TriggerType.valueOf((String)row.getString("type")));
        trigger.setTags(row.getMap("tags", String.class, String.class));
        return trigger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger addMemberTrigger(String tenantId, String groupId, String memberId, String memberName, String memberDescription, Map<String, String> memberContext, Map<String, String> memberTags, Map<String, String> dataIdMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.isEmpty(dataIdMap)) {
            throw new IllegalArgumentException("DataIdMap must be not null");
        }
        try {
            this.deferNotifications();
            Trigger group = this.getTrigger(tenantId, groupId);
            if (group == null) {
                throw new IllegalArgumentException("Trigger not found for tenantId/triggerId [ " + tenantId + "]/[" + groupId + "]");
            }
            HashSet<String> dataIdTokens = new HashSet<String>();
            Collection<Condition> conditions = this.getTriggerConditions(tenantId, groupId, null);
            for (Condition c : conditions) {
                if (Condition.Type.COMPARE == c.getType()) {
                    dataIdTokens.add(c.getDataId());
                    dataIdTokens.add(((CompareCondition)c).getData2Id());
                    continue;
                }
                dataIdTokens.add(c.getDataId());
            }
            if (!dataIdTokens.equals(dataIdMap.keySet())) {
                throw new IllegalArgumentException("DataIdMap must contain the exact dataIds (keyset) expected by the condition set. Expected: " + dataIdTokens + ", dataIdMap: " + dataIdMap.keySet());
            }
            memberId = this.isEmpty(memberId) ? Trigger.generateId() : memberId;
            memberName = this.isEmpty(memberName) ? group.getName() : memberName;
            Trigger member = new Trigger(tenantId, memberId, memberName);
            this.copyGroupTrigger(group, member, true);
            if (!this.isEmpty(memberDescription)) {
                member.setDescription(memberDescription);
            }
            if (null != memberContext) {
                HashMap<String, String> combinedContext = new HashMap<String, String>();
                combinedContext.putAll(member.getContext());
                combinedContext.putAll(memberContext);
                member.setContext(combinedContext);
            }
            if (null != memberTags) {
                HashMap<String, String> combinedTags = new HashMap<String, String>();
                combinedTags.putAll(member.getTags());
                combinedTags.putAll(memberTags);
                member.setTags((Map)combinedTags);
            }
            member.setDataIdMap(dataIdMap);
            this.addTrigger(member);
            for (Condition c : conditions) {
                Condition newCondition = this.getMemberCondition(member, c, dataIdMap);
                if (newCondition == null) continue;
                this.addCondition(newCondition);
            }
            Collection<Dampening> dampenings = this.getTriggerDampenings(tenantId, groupId, null);
            for (Dampening d : dampenings) {
                Dampening newDampening = new Dampening(member.getTenantId(), member.getId(), d.getTriggerMode(), d.getType(), d.getEvalTrueSetting(), d.getEvalTotalSetting(), d.getEvalTimeSetting());
                this.addDampening(newDampening);
            }
            this.insertTags(tenantId, TagType.TRIGGER, member.getId(), member.getTags());
            Trigger trigger = member;
            return trigger;
        }
        finally {
            this.releaseNotifications();
        }
    }

    private Condition getMemberCondition(Trigger member, Condition groupCondition, Map<String, String> dataIdMap) {
        AvailabilityCondition newCondition = null;
        switch (groupCondition.getType()) {
            case AVAILABILITY: {
                newCondition = new AvailabilityCondition(member.getTenantId(), member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((AvailabilityCondition)groupCondition).getOperator());
                break;
            }
            case COMPARE: {
                newCondition = new CompareCondition(member.getTenantId(), member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((CompareCondition)groupCondition).getOperator(), ((CompareCondition)groupCondition).getData2Multiplier(), dataIdMap.get(((CompareCondition)groupCondition).getData2Id()));
                break;
            }
            case EVENT: {
                newCondition = new EventCondition(member.getTenantId(), member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((EventCondition)groupCondition).getExpression());
                break;
            }
            case EXTERNAL: {
                String tokenDataId = groupCondition.getDataId();
                String memberDataId = dataIdMap.get(tokenDataId);
                String tokenExpression = ((ExternalCondition)groupCondition).getExpression();
                String memberExpression = this.isEmpty(tokenExpression) ? tokenExpression : tokenExpression.replace(tokenDataId, memberDataId);
                newCondition = new ExternalCondition(member.getTenantId(), member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), memberDataId, ((ExternalCondition)groupCondition).getAlerterId(), memberExpression);
                break;
            }
            case RANGE: {
                newCondition = new ThresholdRangeCondition(member.getTenantId(), member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((ThresholdRangeCondition)groupCondition).getOperatorLow(), ((ThresholdRangeCondition)groupCondition).getOperatorHigh(), ((ThresholdRangeCondition)groupCondition).getThresholdLow(), ((ThresholdRangeCondition)groupCondition).getThresholdHigh(), ((ThresholdRangeCondition)groupCondition).isInRange());
                break;
            }
            case RATE: {
                newCondition = new RateCondition(member.getTenantId(), member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((RateCondition)groupCondition).getDirection(), ((RateCondition)groupCondition).getPeriod(), ((RateCondition)groupCondition).getOperator(), ((RateCondition)groupCondition).getThreshold());
                break;
            }
            case STRING: {
                newCondition = new StringCondition(member.getTenantId(), member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((StringCondition)groupCondition).getOperator(), ((StringCondition)groupCondition).getPattern(), ((StringCondition)groupCondition).isIgnoreCase());
                break;
            }
            case THRESHOLD: {
                newCondition = new ThresholdCondition(member.getTenantId(), member.getId(), groupCondition.getTriggerMode(), groupCondition.getConditionSetSize(), groupCondition.getConditionSetIndex(), dataIdMap.get(groupCondition.getDataId()), ((ThresholdCondition)groupCondition).getOperator(), ((ThresholdCondition)groupCondition).getThreshold());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected Condition type: " + groupCondition.getType().name());
            }
        }
        newCondition.setContext(groupCondition.getContext());
        return newCondition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trigger addDataDrivenMemberTrigger(String tenantId, String groupId, String source) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.isEmpty(source)) {
            throw new IllegalArgumentException("source must be not null");
        }
        if ("_none_".equals(source)) {
            throw new IllegalArgumentException("source is required (can not be none)");
        }
        try {
            this.deferNotifications();
            Trigger group = this.getTrigger(tenantId, groupId);
            if (group == null) {
                throw new IllegalArgumentException("Trigger not found for tenantId/triggerId [ " + tenantId + "]/[" + groupId + "]");
            }
            HashMap<String, String> dataIdMap = new HashMap<String, String>();
            Collection<Condition> conditions = this.getTriggerConditions(tenantId, groupId, null);
            for (Condition c : conditions) {
                dataIdMap.put(c.getDataId(), c.getDataId());
                if (Condition.Type.COMPARE != c.getType()) continue;
                dataIdMap.put(((CompareCondition)c).getData2Id(), ((CompareCondition)c).getData2Id());
            }
            String memberId = group.getId() + "_" + source;
            Trigger member = new Trigger(tenantId, memberId, group.getName());
            this.copyGroupTrigger(group, member, true);
            member.setSource(source);
            this.addTrigger(member);
            for (Condition condition : conditions) {
                Condition newCondition = this.getMemberCondition(member, condition, dataIdMap);
                if (newCondition == null) continue;
                this.addCondition(newCondition);
            }
            Collection<Dampening> dampenings = this.getTriggerDampenings(tenantId, groupId, null);
            for (Dampening d : dampenings) {
                Dampening newDampening = new Dampening(member.getTenantId(), member.getId(), d.getTriggerMode(), d.getType(), d.getEvalTrueSetting(), d.getEvalTotalSetting(), d.getEvalTimeSetting());
                this.addDampening(newDampening);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(member.getTags());
            hashMap.put("source", source);
            this.insertTags(tenantId, TagType.TRIGGER, member.getId(), member.getTags());
            Trigger trigger = member;
            return trigger;
        }
        finally {
            this.releaseNotifications();
        }
    }

    public Dampening addDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        String triggerId = dampening.getTriggerId();
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        return this.addDampening(dampening);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dampening addGroupDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        try {
            this.deferNotifications();
            this.checkTenantId(tenantId, dampening);
            String groupId = dampening.getTriggerId();
            Trigger groupTrigger = this.getTrigger(tenantId, groupId);
            if (null == groupTrigger) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] does not exist.");
            }
            if (!groupTrigger.isGroup()) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger.");
            }
            Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
            for (Trigger member : memberTriggers) {
                dampening.setTriggerId(member.getId());
                this.addDampening(dampening);
            }
            dampening.setTriggerId(groupTrigger.getId());
            Dampening dampening2 = this.addDampening(dampening);
            return dampening2;
        }
        finally {
            this.releaseNotifications();
        }
    }

    private Dampening addDampening(Dampening dampening) throws Exception {
        PreparedStatement insertDampening = CassStatement.get(this.session, CassStatement.INSERT_DAMPENING);
        if (insertDampening == null) {
            throw new RuntimeException("insertDampening PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertDampening.bind(new Object[]{dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.DAMPENING_CHANGE, dampening));
        return dampening;
    }

    public void removeDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("dampeningId must be not null");
        }
        Dampening dampening = this.getDampening(tenantId, dampeningId);
        if (null == dampening) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring removeDampening(" + dampeningId + "), the Dampening does not exist."));
            }
            return;
        }
        String triggerId = dampening.getTriggerId();
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        this.removeDampening(dampening);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroupDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("dampeningId must be not null");
        }
        try {
            this.deferNotifications();
            Dampening dampening = this.getDampening(tenantId, dampeningId);
            if (null == dampening) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Ignoring removeDampening(" + dampeningId + "), the Dampening does not exist."));
                }
                return;
            }
            String groupId = dampening.getTriggerId();
            Trigger groupTrigger = this.getTrigger(tenantId, groupId);
            if (null == groupTrigger) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] does not exist.");
            }
            if (!groupTrigger.isGroup()) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger.");
            }
            Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
            for (Trigger member : memberTriggers) {
                Collection<Dampening> dampenings = this.getTriggerDampenings(tenantId, member.getId(), dampening.getTriggerMode());
                if (dampenings.isEmpty()) continue;
                this.removeDampening(dampenings.iterator().next());
            }
            this.removeDampening(dampening);
        }
        finally {
            this.releaseNotifications();
        }
    }

    private void removeDampening(Dampening dampening) throws Exception {
        PreparedStatement deleteDampeningId = CassStatement.get(this.session, CassStatement.DELETE_DAMPENING_ID);
        if (deleteDampeningId == null) {
            throw new RuntimeException("deleteDampeningId PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteDampeningId.bind(new Object[]{dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.DAMPENING_CHANGE, dampening));
    }

    public Dampening updateDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        this.checkTenantId(tenantId, dampening);
        String triggerId = dampening.getTriggerId();
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        return this.updateDampening(dampening);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dampening updateGroupDampening(String tenantId, Dampening dampening) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampening)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        try {
            this.deferNotifications();
            this.checkTenantId(tenantId, dampening);
            String groupId = dampening.getTriggerId();
            Trigger groupTrigger = this.getTrigger(tenantId, groupId);
            if (null == groupTrigger) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] does not exist.");
            }
            if (!groupTrigger.isGroup()) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger.");
            }
            Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
            for (Trigger member : memberTriggers) {
                dampening.setTriggerId(member.getId());
                this.updateDampening(dampening);
            }
            dampening.setTriggerId(groupTrigger.getId());
            Dampening dampening2 = this.updateDampening(dampening);
            return dampening2;
        }
        finally {
            this.releaseNotifications();
        }
    }

    private Dampening updateDampening(Dampening dampening) throws Exception {
        PreparedStatement updateDampeningId = CassStatement.get(this.session, CassStatement.UPDATE_DAMPENING_ID);
        if (updateDampeningId == null) {
            throw new RuntimeException("updateDampeningId PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateDampeningId.bind(new Object[]{dampening.getType().name(), dampening.getEvalTrueSetting(), dampening.getEvalTotalSetting(), dampening.getEvalTimeSetting(), dampening.getTenantId(), dampening.getTriggerId(), dampening.getTriggerMode().name(), dampening.getDampeningId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (null != this.alertsEngine) {
            this.alertsEngine.reloadTrigger(dampening.getTenantId(), dampening.getTriggerId());
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.DAMPENING_CHANGE, dampening));
        return dampening;
    }

    public Dampening getDampening(String tenantId, String dampeningId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(dampeningId)) {
            throw new IllegalArgumentException("DampeningId must be not null");
        }
        PreparedStatement selectDampeningId = CassStatement.get(this.session, CassStatement.SELECT_DAMPENING_ID);
        if (selectDampeningId == null) {
            throw new RuntimeException("selectDampeningId PreparedStatement is null");
        }
        Dampening dampening = null;
        try {
            ResultSet rsDampening = this.session.execute((Statement)selectDampeningId.bind(new Object[]{tenantId, dampeningId}));
            Iterator itDampening = rsDampening.iterator();
            if (itDampening.hasNext()) {
                Row row = (Row)itDampening.next();
                dampening = this.mapDampening(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampening;
    }

    public Collection<Dampening> getTriggerDampenings(String tenantId, String triggerId, Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        PreparedStatement selectTriggerDampenings = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_DAMPENINGS);
        PreparedStatement selectTriggerDampeningsMode = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_DAMPENINGS_MODE);
        if (selectTriggerDampenings == null || selectTriggerDampeningsMode == null) {
            throw new RuntimeException("selectTriggerDampenings* PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = triggerMode == null ? this.session.execute((Statement)selectTriggerDampenings.bind(new Object[]{tenantId, triggerId})) : this.session.execute((Statement)selectTriggerDampeningsMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getAllDampenings() throws Exception {
        PreparedStatement selectDampeningsAll = CassStatement.get(this.session, CassStatement.SELECT_DAMPENINGS_ALL);
        if (selectDampeningsAll == null) {
            throw new RuntimeException("selectDampeningsAll PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)selectDampeningsAll.bind());
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    public Collection<Dampening> getDampenings(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        PreparedStatement selectDampeningsByTenant = CassStatement.get(this.session, CassStatement.SELECT_DAMPENINGS_BY_TENANT);
        if (selectDampeningsByTenant == null) {
            throw new RuntimeException("selectDampeningsByTenant PreparedStatement is null");
        }
        ArrayList<Dampening> dampenings = new ArrayList<Dampening>();
        try {
            ResultSet rsDampenings = this.session.execute((Statement)selectDampeningsByTenant.bind(new Object[]{tenantId}));
            this.mapDampenings(rsDampenings, dampenings);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return dampenings;
    }

    private void mapDampenings(ResultSet rsDampenings, List<Dampening> dampenings) throws Exception {
        for (Row row : rsDampenings) {
            Dampening dampening = this.mapDampening(row);
            dampenings.add(dampening);
        }
    }

    private Dampening mapDampening(Row row) {
        Dampening dampening = new Dampening();
        dampening.setTenantId(row.getString("tenantId"));
        dampening.setTriggerId(row.getString("triggerId"));
        dampening.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
        dampening.setType(Dampening.Type.valueOf((String)row.getString("type")));
        dampening.setEvalTrueSetting(row.getInt("evalTrueSetting"));
        dampening.setEvalTotalSetting(row.getInt("evalTotalSetting"));
        dampening.setEvalTimeSetting(row.getLong("evalTimeSetting"));
        return dampening;
    }

    @Deprecated
    public Collection<Condition> addCondition(String tenantId, String triggerId, Mode triggerMode, Condition condition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        condition.setTenantId(tenantId);
        condition.setTriggerId(triggerId);
        condition.setTriggerMode(triggerMode);
        return this.addCondition(condition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Condition> setGroupConditions(String tenantId, String groupId, Mode triggerMode, Collection<Condition> groupConditions, Map<String, Map<String, String>> dataIdMemberMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(groupId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (groupConditions == null) {
            throw new IllegalArgumentException("GroupConditions must be not null");
        }
        try {
            this.deferNotifications();
            Trigger group = this.getTrigger(tenantId, groupId);
            if (null == group) {
                throw new NotFoundApplicationException(Trigger.class.getName(), tenantId, groupId);
            }
            if (!group.isGroup()) {
                throw new IllegalArgumentException("Trigger [" + tenantId + "/" + groupId + "] is not a group trigger.");
            }
            Collection<Trigger> memberTriggers = this.getMemberTriggers(tenantId, groupId, false);
            if (TriggerType.DATA_DRIVEN_GROUP == group.getType()) {
                for (Trigger member : memberTriggers) {
                    this.removeTrigger(member);
                }
                memberTriggers.clear();
            }
            if (!memberTriggers.isEmpty()) {
                if (null == dataIdMemberMap) {
                    dataIdMemberMap = new HashMap<String, Map<String, String>>();
                }
                for (Trigger member : memberTriggers) {
                    String memberId = member.getId();
                    for (Map.Entry entry : member.getDataIdMap().entrySet()) {
                        String groupDataId = (String)entry.getKey();
                        String memberDataId = (String)entry.getValue();
                        Map<String, String> memberIdMap = dataIdMemberMap.get(groupDataId);
                        if (null == memberIdMap) {
                            memberIdMap = new HashMap<String, String>(memberTriggers.size());
                            dataIdMemberMap.put(groupDataId, memberIdMap);
                        }
                        if (memberIdMap.containsKey(memberId)) {
                            if (memberIdMap.get(memberId).equals(member.getDataIdMap().get(groupDataId))) continue;
                            HashMap<String, String> updatedDataIdMap = new HashMap<String, String>(member.getDataIdMap());
                            updatedDataIdMap.put(groupDataId, memberIdMap.get(memberId));
                            this.updateMemberTriggerDataIdMap(tenantId, memberId, updatedDataIdMap);
                            continue;
                        }
                        memberIdMap.put(memberId, memberDataId);
                    }
                }
                for (Condition groupCondition : groupConditions) {
                    CompareCondition cc;
                    if (!dataIdMemberMap.containsKey(groupCondition.getDataId())) {
                        throw new IllegalArgumentException("Missing dataIdMap entry for dataId token [" + groupCondition.getDataId() + "]");
                    }
                    if (Condition.Type.COMPARE == groupCondition.getType() && !dataIdMemberMap.containsKey((cc = (CompareCondition)groupCondition).getData2Id())) {
                        throw new IllegalArgumentException("Missing dataIdMap entry for CompareCondition data2Id token [" + cc.getData2Id() + "]");
                    }
                    for (Map.Entry<String, Map<String, String>> entry : dataIdMemberMap.entrySet()) {
                        String dataId = entry.getKey();
                        Map<String, String> memberMap = entry.getValue();
                        if (memberMap.size() != memberTriggers.size()) {
                            throw new IllegalArgumentException("memberMap size [" + memberMap.size() + "] for dataId [" + (String)dataId + "] must equal number of member triggers [" + memberTriggers.size() + "]");
                        }
                        for (Trigger member : memberTriggers) {
                            String value = memberMap.get(member.getId());
                            if (!this.isEmpty(value)) continue;
                            throw new IllegalArgumentException("Invalid mapping. DataId=[" + (String)dataId + "], Member=[" + member.getId() + "], value=[" + value + "]");
                        }
                    }
                }
            }
            for (Condition groupCondition : groupConditions) {
                groupCondition.setTenantId(group.getTenantId());
                groupCondition.setTriggerId(group.getId());
                groupCondition.setTriggerMode(triggerMode);
            }
            HashMap<String, String> dataIdMap = new HashMap<String, String>();
            ArrayList<Condition> memberConditions = new ArrayList<Condition>(groupConditions.size());
            for (Trigger member : memberTriggers) {
                dataIdMap.clear();
                memberConditions.clear();
                for (Map.Entry<String, Map<String, String>> entry : dataIdMemberMap.entrySet()) {
                    dataIdMap.put(entry.getKey(), entry.getValue().get(member.getId()));
                }
                for (Condition groupCondition : groupConditions) {
                    Condition memberCondition = this.getMemberCondition(member, groupCondition, dataIdMap);
                    memberConditions.add(memberCondition);
                }
                Collection<Condition> memberConditionSet = this.setConditions(tenantId, member.getId(), triggerMode, memberConditions);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Member condition set: " + memberConditionSet));
            }
            Iterator<Map.Entry<String, Map<String, String>>> iterator = this.setConditions(tenantId, groupId, triggerMode, groupConditions);
            return iterator;
        }
        finally {
            this.releaseNotifications();
        }
    }

    private void updateMemberTriggerDataIdMap(String tenantId, String memberTriggerId, Map<String, String> dataIdMap) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(memberTriggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.isEmpty(dataIdMap)) {
            throw new IllegalArgumentException("DatIdMap must be not null");
        }
        PreparedStatement updateTriggerDataIdMap = CassStatement.get(this.session, CassStatement.UPDATE_TRIGGER_DATA_ID_MAP);
        if (updateTriggerDataIdMap == null) {
            throw new RuntimeException("updateTriggerDataIdMap PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateTriggerDataIdMap.bind(new Object[]{dataIdMap, tenantId, memberTriggerId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private Collection<Condition> addCondition(Condition condition) throws Exception {
        String tenantId = condition.getTenantId();
        String triggerId = condition.getTriggerId();
        Mode triggerMode = condition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        conditions.add(condition);
        int i = 0;
        for (Condition c : conditions) {
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, conditions);
    }

    @Deprecated
    public Collection<Condition> removeCondition(String tenantId, String conditionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition condition = this.getCondition(tenantId, conditionId);
        if (null == condition) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Ignoring removeCondition [" + conditionId + "], the condition does not exist."));
            }
            return null;
        }
        String triggerId = condition.getTriggerId();
        Trigger trigger = this.getTrigger(tenantId, triggerId);
        if (null == trigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (trigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (trigger.isMember() && !trigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        return this.removeCondition(condition);
    }

    private Collection<Condition> removeCondition(Condition condition) throws Exception {
        String tenantId = condition.getTenantId();
        String triggerId = condition.getTriggerId();
        Mode triggerMode = condition.getTriggerMode();
        String conditionId = condition.getConditionId();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        int i = 0;
        int size = conditions.size() - 1;
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(conditionId)) continue;
            c.setConditionSetSize(conditions.size());
            c.setConditionSetIndex(++i);
            newConditions.add(c);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, newConditions);
    }

    @Deprecated
    public Collection<Condition> updateCondition(String tenantId, Condition condition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (condition == null) {
            throw new IllegalArgumentException("Condition must be not null");
        }
        String conditionId = condition.getConditionId();
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("ConditionId must be not null");
        }
        Condition existingCondition = this.getCondition(tenantId, conditionId);
        if (null == existingCondition) {
            throw new IllegalArgumentException("ConditionId [" + conditionId + "] on tenant " + tenantId + " does not exist.");
        }
        if (existingCondition.getTriggerMode() != condition.getTriggerMode()) {
            throw new IllegalArgumentException("The condition trigger mode [" + existingCondition.getTriggerMode().name() + "] can not be changed.");
        }
        String triggerId = existingCondition.getTriggerId();
        Trigger existingTrigger = this.getTrigger(tenantId, triggerId);
        if (null == existingTrigger) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] does not exist.");
        }
        if (existingTrigger.isGroup()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a group trigger.");
        }
        if (existingTrigger.isMember() && !existingTrigger.isOrphan()) {
            throw new IllegalArgumentException("Trigger [" + tenantId + "/" + triggerId + "] is a member trigger and must be managed via the group.");
        }
        return this.updateCondition(existingTrigger, condition);
    }

    private Collection<Condition> updateCondition(Trigger trigger, Condition condition) throws Exception {
        String tenantId = trigger.getTenantId();
        String triggerId = trigger.getId();
        Mode triggerMode = condition.getTriggerMode();
        Collection<Condition> conditions = this.getTriggerConditions(tenantId, triggerId, triggerMode);
        int size = conditions.size();
        ArrayList<Condition> newConditions = new ArrayList<Condition>(size);
        for (Condition c : conditions) {
            if (c.getConditionId().equals(condition.getConditionId())) {
                newConditions.add(condition);
                continue;
            }
            newConditions.add(c);
        }
        return this.setConditions(tenantId, triggerId, triggerMode, newConditions);
    }

    public Collection<Condition> setConditions(String tenantId, String triggerId, Mode triggerMode, Collection<Condition> conditions) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must be not null");
        }
        if (conditions == null) {
            throw new IllegalArgumentException("Conditions must be not null");
        }
        PreparedStatement insertConditionAvailability = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_AVAILABILITY);
        PreparedStatement insertConditionCompare = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_COMPARE);
        PreparedStatement insertConditionEvent = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_EVENT);
        PreparedStatement insertConditionExternal = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_EXTERNAL);
        PreparedStatement insertConditionMissing = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_MISSING);
        PreparedStatement insertConditionRate = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_RATE);
        PreparedStatement insertConditionString = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_STRING);
        PreparedStatement insertConditionThreshold = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_THRESHOLD);
        PreparedStatement insertConditionThresholdRange = CassStatement.get(this.session, CassStatement.INSERT_CONDITION_THRESHOLD_RANGE);
        if (insertConditionAvailability == null || insertConditionCompare == null || insertConditionEvent == null || insertConditionExternal == null || insertConditionMissing == null || insertConditionRate == null || insertConditionString == null || insertConditionThreshold == null || insertConditionThresholdRange == null) {
            throw new RuntimeException("insert*Condition PreparedStatement is null");
        }
        this.removeConditions(tenantId, triggerId, triggerMode);
        HashSet<String> dataIds = new HashSet<String>();
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            BatchStatement batch = new BatchStatement(this.batchType);
            int i = 0;
            int indexCondition = 0;
            for (Condition cond : conditions) {
                cond.setTenantId(tenantId);
                cond.setTriggerId(triggerId);
                cond.setTriggerMode(triggerMode);
                cond.setConditionSetSize(conditions.size());
                cond.setConditionSetIndex(++indexCondition);
                switch (cond.getType()) {
                    case AVAILABILITY: {
                        AvailabilityCondition aCond = (AvailabilityCondition)cond;
                        batch.add((Statement)insertConditionAvailability.bind(new Object[]{aCond.getTenantId(), aCond.getTriggerId(), aCond.getTriggerMode().name(), aCond.getContext(), aCond.getConditionSetSize(), aCond.getConditionSetIndex(), aCond.getConditionId(), aCond.getDataId(), aCond.getOperator().name()}));
                        dataIds.add(aCond.getDataId());
                        break;
                    }
                    case COMPARE: {
                        CompareCondition cCond = (CompareCondition)cond;
                        batch.add((Statement)insertConditionCompare.bind(new Object[]{cCond.getTenantId(), cCond.getTriggerId(), cCond.getTriggerMode().name(), cCond.getContext(), cCond.getConditionSetSize(), cCond.getConditionSetIndex(), cCond.getConditionId(), cCond.getDataId(), cCond.getOperator().name(), cCond.getData2Id(), cCond.getData2Multiplier()}));
                        dataIds.add(cCond.getDataId());
                        dataIds.add(cCond.getData2Id());
                        break;
                    }
                    case EVENT: {
                        EventCondition evCond = (EventCondition)cond;
                        batch.add((Statement)insertConditionEvent.bind(new Object[]{evCond.getTenantId(), evCond.getTriggerId(), evCond.getTriggerMode().name(), evCond.getContext(), evCond.getConditionSetSize(), evCond.getConditionSetIndex(), evCond.getConditionId(), evCond.getDataId(), evCond.getExpression()}));
                        dataIds.add(evCond.getDataId());
                        break;
                    }
                    case EXTERNAL: {
                        ExternalCondition eCond = (ExternalCondition)cond;
                        batch.add((Statement)insertConditionExternal.bind(new Object[]{eCond.getTenantId(), eCond.getTriggerId(), eCond.getTriggerMode().name(), eCond.getContext(), eCond.getConditionSetSize(), eCond.getConditionSetIndex(), eCond.getConditionId(), eCond.getDataId(), eCond.getAlerterId(), eCond.getExpression()}));
                        dataIds.add(eCond.getDataId());
                        break;
                    }
                    case MISSING: {
                        MissingCondition mCond = (MissingCondition)cond;
                        batch.add((Statement)insertConditionMissing.bind(new Object[]{mCond.getTenantId(), mCond.getTriggerId(), mCond.getTriggerMode().name(), mCond.getContext(), mCond.getConditionSetSize(), mCond.getConditionSetIndex(), mCond.getConditionId(), mCond.getDataId(), mCond.getInterval()}));
                        dataIds.add(mCond.getDataId());
                        break;
                    }
                    case RANGE: {
                        ThresholdRangeCondition rCond = (ThresholdRangeCondition)cond;
                        batch.add((Statement)insertConditionThresholdRange.bind(new Object[]{rCond.getTenantId(), rCond.getTriggerId(), rCond.getTriggerMode().name(), rCond.getContext(), rCond.getConditionSetSize(), rCond.getConditionSetIndex(), rCond.getConditionId(), rCond.getDataId(), rCond.getOperatorLow().name(), rCond.getOperatorHigh().name(), rCond.getThresholdLow(), rCond.getThresholdHigh(), rCond.isInRange()}));
                        dataIds.add(rCond.getDataId());
                        break;
                    }
                    case RATE: {
                        RateCondition rateCond = (RateCondition)cond;
                        batch.add((Statement)insertConditionRate.bind(new Object[]{rateCond.getTenantId(), rateCond.getTriggerId(), rateCond.getTriggerMode().name(), rateCond.getContext(), rateCond.getConditionSetSize(), rateCond.getConditionSetIndex(), rateCond.getConditionId(), rateCond.getDataId(), rateCond.getDirection().name(), rateCond.getPeriod().name(), rateCond.getOperator().name(), rateCond.getThreshold()}));
                        dataIds.add(rateCond.getDataId());
                        break;
                    }
                    case STRING: {
                        StringCondition sCond = (StringCondition)cond;
                        batch.add((Statement)insertConditionString.bind(new Object[]{sCond.getTenantId(), sCond.getTriggerId(), sCond.getTriggerMode().name(), sCond.getContext(), sCond.getConditionSetSize(), sCond.getConditionSetIndex(), sCond.getConditionId(), sCond.getDataId(), sCond.getOperator().name(), sCond.getPattern(), sCond.isIgnoreCase()}));
                        dataIds.add(sCond.getDataId());
                        break;
                    }
                    case THRESHOLD: {
                        ThresholdCondition tCond = (ThresholdCondition)cond;
                        batch.add((Statement)insertConditionThreshold.bind(new Object[]{tCond.getTenantId(), tCond.getTriggerId(), tCond.getTriggerMode().name(), tCond.getContext(), tCond.getConditionSetSize(), tCond.getConditionSetIndex(), tCond.getConditionId(), tCond.getDataId(), tCond.getOperator().name(), tCond.getThreshold()}));
                        dataIds.add(tCond.getDataId());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected ConditionType: " + cond);
                    }
                }
                if ((i += batch.size()) <= this.batchSize) continue;
                futures.add(this.session.executeAsync((Statement)batch));
                batch.clear();
                i = 0;
            }
            if (batch.size() > 0) {
                futures.add(this.session.executeAsync((Statement)batch));
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        if (this.alertsEngine != null) {
            this.alertsEngine.reloadTrigger(tenantId, triggerId);
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.TRIGGER_CONDITION_CHANGE, tenantId, triggerId, dataIds));
        return conditions;
    }

    private void insertTags(String tenantId, TagType type, String id, Map<String, String> tags) throws Exception {
        if (this.isEmpty(tags)) {
            return;
        }
        PreparedStatement insertTag = CassStatement.get(this.session, CassStatement.INSERT_TAG);
        if (insertTag == null) {
            throw new RuntimeException("insertTag PreparedStatement is null");
        }
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>(tags.size());
        BatchStatement batch = new BatchStatement(this.batchType);
        int i = 0;
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            batch.add((Statement)insertTag.bind(new Object[]{tenantId, type.name(), tag.getKey(), tag.getValue(), id}));
            if ((i += batch.size()) <= this.batchSize) continue;
            futures.add(this.session.executeAsync((Statement)batch));
            batch.clear();
            i = 0;
        }
        if (batch.size() > 0) {
            futures.add(this.session.executeAsync((Statement)batch));
        }
        Futures.allAsList(futures).get();
    }

    private void removeConditions(String tenantId, String triggerId, Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must not be null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must not be null");
        }
        if (triggerMode == null) {
            throw new IllegalArgumentException("TriggerMode must not be null");
        }
        PreparedStatement deleteConditionsMode = CassStatement.get(this.session, CassStatement.DELETE_CONDITIONS_MODE);
        if (deleteConditionsMode == null) {
            throw new RuntimeException("deleteConditionsMode PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteConditionsMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    private void deleteTags(String tenantId, TagType type, String id, Map<String, String> tags) throws Exception {
        if (this.isEmpty(tags)) {
            return;
        }
        PreparedStatement deleteTag = CassStatement.get(this.session, CassStatement.DELETE_TAG);
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>(tags.size());
        BatchStatement batch = new BatchStatement(this.batchType);
        int i = 0;
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            batch.add((Statement)deleteTag.bind(new Object[]{tenantId, type.name(), tag.getKey(), tag.getValue(), id}));
            if ((i += batch.size()) <= this.batchSize) continue;
            futures.add(this.session.executeAsync((Statement)batch));
            batch.clear();
            i = 0;
        }
        if (batch.size() > 0) {
            futures.add(this.session.executeAsync((Statement)batch));
        }
        Futures.allAsList(futures).get();
    }

    @Deprecated
    public Condition getCondition(String tenantId, String conditionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(conditionId)) {
            throw new IllegalArgumentException("conditionId must be not null");
        }
        PreparedStatement selectConditionId = CassStatement.get(this.session, CassStatement.SELECT_CONDITION_ID);
        if (selectConditionId == null) {
            throw new RuntimeException("selectConditionId PreparedStatement is null");
        }
        Condition condition = null;
        try {
            ResultSet rsCondition = this.session.execute((Statement)selectConditionId.bind(new Object[]{tenantId, conditionId}));
            Iterator itCondition = rsCondition.iterator();
            if (itCondition.hasNext()) {
                Row row = (Row)itCondition.next();
                condition = this.mapCondition(row);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return condition;
    }

    public Collection<Condition> getTriggerConditions(String tenantId, String triggerId, Mode triggerMode) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("triggerId must be not null");
        }
        PreparedStatement selectTriggerConditions = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_CONDITIONS);
        PreparedStatement selectTriggerConditionsTriggerMode = CassStatement.get(this.session, CassStatement.SELECT_TRIGGER_CONDITIONS_TRIGGER_MODE);
        if (selectTriggerConditions == null || selectTriggerConditionsTriggerMode == null) {
            throw new RuntimeException("selectTriggerConditions* PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = triggerMode == null ? this.session.execute((Statement)selectTriggerConditions.bind(new Object[]{tenantId, triggerId})) : this.session.execute((Statement)selectTriggerConditionsTriggerMode.bind(new Object[]{tenantId, triggerId, triggerMode.name()}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getAllConditions() throws Exception {
        PreparedStatement selectConditionsAll = CassStatement.get(this.session, CassStatement.SELECT_CONDITIONS_ALL);
        if (selectConditionsAll == null) {
            throw new RuntimeException("selectConditionsAll PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)selectConditionsAll.bind());
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    public Collection<Condition> getConditions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        PreparedStatement selectConditionsByTenant = CassStatement.get(this.session, CassStatement.SELECT_CONDITIONS_BY_TENANT);
        if (selectConditionsByTenant == null) {
            throw new RuntimeException("selectConditionsByTenant PreparedStatement is null");
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        try {
            ResultSet rsConditions = this.session.execute((Statement)selectConditionsByTenant.bind(new Object[]{tenantId}));
            this.mapConditions(rsConditions, conditions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return conditions;
    }

    private void mapConditions(ResultSet rsConditions, List<Condition> conditions) throws Exception {
        for (Row row : rsConditions) {
            Condition condition = this.mapCondition(row);
            if (condition == null) continue;
            conditions.add(condition);
        }
    }

    private Condition mapCondition(Row row) throws Exception {
        EventCondition condition = null;
        String type = row.getString("type");
        if (type != null && !type.isEmpty()) {
            switch (Condition.Type.valueOf((String)type)) {
                case AVAILABILITY: {
                    AvailabilityCondition aCondition = new AvailabilityCondition();
                    aCondition.setTenantId(row.getString("tenantId"));
                    aCondition.setTriggerId(row.getString("triggerId"));
                    aCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    aCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    aCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    aCondition.setDataId(row.getString("dataId"));
                    aCondition.setOperator(AvailabilityCondition.Operator.valueOf((String)row.getString("operator")));
                    aCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = aCondition;
                    break;
                }
                case COMPARE: {
                    CompareCondition cCondition = new CompareCondition();
                    cCondition.setTenantId(row.getString("tenantId"));
                    cCondition.setTriggerId(row.getString("triggerId"));
                    cCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    cCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    cCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    cCondition.setDataId(row.getString("dataId"));
                    cCondition.setOperator(CompareCondition.Operator.valueOf((String)row.getString("operator")));
                    cCondition.setData2Id(row.getString("data2Id"));
                    cCondition.setData2Multiplier(Double.valueOf(row.getDouble("data2Multiplier")));
                    cCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = cCondition;
                    break;
                }
                case EXTERNAL: {
                    ExternalCondition eCondition = new ExternalCondition();
                    eCondition.setTenantId(row.getString("tenantId"));
                    eCondition.setTriggerId(row.getString("triggerId"));
                    eCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    eCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    eCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    eCondition.setDataId(row.getString("dataId"));
                    eCondition.setAlerterId(row.getString("operator"));
                    eCondition.setExpression(row.getString("pattern"));
                    eCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = eCondition;
                    break;
                }
                case EVENT: {
                    EventCondition evCondition = new EventCondition();
                    evCondition.setTenantId(row.getString("tenantId"));
                    evCondition.setTriggerId(row.getString("triggerId"));
                    evCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    evCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    evCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    evCondition.setDataId(row.getString("dataId"));
                    evCondition.setExpression(row.getString("pattern"));
                    evCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = evCondition;
                    break;
                }
                case MISSING: {
                    MissingCondition mCondition = new MissingCondition();
                    mCondition.setTenantId(row.getString("tenantId"));
                    mCondition.setTriggerId(row.getString("triggerId"));
                    mCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    mCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    mCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    mCondition.setDataId(row.getString("dataId"));
                    mCondition.setInterval(row.getLong("interval"));
                    mCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = mCondition;
                    break;
                }
                case RANGE: {
                    ThresholdRangeCondition rCondition = new ThresholdRangeCondition();
                    rCondition.setTenantId(row.getString("tenantId"));
                    rCondition.setTriggerId(row.getString("triggerId"));
                    rCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    rCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    rCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    rCondition.setDataId(row.getString("dataId"));
                    rCondition.setOperatorLow(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorLow")));
                    rCondition.setOperatorHigh(ThresholdRangeCondition.Operator.valueOf((String)row.getString("operatorHigh")));
                    rCondition.setThresholdLow(Double.valueOf(row.getDouble("thresholdLow")));
                    rCondition.setThresholdHigh(Double.valueOf(row.getDouble("thresholdHigh")));
                    rCondition.setInRange(row.getBool("inRange"));
                    rCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = rCondition;
                    break;
                }
                case RATE: {
                    RateCondition rateCondition = new RateCondition();
                    rateCondition.setTenantId(row.getString("tenantId"));
                    rateCondition.setTriggerId(row.getString("triggerId"));
                    rateCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    rateCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    rateCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    rateCondition.setDataId(row.getString("dataId"));
                    rateCondition.setDirection(RateCondition.Direction.valueOf((String)row.getString("direction")));
                    rateCondition.setPeriod(RateCondition.Period.valueOf((String)row.getString("period")));
                    rateCondition.setOperator(RateCondition.Operator.valueOf((String)row.getString("operator")));
                    rateCondition.setThreshold(Double.valueOf(row.getDouble("threshold")));
                    rateCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = rateCondition;
                    break;
                }
                case STRING: {
                    StringCondition sCondition = new StringCondition();
                    sCondition.setTenantId(row.getString("tenantId"));
                    sCondition.setTriggerId(row.getString("triggerId"));
                    sCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    sCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    sCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    sCondition.setDataId(row.getString("dataId"));
                    sCondition.setOperator(StringCondition.Operator.valueOf((String)row.getString("operator")));
                    sCondition.setPattern(row.getString("pattern"));
                    sCondition.setIgnoreCase(row.getBool("ignoreCase"));
                    sCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = sCondition;
                    break;
                }
                case THRESHOLD: {
                    ThresholdCondition tCondition = new ThresholdCondition();
                    tCondition.setTenantId(row.getString("tenantId"));
                    tCondition.setTriggerId(row.getString("triggerId"));
                    tCondition.setTriggerMode(Mode.valueOf((String)row.getString("triggerMode")));
                    tCondition.setConditionSetSize(row.getInt("conditionSetSize"));
                    tCondition.setConditionSetIndex(row.getInt("conditionSetIndex"));
                    tCondition.setDataId(row.getString("dataId"));
                    tCondition.setOperator(ThresholdCondition.Operator.valueOf((String)row.getString("operator")));
                    tCondition.setThreshold(Double.valueOf(row.getDouble("threshold")));
                    tCondition.setContext(row.getMap("context", String.class, String.class));
                    condition = tCondition;
                    break;
                }
                default: {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Unexpected condition type found: " + type));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            this.log.debug((Object)"Invalid condition type: null or empty");
        }
        return condition;
    }

    public void addActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        PreparedStatement insertActionPlugin = CassStatement.get(this.session, CassStatement.INSERT_ACTION_PLUGIN);
        if (insertActionPlugin == null) {
            throw new RuntimeException("insertActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)insertActionPlugin.bind(new Object[]{actionPlugin, properties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addActionPlugin(String actionPlugin, Map<String, String> defaultProperties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (defaultProperties == null || defaultProperties.isEmpty()) {
            throw new IllegalArgumentException("defaultProperties must be not null");
        }
        PreparedStatement insertActionPluginDefaulProperties = CassStatement.get(this.session, CassStatement.INSERT_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (insertActionPluginDefaulProperties == null) {
            throw new RuntimeException("insertDefaulPropertiesActionPlugin PreparedStatement is null");
        }
        try {
            Set<String> properties = defaultProperties.keySet();
            this.session.execute((Statement)insertActionPluginDefaulProperties.bind(new Object[]{actionPlugin, properties, defaultProperties}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeActionPlugin(String actionPlugin) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        PreparedStatement deleteActionPlugin = CassStatement.get(this.session, CassStatement.DELETE_ACTION_PLUGIN);
        if (deleteActionPlugin == null) {
            throw new RuntimeException("deleteActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteActionPlugin.bind(new Object[]{actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateActionPlugin(String actionPlugin, Set<String> properties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (properties == null || properties.isEmpty()) {
            throw new IllegalArgumentException("properties must be not null");
        }
        PreparedStatement updateActionPlugin = CassStatement.get(this.session, CassStatement.UPDATE_ACTION_PLUGIN);
        if (updateActionPlugin == null) {
            throw new RuntimeException("updateActionPlugin PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateActionPlugin.bind(new Object[]{properties, actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void updateActionPlugin(String actionPlugin, Map<String, String> defaultProperties) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        if (defaultProperties == null || defaultProperties.isEmpty()) {
            throw new IllegalArgumentException("defaultProperties must be not null");
        }
        PreparedStatement updateDefaultPropertiesActionPlugin = CassStatement.get(this.session, CassStatement.UPDATE_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (updateDefaultPropertiesActionPlugin == null) {
            throw new RuntimeException("updateDefaultPropertiesActionPlugin PreparedStatement is null");
        }
        try {
            Set<String> properties = defaultProperties.keySet();
            this.session.execute((Statement)updateDefaultPropertiesActionPlugin.bind(new Object[]{properties, defaultProperties, actionPlugin}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Collection<String> getActionPlugins() throws Exception {
        PreparedStatement selectActionPlugins = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGINS);
        if (selectActionPlugins == null) {
            throw new RuntimeException("selectActionPlugins PreparedStatement is null");
        }
        ArrayList<String> actionPlugins = new ArrayList<String>();
        try {
            ResultSet rsActionPlugins = this.session.execute((Statement)selectActionPlugins.bind());
            for (Row row : rsActionPlugins) {
                actionPlugins.add(row.getString("actionPlugin"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actionPlugins;
    }

    @AccessTimeout(value=60L, unit=TimeUnit.SECONDS)
    public Set<String> getActionPlugin(String actionPlugin) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        PreparedStatement selectActionPlugin = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGIN);
        if (selectActionPlugin == null) {
            throw new RuntimeException("selectActionPlugin PreparedStatement is null");
        }
        Set properties = null;
        try {
            ResultSet rsActionPlugin = this.session.execute((Statement)selectActionPlugin.bind(new Object[]{actionPlugin}));
            Iterator itActionPlugin = rsActionPlugin.iterator();
            if (itActionPlugin.hasNext()) {
                Row row = (Row)itActionPlugin.next();
                properties = row.getSet("properties", String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return properties;
    }

    public Map<String, String> getDefaultActionPlugin(String actionPlugin) throws Exception {
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        PreparedStatement selectActionPluginDefaultProperties = CassStatement.get(this.session, CassStatement.SELECT_ACTION_PLUGIN_DEFAULT_PROPERTIES);
        if (selectActionPluginDefaultProperties == null) {
            throw new RuntimeException("selectDefaultPropertiesActionPlugin PreparedStatement is null");
        }
        Map defaultProperties = null;
        try {
            ResultSet rsActionPlugin = this.session.execute((Statement)selectActionPluginDefaultProperties.bind(new Object[]{actionPlugin}));
            Iterator itActionPlugin = rsActionPlugin.iterator();
            if (itActionPlugin.hasNext()) {
                Row row = (Row)itActionPlugin.next();
                defaultProperties = row.getMap("defaultProperties", String.class, String.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return defaultProperties;
    }

    public void removeActionDefinition(String tenantId, String actionPlugin, String actionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        PreparedStatement deleteAction = CassStatement.get(this.session, CassStatement.DELETE_ACTION_DEFINITION);
        if (deleteAction == null) {
            throw new RuntimeException("deleteAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)deleteAction.bind(new Object[]{tenantId, actionPlugin, actionId}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.ACTION_DEFINITION_REMOVE, tenantId, actionPlugin, actionId));
    }

    public void updateActionDefinition(String tenantId, ActionDefinition actionDefinition) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (actionDefinition == null) {
            throw new IllegalArgumentException("actionDefinition must be not null");
        }
        if (this.isEmpty(actionDefinition.getActionPlugin())) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionDefinition.getActionId())) {
            throw new IllegalArgumentException("ActionId must be not null");
        }
        if (this.isEmpty(actionDefinition.getProperties())) {
            throw new IllegalArgumentException("Properties must be not null");
        }
        Set<String> pluginProperties = this.getActionPlugin(actionDefinition.getActionPlugin());
        actionDefinition.getProperties().keySet().stream().forEach(property -> {
            boolean isPluginProperty = false;
            for (String pluginProperty : pluginProperties) {
                if (!property.startsWith(pluginProperty)) continue;
                isPluginProperty = true;
                break;
            }
            if (!isPluginProperty) {
                throw new IllegalArgumentException("Property: " + property + " is not valid on plugin: " + actionDefinition.getActionPlugin());
            }
        });
        PreparedStatement updateAction = CassStatement.get(this.session, CassStatement.UPDATE_ACTION_DEFINITION);
        if (updateAction == null) {
            throw new RuntimeException("updateAction PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateAction.bind(new Object[]{JsonUtil.toJson((Object)actionDefinition), tenantId, actionDefinition.getActionPlugin(), actionDefinition.getActionId()}));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        this.notifyListeners(new DefinitionsEvent(DefinitionsEvent.Type.ACTION_DEFINITION_UPDATE, actionDefinition));
    }

    public Map<String, Map<String, Set<String>>> getAllActionDefinitionIds() throws Exception {
        PreparedStatement selectActionsAll = CassStatement.get(this.session, CassStatement.SELECT_ACTION_ID_ALL);
        if (selectActionsAll == null) {
            throw new RuntimeException("selectActionsAll PreparedStatement is null");
        }
        HashMap<String, Map<String, Set<String>>> actions = new HashMap<String, Map<String, Set<String>>>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsAll.bind());
            for (Row row : rsActions) {
                String tenantId = row.getString("tenantId");
                String actionPlugin = row.getString("actionPlugin");
                String actionId = row.getString("actionId");
                if (actions.get(tenantId) == null) {
                    actions.put(tenantId, new HashMap());
                }
                if (((Map)actions.get(tenantId)).get(actionPlugin) == null) {
                    ((Map)actions.get(tenantId)).put(actionPlugin, new HashSet());
                }
                ((Set)((Map)actions.get(tenantId)).get(actionPlugin)).add(actionId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public Collection<ActionDefinition> getAllActionDefinitions() throws Exception {
        PreparedStatement selectActionsAll = CassStatement.get(this.session, CassStatement.SELECT_ACTION_DEFINITION_ALL);
        if (selectActionsAll == null) {
            throw new RuntimeException("selectActionsAll PreparedStatement is null");
        }
        ArrayList<ActionDefinition> actionDefinitions = new ArrayList<ActionDefinition>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsAll.bind());
            for (Row row : rsActions) {
                actionDefinitions.add((ActionDefinition)JsonUtil.fromJson((String)row.getString("payload"), ActionDefinition.class));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actionDefinitions;
    }

    public Map<String, Set<String>> getActionDefinitionIds(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        PreparedStatement selectActionsByTenant = CassStatement.get(this.session, CassStatement.SELECT_ACTION_ID_BY_TENANT);
        if (selectActionsByTenant == null) {
            throw new RuntimeException("selectActionsByTenant PreparedStatement is null");
        }
        HashMap<String, Set<String>> actions = new HashMap<String, Set<String>>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsByTenant.bind(new Object[]{tenantId}));
            for (Row row : rsActions) {
                String actionPlugin = row.getString("actionPlugin");
                String actionId = row.getString("actionId");
                if (actions.get(actionPlugin) == null) {
                    actions.put(actionPlugin, new HashSet());
                }
                ((Set)actions.get(actionPlugin)).add(actionId);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    private List<FullTrigger> getFullTriggers(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        ArrayList<FullTrigger> fullTriggers = new ArrayList<FullTrigger>();
        try {
            Collection<Trigger> triggers = this.selectTriggers(tenantId);
            for (Trigger t : triggers) {
                ArrayList<Dampening> allDampenings = new ArrayList<Dampening>();
                Collection<Dampening> firingDampenings = this.getTriggerDampenings(tenantId, t.getId(), Mode.FIRING);
                Collection<Dampening> autoDampenings = this.getTriggerDampenings(tenantId, t.getId(), Mode.AUTORESOLVE);
                if (!this.isEmpty(firingDampenings)) {
                    allDampenings.addAll(firingDampenings);
                }
                if (!this.isEmpty(autoDampenings)) {
                    allDampenings.addAll(autoDampenings);
                }
                ArrayList<Condition> allConditions = new ArrayList<Condition>();
                Collection<Condition> firingConditions = this.getTriggerConditions(tenantId, t.getId(), Mode.FIRING);
                Collection<Condition> autoConditions = this.getTriggerConditions(tenantId, t.getId(), Mode.AUTORESOLVE);
                if (!this.isEmpty(firingConditions)) {
                    allConditions.addAll(firingConditions);
                }
                if (!this.isEmpty(autoConditions)) {
                    allConditions.addAll(autoConditions);
                }
                fullTriggers.add(new FullTrigger(t, allDampenings, allConditions));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return fullTriggers;
    }

    private List<ActionDefinition> getActionDefinitions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        PreparedStatement selectActionsByTenant = CassStatement.get(this.session, CassStatement.SELECT_ACTION_DEFINITIONS_BY_TENANT);
        if (selectActionsByTenant == null) {
            throw new RuntimeException("selectActionsByTenant PreparedStatement is null");
        }
        ArrayList<ActionDefinition> actionDefinitions = new ArrayList<ActionDefinition>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsByTenant.bind(new Object[]{tenantId}));
            for (Row row : rsActions) {
                actionDefinitions.add((ActionDefinition)JsonUtil.fromJson((String)row.getString("payload"), ActionDefinition.class));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actionDefinitions;
    }

    public Collection<String> getActionDefinitionIds(String tenantId, String actionPlugin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("actionPlugin must be not null");
        }
        PreparedStatement selectActionsPlugin = CassStatement.get(this.session, CassStatement.SELECT_ACTION_ID_BY_PLUGIN);
        if (selectActionsPlugin == null) {
            throw new RuntimeException("selectActionsPlugin PreparedStatement is null");
        }
        ArrayList<String> actions = new ArrayList<String>();
        try {
            ResultSet rsActions = this.session.execute((Statement)selectActionsPlugin.bind(new Object[]{tenantId, actionPlugin}));
            for (Row row : rsActions) {
                actions.add(row.getString("actionId"));
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actions;
    }

    public ActionDefinition getActionDefinition(String tenantId, String actionPlugin, String actionId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(actionPlugin)) {
            throw new IllegalArgumentException("ActionPlugin must be not null");
        }
        if (this.isEmpty(actionId)) {
            throw new IllegalArgumentException("actionId must be not null");
        }
        PreparedStatement selectAction = CassStatement.get(this.session, CassStatement.SELECT_ACTION_DEFINITION);
        if (selectAction == null) {
            throw new RuntimeException("selectAction PreparedStatement is null");
        }
        ActionDefinition actionDefinition = null;
        try {
            ResultSet rsAction = this.session.execute((Statement)selectAction.bind(new Object[]{tenantId, actionPlugin, actionId}));
            Iterator itAction = rsAction.iterator();
            if (itAction.hasNext()) {
                Row row = (Row)itAction.next();
                actionDefinition = (ActionDefinition)JsonUtil.fromJson((String)row.getString("payload"), ActionDefinition.class);
            }
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return actionDefinition;
    }

    public void registerListener(DefinitionsListener listener, DefinitionsEvent.Type eventType, DefinitionsEvent.Type ... eventTypes) {
        this.alertsContext.registerDefinitionListener(listener, eventType, eventTypes);
    }

    private void notifyListeners(DefinitionsEvent de) {
        if (this.isDeferredNotifications()) {
            this.deferredNotifications.add(de);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Notifying applicable listeners %s of event %s", this.alertsContext.getDefinitionListeners(), (Object)de);
        }
        this.alertsContext.getDefinitionListeners().entrySet().stream().filter(e -> ((Set)e.getValue()).contains(de.getType())).forEach(e -> {
            this.log.debugf("Notified Listener %s of %s", e.getKey(), (Object)de.getType().name());
            ((DefinitionsListener)e.getKey()).onChange(Collections.singleton(de));
        });
    }

    private void notifyListenersDeferred() {
        if (this.deferredNotifications.isEmpty()) {
            return;
        }
        Set<DefinitionsEvent> notifications = this.deferredNotifications;
        this.deferredNotifications = new HashSet<DefinitionsEvent>();
        Set notificationTypes = notifications.stream().map(n -> n.getType()).collect(Collectors.toSet());
        if (this.log.isDebugEnabled()) {
            this.log.debugf("Notifying applicable listeners %s of deferred events %s", this.alertsContext.getDefinitionListeners(), notifications);
        }
        this.alertsContext.getDefinitionListeners().entrySet().stream().filter(e -> this.shouldNotify((Set)e.getValue(), notificationTypes)).forEach(e -> {
            this.log.debugf("Notified Listener %s of %s", e.getKey(), (Object)notificationTypes);
            ((DefinitionsListener)e.getKey()).onChange(notifications.stream().filter(de -> ((Set)e.getValue()).contains(de.getType())).collect(Collectors.toSet()));
        });
    }

    private boolean shouldNotify(Set<DefinitionsEvent.Type> listenerTypes, Set<DefinitionsEvent.Type> eventTypes) {
        HashSet<DefinitionsEvent.Type> intersection = new HashSet<DefinitionsEvent.Type>(listenerTypes);
        intersection.retainAll(eventTypes);
        return !intersection.isEmpty();
    }

    public Definitions exportDefinitions(String tenantId) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        Definitions definitions = new Definitions();
        try {
            definitions.setTriggers(this.getFullTriggers(tenantId));
            definitions.setActions(this.getActionDefinitions(tenantId));
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return definitions;
    }

    public Definitions importDefinitions(String tenantId, Definitions definitions, ImportType strategy) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (null == definitions) {
            throw new IllegalArgumentException("Definitions must be not null");
        }
        if (null == strategy) {
            throw new IllegalArgumentException("ImportType startegy must be not null");
        }
        definitions.updateTenant(tenantId);
        Definitions imported = new Definitions();
        try {
            this.deferNotifications();
            Collection<Trigger> existingTriggers = this.selectTriggers(tenantId);
            Map<String, Set<String>> existingActionDefinitions = this.getActionDefinitionIds(tenantId);
            if (strategy.equals((Object)ImportType.DELETE)) {
                this.msgLog.warningDeleteDefinitionsTenant(tenantId);
                for (Trigger trigger : existingTriggers) {
                    this.removeTrigger(trigger);
                }
                for (Map.Entry entry : existingActionDefinitions.entrySet()) {
                    String actionPlugin = (String)entry.getKey();
                    for (String actionId : (Set)entry.getValue()) {
                        this.removeActionDefinition(tenantId, actionPlugin, actionId);
                    }
                }
            }
            ArrayList<ActionDefinition> importedActionDefinitions = new ArrayList<ActionDefinition>();
            if (!this.isEmpty(definitions.getActions())) {
                for (ActionDefinition a : definitions.getActions()) {
                    a.setTenantId(tenantId);
                    if (!this.isEmpty(a)) {
                        boolean existing = existingActionDefinitions.containsKey(a.getActionPlugin()) && existingActionDefinitions.get(a.getActionPlugin()).contains(a.getActionId());
                        switch (strategy) {
                            case DELETE: {
                                this.addActionDefinition(tenantId, a);
                                importedActionDefinitions.add(a);
                                break;
                            }
                            case ALL: {
                                if (existing) {
                                    this.removeActionDefinition(tenantId, a.getActionPlugin(), a.getActionId());
                                }
                                this.addActionDefinition(tenantId, a);
                                importedActionDefinitions.add(a);
                                break;
                            }
                            case NEW: {
                                if (existing) break;
                                this.addActionDefinition(tenantId, a);
                                importedActionDefinitions.add(a);
                                break;
                            }
                            case OLD: {
                                if (!existing) break;
                                this.removeActionDefinition(tenantId, a.getActionPlugin(), a.getActionId());
                                this.addActionDefinition(tenantId, a);
                                importedActionDefinitions.add(a);
                            }
                        }
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("ActionDefinition " + a + " is empty. Ignored on the import process"));
                }
            }
            ArrayList<FullTrigger> arrayList = new ArrayList<FullTrigger>();
            if (!this.isEmpty(definitions.getTriggers())) {
                for (FullTrigger t : definitions.getTriggers()) {
                    if (!this.isEmpty(t.getTrigger())) {
                        boolean existing = existingTriggers.contains(t.getTrigger());
                        switch (strategy) {
                            case DELETE: {
                                this.addFullTrigger(tenantId, t);
                                arrayList.add(t);
                                break;
                            }
                            case ALL: {
                                if (existing) {
                                    this.removeTrigger(t.getTrigger());
                                }
                                this.addFullTrigger(tenantId, t);
                                arrayList.add(t);
                                break;
                            }
                            case NEW: {
                                if (existing) break;
                                this.addFullTrigger(tenantId, t);
                                arrayList.add(t);
                                break;
                            }
                            case OLD: {
                                if (!existing) break;
                                this.removeTrigger(t.getTrigger());
                                this.addFullTrigger(tenantId, t);
                                arrayList.add(t);
                            }
                        }
                        continue;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Trigger " + t + " is empty. Ignored on the import process"));
                }
            }
            imported.setTriggers(arrayList);
            imported.setActions(importedActionDefinitions);
        }
        catch (Exception e) {
            this.msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        finally {
            this.releaseNotifications();
        }
        return imported;
    }

    private void addFullTrigger(String tenantId, FullTrigger fullTrigger) throws Exception {
        if (null == fullTrigger) {
            throw new IllegalArgumentException("FullTrigger must be not null");
        }
        if (fullTrigger.getTrigger() != null) {
            Trigger trigger = fullTrigger.getTrigger();
            trigger.setTenantId(tenantId);
            this.addTrigger(trigger);
            if (!this.isEmpty(fullTrigger.getDampenings())) {
                for (Dampening d : fullTrigger.getDampenings()) {
                    d.setTenantId(tenantId);
                    d.setTriggerId(trigger.getId());
                    this.addDampening(d);
                }
            }
            if (!this.isEmpty(fullTrigger.getConditions())) {
                for (Condition c : fullTrigger.getConditions()) {
                    c.setTenantId(tenantId);
                    c.setTriggerId(trigger.getId());
                    this.addCondition(c);
                }
            }
        }
    }

    private boolean isEmpty(Trigger trigger) {
        return trigger == null || trigger.getId() == null || trigger.getId().trim().isEmpty();
    }

    private boolean isEmpty(Dampening dampening) {
        return dampening == null || dampening.getTriggerId() == null || dampening.getTriggerId().trim().isEmpty() || dampening.getDampeningId() == null || dampening.getDampeningId().trim().isEmpty();
    }

    private boolean isEmpty(String id) {
        return id == null || id.trim().isEmpty();
    }

    private boolean isEmpty(Map<String, String> map) {
        return map == null || map.isEmpty();
    }

    private boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    private boolean isEmpty(ActionDefinition a) {
        return a == null || a.getActionPlugin() == null || a.getActionPlugin().trim().isEmpty() || a.getActionId() == null || a.getActionId().trim().isEmpty();
    }

    private void checkTenantId(String tenantId, Object obj) {
        Dampening dampening;
        if (this.isEmpty(tenantId)) {
            return;
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Trigger) {
            Trigger trigger = (Trigger)obj;
            if (trigger.getTenantId() == null || !trigger.getTenantId().equals(tenantId)) {
                trigger.setTenantId(tenantId);
            }
        } else if (obj instanceof Dampening && ((dampening = (Dampening)obj).getTenantId() == null || !dampening.getTenantId().equals(tenantId))) {
            dampening.setTenantId(tenantId);
        }
    }
}

