/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.tags;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.hawkular.alerts.engine.tags.parser.TagQueryBaseListener;
import org.hawkular.alerts.engine.tags.parser.TagQueryLexer;
import org.hawkular.alerts.engine.tags.parser.TagQueryParser;
import org.jboss.logging.Logger;

public class ExpressionTagQueryParser
extends TagQueryBaseListener
implements ANTLRErrorListener {
    private static final Logger log = Logger.getLogger(ExpressionTagQueryParser.class);
    private ExpressionTagResolver resolver;
    private boolean error;
    private String errorMsg;
    private List<String> evalsPostfix;
    private Stack<Stack<String>> stack;

    public ExpressionTagQueryParser(ExpressionTagResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Resolver must be not null");
        }
        this.resolver = resolver;
    }

    public Set<String> resolve(String expression) throws Exception {
        String prefix = this.parse(expression);
        Set<String> result = prefix.startsWith("and") ? this.and(this.left(prefix), this.right(prefix)) : (prefix.startsWith("or") ? this.or(this.left(prefix), this.right(prefix)) : this.resolver.resolve(ExpressionTagResolver.getTokens(prefix)));
        return result;
    }

    public String parse(String expression) throws Exception {
        this.evalsPostfix = new ArrayList<String>();
        this.stack = new Stack();
        this.error = false;
        this.errorMsg = null;
        ANTLRInputStream input = new ANTLRInputStream(expression);
        TagQueryLexer tql = new TagQueryLexer((CharStream)input);
        tql.addErrorListener(this);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)tql);
        TagQueryParser parser = new TagQueryParser((TokenStream)tokens);
        TagQueryParser.TagqueryContext parseTree = parser.tagquery();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)this, (ParseTree)parseTree);
        if (this.error) {
            throw new IllegalArgumentException("Expression [" + expression + "] is malformed. Msg: " + this.errorMsg);
        }
        if (log.isDebugEnabled()) {
            log.debugf("Expression [%s] evaluated as [%s]", (Object)expression, this.evalsPostfix);
        }
        return this.prefix(this.evalsPostfix);
    }

    private String prefix(List<String> parsed) {
        Stack<String> stack = new Stack<String>();
        for (String eval : parsed) {
            if ("and".equals(eval) || "or".equals(eval)) {
                String op2 = (String)stack.pop();
                String op1 = (String)stack.pop();
                stack.push(eval + "(" + op1 + ", " + op2 + ")");
                continue;
            }
            stack.push(eval);
        }
        return (String)stack.pop();
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        this.error = true;
        this.errorMsg = msg;
    }

    public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
        this.error = true;
        this.errorMsg = "Ambiguity error";
    }

    public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
        this.error = true;
        this.errorMsg = "Attempting Full Context error";
    }

    public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
        this.error = true;
        this.errorMsg = "Context Sensitivity error";
    }

    @Override
    public void visitErrorNode(ErrorNode node) {
        if (this.error) {
            this.errorMsg = "Error " + this.errorMsg + " on node " + node.getText();
        } else {
            this.errorMsg = "Error on node " + node.getText();
            this.error = true;
        }
    }

    @Override
    public void enterObject(TagQueryParser.ObjectContext ctx) {
        Stack<String> objectStack = new Stack<String>();
        this.stack.push(objectStack);
        if (ctx.getParent().getParent() == null && ctx.tagexp() != null) {
            String eval = this.getEval(ctx.tagexp());
            this.evalsPostfix.add(eval);
        }
        if (ctx.logical_operator() != null) {
            TagQueryParser.TagexpContext left = ctx.object(0).tagexp();
            TagQueryParser.TagexpContext right = ctx.object(1).tagexp();
            if (left != null && right != null) {
                String lEval = this.getEval(left);
                String rEval = this.getEval(right);
                if (this.isNot(lEval) && !this.isNot(rEval)) {
                    this.evalsPostfix.add(rEval);
                    this.evalsPostfix.add(lEval);
                } else {
                    this.evalsPostfix.add(lEval);
                    this.evalsPostfix.add(rEval);
                }
            } else if (left != null && right == null) {
                String lEval = this.getEval(left);
                if (!this.isNot(lEval)) {
                    this.evalsPostfix.add(lEval);
                } else {
                    objectStack.push(lEval);
                }
            } else if (left == null && right != null) {
                String rEval = this.getEval(right);
                this.evalsPostfix.add(rEval);
            }
        }
    }

    @Override
    public void exitObject(TagQueryParser.ObjectContext ctx) {
        Stack<String> objectStack = this.stack.pop();
        if (ctx.logical_operator() != null) {
            String eval = ctx.logical_operator().getText().toLowerCase();
            if (!objectStack.isEmpty()) {
                this.evalsPostfix.add(objectStack.pop());
            }
            this.evalsPostfix.add(eval);
        }
    }

    private boolean isNot(String eval) {
        return eval.startsWith("not");
    }

    private String getEval(TagQueryParser.TagexpContext tagexp) {
        String eval = tagexp.array_operator() != null ? tagexp.key().getText() + " " + (tagexp.array_operator().NOT() != null ? "not in" : "in") + " " + tagexp.array().getText() : (tagexp.boolean_operator() != null ? tagexp.key().getText() + " " + tagexp.boolean_operator().getText() + " " + tagexp.value().getText() : (tagexp.NOT() != null ? "not " + tagexp.key().getText() : tagexp.key().getText()));
        return eval;
    }

    private String left(String exp) {
        return this.getOperand(true, exp);
    }

    private String right(String exp) {
        return this.getOperand(false, exp);
    }

    private String getOperand(boolean left, String exp) {
        if (exp.startsWith("and")) {
            int comma = this.getCommaIndex(exp.substring("and".length() + 1, exp.length() - 1)) + "and".length() + 1;
            if (left) {
                return exp.substring("and".length() + 1, comma).trim();
            }
            return exp.substring(comma + 1, exp.length() - 1).trim();
        }
        if (exp.startsWith("or")) {
            int comma = this.getCommaIndex(exp.substring("or".length() + 1, exp.length() - 1)) + "or".length() + 1;
            if (left) {
                return exp.substring("or".length() + 1, comma).trim();
            }
            return exp.substring(comma + 1, exp.length() - 1).trim();
        }
        return exp.trim();
    }

    private int getCommaIndex(String exp) {
        int open = 0;
        for (int i = 0; i < exp.length(); ++i) {
            char c = exp.charAt(i);
            if (c == '(') {
                ++open;
            }
            if (c == ')') {
                --open;
            }
            if (c != ',' || open != 0) continue;
            return i;
        }
        return -1;
    }

    private Set<String> and(String left, String right) throws Exception {
        return this.andOr(true, left, right);
    }

    private Set<String> or(String left, String right) throws Exception {
        return this.andOr(false, left, right);
    }

    private Set<String> andOr(boolean isAnd, String left, String right) throws Exception {
        Set<String> leftResult = left.startsWith("and") ? this.andOr(true, this.left(left), this.right(left)) : (left.startsWith("or") ? this.andOr(false, this.left(left), this.right(left)) : this.resolver.resolve(left));
        if (isAnd && (leftResult == null || leftResult.isEmpty())) {
            return leftResult;
        }
        Set<String> rightResult = right.startsWith("and") ? this.andOr(true, this.left(right), this.right(right)) : (right.startsWith("or") ? this.andOr(false, this.left(right), this.right(right)) : this.resolver.resolve(right));
        if (isAnd) {
            leftResult.retainAll(rightResult);
        } else {
            leftResult.addAll(rightResult);
        }
        return leftResult;
    }

    public static interface ExpressionTagResolver {
        public static final String AND = "and";
        public static final String OR = "or";
        public static final String NOT = "not";
        public static final String EQ = "=";
        public static final String NEQ = "!=";
        public static final String IN = "in";

        public static List<String> getTokens(String tagExpression) {
            if (tagExpression == null || tagExpression.isEmpty()) {
                return null;
            }
            ArrayList<String> tokens = new ArrayList<String>();
            StringBuilder token = new StringBuilder();
            for (int i = 0; i < tagExpression.length(); ++i) {
                char ch = tagExpression.charAt(i);
                if (ch != ' ') {
                    token.append(ch);
                }
                if (token.toString().equals(NOT)) {
                    tokens.add(token.toString());
                    token = new StringBuilder();
                    continue;
                }
                if (ch != ' ') continue;
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token = new StringBuilder();
            }
            tokens.add(token.toString());
            return tokens;
        }

        default public Set<String> resolve(String tagExpression) throws Exception {
            return this.resolve(ExpressionTagResolver.getTokens(tagExpression));
        }

        public Set<String> resolve(List<String> var1) throws Exception;
    }
}

