/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.hawkular.alerts.api.model.condition.NelsonCondition;
import org.hawkular.alerts.api.model.data.Data;

public class NelsonData {
    private NelsonCondition condition;
    protected List<NelsonCondition.NelsonRule> violations = new ArrayList<NelsonCondition.NelsonRule>(8);
    private LinkedList<Data> violationsData = new LinkedList();
    private Mean mean = new Mean();
    private StandardDeviation standardDeviation = new StandardDeviation();
    private double oneDeviation;
    private double twoDeviations;
    private double threeDeviations;
    private int rule2Count;
    private int rule3Count;
    private Double rule3PreviousSample;
    private int rule4Count;
    private Double rule4PreviousSample;
    private String rule4PreviousDirection;
    private LinkedList<String> rule5LastThree = new LinkedList();
    int rule5Above;
    int rule5Below;
    private LinkedList<String> rule6LastFive = new LinkedList();
    int rule6Above;
    int rule6Below;
    private int rule7Count;
    private int rule8Count;

    public NelsonData(NelsonCondition condition) {
        this.condition = condition;
    }

    public void clear() {
        this.mean.clear();
        this.standardDeviation.clear();
        this.violations.clear();
        this.rule2Count = 0;
        this.rule3Count = 0;
        this.rule3PreviousSample = null;
        this.rule4Count = 0;
        this.rule4PreviousSample = null;
        this.rule4PreviousDirection = null;
        this.rule5LastThree.clear();
        this.rule5Above = 0;
        this.rule5Below = 0;
        this.rule6LastFive.clear();
        this.rule6Above = 0;
        this.rule6Below = 0;
        this.rule7Count = 0;
        this.rule8Count = 0;
    }

    public boolean hasViolations() {
        return !this.violations.isEmpty();
    }

    public void addData(Data data) {
        Double sample;
        if (this.violationsData.contains(data)) {
            return;
        }
        try {
            sample = Double.valueOf(data.getValue());
        }
        catch (Exception e) {
            return;
        }
        if (!this.isValid(sample)) {
            return;
        }
        this.violationsData.push(data);
        while (this.violationsData.size() > 15) {
            this.violationsData.removeLast();
        }
        this.addSample(sample);
    }

    private void addSample(double sample) {
        if (this.mean.getN() < (long)this.condition.getSampleSize()) {
            this.mean.increment(sample);
            this.standardDeviation.increment(sample);
            if (this.mean.getN() == (long)this.condition.getSampleSize()) {
                this.oneDeviation = this.standardDeviation.getResult();
                this.twoDeviations = this.oneDeviation * 2.0;
                this.threeDeviations = this.oneDeviation * 3.0;
            }
        }
        this.violations.clear();
        if (this.rule1(sample)) {
            this.violations.add(NelsonCondition.NelsonRule.Rule1);
        }
        if (this.rule2(sample)) {
            this.violations.add(NelsonCondition.NelsonRule.Rule2);
        }
        if (this.rule3(sample)) {
            this.violations.add(NelsonCondition.NelsonRule.Rule3);
        }
        if (this.rule4(sample)) {
            this.violations.add(NelsonCondition.NelsonRule.Rule4);
        }
        if (this.rule5(sample)) {
            this.violations.add(NelsonCondition.NelsonRule.Rule5);
        }
        if (this.rule6(sample)) {
            this.violations.add(NelsonCondition.NelsonRule.Rule6);
        }
        if (this.rule7(sample)) {
            this.violations.add(NelsonCondition.NelsonRule.Rule7);
        }
        if (this.rule8(sample)) {
            this.violations.add(NelsonCondition.NelsonRule.Rule8);
        }
    }

    public boolean hasMean() {
        return this.mean != null && this.mean.getN() == (long)this.condition.getSampleSize();
    }

    private boolean rule1(double sample) {
        if (!this.hasMean()) {
            return false;
        }
        return Math.abs(sample - this.mean.getResult()) > this.threeDeviations;
    }

    private boolean rule2(double sample) {
        if (!this.hasMean()) {
            return false;
        }
        this.rule2Count = sample > this.mean.getResult() ? (this.rule2Count > 0 ? ++this.rule2Count : 1) : (this.rule2Count < 0 ? --this.rule2Count : -1);
        return Math.abs(this.rule2Count) >= 9;
    }

    private boolean rule3(double sample) {
        if (null == this.rule3PreviousSample) {
            this.rule3PreviousSample = sample;
            this.rule3Count = 0;
            return false;
        }
        this.rule3Count = sample > this.rule3PreviousSample ? (this.rule3Count > 0 ? ++this.rule3Count : 1) : (sample < this.rule3PreviousSample ? (this.rule3Count < 0 ? --this.rule3Count : -1) : 0);
        this.rule3PreviousSample = sample;
        return Math.abs(this.rule3Count) >= 6;
    }

    private boolean rule4(Double sample) {
        String sampleDirection;
        if (null == this.rule4PreviousSample || sample.doubleValue() == this.rule4PreviousSample.doubleValue()) {
            this.rule4PreviousSample = sample;
            this.rule4PreviousDirection = "=";
            this.rule4Count = 0;
            return false;
        }
        String string = sampleDirection = sample > this.rule4PreviousSample ? ">" : "<";
        this.rule4Count = sampleDirection.equals(this.rule4PreviousDirection) ? 0 : ++this.rule4Count;
        this.rule4PreviousSample = sample;
        this.rule4PreviousDirection = sampleDirection;
        return Math.abs(this.rule4Count) >= 14;
    }

    private boolean rule5(double sample) {
        if (!this.hasMean()) {
            return false;
        }
        if (this.rule5LastThree.size() == 3) {
            switch (this.rule5LastThree.removeLast()) {
                case ">": {
                    --this.rule5Above;
                    break;
                }
                case "<": {
                    --this.rule5Below;
                }
            }
        }
        if (Math.abs(sample - this.mean.getResult()) > this.twoDeviations) {
            if (sample > this.mean.getResult()) {
                ++this.rule5Above;
                this.rule5LastThree.push(">");
            } else {
                ++this.rule5Below;
                this.rule5LastThree.push("<");
            }
        } else {
            this.rule5LastThree.push("");
        }
        return this.rule5Above >= 2 || this.rule5Below >= 2;
    }

    private boolean rule6(double sample) {
        if (!this.hasMean()) {
            return false;
        }
        if (this.rule6LastFive.size() == 5) {
            switch (this.rule6LastFive.removeLast()) {
                case ">": {
                    --this.rule6Above;
                    break;
                }
                case "<": {
                    --this.rule6Below;
                }
            }
        }
        if (Math.abs(sample - this.mean.getResult()) > this.oneDeviation) {
            if (sample > this.mean.getResult()) {
                ++this.rule6Above;
                this.rule6LastFive.push(">");
            } else {
                ++this.rule6Below;
                this.rule6LastFive.push("<");
            }
        } else {
            this.rule6LastFive.push("");
        }
        return this.rule6Above >= 4 || this.rule6Below >= 4;
    }

    private boolean rule7(double sample) {
        if (!this.hasMean()) {
            return false;
        }
        if (sample == this.mean.getResult()) {
            this.rule7Count = 0;
            return false;
        }
        this.rule7Count = Math.abs(sample - this.mean.getResult()) <= this.oneDeviation ? ++this.rule7Count : 0;
        return this.rule7Count >= 15;
    }

    private boolean rule8(Double sample) {
        if (!this.hasMean()) {
            return false;
        }
        this.rule8Count = Math.abs(sample - this.mean.getResult()) > this.oneDeviation ? ++this.rule8Count : 0;
        return this.rule8Count >= 8;
    }

    private boolean isValid(Double d) {
        return null != d && !d.isNaN() && !d.isInfinite();
    }

    public NelsonCondition getCondition() {
        return this.condition;
    }

    public List<NelsonCondition.NelsonRule> getViolations() {
        return Collections.unmodifiableList(this.violations);
    }

    public List<Data> getViolationsData() {
        return Collections.unmodifiableList(this.violationsData);
    }

    public Mean getMean() {
        return this.mean;
    }

    public double getMeanResult() {
        return this.mean.getResult();
    }

    public double getStandardDeviationResult() {
        return this.oneDeviation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NelsonData other = (NelsonData)obj;
        return !(this.condition == null ? other.condition != null : !this.condition.equals((Object)other.condition));
    }

    public String toString() {
        return "NelsonData [condition=" + this.condition + ", violationsData=" + this.violationsData + ", violations=" + this.violations + ", mean=" + this.mean + ", standardDeviation=" + this.oneDeviation + ", twoDeviations=" + this.twoDeviations + ", threeDeviations=" + this.threeDeviations + "]";
    }
}

