/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import org.hawkular.alerts.api.model.action.ActionDefinition;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.infinispan.Cache;
import org.jboss.logging.Logger;

@Singleton
@Startup
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class ActionsCacheManager {
    private final Logger log = Logger.getLogger(ActionsCacheManager.class);
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    @EJB
    DefinitionsService definitions;
    @Resource(lookup="java:jboss/infinispan/cache/hawkular-alerts/globalActions")
    private Cache<ActionKey, ActionDefinition> globalActionsCache;

    @PostConstruct
    public void init() {
        this.msgLog.infoInitActionsCache();
        this.globalActionsCache.clear();
        this.initialCacheUpdate();
        this.definitions.registerListener(events -> events.stream().forEach(event -> {
            ActionKey key = new ActionKey(event.getTargetTenantId(), event.getActionPlugin(), event.getTargetId());
            switch (event.getType()) {
                case ACTION_DEFINITION_CREATE: 
                case ACTION_DEFINITION_UPDATE: {
                    ActionDefinition actionDefinition = event.getActionDefinition();
                    if (!actionDefinition.isGlobal()) break;
                    this.globalActionsCache.put((Object)key, (Object)actionDefinition);
                    break;
                }
                case ACTION_DEFINITION_REMOVE: {
                    this.globalActionsCache.remove((Object)key);
                }
            }
        }), DefinitionsEvent.Type.ACTION_DEFINITION_CREATE, new DefinitionsEvent.Type[]{DefinitionsEvent.Type.ACTION_DEFINITION_REMOVE, DefinitionsEvent.Type.ACTION_DEFINITION_UPDATE});
    }

    public boolean hasGlobalActions() {
        return !this.globalActionsCache.isEmpty();
    }

    public Collection<ActionDefinition> getGlobalActions(String tenantId) {
        ArrayList<ActionDefinition> globalActions = new ArrayList<ActionDefinition>();
        for (ActionKey key : this.globalActionsCache.keySet()) {
            if (!key.getTenantId().equals(tenantId)) continue;
            globalActions.add((ActionDefinition)this.globalActionsCache.get((Object)key));
        }
        return globalActions;
    }

    private void initialCacheUpdate() {
        try {
            this.log.debug((Object)"Initial ActionsCacheManager update in progress..");
            this.globalActionsCache.startBatch();
            Collection actionDefinitions = this.definitions.getAllActionDefinitions();
            for (ActionDefinition actionDefinition : actionDefinitions) {
                if (!actionDefinition.isGlobal()) continue;
                ActionKey key = new ActionKey(actionDefinition.getTenantId(), actionDefinition.getActionPlugin(), actionDefinition.getActionId());
                this.globalActionsCache.put((Object)key, (Object)actionDefinition);
            }
            this.globalActionsCache.endBatch(true);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to load global actions", (Throwable)e);
            this.globalActionsCache.endBatch(false);
            return;
        }
    }

    public static class ActionKey
    implements Serializable {
        private String tenantId;
        private String actionPlugin;
        private String actionId;

        public ActionKey(String tenantId, String actionPlugin, String actionId) {
            this.tenantId = tenantId;
            this.actionPlugin = actionPlugin;
            this.actionId = actionId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getActionPlugin() {
            return this.actionPlugin;
        }

        public void setActionPlugin(String actionPlugin) {
            this.actionPlugin = actionPlugin;
        }

        public String getActionId() {
            return this.actionId;
        }

        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionKey actionKey = (ActionKey)o;
            if (this.tenantId != null ? !this.tenantId.equals(actionKey.tenantId) : actionKey.tenantId != null) {
                return false;
            }
            if (this.actionPlugin != null ? !this.actionPlugin.equals(actionKey.actionPlugin) : actionKey.actionPlugin != null) {
                return false;
            }
            return this.actionId != null ? this.actionId.equals(actionKey.actionId) : actionKey.actionId == null;
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.actionPlugin != null ? this.actionPlugin.hashCode() : 0);
            result = 31 * result + (this.actionId != null ? this.actionId.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ActionKey{tenantId='" + this.tenantId + '\'' + ", actionPlugin='" + this.actionPlugin + '\'' + ", actionId='" + this.actionId + '\'' + '}';
        }
    }
}

