/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.enterprise.concurrent.ManagedExecutorService;
import javax.inject.Inject;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.Severity;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.paging.AlertComparator;
import org.hawkular.alerts.api.model.paging.EventComparator;
import org.hawkular.alerts.api.model.paging.Order;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.PageContext;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.ActionsService;
import org.hawkular.alerts.api.services.AlertsCriteria;
import org.hawkular.alerts.api.services.AlertsService;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.EventsCriteria;
import org.hawkular.alerts.api.services.PropertiesService;
import org.hawkular.alerts.engine.impl.CassClusterSession;
import org.hawkular.alerts.engine.impl.CassStatement;
import org.hawkular.alerts.engine.impl.IncomingDataManagerImpl;
import org.hawkular.alerts.engine.impl.TagType;
import org.hawkular.alerts.engine.log.MsgLogger;
import org.hawkular.alerts.engine.service.AlertsEngine;
import org.hawkular.alerts.engine.service.IncomingDataManager;
import org.hawkular.alerts.engine.tags.ExpressionTagQueryParser;
import org.jboss.logging.Logger;

@Local(value={AlertsService.class})
@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CassAlertsServiceImpl
implements AlertsService {
    private static final String CRITERIA_NO_QUERY_SIZE = "hawkular-alerts.criteria-no-query-size";
    private static final String CRITERIA_NO_QUERY_SIZE_ENV = "CRITERIA_NO_QUERY_SIZE";
    private static final String CRITERIA_NO_QUERY_SIZE_DEFAULT = "200";
    private static final String BATCH_SIZE = "hawkular-alerts.batch-size";
    private static final String BATCH_SIZE_ENV = "BATCH_SIZE";
    private static final String BATCH_SIZE_DEFAULT = "10";
    private static final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final Logger log = Logger.getLogger(CassAlertsServiceImpl.class);
    private int criteriaNoQuerySize;
    private int batchSize;
    private final BatchStatement.Type batchType = BatchStatement.Type.LOGGED;
    @EJB
    AlertsEngine alertsEngine;
    @EJB
    DefinitionsService definitionsService;
    @EJB
    ActionsService actionsService;
    @EJB
    IncomingDataManager incomingDataManager;
    @EJB
    PropertiesService properties;
    @Inject
    @CassClusterSession
    Session session;
    @Resource
    private ManagedExecutorService executor;

    @PostConstruct
    public void init() {
        this.criteriaNoQuerySize = Integer.valueOf(this.properties.getProperty(CRITERIA_NO_QUERY_SIZE, CRITERIA_NO_QUERY_SIZE_ENV, CRITERIA_NO_QUERY_SIZE_DEFAULT));
        this.batchSize = Integer.valueOf(this.properties.getProperty(BATCH_SIZE, BATCH_SIZE_ENV, BATCH_SIZE_DEFAULT));
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setExecutor(ManagedExecutorService executor) {
        this.executor = executor;
    }

    public void setProperties(PropertiesService properties) {
        this.properties = properties;
    }

    public void addAlerts(Collection<Alert> alerts) throws Exception {
        if (alerts == null) {
            throw new IllegalArgumentException("Alerts must be not null");
        }
        if (alerts.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding " + alerts.size() + " alerts"));
        }
        PreparedStatement insertAlert = CassStatement.get(this.session, CassStatement.INSERT_ALERT);
        PreparedStatement insertAlertTrigger = CassStatement.get(this.session, CassStatement.INSERT_ALERT_TRIGGER);
        PreparedStatement insertAlertCtime = CassStatement.get(this.session, CassStatement.INSERT_ALERT_CTIME);
        PreparedStatement insertAlertStime = CassStatement.get(this.session, CassStatement.INSERT_ALERT_STIME);
        PreparedStatement insertTag = CassStatement.get(this.session, CassStatement.INSERT_TAG);
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            BatchStatement batch = new BatchStatement(this.batchType);
            int i = 0;
            for (Alert a : alerts) {
                batch.add((Statement)insertAlert.bind(new Object[]{a.getTenantId(), a.getAlertId(), JsonUtil.toJson((Object)a)}));
                batch.add((Statement)insertAlertTrigger.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getTriggerId()}));
                batch.add((Statement)insertAlertCtime.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getCtime()}));
                batch.add((Statement)insertAlertStime.bind(new Object[]{a.getTenantId(), a.getAlertId(), a.getCurrentLifecycle().getStime()}));
                a.getTags().entrySet().stream().forEach(tag -> batch.add((Statement)insertTag.bind(new Object[]{a.getTenantId(), TagType.ALERT.name(), tag.getKey(), tag.getValue(), a.getId()})));
                if ((i += batch.size()) <= this.batchSize) continue;
                futures.add(this.session.executeAsync((Statement)batch));
                batch.clear();
                i = 0;
            }
            if (batch.size() > 0) {
                futures.add(this.session.executeAsync((Statement)batch));
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        List<Event> events = alerts.stream().map(Event::new).collect(Collectors.toList());
        this.persistEvents(events);
    }

    public void persistEvents(Collection<Event> events) throws Exception {
        if (events == null) {
            throw new IllegalArgumentException("Events must be not null");
        }
        if (events.isEmpty()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Adding " + events.size() + " events"));
        }
        PreparedStatement insertEvent = CassStatement.get(this.session, CassStatement.INSERT_EVENT);
        PreparedStatement insertEventCategory = CassStatement.get(this.session, CassStatement.INSERT_EVENT_CATEGORY);
        PreparedStatement insertEventCtime = CassStatement.get(this.session, CassStatement.INSERT_EVENT_CTIME);
        PreparedStatement insertEventTrigger = CassStatement.get(this.session, CassStatement.INSERT_EVENT_TRIGGER);
        PreparedStatement insertTag = CassStatement.get(this.session, CassStatement.INSERT_TAG);
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            BatchStatement batch = new BatchStatement(this.batchType);
            int i = 0;
            for (Event e : events) {
                batch.add((Statement)insertEvent.bind(new Object[]{e.getTenantId(), e.getId(), JsonUtil.toJson((Object)e)}));
                batch.add((Statement)insertEventCategory.bind(new Object[]{e.getTenantId(), e.getCategory(), e.getId()}));
                batch.add((Statement)insertEventCtime.bind(new Object[]{e.getTenantId(), e.getCtime(), e.getId()}));
                if (null != e.getTrigger()) {
                    batch.add((Statement)insertEventTrigger.bind(new Object[]{e.getTenantId(), e.getTrigger().getId(), e.getId()}));
                }
                e.getTags().entrySet().stream().forEach(tag -> batch.add((Statement)insertTag.bind(new Object[]{e.getTenantId(), TagType.EVENT.name(), tag.getKey(), tag.getValue(), e.getId()})));
                if ((i += batch.size()) <= this.batchSize) continue;
                futures.add(this.session.executeAsync((Statement)batch));
                batch.clear();
                i = 0;
            }
            if (batch.size() > 0) {
                futures.add(this.session.executeAsync((Statement)batch));
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addNote(String tenantId, String alertId, String user, String text) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertId)) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        if (this.isEmpty(user) || this.isEmpty(text)) {
            throw new IllegalArgumentException("user or text must be not null");
        }
        Alert alert = this.getAlert(tenantId, alertId, false);
        if (alert == null) {
            return;
        }
        alert.addNote(user, text);
        PreparedStatement updateAlert = CassStatement.get(this.session, CassStatement.UPDATE_ALERT);
        if (updateAlert == null) {
            throw new RuntimeException("updateAlert PreparedStatement is null");
        }
        try {
            this.session.execute((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)alert), alert.getTenantId(), alert.getAlertId()}));
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addAlertTags(String tenantId, Collection<String> alertIds, Map<String, String> tags) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            throw new IllegalArgumentException("AlertIds must be not null");
        }
        if (this.isEmpty(tags)) {
            throw new IllegalArgumentException("Tags must be not null");
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> existingAlerts = this.getAlerts(tenantId, criteria, null);
        PreparedStatement updateAlert = CassStatement.get(this.session, CassStatement.UPDATE_ALERT);
        PreparedStatement insertTag = CassStatement.get(this.session, CassStatement.INSERT_TAG);
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            BatchStatement batch = new BatchStatement(this.batchType);
            int i = 0;
            for (Alert a : existingAlerts) {
                tags.entrySet().stream().forEach(tag -> {
                    a.addTag((String)tag.getKey(), (String)tag.getValue());
                    batch.add((Statement)insertTag.bind(new Object[]{tenantId, TagType.ALERT.name(), tag.getKey(), tag.getValue(), a.getId()}));
                });
                batch.add((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)a), tenantId, a.getAlertId()}));
                if ((i += batch.size()) <= this.batchSize) continue;
                futures.add(this.session.executeAsync((Statement)batch));
                batch.clear();
                i = 0;
            }
            if (batch.size() > 0) {
                futures.add(this.session.executeAsync((Statement)batch));
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void addEventTags(String tenantId, Collection<String> eventIds, Map<String, String> tags) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(eventIds)) {
            throw new IllegalArgumentException("EventIds must be not null");
        }
        if (this.isEmpty(tags)) {
            throw new IllegalArgumentException("Tags must be not null");
        }
        EventsCriteria criteria = new EventsCriteria();
        criteria.setEventIds(eventIds);
        Page<Event> existingEvents = this.getEvents(tenantId, criteria, null);
        PreparedStatement updateEvent = CassStatement.get(this.session, CassStatement.UPDATE_EVENT);
        PreparedStatement insertTag = CassStatement.get(this.session, CassStatement.INSERT_TAG);
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            BatchStatement batch = new BatchStatement(this.batchType);
            boolean i = false;
            for (Event e : existingEvents) {
                tags.entrySet().stream().forEach(tag -> {
                    e.addTag((String)tag.getKey(), (String)tag.getValue());
                    batch.add((Statement)insertTag.bind(new Object[]{tenantId, TagType.EVENT.name(), tag.getKey(), tag.getValue(), e.getId()}));
                });
                batch.add((Statement)updateEvent.bind(new Object[]{JsonUtil.toJson((Object)e), tenantId, e.getId()}));
            }
            if (batch.size() > 0) {
                futures.add(this.session.executeAsync((Statement)batch));
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeAlertTags(String tenantId, Collection<String> alertIds, Collection<String> tags) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            throw new IllegalArgumentException("AlertIds must be not null");
        }
        if (this.isEmpty(tags)) {
            throw new IllegalArgumentException("Tags must be not null");
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> existingAlerts = this.getAlerts(tenantId, criteria, null);
        PreparedStatement updateAlert = CassStatement.get(this.session, CassStatement.UPDATE_ALERT);
        PreparedStatement deleteTag = CassStatement.get(this.session, CassStatement.DELETE_TAG);
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            BatchStatement batch = new BatchStatement(this.batchType);
            int i = 0;
            for (Alert a : existingAlerts) {
                tags.stream().forEach(tag -> {
                    if (a.getTags().containsKey(tag)) {
                        batch.add((Statement)deleteTag.bind(new Object[]{tenantId, TagType.ALERT.name(), tag, a.getTags().get(tag), a.getId()}));
                        a.removeTag(tag);
                    }
                });
                batch.add((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)a), tenantId, a.getAlertId()}));
                if ((i += batch.size()) <= this.batchSize) continue;
                futures.add(this.session.executeAsync((Statement)batch));
                batch.clear();
                i = 0;
            }
            if (batch.size() > 0) {
                futures.add(this.session.executeAsync((Statement)batch));
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public void removeEventTags(String tenantId, Collection<String> eventIds, Collection<String> tags) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(eventIds)) {
            throw new IllegalArgumentException("EventIds must be not null");
        }
        if (this.isEmpty(tags)) {
            throw new IllegalArgumentException("Tags must be not null");
        }
        EventsCriteria criteria = new EventsCriteria();
        criteria.setEventIds(eventIds);
        Page<Event> existingEvents = this.getEvents(tenantId, criteria, null);
        PreparedStatement updateEvent = CassStatement.get(this.session, CassStatement.UPDATE_EVENT);
        PreparedStatement deleteTag = CassStatement.get(this.session, CassStatement.DELETE_TAG);
        try {
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            BatchStatement batch = new BatchStatement(this.batchType);
            int i = 0;
            for (Event e : existingEvents) {
                tags.stream().forEach(tag -> {
                    if (e.getTags().containsKey(tag)) {
                        batch.add((Statement)deleteTag.bind(new Object[]{tenantId, TagType.EVENT.name(), tag, e.getTags().get(tag), e.getId()}));
                        e.removeTag(tag);
                    }
                });
                batch.add((Statement)updateEvent.bind(new Object[]{JsonUtil.toJson((Object)e), tenantId, e.getId()}));
                if ((i += batch.size()) <= this.batchSize) continue;
                futures.add(this.session.executeAsync((Statement)batch));
                batch.clear();
                i = 0;
            }
            if (batch.size() > 0) {
                futures.add(this.session.executeAsync((Statement)batch));
            }
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
    }

    public Alert getAlert(String tenantId, String alertId, boolean thin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertId)) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        PreparedStatement selectAlert = CassStatement.get(this.session, CassStatement.SELECT_ALERT);
        if (selectAlert == null) {
            throw new RuntimeException("selectAlert PreparedStatement is null");
        }
        Alert alert = null;
        try {
            ResultSet rsAlert = this.session.execute((Statement)selectAlert.bind(new Object[]{tenantId, alertId}));
            Iterator itAlert = rsAlert.iterator();
            if (itAlert.hasNext()) {
                Row row = (Row)itAlert.next();
                alert = (Alert)JsonUtil.fromJson((String)row.getString("payload"), Alert.class, (boolean)thin);
            }
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alert;
    }

    public Event getEvent(String tenantId, String eventId, boolean thin) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(eventId)) {
            throw new IllegalArgumentException("EventId must be not null");
        }
        PreparedStatement selectEvent = CassStatement.get(this.session, CassStatement.SELECT_EVENT);
        if (selectEvent == null) {
            throw new RuntimeException("selectEvent PreparedStatement is null");
        }
        Event event = null;
        try {
            ResultSet rsEvent = this.session.execute((Statement)selectEvent.bind(new Object[]{tenantId, eventId}));
            Iterator itEvent = rsEvent.iterator();
            if (itEvent.hasNext()) {
                Row row = (Row)itEvent.next();
                event = (Event)JsonUtil.fromJson((String)row.getString("payload"), Event.class, (boolean)thin);
            }
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return event;
    }

    public Page<Alert> getAlerts(String tenantId, AlertsCriteria criteria, Pager pager) throws Exception {
        return this.getAlerts(Collections.singleton(tenantId), criteria, pager);
    }

    public Page<Alert> getAlerts(Set<String> tenantIds, AlertsCriteria criteria, Pager pager) throws Exception {
        if (this.isEmpty(tenantIds)) {
            throw new IllegalArgumentException("TenantIds must be not null");
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        if (tenantIds.size() == 1) {
            alerts.addAll(this.getAlerts(tenantIds.iterator().next(), criteria));
        } else {
            TreeSet<String> orderedTenantIds = new TreeSet<String>(tenantIds);
            ArrayList futures = new ArrayList();
            orderedTenantIds.stream().forEach(tenantId -> futures.add(this.executor.submit(() -> {
                try {
                    List<Alert> tenantAlerts = this.getAlerts((String)tenantId, criteria);
                    List list = alerts;
                    synchronized (list) {
                        alerts.addAll(tenantAlerts);
                    }
                }
                catch (Exception e) {
                    msgLog.errorDatabaseException(e.getMessage());
                }
            })));
            futures.stream().forEach(f -> {
                try {
                    f.get();
                }
                catch (Exception e) {
                    msgLog.errorDatabaseException(e.getMessage());
                }
            });
        }
        if (alerts.isEmpty()) {
            return new Page(alerts, (PageContext)pager, 0L);
        }
        return this.preparePage(alerts, pager);
    }

    private List<Alert> getAlerts(String tenantId, AlertsCriteria criteria) throws Exception {
        boolean thin;
        boolean filter = null != criteria && criteria.hasCriteria();
        boolean bl = thin = null != criteria && criteria.isThin();
        if (filter && log.isDebugEnabled()) {
            log.debug((Object)("getAlerts criteria: " + criteria.toString()));
        }
        ArrayList<Alert> alerts = new ArrayList<Alert>();
        HashSet<String> alertIds = new HashSet<String>();
        boolean activeFilter = false;
        try {
            if (filter) {
                if (criteria.hasAlertIdCriteria()) {
                    Set<String> alertIdsFilteredByAlerts = this.filterByAlerts(criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByAlerts);
                    } else {
                        alertIds.addAll(alertIdsFilteredByAlerts);
                    }
                    if (alertIds.isEmpty()) {
                        return alerts;
                    }
                    activeFilter = true;
                }
                if (criteria.hasTagQueryCriteria()) {
                    Set<String> alertIdsFilteredByTagQuery = this.getIdsByTagQuery(tenantId, TagType.ALERT, criteria.getTagQuery());
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByTagQuery);
                    } else {
                        alertIds.addAll(alertIdsFilteredByTagQuery);
                    }
                    if (alertIds.isEmpty()) {
                        return alerts;
                    }
                    activeFilter = true;
                }
                if (criteria.hasTriggerIdCriteria()) {
                    Set<String> alertIdsFilteredByTriggers = this.filterByTriggers(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByTriggers);
                    } else {
                        alertIds.addAll(alertIdsFilteredByTriggers);
                    }
                    if (alertIds.isEmpty()) {
                        return alerts;
                    }
                    activeFilter = true;
                }
                if (criteria.hasCTimeCriteria()) {
                    Set<String> alertIdsFilteredByTime = this.filterByCTime(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByTime);
                    } else {
                        alertIds.addAll(alertIdsFilteredByTime);
                    }
                    if (alertIds.isEmpty()) {
                        return alerts;
                    }
                    activeFilter = true;
                }
                if (criteria.hasResolvedTimeCriteria()) {
                    Set<String> alertIdsFilteredByResolvedTime = this.filterByResolvedTime(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByResolvedTime);
                    } else {
                        alertIds.addAll(alertIdsFilteredByResolvedTime);
                    }
                    if (alertIds.isEmpty()) {
                        return alerts;
                    }
                    activeFilter = true;
                }
                if (criteria.hasAckTimeCriteria()) {
                    Set<String> alertIdsFilteredByAckTime = this.filterByAckTime(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByAckTime);
                    } else {
                        alertIds.addAll(alertIdsFilteredByAckTime);
                    }
                    if (alertIds.isEmpty()) {
                        return alerts;
                    }
                    activeFilter = true;
                }
                if (criteria.hasStatusTimeCriteria()) {
                    Set<String> alertIdsFilteredByStatusTime = this.filterByStatusTime(tenantId, criteria);
                    if (activeFilter) {
                        alertIds.retainAll(alertIdsFilteredByStatusTime);
                    } else {
                        alertIds.addAll(alertIdsFilteredByStatusTime);
                    }
                    if (alertIds.isEmpty()) {
                        return alerts;
                    }
                    activeFilter = true;
                }
                if (activeFilter) {
                    PreparedStatement selectAlertsByTenantAndAlert = CassStatement.get(this.session, CassStatement.SELECT_ALERT);
                    List futures = alertIds.stream().map(alertId -> this.session.executeAsync((Statement)selectAlertsByTenantAndAlert.bind(new Object[]{tenantId, alertId}))).collect(Collectors.toList());
                    List rsAlerts = (List)Futures.allAsList(futures).get();
                    rsAlerts.stream().forEach(r -> {
                        for (Row row : r) {
                            String payload = row.getString("payload");
                            Alert alert = (Alert)JsonUtil.fromJson((String)payload, Alert.class, (boolean)thin);
                            alerts.add(alert);
                        }
                    });
                } else {
                    log.warnf("Only supplying Severity and/or Status can be slow and return large Sets: %s", (Object)criteria);
                    this.fetchAllAlerts(tenantId, thin, alerts);
                }
                if (criteria.hasSeverityCriteria()) {
                    this.filterBySeverities(tenantId, criteria, alerts);
                    if (alerts.isEmpty()) {
                        return alerts;
                    }
                }
                if (criteria.hasStatusCriteria()) {
                    this.filterByStatuses(tenantId, criteria, alerts);
                    if (alerts.isEmpty()) {
                        return alerts;
                    }
                }
            } else {
                this.fetchAllAlerts(tenantId, thin, alerts);
            }
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alerts;
    }

    private void fetchAllAlerts(String tenantId, boolean thin, Collection<Alert> alerts) {
        PreparedStatement selectAlertsByTenant = CassStatement.get(this.session, CassStatement.SELECT_ALERTS_BY_TENANT);
        ResultSet rsAlerts = this.session.execute((Statement)selectAlertsByTenant.bind(new Object[]{tenantId}));
        for (Row row : rsAlerts) {
            String payload = row.getString("payload");
            Alert alert = (Alert)JsonUtil.fromJson((String)payload, Alert.class, (boolean)thin);
            alerts.add(alert);
        }
    }

    private Page<Alert> preparePage(List<Alert> alerts, Pager pager) {
        if (pager != null) {
            if (pager.getOrder() != null && !pager.getOrder().isEmpty() && ((Order)pager.getOrder().get(0)).getField() == null) {
                pager = Pager.builder().withPageSize(pager.getPageSize()).withStartPage(pager.getPageNumber()).orderBy(AlertComparator.Field.ALERT_ID.getText(), Order.Direction.DESCENDING).build();
            }
            List<Alert> ordered = alerts;
            if (pager.getOrder() != null) {
                pager.getOrder().stream().filter(o -> o.getField() != null && o.getDirection() != null).forEach(o -> {
                    AlertComparator comparator = new AlertComparator(o.getField(), o.getDirection());
                    Collections.sort(ordered, comparator);
                });
            }
            if (!pager.isLimited() || ordered.size() < pager.getStart()) {
                pager = new Pager(0, ordered.size(), (Iterable)pager.getOrder());
                return new Page(ordered, (PageContext)pager, (long)ordered.size());
            }
            if (pager.getEnd() >= ordered.size()) {
                return new Page(ordered.subList(pager.getStart(), ordered.size()), (PageContext)pager, (long)ordered.size());
            }
            return new Page(ordered.subList(pager.getStart(), pager.getEnd()), (PageContext)pager, (long)ordered.size());
        }
        pager = Pager.builder().withPageSize(alerts.size()).orderBy(AlertComparator.Field.ALERT_ID.getText(), Order.Direction.ASCENDING).build();
        return new Page(alerts, (PageContext)pager, (long)alerts.size());
    }

    private Set<String> filterByAlerts(AlertsCriteria criteria) {
        Set<String> result = Collections.emptySet();
        if (this.isEmpty(criteria.getAlertIds())) {
            if (!this.isEmpty(criteria.getAlertId())) {
                result = new HashSet<String>(1);
                result.add(criteria.getAlertId());
            }
        } else {
            result = new HashSet();
            result.addAll(criteria.getAlertIds());
        }
        return result;
    }

    private Set<String> filterByTriggers(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        Set<String> triggerIds = this.extractTriggerIds(tenantId, criteria);
        if (triggerIds.size() > 0) {
            PreparedStatement selectAlertsTriggers = CassStatement.get(this.session, CassStatement.SELECT_ALERT_TRIGGER);
            List futures = triggerIds.stream().map(triggerId -> this.session.executeAsync((Statement)selectAlertsTriggers.bind(new Object[]{tenantId, triggerId}))).collect(Collectors.toList());
            List rsAlertIdsByTriggerIds = (List)Futures.allAsList(futures).get();
            HashSet<String> alertIds = new HashSet<String>();
            rsAlertIdsByTriggerIds.stream().forEach(r -> {
                for (Row row : r) {
                    String alertId = row.getString("alertId");
                    alertIds.add(alertId);
                }
            });
            result = alertIds;
        }
        return result;
    }

    private Set<String> extractTriggerIds(String tenantId, AlertsCriteria criteria) {
        HashSet<String> triggerIds;
        boolean hasTriggerId = !this.isEmpty(criteria.getTriggerId());
        boolean hasTriggerIds = !this.isEmpty(criteria.getTriggerIds());
        Set<Object> set = triggerIds = hasTriggerId || hasTriggerIds ? new HashSet() : Collections.emptySet();
        if (!hasTriggerIds) {
            if (hasTriggerId) {
                triggerIds.add(criteria.getTriggerId());
            }
        } else {
            for (String triggerId : criteria.getTriggerIds()) {
                if (this.isEmpty(triggerId)) continue;
                triggerIds.add(triggerId);
            }
        }
        return triggerIds;
    }

    private Set<String> filterByCTime(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        if (criteria.getStartTime() != null || criteria.getEndTime() != null) {
            BoundStatement boundCtime;
            result = new HashSet();
            if (criteria.getStartTime() != null && criteria.getEndTime() != null) {
                PreparedStatement selectAlertCTimeStartEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_CTIME_START_END);
                boundCtime = selectAlertCTimeStartEnd.bind(new Object[]{tenantId, criteria.getStartTime(), criteria.getEndTime()});
            } else if (criteria.getStartTime() != null) {
                PreparedStatement selectAlertCTimeStart = CassStatement.get(this.session, CassStatement.SELECT_ALERT_CTIME_START);
                boundCtime = selectAlertCTimeStart.bind(new Object[]{tenantId, criteria.getStartTime()});
            } else {
                PreparedStatement selectAlertCTimeEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_CTIME_END);
                boundCtime = selectAlertCTimeEnd.bind(new Object[]{tenantId, criteria.getEndTime()});
            }
            ResultSet rsAlertsCtimes = this.session.execute((Statement)boundCtime);
            for (Row row : rsAlertsCtimes) {
                String alertId = row.getString("alertId");
                result.add(alertId);
            }
        }
        return result;
    }

    private void filterBySeverities(String tenantId, AlertsCriteria criteria, Collection<Alert> alerts) throws Exception {
        HashSet<Severity> severities = new HashSet<Severity>();
        if (this.isEmpty(criteria.getSeverities())) {
            if (criteria.getSeverity() != null) {
                severities.add(criteria.getSeverity());
            }
        } else {
            severities.addAll(criteria.getSeverities());
        }
        if (severities.size() > 0) {
            Iterator<Alert> i = alerts.iterator();
            while (i.hasNext()) {
                Alert a = i.next();
                if (severities.contains(a.getSeverity())) continue;
                i.remove();
            }
        }
    }

    private void filterByStatuses(String tenantId, AlertsCriteria criteria, Collection<Alert> alerts) throws Exception {
        HashSet<Alert.Status> statusSet = new HashSet<Alert.Status>();
        if (this.isEmpty(criteria.getStatusSet())) {
            if (criteria.getStatus() != null) {
                statusSet.add(criteria.getStatus());
            }
        } else {
            statusSet.addAll(criteria.getStatusSet());
        }
        if (statusSet.size() > 0) {
            Iterator<Alert> i = alerts.iterator();
            while (i.hasNext()) {
                Alert a = i.next();
                if (statusSet.contains(a.getStatus())) continue;
                i.remove();
            }
        }
    }

    private Set<String> filterByStatusTime(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        if (criteria.getStartStatusTime() != null || criteria.getEndStatusTime() != null) {
            BoundStatement boundStime;
            result = new HashSet();
            if (criteria.getStartStatusTime() != null && criteria.getEndStatusTime() != null) {
                PreparedStatement selectAlertSTimeStartEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_STIME_START_END);
                boundStime = selectAlertSTimeStartEnd.bind(new Object[]{tenantId, criteria.getStartStatusTime(), criteria.getEndStatusTime()});
            } else if (criteria.getStartStatusTime() != null) {
                PreparedStatement selectAlertSTimeStart = CassStatement.get(this.session, CassStatement.SELECT_ALERT_STIME_START);
                boundStime = selectAlertSTimeStart.bind(new Object[]{tenantId, criteria.getStartStatusTime()});
            } else {
                PreparedStatement selectAlertSTimeEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_STIME_END);
                boundStime = selectAlertSTimeEnd.bind(new Object[]{tenantId, criteria.getEndStatusTime()});
            }
            ResultSet rsAlertsStimes = this.session.execute((Statement)boundStime);
            for (Row row : rsAlertsStimes) {
                String alertId = row.getString("alertId");
                result.add(alertId);
            }
        }
        return result;
    }

    private Set<String> filterByEvents(EventsCriteria criteria) {
        Set<String> result = Collections.emptySet();
        if (this.isEmpty(criteria.getEventIds())) {
            if (!this.isEmpty(criteria.getEventId())) {
                result = new HashSet<String>(1);
                result.add(criteria.getEventId());
            }
        } else {
            result = new HashSet();
            result.addAll(criteria.getEventIds());
        }
        return result;
    }

    private Set<String> filterByResolvedTime(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        if (criteria.getStartResolvedTime() != null || criteria.getEndResolvedTime() != null) {
            BoundStatement boundLifecycleTime;
            result = new HashSet();
            if (criteria.getStartResolvedTime() != null && criteria.getEndResolvedTime() != null) {
                PreparedStatement selectAlertLifecycleStartEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_LIFECYCLE_START_END);
                boundLifecycleTime = selectAlertLifecycleStartEnd.bind(new Object[]{tenantId, Alert.Status.RESOLVED.name(), criteria.getStartResolvedTime(), criteria.getEndResolvedTime()});
            } else if (criteria.getStartResolvedTime() != null) {
                PreparedStatement selectAlertLifecycleStart = CassStatement.get(this.session, CassStatement.SELECT_ALERT_LIFECYCLE_START);
                boundLifecycleTime = selectAlertLifecycleStart.bind(new Object[]{tenantId, Alert.Status.RESOLVED.name(), criteria.getStartResolvedTime()});
            } else {
                PreparedStatement selectAlertLifecycleEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_LIFECYCLE_END);
                boundLifecycleTime = selectAlertLifecycleEnd.bind(new Object[]{tenantId, criteria.getEndResolvedTime()});
            }
            ResultSet rsAlertsLifecycleTimes = this.session.execute((Statement)boundLifecycleTime);
            for (Row row : rsAlertsLifecycleTimes) {
                String alertId = row.getString("alertId");
                result.add(alertId);
            }
        }
        return result;
    }

    private Set<String> filterByAckTime(String tenantId, AlertsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        if (criteria.getStartAckTime() != null || criteria.getEndAckTime() != null) {
            BoundStatement boundLifecycleTime;
            result = new HashSet();
            if (criteria.getStartAckTime() != null && criteria.getEndAckTime() != null) {
                PreparedStatement selectAlertLifecycleStartEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_LIFECYCLE_START_END);
                boundLifecycleTime = selectAlertLifecycleStartEnd.bind(new Object[]{tenantId, Alert.Status.ACKNOWLEDGED.name(), criteria.getStartAckTime(), criteria.getEndAckTime()});
            } else if (criteria.getStartAckTime() != null) {
                PreparedStatement selectAlertLifecycleStart = CassStatement.get(this.session, CassStatement.SELECT_ALERT_LIFECYCLE_START);
                boundLifecycleTime = selectAlertLifecycleStart.bind(new Object[]{tenantId, Alert.Status.ACKNOWLEDGED.name(), criteria.getStartAckTime()});
            } else {
                PreparedStatement selectAlertLifecycleEnd = CassStatement.get(this.session, CassStatement.SELECT_ALERT_LIFECYCLE_END);
                boundLifecycleTime = selectAlertLifecycleEnd.bind(new Object[]{tenantId, criteria.getEndAckTime()});
            }
            ResultSet rsAlertsLifecycleTimes = this.session.execute((Statement)boundLifecycleTime);
            for (Row row : rsAlertsLifecycleTimes) {
                String alertId = row.getString("alertId");
                result.add(alertId);
            }
        }
        return result;
    }

    private Set<String> getIdsByTags(String tenantId, TagType tagType, Map<String, String> tags) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        PreparedStatement selectTagsByName = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME);
        PreparedStatement selectTagsByNameAndValue = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME_AND_VALUE);
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            boolean nameOnly = "*".equals(tag.getValue());
            BoundStatement bs = nameOnly ? selectTagsByName.bind(new Object[]{tenantId, tagType.name(), tag.getKey()}) : selectTagsByNameAndValue.bind(new Object[]{tenantId, tagType.name(), tag.getKey(), tag.getValue()});
            futures.add(this.session.executeAsync((Statement)bs));
        }
        List rsTags = (List)Futures.allAsList(futures).get();
        rsTags.stream().forEach(r -> {
            for (Row row : r) {
                ids.add(row.getString("id"));
            }
        });
        return ids;
    }

    private Set<TagValue> getTagValueByTagName(String tenantId, TagType tagType, String tagName) throws Exception {
        HashSet<TagValue> tagValues = new HashSet<TagValue>();
        PreparedStatement selectTagsByName = CassStatement.get(this.session, CassStatement.SELECT_TAGS_BY_NAME);
        ((ResultSet)this.session.executeAsync((Statement)selectTagsByName.bind(new Object[]{tenantId, tagType.name(), tagName})).get()).all().forEach(r -> tagValues.add(new TagValue(tenantId, tagName, r.getString("value"), r.getString("id"))));
        return tagValues;
    }

    private boolean filterTagValue(String op, String regexps, String value) {
        String[] items;
        if (op.equals("=") || op.equals("!=")) {
            boolean matches;
            if (regexps.equals("'*'")) {
                matches = true;
            } else if (regexps.charAt(0) == '\'') {
                String regexp = regexps.substring(1, regexps.length() - 1);
                matches = value.matches(regexp);
            } else {
                String regexp = regexps;
                matches = value.equals(regexp);
            }
            return op.equals("=") ? matches : !matches;
        }
        String array = regexps.substring(1, regexps.length() - 1);
        for (String item : items = array.split(",")) {
            String regexp;
            if (item.equals("'*'")) {
                return op.equals("in");
            }
            String string = regexp = item.charAt(0) == '\'' ? item.substring(1, item.length() - 1) : item;
            if (!value.matches(regexp)) continue;
            return op.equals("in");
        }
        return !op.equals("in");
    }

    private Set<String> getIdsByTagQuery(String tenantId, TagType tagType, String tagQuery) throws Exception {
        ExpressionTagQueryParser parser = new ExpressionTagQueryParser(tokens -> {
            Set<Object> result = new HashSet();
            if (tokens != null) {
                HashMap<String, String> map = new HashMap<String, String>();
                if (tokens.size() == 1) {
                    String tag = (String)tokens.get(0);
                    map.put(tag, "*");
                    Set<String> idsByTag = this.getIdsByTags(tenantId, tagType, map);
                    result = idsByTag;
                } else if (tokens.size() == 2) {
                    String tag = (String)tokens.get(1);
                    Set<String> allIds = TagType.ALERT.equals((Object)tagType) ? this.getAllAlertIds(tenantId) : this.getAllEventIds(tenantId);
                    map.put(tag, "*");
                    Set<String> idsByTag = this.getIdsByTags(tenantId, tagType, map);
                    allIds.removeAll(idsByTag);
                    result = allIds;
                } else {
                    String regexp;
                    String op;
                    String tag = (String)tokens.get(0);
                    if (tokens.size() == 3) {
                        op = (String)tokens.get(1);
                        regexp = (String)tokens.get(2);
                    } else {
                        op = (String)tokens.get(1) + (String)tokens.get(2);
                        regexp = (String)tokens.get(3);
                    }
                    Set<TagValue> tagValues = this.getTagValueByTagName(tenantId, tagType, tag);
                    result = tagValues.stream().filter(tagValue -> this.filterTagValue(op, regexp, tagValue.getValue())).map(tagValue -> tagValue.getId()).collect(Collectors.toSet());
                }
            }
            return result;
        });
        return parser.resolve(tagQuery);
    }

    private Set<String> getAllAlertIds(String tenantId) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        PreparedStatement selectAlertIdsByTenant = CassStatement.get(this.session, CassStatement.SELECT_ALERT_IDS_BY_TENANT);
        ResultSetFuture future = this.session.executeAsync((Statement)selectAlertIdsByTenant.bind(new Object[]{tenantId}));
        ((ResultSet)future.get()).all().stream().forEach(r -> ids.add(r.getString("alertId")));
        return ids;
    }

    private Set<String> getAllEventIds(String tenantId) throws Exception {
        HashSet<String> ids = new HashSet<String>();
        PreparedStatement selectEventIdsByTenant = CassStatement.get(this.session, CassStatement.SELECT_EVENT_IDS_BY_TENANT);
        ResultSetFuture future = this.session.executeAsync((Statement)selectEventIdsByTenant.bind(new Object[]{tenantId}));
        ((ResultSet)future.get()).all().stream().forEach(r -> ids.add(r.getString("id")));
        return ids;
    }

    public Page<Event> getEvents(String tenantId, EventsCriteria criteria, Pager pager) throws Exception {
        return this.getEvents(Collections.singleton(tenantId), criteria, pager);
    }

    public Page<Event> getEvents(Set<String> tenantIds, EventsCriteria criteria, Pager pager) throws Exception {
        if (this.isEmpty(tenantIds)) {
            throw new IllegalArgumentException("TenantIds must be not null");
        }
        ArrayList<Event> events = new ArrayList<Event>();
        if (tenantIds.size() == 1) {
            events.addAll(this.getEvents(tenantIds.iterator().next(), criteria));
        } else {
            TreeSet<String> orderedTenantIds = new TreeSet<String>(tenantIds);
            ArrayList futures = new ArrayList();
            orderedTenantIds.stream().forEach(tenantId -> futures.add(this.executor.submit(() -> {
                try {
                    List<Event> tenantEvents = this.getEvents((String)tenantId, criteria);
                    List list = events;
                    synchronized (list) {
                        events.addAll(tenantEvents);
                    }
                }
                catch (Exception e) {
                    msgLog.errorDatabaseException(e.getMessage());
                }
            })));
            futures.stream().forEach(f -> {
                try {
                    f.get();
                }
                catch (Exception e) {
                    msgLog.errorDatabaseException(e.getMessage());
                }
            });
        }
        if (events.isEmpty()) {
            return new Page(events, (PageContext)pager, 0L);
        }
        return this.prepareEventsPage(events, pager);
    }

    private List<Event> getEvents(String tenantId, EventsCriteria criteria) throws Exception {
        int noQuerySize;
        boolean filter = null != criteria && criteria.hasCriteria();
        boolean thin = null != criteria && criteria.isThin();
        int n = noQuerySize = null == criteria || null == criteria.getCriteriaNoQuerySize() ? this.criteriaNoQuerySize : criteria.getCriteriaNoQuerySize();
        if (filter && log.isDebugEnabled()) {
            log.debug((Object)("getEvents criteria: " + criteria.toString()));
        }
        ArrayList<Event> events = new ArrayList<Event>();
        HashSet<String> eventIds = new HashSet<String>();
        boolean activeFilter = false;
        try {
            if (filter) {
                if (criteria.hasEventIdCriteria()) {
                    Set<String> idsFilteredByEvents = this.filterByEvents(criteria);
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByEvents);
                    } else {
                        eventIds.addAll(idsFilteredByEvents);
                    }
                    if (eventIds.isEmpty()) {
                        return events;
                    }
                    activeFilter = true;
                }
                if (criteria.hasTagQueryCriteria()) {
                    Set<String> idsFilteredByTagQuery = this.getIdsByTagQuery(tenantId, TagType.EVENT, criteria.getTagQuery());
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByTagQuery);
                    } else {
                        eventIds.addAll(idsFilteredByTagQuery);
                    }
                    if (eventIds.isEmpty()) {
                        return events;
                    }
                    activeFilter = true;
                }
                if (criteria.hasTriggerIdCriteria()) {
                    Set<String> idsFilteredByTriggers = this.filterByTriggers(tenantId, criteria);
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByTriggers);
                    } else {
                        eventIds.addAll(idsFilteredByTriggers);
                    }
                    if (eventIds.isEmpty()) {
                        return events;
                    }
                    activeFilter = true;
                }
                if (criteria.hasCTimeCriteria()) {
                    Set<String> idsFilteredByTime = this.filterByCTime(tenantId, criteria);
                    if (activeFilter) {
                        eventIds.retainAll(idsFilteredByTime);
                    } else {
                        eventIds.addAll(idsFilteredByTime);
                    }
                    if (eventIds.isEmpty()) {
                        return events;
                    }
                    activeFilter = true;
                }
                if (activeFilter && eventIds.size() <= noQuerySize) {
                    this.fetchEvents(tenantId, eventIds, thin, events);
                }
                if (criteria.hasCategoryCriteria()) {
                    if (events.isEmpty()) {
                        Set<String> idsFilteredByCategory = this.filterByCategories(tenantId, criteria);
                        if (activeFilter) {
                            eventIds.retainAll(idsFilteredByCategory);
                        } else {
                            eventIds.addAll(idsFilteredByCategory);
                        }
                        if (eventIds.isEmpty()) {
                            return events;
                        }
                        activeFilter = true;
                    } else {
                        this.filterByCategories(tenantId, criteria, events);
                        if (events.isEmpty()) {
                            return events;
                        }
                    }
                }
                if (events.isEmpty()) {
                    this.fetchEvents(tenantId, eventIds, thin, events);
                }
            } else {
                PreparedStatement selectEventsByTenant = CassStatement.get(this.session, CassStatement.SELECT_EVENTS_BY_TENANT);
                ResultSet rsEvents = this.session.execute((Statement)selectEventsByTenant.bind(new Object[]{tenantId}));
                for (Row row : rsEvents) {
                    String payload = row.getString("payload");
                    Event event = (Event)JsonUtil.fromJson((String)payload, Event.class, (boolean)thin);
                    events.add(event);
                }
            }
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return events;
    }

    private void fetchEvents(String tenantId, Set<String> eventIds, boolean thin, List<Event> events) throws Exception {
        PreparedStatement selectEvent = CassStatement.get(this.session, CassStatement.SELECT_EVENT);
        List futures = eventIds.stream().map(id -> this.session.executeAsync((Statement)selectEvent.bind(new Object[]{tenantId, id}))).collect(Collectors.toList());
        List rsEvents = (List)Futures.allAsList(futures).get();
        rsEvents.stream().forEach(r -> {
            for (Row row : r) {
                String payload = row.getString("payload");
                Event event = (Event)JsonUtil.fromJson((String)payload, Event.class, (boolean)thin);
                events.add(event);
            }
        });
    }

    private Page<Event> prepareEventsPage(List<Event> events, Pager pager) {
        if (pager != null) {
            if (pager.getOrder() != null && !pager.getOrder().isEmpty() && ((Order)pager.getOrder().get(0)).getField() == null) {
                pager = Pager.builder().withPageSize(pager.getPageSize()).withStartPage(pager.getPageNumber()).orderBy(EventComparator.Field.ID.getName(), Order.Direction.DESCENDING).build();
            }
            List<Event> ordered = events;
            if (pager.getOrder() != null) {
                pager.getOrder().stream().filter(o -> o.getField() != null && o.getDirection() != null).forEach(o -> {
                    EventComparator comparator = new EventComparator(o.getField(), o.getDirection());
                    Collections.sort(ordered, comparator);
                });
            }
            if (!pager.isLimited() || ordered.size() < pager.getStart()) {
                pager = new Pager(0, ordered.size(), (Iterable)pager.getOrder());
                return new Page(ordered, (PageContext)pager, (long)ordered.size());
            }
            if (pager.getEnd() >= ordered.size()) {
                return new Page(ordered.subList(pager.getStart(), ordered.size()), (PageContext)pager, (long)ordered.size());
            }
            return new Page(ordered.subList(pager.getStart(), pager.getEnd()), (PageContext)pager, (long)ordered.size());
        }
        pager = Pager.builder().withPageSize(events.size()).orderBy(EventComparator.Field.ID.getName(), Order.Direction.ASCENDING).build();
        return new Page(events, (PageContext)pager, (long)events.size());
    }

    private Set<String> filterByTriggers(String tenantId, EventsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        Set<String> triggerIds = this.extractTriggerIds(tenantId, criteria);
        if (triggerIds.size() > 0) {
            PreparedStatement selectEventsTriggers = CassStatement.get(this.session, CassStatement.SELECT_EVENT_TRIGGER);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            for (String triggerId : triggerIds) {
                if (this.isEmpty(triggerId)) continue;
                futures.add(this.session.executeAsync((Statement)selectEventsTriggers.bind(new Object[]{tenantId, triggerId})));
            }
            List rsIdsByTriggerIds = (List)Futures.allAsList(futures).get();
            HashSet<String> eventIds = new HashSet<String>();
            rsIdsByTriggerIds.stream().forEach(r -> {
                for (Row row : r) {
                    String eventId = row.getString("id");
                    eventIds.add(eventId);
                }
            });
            result = eventIds;
        }
        return result;
    }

    private Set<String> extractTriggerIds(String tenantId, EventsCriteria criteria) {
        HashSet<String> triggerIds;
        boolean hasTriggerId = !this.isEmpty(criteria.getTriggerId());
        boolean hasTriggerIds = !this.isEmpty(criteria.getTriggerIds());
        Set<Object> set = triggerIds = hasTriggerId || hasTriggerIds ? new HashSet() : Collections.emptySet();
        if (!hasTriggerIds) {
            if (hasTriggerId) {
                triggerIds.add(criteria.getTriggerId());
            }
        } else {
            for (String triggerId : criteria.getTriggerIds()) {
                if (this.isEmpty(triggerId)) continue;
                triggerIds.add(triggerId);
            }
        }
        return triggerIds;
    }

    private Set<String> filterByCTime(String tenantId, EventsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        if (criteria.getStartTime() != null || criteria.getEndTime() != null) {
            BoundStatement boundCtime;
            result = new HashSet();
            if (criteria.getStartTime() != null && criteria.getEndTime() != null) {
                PreparedStatement selectEventCTimeStartEnd = CassStatement.get(this.session, CassStatement.SELECT_EVENT_CTIME_START_END);
                boundCtime = selectEventCTimeStartEnd.bind(new Object[]{tenantId, criteria.getStartTime(), criteria.getEndTime()});
            } else if (criteria.getStartTime() != null) {
                PreparedStatement selectEventCTimeStart = CassStatement.get(this.session, CassStatement.SELECT_EVENT_CTIME_START);
                boundCtime = selectEventCTimeStart.bind(new Object[]{tenantId, criteria.getStartTime()});
            } else {
                PreparedStatement selectEventCTimeEnd = CassStatement.get(this.session, CassStatement.SELECT_EVENT_CTIME_END);
                boundCtime = selectEventCTimeEnd.bind(new Object[]{tenantId, criteria.getEndTime()});
            }
            ResultSet rsIdsCtimes = this.session.execute((Statement)boundCtime);
            for (Row row : rsIdsCtimes) {
                String eventId = row.getString("id");
                result.add(eventId);
            }
        }
        return result;
    }

    private Set<String> filterByCategories(String tenantId, EventsCriteria criteria) throws Exception {
        Set<String> result = Collections.emptySet();
        HashSet<String> categories = new HashSet<String>();
        if (this.isEmpty(criteria.getCategories())) {
            if (criteria.getCategory() != null) {
                categories.add(criteria.getCategory());
            }
        } else {
            categories.addAll(criteria.getCategories());
        }
        if (categories.size() > 0) {
            PreparedStatement selectEventCategory = CassStatement.get(this.session, CassStatement.SELECT_EVENT_CATEGORY);
            List futures = categories.stream().map(category -> this.session.executeAsync((Statement)selectEventCategory.bind(new Object[]{tenantId, category}))).collect(Collectors.toList());
            List rsAlertStatuses = (List)Futures.allAsList(futures).get();
            HashSet<String> eventIds = new HashSet<String>();
            rsAlertStatuses.stream().forEach(r -> {
                for (Row row : r) {
                    String eventId = row.getString("id");
                    eventIds.add(eventId);
                }
            });
            result = eventIds;
        }
        return result;
    }

    private void filterByCategories(String tenantId, EventsCriteria criteria, Collection<Event> events) throws Exception {
        HashSet<String> categories = new HashSet<String>();
        if (this.isEmpty(criteria.getCategories())) {
            if (criteria.getCategory() != null) {
                categories.add(criteria.getCategory());
            }
        } else {
            categories.addAll(criteria.getCategories());
        }
        if (categories.size() > 0) {
            Iterator<Event> i = events.iterator();
            while (i.hasNext()) {
                Event e = i.next();
                if (categories.contains(e.getCategory())) continue;
                i.remove();
            }
        }
    }

    public void ackAlerts(String tenantId, Collection<String> alertIds, String ackBy, String ackNotes) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        if (this.isEmpty(ackBy)) {
            ackBy = "unknown";
        }
        if (this.isEmpty(ackNotes)) {
            ackNotes = "none";
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> alertsToAck = this.getAlerts(tenantId, criteria, null);
        for (Alert a : alertsToAck) {
            a.addNote(ackBy, ackNotes);
            a.addLifecycle(Alert.Status.ACKNOWLEDGED, ackBy, System.currentTimeMillis());
            this.updateAlertStatus(a);
            this.sendAction(a);
        }
    }

    public int deleteAlerts(String tenantId, AlertsCriteria criteria) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (null == criteria) {
            throw new IllegalArgumentException("Criteria must be not null");
        }
        criteria.setThin(true);
        Page<Alert> alertsToDelete = this.getAlerts(tenantId, criteria, null);
        if (alertsToDelete.isEmpty()) {
            return 0;
        }
        PreparedStatement deleteAlert = CassStatement.get(this.session, CassStatement.DELETE_ALERT);
        PreparedStatement deleteAlertCtime = CassStatement.get(this.session, CassStatement.DELETE_ALERT_CTIME);
        PreparedStatement deleteAlertTrigger = CassStatement.get(this.session, CassStatement.DELETE_ALERT_TRIGGER);
        PreparedStatement deleteAlertLifecycle = CassStatement.get(this.session, CassStatement.DELETE_ALERT_LIFECYCLE);
        PreparedStatement deleteAlertStime = CassStatement.get(this.session, CassStatement.DELETE_ALERT_STIME);
        if (deleteAlert == null || deleteAlertCtime == null || deleteAlertTrigger == null || deleteAlertLifecycle == null) {
            throw new RuntimeException("delete*Alerts PreparedStatement is null");
        }
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        int i = 0;
        BatchStatement batch = new BatchStatement(this.batchType);
        for (Alert a : alertsToDelete) {
            String id = a.getAlertId();
            batch.add((Statement)deleteAlert.bind(new Object[]{tenantId, id}));
            batch.add((Statement)deleteAlertCtime.bind(new Object[]{tenantId, a.getCtime(), id}));
            batch.add((Statement)deleteAlertTrigger.bind(new Object[]{tenantId, a.getTriggerId(), id}));
            a.getLifecycle().stream().forEach(l -> {
                batch.add((Statement)deleteAlertLifecycle.bind(new Object[]{tenantId, l.getStatus().name(), l.getStime(), a.getAlertId()}));
                batch.add((Statement)deleteAlertStime.bind(new Object[]{tenantId, l.getStime(), a.getAlertId()}));
            });
            if ((i += batch.size()) <= this.batchSize) continue;
            futures.add(this.session.executeAsync((Statement)batch));
            batch.clear();
            i = 0;
        }
        if (batch.size() > 0) {
            futures.add(this.session.executeAsync((Statement)batch));
        }
        Futures.allAsList(futures).get();
        return alertsToDelete.size();
    }

    public int deleteEvents(String tenantId, EventsCriteria criteria) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (null == criteria) {
            throw new IllegalArgumentException("Criteria must be not null");
        }
        criteria.setThin(true);
        Page<Event> eventsToDelete = this.getEvents(tenantId, criteria, null);
        if (eventsToDelete.isEmpty()) {
            return 0;
        }
        PreparedStatement deleteEvent = CassStatement.get(this.session, CassStatement.DELETE_EVENT);
        PreparedStatement deleteEventCategory = CassStatement.get(this.session, CassStatement.DELETE_EVENT_CATEGORY);
        PreparedStatement deleteEventCTime = CassStatement.get(this.session, CassStatement.DELETE_EVENT_CTIME);
        PreparedStatement deleteEventTrigger = CassStatement.get(this.session, CassStatement.DELETE_EVENT_TRIGGER);
        if (deleteEvent == null || deleteEventCTime == null || deleteEventCategory == null || deleteEventTrigger == null) {
            throw new RuntimeException("delete*Events PreparedStatement is null");
        }
        ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
        int i = 0;
        BatchStatement batch = new BatchStatement(this.batchType);
        for (Event e : eventsToDelete) {
            String id = e.getId();
            batch.add((Statement)deleteEvent.bind(new Object[]{tenantId, id}));
            batch.add((Statement)deleteEventCategory.bind(new Object[]{tenantId, e.getCategory(), id}));
            batch.add((Statement)deleteEventCTime.bind(new Object[]{tenantId, e.getCtime(), id}));
            if (null != e.getTrigger()) {
                batch.add((Statement)deleteEventTrigger.bind(new Object[]{tenantId, e.getTrigger().getId(), id}));
            }
            if ((i += batch.size()) <= this.batchSize) continue;
            futures.add(this.session.executeAsync((Statement)batch));
            batch.clear();
            i = 0;
        }
        if (batch.size() > 0) {
            futures.add(this.session.executeAsync((Statement)batch));
        }
        Futures.allAsList(futures).get();
        return eventsToDelete.size();
    }

    public void resolveAlerts(String tenantId, Collection<String> alertIds, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(alertIds)) {
            return;
        }
        if (this.isEmpty(resolvedBy)) {
            resolvedBy = "unknown";
        }
        if (this.isEmpty(resolvedNotes)) {
            resolvedNotes = "none";
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setAlertIds(alertIds);
        Page<Alert> alertsToResolve = this.getAlerts(tenantId, criteria, null);
        for (Alert a2 : alertsToResolve) {
            a2.addNote(resolvedBy, resolvedNotes);
            a2.setResolvedEvalSets(resolvedEvalSets);
            a2.addLifecycle(Alert.Status.RESOLVED, resolvedBy, System.currentTimeMillis());
            this.updateAlertStatus(a2);
            this.sendAction(a2);
        }
        Set triggerIds = alertsToResolve.stream().map(a -> a.getTriggerId()).collect(Collectors.toSet());
        triggerIds.stream().forEach(tid -> this.handleResolveOptions(tenantId, (String)tid, true));
    }

    public void resolveAlertsForTrigger(String tenantId, String triggerId, String resolvedBy, String resolvedNotes, List<Set<ConditionEval>> resolvedEvalSets) throws Exception {
        if (this.isEmpty(tenantId)) {
            throw new IllegalArgumentException("TenantId must be not null");
        }
        if (this.isEmpty(triggerId)) {
            throw new IllegalArgumentException("TriggerId must be not null");
        }
        if (this.isEmpty(resolvedBy)) {
            resolvedBy = "unknown";
        }
        if (this.isEmpty(resolvedNotes)) {
            resolvedNotes = "none";
        }
        AlertsCriteria criteria = new AlertsCriteria();
        criteria.setTriggerId(triggerId);
        criteria.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
        Page<Alert> alertsToResolve = this.getAlerts(tenantId, criteria, null);
        for (Alert a : alertsToResolve) {
            a.addNote(resolvedBy, resolvedNotes);
            a.setResolvedEvalSets(resolvedEvalSets);
            a.addLifecycle(Alert.Status.RESOLVED, resolvedBy, System.currentTimeMillis());
            this.updateAlertStatus(a);
            this.sendAction(a);
        }
        this.handleResolveOptions(tenantId, triggerId, false);
    }

    private Alert updateAlertStatus(Alert alert) throws Exception {
        if (alert == null || alert.getAlertId() == null || alert.getAlertId().isEmpty()) {
            throw new IllegalArgumentException("AlertId must be not null");
        }
        try {
            PreparedStatement insertAlertLifecycle = CassStatement.get(this.session, CassStatement.INSERT_ALERT_LIFECYCLE);
            PreparedStatement insertAlertStime = CassStatement.get(this.session, CassStatement.INSERT_ALERT_STIME);
            PreparedStatement updateAlert = CassStatement.get(this.session, CassStatement.UPDATE_ALERT);
            ArrayList<ResultSetFuture> futures = new ArrayList<ResultSetFuture>();
            Alert.LifeCycle lifecycle = alert.getCurrentLifecycle();
            if (lifecycle != null) {
                futures.add(this.session.executeAsync((Statement)insertAlertLifecycle.bind(new Object[]{alert.getTenantId(), alert.getAlertId(), lifecycle.getStatus().name(), lifecycle.getStime()})));
                futures.add(this.session.executeAsync((Statement)insertAlertStime.bind(new Object[]{alert.getTenantId(), alert.getAlertId(), lifecycle.getStime()})));
            }
            futures.add(this.session.executeAsync((Statement)updateAlert.bind(new Object[]{JsonUtil.toJson((Object)alert), alert.getTenantId(), alert.getAlertId()})));
            Futures.allAsList(futures).get();
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
            throw e;
        }
        return alert;
    }

    private void handleResolveOptions(String tenantId, String triggerId, boolean checkIfAllResolved) {
        try {
            Trigger loadedTrigger;
            Trigger trigger = this.definitionsService.getTrigger(tenantId, triggerId);
            if (null == trigger) {
                return;
            }
            boolean setEnabled = trigger.isAutoEnable() && !trigger.isEnabled();
            boolean setFiring = trigger.isAutoResolve();
            if (setFiring && null != (loadedTrigger = this.alertsEngine.getLoadedTrigger(trigger)) && Mode.FIRING == loadedTrigger.getMode()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ignoring setFiring, loaded Trigger already in firing mode " + loadedTrigger.toString()));
                }
                setFiring = false;
            }
            if (!setEnabled && !setFiring) {
                return;
            }
            boolean allResolved = true;
            if (checkIfAllResolved) {
                AlertsCriteria ac = new AlertsCriteria();
                ac.setTriggerId(triggerId);
                ac.setStatusSet(EnumSet.complementOf(EnumSet.of(Alert.Status.RESOLVED)));
                Page<Alert> unresolvedAlerts = this.getAlerts(tenantId, ac, new Pager(0, 1, new Order[]{Order.unspecified()}));
                allResolved = unresolvedAlerts.isEmpty();
            }
            if (!allResolved) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Ignoring resolveOptions, not all Alerts for Trigger " + trigger.toString() + " are resolved"));
                }
                return;
            }
            if (setEnabled) {
                trigger.setEnabled(true);
                this.definitionsService.updateTrigger(tenantId, trigger);
            } else {
                this.alertsEngine.reloadTrigger(tenantId, triggerId);
            }
        }
        catch (Exception e) {
            msgLog.errorDatabaseException(e.getMessage());
        }
    }

    public void sendData(Collection<Data> data) throws Exception {
        this.sendData(data, false);
    }

    public void sendData(Collection<Data> data, boolean ignoreFiltering) throws Exception {
        if (this.isEmpty(data)) {
            return;
        }
        this.incomingDataManager.bufferData(new IncomingDataManagerImpl.IncomingData(data, !ignoreFiltering));
    }

    public void addEvents(Collection<Event> events) throws Exception {
        if (null == events || events.isEmpty()) {
            return;
        }
        this.persistEvents(events);
        this.sendEvents(events);
    }

    public void sendEvents(Collection<Event> events) throws Exception {
        this.sendEvents(events, false);
    }

    public void sendEvents(Collection<Event> events, boolean ignoreFiltering) throws Exception {
        if (this.isEmpty(events)) {
            return;
        }
        this.incomingDataManager.bufferEvents(new IncomingDataManagerImpl.IncomingEvents(events, !ignoreFiltering));
    }

    private void sendAction(Alert a) {
        if (this.actionsService != null && a != null && a.getTrigger() != null) {
            this.actionsService.send(a.getTrigger(), (Event)a);
        }
    }

    private boolean isEmpty(Map<?, ?> m) {
        return null == m || m.isEmpty();
    }

    private boolean isEmpty(Collection<?> c) {
        return null == c || c.isEmpty();
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private static class TagValue {
        private String tenantId;
        private String tag;
        private String value;
        private String id;

        public TagValue(String tenantId, String tag, String value, String id) {
            this.tenantId = tenantId;
            this.tag = tag;
            this.value = value;
            this.id = id;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getTag() {
            return this.tag;
        }

        public String getValue() {
            return this.value;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TagValue tagValue = (TagValue)o;
            if (this.tenantId != null ? !this.tenantId.equals(tagValue.tenantId) : tagValue.tenantId != null) {
                return false;
            }
            if (this.tag != null ? !this.tag.equals(tagValue.tag) : tagValue.tag != null) {
                return false;
            }
            if (this.value != null ? !this.value.equals(tagValue.value) : tagValue.value != null) {
                return false;
            }
            return this.id != null ? this.id.equals(tagValue.id) : tagValue.id == null;
        }

        public int hashCode() {
            int result = this.tenantId != null ? this.tenantId.hashCode() : 0;
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }
    }
}

