/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import org.hawkular.alerts.engine.log.MsgLogger;

public class AlertProperties {
    private static final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String ALERTS_CONF = "hawkular-alerts.properties";
    private static Properties alertsProperties = null;

    private AlertProperties() {
    }

    public static String getProperty(String key, String defaultValue) {
        return AlertProperties.getProperty(key, null, defaultValue);
    }

    public static String getProperty(String key, String envKey, String defaultValue) {
        String value;
        if (alertsProperties == null) {
            AlertProperties.initConfiguration();
        }
        if ((value = System.getProperty(key)) == null) {
            if (envKey != null) {
                value = System.getenv(envKey);
            }
            if (value == null) {
                value = alertsProperties.getProperty(key, defaultValue);
            }
        }
        return value;
    }

    private static void initConfiguration() {
        try {
            File extFile;
            String userHome = System.getProperty("user.home");
            InputStream is = null;
            if (userHome != null && (extFile = new File(userHome, ".hawkular-alerts.properties")).exists()) {
                is = new FileInputStream(extFile);
            }
            if (is == null) {
                is = AlertProperties.class.getClassLoader().getResourceAsStream(ALERTS_CONF);
            }
            alertsProperties = new Properties();
            alertsProperties.load(is);
        }
        catch (Exception e) {
            msgLog.warningFileNotFound(ALERTS_CONF);
        }
    }
}

