/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.engine.impl;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ejb.EJB;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.hawkular.alerts.api.services.ActionListener;
import org.hawkular.alerts.api.services.DefinitionsEvent;
import org.hawkular.alerts.api.services.DefinitionsListener;
import org.hawkular.alerts.api.services.DistributedEvent;
import org.hawkular.alerts.api.services.DistributedListener;
import org.hawkular.alerts.engine.service.PartitionManager;
import org.hawkular.alerts.engine.service.PartitionTriggerListener;
import org.jboss.logging.Logger;

@Startup
@Singleton
public class AlertsContext {
    private final Logger log = Logger.getLogger(AlertsContext.class);
    private Map<DefinitionsListener, Set<DefinitionsEvent.Type>> definitionListeners = new HashMap<DefinitionsListener, Set<DefinitionsEvent.Type>>();
    List<ActionListener> actionsListeners = new CopyOnWriteArrayList<ActionListener>();
    List<DistributedListener> distributedListener = new CopyOnWriteArrayList<DistributedListener>();
    private boolean distributed = false;
    @EJB
    PartitionManager partitionManager;

    @PostConstruct
    public void init() {
        if (this.partitionManager != null) {
            this.distributed = this.partitionManager.isDistributed();
        }
        if (this.distributed) {
            this.partitionManager.registerTriggerListener(new PartitionTriggerListener(){

                @Override
                public void onTriggerChange(PartitionManager.Operation operation, String tenantId, String triggerId) {
                    DistributedEvent.Operation op = DistributedEvent.Operation.valueOf((String)operation.name());
                    DistributedEvent event = new DistributedEvent(op, tenantId, triggerId);
                    AlertsContext.this.distributedListener.stream().forEach(listener -> listener.onChange(Collections.singleton(event)));
                }

                @Override
                public void onPartitionChange(Map<String, List<String>> partition, Map<String, List<String>> removed, Map<String, List<String>> added) {
                    HashSet events = new HashSet();
                    removed.entrySet().stream().forEach(entry -> {
                        String tenantId = (String)entry.getKey();
                        ((List)entry.getValue()).stream().forEach(triggerId -> events.add(new DistributedEvent(DistributedEvent.Operation.REMOVE, tenantId, triggerId)));
                    });
                    added.entrySet().stream().forEach(entry -> {
                        String tenantId = (String)entry.getKey();
                        ((List)entry.getValue()).stream().forEach(triggerId -> events.add(new DistributedEvent(DistributedEvent.Operation.ADD, tenantId, triggerId)));
                    });
                    AlertsContext.this.distributedListener.stream().forEach(listener -> listener.onChange(events));
                }
            });
        }
    }

    public void registerDefinitionListener(DefinitionsListener listener, DefinitionsEvent.Type eventType, DefinitionsEvent.Type ... eventTypes) {
        EnumSet<DefinitionsEvent.Type[]> types = EnumSet.of(eventType, eventTypes);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Registering listeners " + listener + " for event types " + types));
        }
        this.definitionListeners.put(listener, types);
    }

    public void registerDistributedListener(DistributedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("DistributedListener must not be null");
        }
        this.distributedListener.add(listener);
    }

    public Map<DefinitionsListener, Set<DefinitionsEvent.Type>> getDefinitionListeners() {
        return this.definitionListeners;
    }

    public void registerActionListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ActionListener must not be null");
        }
        this.actionsListeners.add(listener);
    }

    public List<ActionListener> getActionsListeners() {
        return this.actionsListeners;
    }

    public void notifyListeners(List<DefinitionsEvent> notifications) {
        Set notificationTypes = notifications.stream().map(n -> n.getType()).collect(Collectors.toSet());
        this.log.debugf("Notifying applicable listeners %s of events %s", this.definitionListeners, notifications);
        this.definitionListeners.entrySet().stream().filter(e -> this.shouldNotify((Set)e.getValue(), notificationTypes)).forEach(e -> {
            this.log.debugf("Notified Listener %s of %s", e.getKey(), (Object)notificationTypes);
            ((DefinitionsListener)e.getKey()).onChange(notifications.stream().filter(de -> ((Set)e.getValue()).contains(de.getType())).collect(Collectors.toList()));
        });
        if (!this.distributed) {
            this.distributedListener.stream().forEach(listener -> listener.onChange(this.mapDistributedEvents(notifications)));
        }
    }

    private boolean shouldNotify(Set<DefinitionsEvent.Type> listenerTypes, Set<DefinitionsEvent.Type> eventTypes) {
        HashSet<DefinitionsEvent.Type> intersection = new HashSet<DefinitionsEvent.Type>(listenerTypes);
        intersection.retainAll(eventTypes);
        return !intersection.isEmpty();
    }

    private Set<DistributedEvent> mapDistributedEvents(List<DefinitionsEvent> notification) {
        if (notification == null) {
            return null;
        }
        LinkedHashSet<DistributedEvent> events = new LinkedHashSet<DistributedEvent>();
        for (DefinitionsEvent definitionsEvent : notification) {
            DistributedEvent.Operation op = null;
            String tenantId = definitionsEvent.getTargetTenantId();
            String triggerId = definitionsEvent.getTargetId();
            switch (definitionsEvent.getType()) {
                case TRIGGER_CREATE: {
                    op = DistributedEvent.Operation.ADD;
                    break;
                }
                case TRIGGER_UPDATE: {
                    op = DistributedEvent.Operation.UPDATE;
                    break;
                }
                case TRIGGER_REMOVE: {
                    op = DistributedEvent.Operation.REMOVE;
                    break;
                }
                case TRIGGER_CONDITION_CHANGE: {
                    op = DistributedEvent.Operation.UPDATE;
                }
            }
            if (op == null) continue;
            events.add(new DistributedEvent(op, tenantId, triggerId));
        }
        return events;
    }
}

