/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.AssignableExpression;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class ArrayExpression
extends AssignableExpression {
    Expression arrayRef;
    List<Expression> idxList;

    public ArrayExpression(Rule rule, Type type, ParseNode token, Expression arrayRef, List<Expression> idxList) {
        super(rule, type, token);
        this.arrayRef = arrayRef;
        this.idxList = idxList;
    }

    @Override
    public void bind() throws TypeException {
        this.arrayRef.bind();
        Iterator<Expression> iterator = this.idxList.iterator();
        while (iterator.hasNext()) {
            iterator.next().bind();
        }
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.typeCheckAny();
        if (Type.dereference(expected).isDefined() && !expected.isAssignableFrom(this.type)) {
            throw new TypeException("ArrayExpression.typeCheck : invalid expected result type " + expected.getName() + this.getPos());
        }
        return this.type;
    }

    @Override
    public Type typeCheckAssign(Type expected) throws TypeException {
        this.typeCheckAny();
        if (Type.dereference(expected).isDefined() && !this.type.isAssignableFrom(expected)) {
            throw new TypeException("ArrayExpression.typeCheckAssign : invalid value type " + expected.getName() + " for array assignment " + this.getPos());
        }
        return this.type;
    }

    private void typeCheckAny() throws TypeException {
        Type arrayType;
        Type nextType = arrayType = this.arrayRef.typeCheck(Type.UNDEFINED);
        for (Expression expr : this.idxList) {
            if (!nextType.isArray()) {
                throw new TypeException("ArrayExpression.typeCheck : invalid type for array dereference " + nextType.getName() + this.getPos());
            }
            nextType = nextType.getBaseType();
            expr.typeCheck(Type.N);
        }
        this.type = nextType;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            Object value = this.arrayRef.interpret(helper);
            Type nextType = this.arrayRef.getType();
            for (Expression expr : this.idxList) {
                int idx = ((Number)expr.interpret(helper)).intValue();
                if (value == null) {
                    throw new ExecuteException("ArrayExpression.interpret : attempted array indirection through null value " + this.arrayRef.token.getText() + this.getPos());
                }
                value = Array.get(value, idx);
                nextType = nextType.getBaseType();
            }
            return value;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("ArrayExpression.interpret : failed to evaluate expression " + this.arrayRef.token.getText() + this.getPos(), e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExecuteException("ArrayExpression.interpret : invalid index for array " + this.arrayRef.token.getText() + this.getPos(), e);
        }
        catch (ClassCastException e) {
            throw new ExecuteException("ArrayExpression.interpret : invalid index dereferencing array " + this.arrayRef.token.getText() + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("ArrayExpression.interpret : unexpected exception dereferencing array " + this.arrayRef.token.getText() + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Type valueType = this.arrayRef.getType().getBaseType();
        int currentStack = compileContext.getStackCount();
        int expected = 0;
        this.arrayRef.compile(mv, compileContext);
        Iterator<Expression> iterator = this.idxList.iterator();
        while (iterator.hasNext()) {
            Expression idxExpr = iterator.next();
            idxExpr.compile(mv, compileContext);
            this.compileTypeConversion(idxExpr.getType(), Type.I, mv, compileContext);
            if (valueType.isObject() || valueType.isArray()) {
                mv.visitInsn(50);
                expected = 1;
            } else if (valueType == Type.Z || valueType == Type.B) {
                mv.visitInsn(51);
                expected = 1;
            } else if (valueType == Type.S) {
                mv.visitInsn(53);
                expected = 1;
            } else if (valueType == Type.C) {
                mv.visitInsn(52);
                expected = 1;
            } else if (valueType == Type.I) {
                mv.visitInsn(46);
                expected = 1;
            } else if (valueType == Type.J) {
                mv.visitInsn(47);
                expected = 2;
            } else if (valueType == Type.F) {
                mv.visitInsn(48);
                expected = 1;
            } else if (valueType == Type.D) {
                mv.visitInsn(49);
                expected = 2;
            }
            compileContext.addStackCount(expected - 2);
            if (!iterator.hasNext()) continue;
            assert (valueType.isArray());
            valueType = valueType.getBaseType();
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ArrayExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        this.arrayRef.writeTo(stringWriter);
        for (Expression expr : this.idxList) {
            stringWriter.write("[");
            expr.writeTo(stringWriter);
            stringWriter.write("]");
        }
    }

    @Override
    public Object interpretAssign(HelperAdapter helper, Object value) throws ExecuteException {
        try {
            Object array = this.arrayRef.interpret(helper);
            Type nextType = this.arrayRef.getType();
            int count = this.idxList.size() - 1;
            for (Expression expr : this.idxList) {
                int idx = ((Number)expr.interpret(helper)).intValue();
                if (array == null) {
                    throw new ExecuteException("ArrayExpression.interpret : attempted array indirection through null value " + this.arrayRef.token.getText() + this.getPos());
                }
                if (count-- > 0) {
                    array = Array.get(array, idx);
                    nextType = nextType.getBaseType();
                    continue;
                }
                Array.set(array, idx, value);
            }
            return value;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw new ExecuteException("ArrayExpression.interpret : failed to evaluate expression " + this.arrayRef.token.getText() + this.getPos(), e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ExecuteException("ArrayExpression.interpret : invalid index for array " + this.arrayRef.token.getText() + this.getPos(), e);
        }
        catch (ClassCastException e) {
            throw new ExecuteException("ArrayExpression.interpret : invalid index dereferencing array " + this.arrayRef.token.getText() + this.getPos(), e);
        }
        catch (Exception e) {
            throw new ExecuteException("ArrayExpression.interpret : unexpected exception dereferencing array " + this.arrayRef.token.getText() + this.getPos(), e);
        }
    }

    @Override
    public void compileAssign(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        int size;
        compileContext.notifySourceLine(this.line);
        Type valueType = this.arrayRef.getType().getBaseType();
        int currentStack = compileContext.getStackCount();
        boolean isTwoWords = valueType.getNBytes() > 4;
        int toPop = 0;
        int n = size = isTwoWords ? 2 : 1;
        if (isTwoWords) {
            mv.visitInsn(92);
        } else {
            mv.visitInsn(89);
        }
        compileContext.addStackCount(size);
        this.arrayRef.compile(mv, compileContext);
        Iterator<Expression> iterator = this.idxList.iterator();
        while (iterator.hasNext()) {
            Expression idxExpr = iterator.next();
            if (iterator.hasNext()) {
                idxExpr.compile(mv, compileContext);
                this.compileTypeConversion(idxExpr.getType(), Type.I, mv, compileContext);
                mv.visitInsn(50);
                compileContext.addStackCount(-1);
                valueType = valueType.getBaseType();
                continue;
            }
            if (isTwoWords) {
                mv.visitInsn(91);
                compileContext.addStackCount(1);
                mv.visitInsn(87);
                compileContext.addStackCount(-1);
            } else {
                mv.visitInsn(95);
            }
            idxExpr.compile(mv, compileContext);
            this.compileTypeConversion(idxExpr.getType(), Type.I, mv, compileContext);
            if (isTwoWords) {
                mv.visitInsn(91);
                compileContext.addStackCount(1);
                mv.visitInsn(87);
                compileContext.addStackCount(-1);
            } else {
                mv.visitInsn(95);
            }
            if (valueType.isObject() || valueType.isArray()) {
                mv.visitInsn(83);
                toPop = -3;
            } else if (valueType == Type.Z || valueType == Type.B) {
                mv.visitInsn(84);
                toPop = -3;
            } else if (valueType == Type.S) {
                mv.visitInsn(86);
                toPop = -3;
            } else if (valueType == Type.C) {
                mv.visitInsn(85);
                toPop = -3;
            } else if (valueType == Type.I) {
                mv.visitInsn(79);
                toPop = -3;
            } else if (valueType == Type.J) {
                mv.visitInsn(80);
                toPop = -4;
            } else if (valueType == Type.F) {
                mv.visitInsn(81);
                toPop = -3;
            } else if (valueType == Type.D) {
                mv.visitInsn(82);
                toPop = -4;
            }
            compileContext.addStackCount(toPop);
            if (!iterator.hasNext()) continue;
            assert (valueType.isArray());
            valueType = valueType.getBaseType();
        }
        if (compileContext.getStackCount() != currentStack) {
            throw new CompileException("ArrayExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + currentStack);
        }
    }

    @Override
    public void bindAssign() throws TypeException {
        this.bind();
    }
}

