/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.EarlyReturnException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class ReturnExpression
extends Expression {
    private Expression returnValue;

    public ReturnExpression(Rule rule, ParseNode token, Expression returnValue) {
        super(rule, Type.VOID, token);
        this.returnValue = returnValue;
    }

    @Override
    public void bind() throws TypeException {
        if (this.returnValue != null) {
            this.returnValue.bind();
        }
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.type = this.rule.getReturnType();
        if (this.returnValue == null && !this.type.isVoid()) {
            throw new TypeException("ReturnExpression.typeCheck : return expression must supply argument when triggered from method with return type " + this.type.getName() + this.getPos());
        }
        if (this.returnValue != null) {
            if (this.type.isVoid()) {
                throw new TypeException("ReturnExpression.typeCheck : return expression must not supply argument when triggered from void method" + this.getPos());
            }
            this.returnValue.typeCheck(this.type);
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        if (this.returnValue != null) {
            Object value = this.returnValue.interpret(helper);
            Type subtype = this.returnValue.type;
            if (this.type.isNumeric()) {
                if (this.type == Type.C && subtype != Type.C) {
                    int number = ((Number)value).intValue();
                    value = Character.valueOf((char)number);
                } else if (subtype == Type.C) {
                    char c = ((Character)value).charValue();
                    if (this.type == Type.B) {
                        value = (byte)c;
                    } else if (this.type == Type.S) {
                        value = (short)c;
                    } else if (this.type == Type.I) {
                        value = (int)c;
                    } else if (this.type == Type.J) {
                        value = (long)c;
                    } else if (this.type == Type.F) {
                        value = Float.valueOf(c);
                    } else if (this.type == Type.D) {
                        value = (double)c;
                    }
                } else if (this.type == Type.B && subtype != Type.B) {
                    Number number = (Number)value;
                    value = number.byteValue();
                } else if (this.type == Type.S && subtype != Type.S) {
                    Number number = (Number)value;
                    value = number.shortValue();
                } else if (this.type == Type.I && subtype != Type.I) {
                    Number number = (Number)value;
                    value = number.intValue();
                } else if (this.type == Type.J && subtype != Type.J) {
                    Number number = (Number)value;
                    value = number.longValue();
                } else if (this.type == Type.F && subtype != Type.F) {
                    Number number = (Number)value;
                    value = Float.valueOf(number.floatValue());
                } else if (this.type == Type.D && subtype != Type.D) {
                    Number number = (Number)value;
                    value = number.doubleValue();
                }
            }
            throw new EarlyReturnException("return from " + helper.getName(), value);
        }
        throw new EarlyReturnException("return from " + helper.getName());
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Type valueType = this.returnValue == null ? Type.VOID : this.returnValue.getType();
        int currentStack = compileContext.getStackCount();
        int expected = 1;
        String exceptionClassName = Type.internalName(EarlyReturnException.class);
        mv.visitTypeInsn(187, exceptionClassName);
        compileContext.addStackCount(1);
        mv.visitInsn(89);
        compileContext.addStackCount(1);
        mv.visitLdcInsn("return from " + this.rule.getName());
        compileContext.addStackCount(1);
        if (this.returnValue != null) {
            this.returnValue.compile(mv, compileContext);
            if (valueType != this.type) {
                this.compileTypeConversion(valueType, this.type, mv, compileContext);
            }
            if (this.type.isPrimitive()) {
                this.compileBox(Type.boxType(this.type), mv, compileContext);
            }
        } else {
            mv.visitInsn(1);
            compileContext.addStackCount(1);
        }
        mv.visitMethodInsn(183, exceptionClassName, "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V");
        compileContext.addStackCount(-3);
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ReturnExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
        mv.visitInsn(191);
        compileContext.addStackCount(-1);
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        if (this.returnValue != null) {
            stringWriter.write("RETURN ");
            this.returnValue.writeTo(stringWriter);
        } else {
            stringWriter.write("RETURN");
        }
    }
}

