/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.instrumenter.io;

import java.io.IOException;
import java.io.InputStream;
import org.hawkular.apm.client.collector.TraceCollector;
import shaded.org.hawkular.apm.api.model.config.Direction;

public class InstrumentedInputStream
extends InputStream {
    private TraceCollector collector;
    private Direction direction;
    private InputStream is;

    public InstrumentedInputStream(TraceCollector collector, Direction direction, InputStream is) {
        this.collector = collector;
        this.direction = direction;
        this.is = is;
        if (direction == Direction.In) {
            collector.initInBuffer(null, this);
        } else {
            collector.initOutBuffer(null, this);
        }
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int len = this.is.read(b);
        if (this.direction == Direction.In) {
            this.collector.appendInBuffer(null, this, b, 0, len);
        } else {
            this.collector.appendOutBuffer(null, this, b, 0, len);
        }
        return len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int actuallen = this.is.read(b, off, len);
        if (this.direction == Direction.In) {
            this.collector.appendInBuffer(null, this, b, off, actuallen);
        } else {
            this.collector.appendOutBuffer(null, this, b, off, actuallen);
        }
        return actuallen;
    }

    @Override
    public void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    @Override
    public void close() throws IOException {
        if (this.direction == Direction.In) {
            this.collector.recordInBuffer(null, this);
        } else {
            this.collector.recordOutBuffer(null, this);
        }
        this.is.close();
    }

    public String toString() {
        return "InstrumentedInputStream[" + this.is + "]";
    }
}

