/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.client.api.recorder;

import shaded.com.fasterxml.jackson.core.JsonProcessingException;
import shaded.com.fasterxml.jackson.databind.ObjectMapper;
import shaded.org.hawkular.apm.api.logging.Logger;
import shaded.org.hawkular.apm.api.model.trace.Trace;
import shaded.org.hawkular.apm.client.api.recorder.TraceRecorder;

public class LoggingRecorder
implements TraceRecorder {
    private final Logger log;
    private ObjectMapper objectMapper = new ObjectMapper();

    public LoggingRecorder() {
        this(LoggingRecorder.class.getName());
    }

    public LoggingRecorder(String loggerName) {
        this.log = Logger.getLogger(loggerName, true);
    }

    @Override
    public void record(Trace trace) {
        String json;
        if (this.log.isLoggable(Logger.Level.INFO) && (json = this.serialize(trace)) != null) {
            this.log.info(json);
        }
    }

    private String serialize(Object object) {
        String json = null;
        try {
            json = this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            this.log.severe("Failed to serialize trace", e);
        }
        return json;
    }
}

