/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.instrumenter.rules;

import org.hawkular.apm.instrumenter.rules.InstrumentActionTransformer;
import shaded.org.hawkular.apm.api.model.config.Direction;
import shaded.org.hawkular.apm.api.model.config.instrumentation.jvm.InstrumentAction;
import shaded.org.hawkular.apm.api.model.config.instrumentation.jvm.ProcessContent;

public class ProcessContentTransformer
implements InstrumentActionTransformer {
    @Override
    public Class<? extends InstrumentAction> getActionType() {
        return ProcessContent.class;
    }

    @Override
    public String convertToRuleAction(InstrumentAction action) {
        ProcessContent pcAction = (ProcessContent)action;
        StringBuilder builder = new StringBuilder(128);
        builder.append("collector().");
        if (pcAction.getDirection() == Direction.In) {
            builder.append("processIn(");
        } else {
            builder.append("processOut(");
        }
        builder.append("getRuleName(),null,createArrayBuilder()");
        for (String expr : pcAction.getValueExpressions()) {
            builder.append(".add(");
            builder.append(expr);
            builder.append(')');
        }
        builder.append(".get()");
        builder.append(")");
        return builder.toString();
    }
}

