/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.instrumenter.io;

import java.io.IOException;
import java.io.OutputStream;
import org.hawkular.apm.api.model.config.Direction;
import org.hawkular.apm.client.api.TraceCollector;

public class InstrumentedOutputStream
extends OutputStream {
    private TraceCollector collector;
    private Direction direction;
    private OutputStream os;
    private String initiateLinkId;

    public InstrumentedOutputStream(TraceCollector collector, Direction direction, OutputStream os, String initiateLinkId) {
        this.collector = collector;
        this.direction = direction;
        this.os = os;
        this.initiateLinkId = initiateLinkId;
        if (direction == Direction.In) {
            collector.initInBuffer(null, (Object)this);
        } else {
            collector.initOutBuffer(null, (Object)this);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.direction == Direction.In) {
            this.collector.appendInBuffer(null, (Object)this, b, 0, b.length);
        } else {
            this.collector.appendOutBuffer(null, (Object)this, b, 0, b.length);
        }
        this.os.write(b);
    }

    @Override
    public void write(byte[] b, int offset, int len) throws IOException {
        if (this.direction == Direction.In) {
            this.collector.appendInBuffer(null, (Object)this, b, offset, len);
        } else {
            this.collector.appendOutBuffer(null, (Object)this, b, offset, len);
        }
        this.os.write(b, offset, len);
    }

    @Override
    public void write(int arg0) throws IOException {
        this.os.write(arg0);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.direction == Direction.In) {
            this.collector.recordInBuffer(null, (Object)this);
        } else {
            this.collector.recordOutBuffer(null, (Object)this);
        }
        if (this.initiateLinkId != null) {
            this.collector.session().initiateCorrelation(this.initiateLinkId);
            this.collector.session().unlink();
        }
        this.os.close();
    }

    public String toString() {
        return "InstrumentedOutputStream[" + this.os + "]";
    }
}

