/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.instrumenter.rules;

import org.hawkular.apm.api.model.config.Direction;
import org.hawkular.apm.api.model.config.instrumentation.jvm.InstrumentAction;
import org.hawkular.apm.api.model.config.instrumentation.jvm.ProcessHeaders;
import org.hawkular.apm.instrumenter.rules.InstrumentActionTransformer;

public class ProcessHeadersTransformer
implements InstrumentActionTransformer {
    @Override
    public Class<? extends InstrumentAction> getActionType() {
        return ProcessHeaders.class;
    }

    @Override
    public String convertToRuleAction(InstrumentAction action) {
        ProcessHeaders phAction = (ProcessHeaders)action;
        StringBuilder builder = new StringBuilder(64);
        builder.append("collector().");
        if (phAction.getDirection() == Direction.In) {
            builder.append("processIn(");
        } else {
            builder.append("processOut(");
        }
        builder.append("getRuleName(),");
        if (phAction.getOriginalType() != null) {
            builder.append("getHeaders(\"");
            builder.append(phAction.getOriginalType());
            builder.append("\",");
        }
        builder.append(phAction.getHeadersExpression());
        if (phAction.getOriginalType() != null) {
            builder.append(")");
        }
        builder.append(",null)");
        return builder.toString();
    }
}

