/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.jms;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.hawkular.apm.api.services.Publisher;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.server.api.log.MsgLogger;
import org.hawkular.apm.server.api.task.ProcessingUnit;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.jms.AbstractPublisherJMS;

public abstract class RetryCapableMDB<S, T>
implements MessageListener {
    private static final Logger log = Logger.getLogger(RetryCapableMDB.class.getName());
    private static final MsgLogger serverMsgLogger = MsgLogger.LOGGER;
    private static final ObjectMapper mapper = new ObjectMapper();
    private TypeReference<List<S>> typeReference;
    private AbstractPublisherJMS<S> retryPublisher;
    private Processor<S, T> processor;
    private Publisher<T> publisher;
    private String retrySubscriber;
    private static final int DEFAULT_MAX_RETRY_COUNT = 3;
    private int maxRetryCount = PropertyUtil.getPropertyAsInteger((String)"HAWKULAR_APM_PROCESSOR_MAX_RETRY_COUNT", (Integer)3);

    public RetryCapableMDB(String subscriberName) {
        this.retrySubscriber = subscriberName;
    }

    public Processor<S, T> getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor<S, T> processor) {
        this.processor = processor;
    }

    public Publisher<T> getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Publisher<T> publisher) {
        this.publisher = publisher;
    }

    public AbstractPublisherJMS<S> getRetryPublisher() {
        return this.retryPublisher;
    }

    public void setRetryPublisher(AbstractPublisherJMS<S> retryPublisher) {
        this.retryPublisher = retryPublisher;
    }

    public TypeReference<List<S>> getTypeReference() {
        return this.typeReference;
    }

    public void setTypeReference(TypeReference<List<S>> typeReference) {
        this.typeReference = typeReference;
    }

    public void onMessage(Message message) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Message received=" + message);
        }
        try {
            String tenantId = message.getStringProperty("tenant");
            int retryCount = message.propertyExists("retryCount") ? message.getIntProperty("retryCount") : this.maxRetryCount;
            String data = ((TextMessage)message).getText();
            List items = (List)mapper.readValue(data, this.getTypeReference());
            this.process(tenantId, items, retryCount);
        }
        catch (Exception e) {
            serverMsgLogger.warnMaxRetryReached((Throwable)e);
        }
    }

    protected void process(String tenantId, List<S> items, int retryCount) throws Exception {
        ProcessingUnit pu = new ProcessingUnit();
        pu.setProcessor(this.getProcessor());
        pu.setRetrySubscriber(this.retrySubscriber);
        pu.setRetryCount(retryCount);
        pu.setResultHandler((tid, events) -> this.getPublisher().publish(tid, events, this.getPublisher().getInitialRetryCount(), this.getProcessor().getDeliveryDelay(events)));
        pu.setRetryHandler((tid, events) -> this.getRetryPublisher().retry(tid, events, pu.getRetrySubscriber(), pu.getRetryCount() - 1, this.getProcessor().getRetryDelay(events, pu.getRetryCount() - 1)));
        pu.handle(tenantId, items);
    }
}

