/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.hawkular.btm.api.client.ConfigurationManager;
import org.hawkular.btm.api.model.admin.CollectorConfiguration;

public abstract class AbstractConfigurationManager
implements ConfigurationManager {
    private static final String HAWKULAR_BTM_CONFIG = "hawkular-btm.config";
    private static ObjectMapper mapper = new ObjectMapper();

    @Override
    public final CollectorConfiguration getConfiguration() {
        if (System.getProperties().containsKey(HAWKULAR_BTM_CONFIG)) {
            return this.loadConfig(System.getProperty(HAWKULAR_BTM_CONFIG));
        }
        return this.doGetConfiguration();
    }

    protected abstract CollectorConfiguration doGetConfiguration();

    protected CollectorConfiguration loadConfig(String uri) {
        CollectorConfiguration config = null;
        try {
            Path path = Paths.get(uri, new String[0]);
            File file = path.toFile();
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    Path child = path.resolve(f.getName());
                    String json = new String(Files.readAllBytes(child));
                    CollectorConfiguration childConfig = (CollectorConfiguration)mapper.readValue(json, CollectorConfiguration.class);
                    if (config == null) {
                        config = childConfig;
                        continue;
                    }
                    config.merge(childConfig, false);
                }
            } else {
                String json = new String(Files.readAllBytes(path));
                config = (CollectorConfiguration)mapper.readValue(json, CollectorConfiguration.class);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load BTM configuration: " + e);
            e.printStackTrace();
        }
        return config;
    }
}

