/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.admin.CollectorConfiguration;

public class ConfigurationLoader {
    public static final String HAWKULAR_BTM_CONFIG = "hawkular-btm.config";
    private static final String DEFAULT_URI = "btmconfig";
    private static ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = Logger.getLogger(ConfigurationLoader.class.getName());

    public static CollectorConfiguration getConfiguration() {
        return ConfigurationLoader.loadConfig(System.getProperty(HAWKULAR_BTM_CONFIG, DEFAULT_URI));
    }

    protected static CollectorConfiguration loadConfig(String uri) {
        final CollectorConfiguration config = new CollectorConfiguration();
        File f = new File(uri);
        if (!f.isAbsolute()) {
            if (System.getProperties().containsKey("jboss.server.data.dir")) {
                uri = System.getProperty("jboss.server.data.dir") + File.separatorChar + uri;
            } else {
                try {
                    URL url = Thread.currentThread().getContextClassLoader().getResource(uri);
                    uri = url.getPath();
                }
                catch (Exception e) {
                    log.log(Logger.Level.SEVERE, "Failed to get absolute path for uri '" + uri + "'", e);
                    uri = null;
                }
            }
        }
        String[] uriParts = uri.split("/");
        int startIndex = 0;
        if (uriParts[0].equals("file:")) {
            ++startIndex;
        }
        try {
            Path path = ConfigurationLoader.getPath(startIndex, uriParts);
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                    if (path.toString().endsWith(".json")) {
                        String json = new String(Files.readAllBytes(path));
                        CollectorConfiguration childConfig = (CollectorConfiguration)mapper.readValue(json, CollectorConfiguration.class);
                        if (childConfig != null) {
                            config.merge(childConfig, false);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Path getPath(int startindex, String[] uriParts) {
        Path ret = Paths.get("/", new String[0]);
        ArrayList toClose = new ArrayList();
        try {
            for (int i = startindex; i < uriParts.length; ++i) {
                String name = uriParts[i];
                if (name.endsWith("!")) {
                    name = name.substring(0, name.length() - 1);
                }
                ret = ret.resolve(name);
                if (!name.endsWith(".jar") && !name.endsWith(".war")) continue;
                try {
                    FileSystem jarfs = FileSystems.newFileSystem(ret, Thread.currentThread().getContextClassLoader());
                    ret = jarfs.getRootDirectories().iterator().next();
                    continue;
                }
                catch (IOException e) {
                    log.log(Logger.Level.SEVERE, "Failed to access archive '" + name + "'", e);
                }
            }
        }
        finally {
            for (FileSystem fs : toClose) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    log.log(Logger.Level.SEVERE, "Failed to close file system '" + fs + "'", e);
                }
            }
        }
        return ret;
    }
}

