/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseCriteria {
    private final Logger log = Logger.getLogger(BaseCriteria.class.getName());
    private long startTime = 0L;
    private long endTime = 0L;
    private String businessTransaction;
    private Set<PropertyCriteria> properties = new HashSet<PropertyCriteria>();
    private static int DEFAULT_RESPONSE_SIZE = 100000;
    private static long DEFAULT_TIMEOUT = 10000L;
    private long timeout = DEFAULT_TIMEOUT;
    private int maxResponseSize = DEFAULT_RESPONSE_SIZE;

    public long getStartTime() {
        return this.startTime;
    }

    public BaseCriteria setStartTime(long startTime) {
        this.startTime = startTime;
        return this;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public BaseCriteria setEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getBusinessTransaction() {
        return this.businessTransaction;
    }

    public BaseCriteria setBusinessTransaction(String name) {
        this.businessTransaction = name;
        return this;
    }

    public Set<PropertyCriteria> getProperties() {
        return this.properties;
    }

    public BaseCriteria setProperties(Set<PropertyCriteria> properties) {
        this.properties = properties;
        return this;
    }

    public void addProperty(String name, String value, boolean excluded) {
        this.properties.add(new PropertyCriteria(name, value, excluded));
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int getMaxResponseSize() {
        return this.maxResponseSize;
    }

    public void setMaxResponseSize(int maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    public Map<String, String> parameters() {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (this.getBusinessTransaction() != null) {
            ret.put("businessTransaction", this.getBusinessTransaction());
        }
        if (this.getStartTime() > 0L) {
            ret.put("startTime", "" + this.getStartTime());
        }
        if (this.getEndTime() > 0L) {
            ret.put("endTime", "" + this.getEndTime());
        }
        if (!this.getProperties().isEmpty()) {
            boolean first = true;
            StringBuilder buf = new StringBuilder();
            for (PropertyCriteria pc : this.getProperties()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(pc.encoded());
            }
            ret.put("properties", buf.toString());
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Criteria parameters [" + ret + "]");
        }
        return ret;
    }

    public String toString() {
        return "BaseCriteria [startTime=" + this.startTime + ", endTime=" + this.endTime + ", businessTransaction=" + this.businessTransaction + ", properties=" + this.properties + "]";
    }

    public static class PropertyCriteria {
        private String name;
        private String value;
        private boolean excluded = false;

        public PropertyCriteria() {
        }

        public PropertyCriteria(String name, String value, boolean excluded) {
            this.name = name;
            this.value = value;
            this.excluded = excluded;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean isExcluded() {
            return this.excluded;
        }

        public void setExcluded(boolean excluded) {
            this.excluded = excluded;
        }

        public String encoded() {
            StringBuilder buf = new StringBuilder();
            if (this.isExcluded()) {
                buf.append('-');
            }
            buf.append(this.getName());
            buf.append('|');
            buf.append(this.getValue());
            return buf.toString();
        }
    }
}

